/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.test.integration.sequencer.ddl.dialect.derby;

import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.SimpleCredentials;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.modeshape.graph.connector.inmemory.InMemoryRepositorySource;
import org.modeshape.jcr.JaasTestUtil;
import org.modeshape.jcr.JcrConfiguration;
import org.modeshape.jcr.JcrTools;
import org.modeshape.repository.ModeShapeConfiguration;
import org.modeshape.test.integration.sequencer.ddl.DdlIntegrationTestUtil;

public class DerbyDdlSequencerIntegrationTest
extends DdlIntegrationTestUtil {
    private String resourceFolder = "org/modeshape/test/integration/sequencer/ddl//dialect/derby/";

    @BeforeClass
    public static void beforeAll() {
        JaasTestUtil.initJaas((String)"security/jaas.conf.xml");
    }

    @AfterClass
    public static void afterAll() {
        JaasTestUtil.releaseJaas();
    }

    @Before
    public void beforeEach() throws Exception {
        this.tools = new JcrTools();
        String repositoryName = "ddlRepository";
        String workspaceName = "default";
        String repositorySource = "ddlRepositorySource";
        JcrConfiguration config = new JcrConfiguration();
        ((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)config.repositorySource(repositorySource).usingClass(InMemoryRepositorySource.class)).setDescription("The repository for our content")).setProperty("defaultWorkspaceName", workspaceName);
        config.repository(repositoryName).addNodeTypes(this.getUrl("org/modeshape/sequencer/ddl/StandardDdl.cnd")).addNodeTypes(this.getUrl(this.resourceFolder + "DerbyDdl.cnd")).registerNamespace("ddl", "http://www.modeshape.org/ddl/1.0").registerNamespace("derbyddl", "http://www.modeshape.org/ddl/derby/1.0").setSource(repositorySource);
        ((ModeShapeConfiguration.SequencerDefinition)((ModeShapeConfiguration.SequencerDefinition)config.sequencer("DDL Sequencer").usingClass("org.modeshape.sequencer.ddl.DdlSequencer").loadedFromClasspath()).setDescription("Sequences DDL files to extract individual statements and accompanying statement properties and values")).sequencingFrom("(//(*.(ddl)[*]))/jcr:content[@jcr:data]").andOutputtingTo("/ddls/$1");
        config.save();
        this.engine = config.build();
        this.engine.start();
        this.session = this.engine.getRepository(repositoryName).login((Credentials)new SimpleCredentials("superuser", "superuser".toCharArray()), workspaceName);
    }

    @After
    public void afterEach() throws Exception {
        if (this.session != null) {
            this.session.logout();
        }
        if (this.engine != null) {
            this.engine.shutdown();
        }
    }

    @Test
    public void shouldSequenceDerbyDdlFile() throws Exception {
        this.uploadFile(this.resourceFolder, "derby_test_statements.ddl", "shouldSequenceDerbyDdlFile");
        this.waitUntilSequencedNodesIs(1);
        Node root = this.session.getRootNode();
        if (root.hasNode("ddls") && root.hasNode("ddls")) {
            Node ddlsNode = root.getNode("ddls/a/b");
            NodeIterator iter = ddlsNode.getNodes();
            while (iter.hasNext()) {
                Node ddlNode = iter.nextNode();
                long numStatements = ddlNode.getNodes().nextNode().getNodes().getSize();
                Assert.assertEquals((long)numStatements, (long)64L);
                this.verifyNode(ddlNode, "HOTELAVAILABILITY", "ddl:startLineNumber");
                this.verifyNode(ddlNode, "SAMP.DEPARTMENT", "ddl:expression");
                this.verifyNode(ddlNode, "HOTEL_ID", "ddl:datatypeName");
                this.verifyNode(ddlNode, "CITIES", "ddl:startLineNumber");
                this.verifyNode(ddlNode, "PROPERTY_FILE_READER", "ddl:startLineNumber", 71);
                this.verifyNodeTypes(ddlNode, "PROPERTY_FILE_READER", "derbyddl:createFunctionStatement", "ddl:creatable", "derbyddl:functionOperand");
                this.verifyNode(ddlNode, "KEY_COL", "ddl:datatypeName", "VARCHAR");
                Node functionNode = this.findNode(ddlNode, "TO_DEGREES");
                Assert.assertNotNull((Object)functionNode);
                this.verifyChildNode(functionNode, "parameterStyle", "ddl:value", "PARAMETER STYLE JAVA");
                Node indexNode = this.findNode(ddlNode, "IXSALE", "derbyddl:createIndexStatement");
                Assert.assertNotNull((Object)indexNode);
                this.verifySimpleStringProperty(indexNode, "derbyddl:tableName", "SAMP.SALES");
                Node colRefNode = this.findNode(indexNode, "SALES");
                Assert.assertNotNull((Object)colRefNode);
                colRefNode = this.findNode(ddlNode, "SALES", "derbyddl:indexColumnReference");
                Assert.assertNotNull((Object)colRefNode);
                this.verifyNodeTypes(colRefNode, "SALES", "derbyddl:indexColumnReference", "ddl:columnReference", "ddl:referenceOperand");
                Node ttNode = this.findNode(ddlNode, "SESSION.t1", "derbyddl:declareGlobalTemporaryTableStatement");
                Assert.assertNotNull((Object)ttNode);
                Node colNode = this.findNode(ttNode, "c11");
                Assert.assertNotNull((Object)colNode);
                this.verifySimpleStringProperty(colNode, "ddl:datatypeName", "int");
                Node lockNode = this.findNode(ddlNode, "FlightAvailability", "derbyddl:lockTableStatement");
                Assert.assertNotNull((Object)lockNode);
                Node optionNode = this.findNode(lockNode, "lockMode");
                Assert.assertNotNull((Object)optionNode);
                this.verifySimpleStringProperty(optionNode, "ddl:value", "EXCLUSIVE");
                Node renameTableNode = this.findNode(ddlNode, "SAMP.EMP_ACT", "derbyddl:renameTableStatement");
                Assert.assertNotNull((Object)renameTableNode);
                this.verifySimpleStringProperty(renameTableNode, "ddl:newName", "EMPLOYEE_ACT");
                Node synonymNode = this.findNode(ddlNode, "SAMP.T1", "derbyddl:createSynonymStatement");
                Assert.assertNotNull((Object)synonymNode);
                this.verifySimpleStringProperty(synonymNode, "derbyddl:tableName", "SAMP.TABLEWITHLONGNAME");
                Node triggerNode = this.findNode(ddlNode, "FLIGHTSDELETE3", "derbyddl:createTriggerStatement");
                Assert.assertNotNull((Object)triggerNode);
                this.verifySimpleStringProperty(triggerNode, "derbyddl:tableName", "FLIGHTS");
                triggerNode = this.findNode(ddlNode, "t1", "derbyddl:createTriggerStatement");
                Assert.assertNotNull((Object)triggerNode);
                this.verifySimpleStringProperty(triggerNode, "derbyddl:tableName", "x");
                optionNode = this.findNode(triggerNode, "forEach");
                Assert.assertNotNull((Object)optionNode);
                this.verifySimpleStringProperty(optionNode, "ddl:value", "FOR EACH ROW");
                optionNode = this.findNode(triggerNode, "eventType");
                Assert.assertNotNull((Object)optionNode);
                this.verifySimpleStringProperty(optionNode, "ddl:value", "UPDATE");
                Node grantNode = this.findNode(ddlNode, "p", "derbyddl:grantOnProcedureStatement");
                Assert.assertNotNull((Object)grantNode);
                grantNode = this.findNode(ddlNode, "grantRoles", "derbyddl:grantRolesStatement");
                Assert.assertNotNull((Object)grantNode);
                Node roleNode = this.findNode(grantNode, "george", "ddl:grantee");
                Assert.assertNotNull((Object)roleNode);
            }
        }
    }
}

