/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.test.integration.performance;

import java.lang.reflect.Method;
import javax.jcr.Session;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.Profiler;
import org.modeshape.test.integration.performance.GeneratePerformanceRules;

public class GeneratePerformanceRulesTest {
    private GeneratePerformanceRules generator;
    private GeneratePerformanceRules.Specification spec;

    @Before
    public void beforeEach() {
        this.generator = new GeneratePerformanceRules();
        this.spec = null;
    }

    @After
    public void afterEach() {
        this.generator = null;
        this.spec = null;
    }

    @Test
    public void shouldModifierComparisonForPublicMethod() throws Exception {
        this.spec = new GeneratePerformanceRules.Specification(JcrRepository.class, Session.class, GeneratePerformanceRules.Visibility.PUBLIC);
        this.assertIncluded(Session.class, "getRootNode", new Class[0]);
        this.assertIncluded(Session.class, "getNode", String.class);
    }

    @Test
    public void shouldModifierComparisonForPackageMethod() throws Exception {
        this.spec = new GeneratePerformanceRules.Specification(JcrRepository.class, Session.class, GeneratePerformanceRules.Visibility.PACKAGE);
        this.assertExcluded(Session.class, "getRootNode", new Class[0]);
    }

    @Test
    public void shouldModifierComparisonForProtectedMethod() throws Exception {
        this.spec = new GeneratePerformanceRules.Specification(JcrRepository.class, Session.class, GeneratePerformanceRules.Visibility.PROTECTED);
        this.assertExcluded(Session.class, "getRootNode", new Class[0]);
    }

    @Test
    public void shouldModifierComparisonForPrivateMethod() throws Exception {
        this.spec = new GeneratePerformanceRules.Specification(JcrRepository.class, Session.class, GeneratePerformanceRules.Visibility.PRIVATE);
        this.assertExcluded(Session.class, "getRootNode", new Class[0]);
    }

    @Test
    public void shouldGenerateCorrectSignatureForMethodWithNoParameters() throws Exception {
        this.spec = new GeneratePerformanceRules.Specification(JcrRepository.class, Session.class, GeneratePerformanceRules.Visibility.PUBLIC);
        String signature = this.generator.signatureFor(Session.class.getMethod("getRootNode", new Class[0]));
        Assert.assertThat((Object)signature, (Matcher)Is.is((Object)"getRootNode()"));
    }

    @Test
    public void shouldGenerateCorrectSignatureForMethodWithOneParameter() throws Exception {
        this.spec = new GeneratePerformanceRules.Specification(JcrRepository.class, Session.class, GeneratePerformanceRules.Visibility.PUBLIC);
        String signature = this.generator.signatureFor(Session.class.getMethod("getNode", String.class));
        Assert.assertThat((Object)signature, (Matcher)Is.is((Object)"getNode(java.lang.String)"));
    }

    @Ignore
    @Test
    public void shouldGenerateRulesForOneClass() throws Exception {
        this.generator.instrumentClass("org.modeshape.jcr.JcrSession(public:javax.jcr.Session)");
        this.generator.setOutputFile("System.out");
        this.generator.generateRules();
    }

    @Test
    public void shouldGenerateRulesForPerformance() throws Exception {
        this.generator.instrumentClass("org.modeshape.jcr.JcrSession(public:javax.jcr.Session)");
        this.generator.instrumentClass("org.modeshape.jcr.JcrWorkspace(public:javax.jcr.Workspace)");
        this.generator.setOutputFile("target/byteman/jcr-performance-generated.txt");
        this.generator.setHelperClass(Profiler.class.getCanonicalName());
        this.generator.generateRules();
    }

    protected void assertExcluded(Class<?> clazz, String methodName, Class<?> ... paramTypes) throws Exception {
        Method method = clazz.getMethod(methodName, paramTypes);
        Assert.assertThat((Object)method, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)this.spec.includes(method), (Matcher)Is.is((Object)false));
    }

    protected void assertIncluded(Class<?> clazz, String methodName, Class<?> ... paramTypes) throws Exception {
        Method method = clazz.getMethod(methodName, paramTypes);
        Assert.assertThat((Object)method, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)this.spec.includes(method), (Matcher)Is.is((Object)true));
    }
}

