/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.test.integration.sequencer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import org.junit.Assert;
import org.modeshape.common.SystemFailureException;
import org.modeshape.common.text.Inflector;
import org.modeshape.test.ModeShapeSingleUseTest;

public abstract class AbstractSequencerTest
extends ModeShapeSingleUseTest {
    public DeleteListener registerListenerForDeletes() throws RepositoryException {
        return this.registerListenerForDeletesBelow("/");
    }

    public DeleteListener registerListenerForDeletesBelow(String path) throws RepositoryException {
        DeleteListener listener = new DeleteListener(this.session(), path);
        listener.register();
        return listener;
    }

    public static class SequencedNodeValidator {
        public static void validateSequencedNodeType(Node sequencedNode) throws RepositoryException {
            NodeTypeManager nodeTypeManager = sequencedNode.getSession().getWorkspace().getNodeTypeManager();
            List<String> typeNames = SequencedNodeValidator.getAllMixinAndTypeNames(sequencedNode);
            if (!typeNames.contains("nt:unstructured")) {
                Map<String, Property> nodeProperties = SequencedNodeValidator.collectProperties(sequencedNode);
                for (PropertyDefinition propertyDef : SequencedNodeValidator.collectAllPropertyDefinitions(typeNames, nodeTypeManager)) {
                    boolean nodeHasProperty = nodeProperties.containsKey(propertyDef.getName());
                    if (propertyDef.isMandatory()) {
                        Assert.assertTrue((String)("Property " + propertyDef.getName() + " not found under " + sequencedNode), (boolean)nodeHasProperty);
                    }
                    if (propertyDef.isMultiple() && nodeHasProperty) {
                        Assert.assertArrayEquals((Object[])propertyDef.getDefaultValues(), (Object[])nodeProperties.get(propertyDef.getName()).getValues());
                    }
                    nodeProperties.remove(propertyDef.getName());
                }
                Assert.assertTrue((String)("Unidentified node properties found " + nodeProperties), (boolean)nodeProperties.isEmpty());
            }
            for (String childNodeName : SequencedNodeValidator.collectAllRequiredChildren(typeNames, nodeTypeManager)) {
                Assert.assertTrue((String)("Child " + childNodeName + "not found under " + sequencedNode), (boolean)sequencedNode.hasNode(childNodeName));
            }
            NodeIterator childNodeIt = sequencedNode.getNodes();
            while (childNodeIt.hasNext()) {
                SequencedNodeValidator.validateSequencedNodeType(childNodeIt.nextNode());
            }
        }

        private static Map<String, Property> collectProperties(Node node) throws RepositoryException {
            HashMap<String, Property> propertyMap = new HashMap<String, Property>();
            PropertyIterator propertyIterator = node.getProperties();
            while (propertyIterator.hasNext()) {
                Property property = propertyIterator.nextProperty();
                if (property.getName().startsWith("jcr") || property.getName().startsWith("http://www.jcp.org/jcr/1.0")) continue;
                propertyMap.put(property.getName(), property);
            }
            return propertyMap;
        }

        private static List<PropertyDefinition> collectAllPropertyDefinitions(List<String> typeNames, NodeTypeManager nodeTypeManager) throws RepositoryException {
            ArrayList<PropertyDefinition> result = new ArrayList<PropertyDefinition>();
            for (String typeName : typeNames) {
                NodeType type = nodeTypeManager.getNodeType(typeName);
                for (PropertyDefinition propertyDefinition : type.getPropertyDefinitions()) {
                    if (propertyDefinition.getName().startsWith("jcr") || propertyDefinition.getName().startsWith("http://www.jcp.org/jcr/1.0") || propertyDefinition.getName().equals("*")) continue;
                    result.add(propertyDefinition);
                }
            }
            return result;
        }

        private static List<String> collectAllRequiredChildren(List<String> typeNames, NodeTypeManager nodeTypeManager) throws RepositoryException {
            ArrayList<String> result = new ArrayList<String>();
            for (String typeName : typeNames) {
                NodeType type = nodeTypeManager.getNodeType(typeName);
                for (NodeDefinition childDefinition : type.getChildNodeDefinitions()) {
                    if (!childDefinition.isMandatory()) continue;
                    result.add(childDefinition.getName());
                }
            }
            return result;
        }

        private static List<String> getAllMixinAndTypeNames(Node sequencedNode) throws RepositoryException {
            ArrayList<String> types = new ArrayList<String>();
            types.add(sequencedNode.getPrimaryNodeType().getName());
            if (!sequencedNode.hasProperty("jcr:mixinTypes")) {
                return types;
            }
            for (Value mixinValue : sequencedNode.getProperty("jcr:mixinTypes").getValues()) {
                types.add(mixinValue.getString());
            }
            return types;
        }
    }

    public static class DeleteListener
    implements EventListener {
        private final Session session;
        private final String path;
        private List<List<String>> deletedPaths = new ArrayList<List<String>>();
        private boolean isRegistered = false;

        protected DeleteListener(Session session, String path) {
            this.session = session;
            this.path = path;
        }

        public void onEvent(EventIterator events) {
            try {
                ArrayList<String> deleted = new ArrayList<String>();
                while (events.hasNext()) {
                    Event event = events.nextEvent();
                    deleted.add(event.getPath());
                }
                this.deletedPaths.add(deleted);
            }
            catch (RepositoryException e) {
                throw new SystemFailureException((Throwable)e);
            }
        }

        public void clear() {
            this.deletedPaths.clear();
        }

        public int size() {
            int count = 0;
            for (List<String> list : this.deletedPaths) {
                count += list.size();
            }
            return count;
        }

        public List<List<String>> getDeletedPaths() {
            return this.deletedPaths;
        }

        public void register() throws RepositoryException {
            if (this.isRegistered) {
                return;
            }
            this.session.getWorkspace().getObservationManager().addEventListener((EventListener)this, 2, this.path, true, null, null, false);
            this.isRegistered = true;
        }

        public void unregister() throws RepositoryException {
            this.session.getWorkspace().getObservationManager().removeEventListener((EventListener)this);
            this.isRegistered = false;
        }

        public Set<String> waitForDeleted(long maxTimeToWait, TimeUnit unit, String ... paths) {
            return this.waitForDeleted(maxTimeToWait, unit, true, paths);
        }

        public Set<String> waitForDeleted(long maxTimeToWait, TimeUnit unit, boolean failIfNotAllFound, String ... paths) {
            assert (paths != null);
            HashSet<String> remainingPaths = new HashSet<String>();
            for (String path : paths) {
                if (path == null) continue;
                remainingPaths.add(path);
            }
            if (remainingPaths.isEmpty()) {
                return remainingPaths;
            }
            long maxTimeToWaitInMillis = unit.toMillis(maxTimeToWait);
            long startTime = System.currentTimeMillis();
            long waitedInMillis = 0L;
            while (waitedInMillis < maxTimeToWaitInMillis) {
                for (List<String> list : this.deletedPaths) {
                    remainingPaths.removeAll(list);
                    if (!remainingPaths.isEmpty()) continue;
                    return remainingPaths;
                }
                waitedInMillis = System.currentTimeMillis() - startTime;
                if (waitedInMillis >= maxTimeToWaitInMillis) continue;
                try {
                    Thread.sleep(Math.min(50L, maxTimeToWaitInMillis - waitedInMillis));
                }
                catch (InterruptedException e) {
                    break;
                }
                waitedInMillis = System.currentTimeMillis() - startTime;
            }
            if (failIfNotAllFound && !remainingPaths.isEmpty()) {
                Inflector inflector = new Inflector();
                String unitName = inflector.pluralize((Object)unit.toString().toLowerCase(), (int)maxTimeToWait);
                Assert.fail((String)("Waited for " + maxTimeToWait + " " + unitName + " but didn't see events for deletion of: " + remainingPaths + ". Did see these deletions: " + this.deletedPaths));
            }
            return remainingPaths;
        }
    }
}

