/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.test.integration.sequencer.ddl.dialect.oracle;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.test.integration.sequencer.ddl.AbstractDdlIntegrationTest;

public class OracleDdlSequencerIntegrationTest
extends AbstractDdlIntegrationTest {
    private static final String RESOURCE_FOLDER = "org/modeshape/test/integration/sequencer/ddl//dialect/oracle/";

    @Override
    protected void addCustomConfiguration() {
        this.config.repository("ddlRepository").addNodeTypes(this.getUrl("org/modeshape/sequencer/ddl/dialect/oracle/OracleDdl.cnd")).registerNamespace("oracleddl", "http://www.modeshape.org/ddl/oracle/1.0");
    }

    @Test
    public void shouldSequenceOracleDdlFile() throws Exception {
        this.uploadFile(RESOURCE_FOLDER, "oracle_test_statements.ddl");
        this.waitUntilSequencedNodesIs(1);
        Node ddlsNode = this.getStatementsContainer();
        NodeIterator iter = ddlsNode.getNodes();
        while (iter.hasNext()) {
            Node ddlNode = iter.nextNode();
            long numStatements = ddlNode.getNodes().nextNode().getNodes().getSize();
            Assert.assertEquals((long)numStatements, (long)50L);
            this.verifyNode(ddlNode, "address", "ddl:startLineNumber");
            this.verifyNode(ddlNode, "cust_orders", "ddl:expression");
            this.verifyMixin(ddlNode, "cust_orders", "oracleddl:createIndexStatement");
            this.verifyNodeType(ddlNode, "cust_orders", "oracleddl:createIndexStatement");
            this.verifyNodeType(ddlNode, "cust_orders", "ddl:creatable");
            this.verifyNode(ddlNode, "cust_orders", "ddl:startCharIndex", 1698);
            this.verifyNode(ddlNode, "customers_dim", "ddl:startColumnNumber");
        }
    }

    @Test
    public void shouldSequenceOracleCreateProceduresAndFunctions() throws Exception {
        this.uploadFile(RESOURCE_FOLDER, "create_procedure_statements.ddl");
        this.waitUntilSequencedNodesIs(1);
        Node ddlsNode = this.getStatementsContainer();
        NodeIterator iter = ddlsNode.getNodes();
        while (iter.hasNext()) {
            Node ddlNode = iter.nextNode();
            long numStatements = ddlNode.getNodes().nextNode().getNodes().getSize();
            Assert.assertEquals((long)4L, (long)numStatements);
            Node node = this.assertNode(ddlNode, "remove_emp", "oracleddl:createProcedureStatement");
            Assert.assertEquals((long)1L, (long)node.getNodes().getSize());
            Node paramNode = this.assertNode(node, "employee_id", "oracleddl:functionParameter");
            this.verifySimpleStringProperty(paramNode, "ddl:datatypeName", "NUMBER");
            node = this.assertNode(ddlNode, "find_root", "oracleddl:createProcedureStatement");
            Assert.assertEquals((long)1L, (long)node.getNodes().getSize());
            paramNode = this.assertNode(node, "x", "oracleddl:functionParameter");
            this.verifySimpleStringProperty(paramNode, "ddl:datatypeName", "REAL");
            this.verifySimpleStringProperty(paramNode, "oracleddl:inOutNoCopy", "IN");
            node = this.assertNode(ddlNode, "SecondMax", "oracleddl:createFunctionStatement");
            Assert.assertEquals((long)1L, (long)node.getNodes().getSize());
            paramNode = this.assertNode(node, "input", "oracleddl:functionParameter");
            this.verifySimpleStringProperty(paramNode, "ddl:datatypeName", "NUMBER");
            node = this.assertNode(ddlNode, "text_length", "oracleddl:createFunctionStatement");
            Assert.assertEquals((long)1L, (long)node.getNodes().getSize());
            this.verifySimpleStringProperty(node, "ddl:datatypeName", "NUMBER");
            paramNode = this.assertNode(node, "a", "oracleddl:functionParameter");
            this.verifySimpleStringProperty(paramNode, "ddl:datatypeName", "CLOB");
        }
    }
}

