/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.rhq.plugin.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.managed.api.ManagedComponent;
import org.jboss.managed.api.ManagedOperation;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.values.CollectionValueSupport;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.MetaValueFactory;
import org.modeshape.jboss.managed.ManagedRepository;
import org.modeshape.jboss.managed.ManagedSequencerConfig;
import org.modeshape.rhq.plugin.objects.ExecutedResult;
import org.modeshape.rhq.plugin.util.PluginConstants;
import org.modeshape.rhq.plugin.util.ProfileServiceUtil;
import org.rhq.plugins.jbossas5.connection.ProfileServiceConnection;

public class ModeShapeManagementView
implements PluginConstants {
    private static final Log LOG = LogFactory.getLog((String)"org.modeshape");
    private static final MetaValueFactory metaValueFactory = MetaValueFactory.getInstance();

    public Object getMetric(ProfileServiceConnection connection, String componentType, String identifier, String metric, Map<String, Object> valueMap) throws Exception {
        Object resultObject = new Object();
        if (componentType.equals("ModeShapeSequencingService")) {
            resultObject = this.getSequencerServiceMetric(connection, componentType, metric, valueMap);
        } else if (componentType.equals("Connector")) {
            resultObject = this.getConnectorMetric(connection, componentType, metric, valueMap);
        } else if (componentType.equals("Repository")) {
            resultObject = this.getRepositoryMetric(connection, componentType, metric, valueMap);
        }
        return resultObject;
    }

    private Object getSequencerServiceMetric(ProfileServiceConnection connection, String componentType, String metric, Map<String, Object> valueMap) throws Exception {
        Object resultObject = new Object();
        MetaValue value = null;
        if (metric.equals("getNodesSequencedCount") || metric.equals("getNodesSkippedCount")) {
            value = this.executeSequencingServiceOperation(connection, metric, valueMap);
            resultObject = ProfileServiceUtil.stringValue(value);
        }
        return resultObject;
    }

    private Object getRepositoryMetric(ProfileServiceConnection connection, String componentType, String metric, Map<String, Object> valueMap) throws Exception {
        Object resultObject = new Object();
        MetaValue value = null;
        if (metric.equals("getActiveSessions")) {
            value = ModeShapeManagementView.executeManagedOperation(ProfileServiceUtil.getManagedEngine(connection), metric, MetaValueFactory.getInstance().create(valueMap.get("repositoryName")));
            resultObject = ProfileServiceUtil.stringValue(value);
        }
        return resultObject;
    }

    private Object getConnectorMetric(ProfileServiceConnection connection, String componentType, String metric, Map<String, Object> valueMap) throws Exception {
        Object resultObject = new Object();
        MetaValue value = null;
        if (metric.equals("getInUseConnections")) {
            value = ModeShapeManagementView.executeManagedOperation(ProfileServiceUtil.getManagedEngine(connection), metric, MetaValueFactory.getInstance().create(valueMap.get("connectorName")));
            resultObject = ProfileServiceUtil.stringValue(value);
        } else if (metric.equals("getActiveSessions")) {
            value = ModeShapeManagementView.executeManagedOperation(ProfileServiceUtil.getManagedEngine(connection), metric, MetaValueFactory.getInstance().create(valueMap.get("connectorName")));
            resultObject = ProfileServiceUtil.stringValue(value);
        }
        return resultObject;
    }

    public void executeOperation(ProfileServiceConnection connection, ExecutedResult operationResult, Map<String, Object> valueMap) {
        if (operationResult.getComponentType().equals("ModeShapeEngine")) {
            this.executeEngineOperation(connection, operationResult, operationResult.getOperationName(), valueMap);
        } else if (!operationResult.getComponentType().equals("Repository") && operationResult.getComponentType().equals("Connector")) {
            this.executeConnectorOperation(connection, operationResult, operationResult.getOperationName(), valueMap);
        }
    }

    private void executeEngineOperation(ProfileServiceConnection connection, ExecutedResult operationResult, String operationName, Map<String, Object> valueMap) {
        try {
            ModeShapeManagementView.executeManagedOperation(ProfileServiceUtil.getManagedEngine(connection), operationName, new MetaValue[]{null});
        }
        catch (Exception e) {
            String msg = "Exception executing operation: " + operationName;
            LOG.error((Object)msg, (Throwable)e);
        }
    }

    private void executeConnectorOperation(ProfileServiceConnection connection, ExecutedResult operationResult, String operationName, Map<String, Object> valueMap) {
        if (operationName.equals("pingConnector")) {
            try {
                String connectorName = (String)valueMap.get("connectorName");
                MetaValue[] args = new MetaValue[]{metaValueFactory.create((Object)connectorName)};
                MetaValue value = ModeShapeManagementView.executeManagedOperation(ProfileServiceUtil.getManagedEngine(connection), operationName, operationResult, args);
                operationResult.setContent(value);
            }
            catch (Exception e) {
                String msg = "Exception executing operation: pingConnector";
                LOG.error((Object)"Exception executing operation: pingConnector", (Throwable)e);
            }
        }
    }

    private MetaValue executeSequencingServiceOperation(ProfileServiceConnection connection, String operationName, Map<String, Object> valueMap) {
        MetaValue value = null;
        try {
            MetaValue[] args = new MetaValue[]{};
            value = ModeShapeManagementView.executeManagedOperation(ProfileServiceUtil.getManagedSequencingService(connection), operationName, args);
        }
        catch (Exception e) {
            String msg = "Exception executing operation: " + operationName;
            LOG.error((Object)msg, (Throwable)e);
        }
        return value;
    }

    public static MetaValue executeManagedOperation(ManagedComponent mc, String operation, MetaValue ... args) throws Exception {
        for (ManagedOperation mo : mc.getOperations()) {
            String opName = mo.getName();
            if (!opName.equals(operation)) continue;
            try {
                if (args == null || args.length == 1 && args[0] == null) {
                    return mo.invoke(new MetaValue[0]);
                }
                return mo.invoke(args);
            }
            catch (Exception e) {
                String msg = "Exception invoking " + operation;
                LOG.error((Object)msg, (Throwable)e);
                throw e;
            }
        }
        throw new Exception("No operation found with given name =" + operation);
    }

    public static MetaValue executeManagedOperation(ManagedComponent mc, String operation, ExecutedResult operationResult, MetaValue ... args) throws Exception {
        for (ManagedOperation mo : mc.getOperations()) {
            String opName = mo.getName();
            if (!opName.equals(operation)) continue;
            operationResult.setManagedOperation(mo);
            try {
                if (args == null || args.length == 1 && args[0] == null) {
                    return mo.invoke(new MetaValue[0]);
                }
                return mo.invoke(args);
            }
            catch (Exception e) {
                String msg = "Exception invoking " + operation;
                LOG.error((Object)msg, (Throwable)e);
                throw e;
            }
        }
        throw new Exception("No operation found with given name =" + operation);
    }

    public static Collection<ManagedRepository> getRepositoryCollectionValue(MetaValue pValue) {
        ArrayList<ManagedRepository> list = new ArrayList<ManagedRepository>();
        MetaType metaType = pValue.getMetaType();
        if (metaType.isCollection()) {
            for (MetaValue value : ((CollectionValueSupport)pValue).getElements()) {
                if (!value.getMetaType().isComposite()) {
                    throw new IllegalStateException(pValue + " is not a Composite type");
                }
                ManagedRepository repository = (ManagedRepository)MetaValueFactory.getInstance().unwrap(value);
                list.add(repository);
            }
        }
        return list;
    }

    public static String getConnectorPingString(MetaValue pValue) throws Exception {
        MetaType metaType = pValue.getMetaType();
        StringBuffer sb = new StringBuffer();
        if (metaType.isCollection()) {
            for (MetaValue value : ((CollectionValueSupport)pValue).getElements()) {
                String resultValue = ProfileServiceUtil.stringValue(value);
                sb.append(resultValue + " ");
            }
        }
        return sb.toString();
    }

    public static Collection<ManagedSequencerConfig> getSequencerCollectionValue(MetaValue pValue) {
        ArrayList<ManagedSequencerConfig> list = new ArrayList<ManagedSequencerConfig>();
        MetaType metaType = pValue.getMetaType();
        if (metaType.isCollection()) {
            for (MetaValue value : ((CollectionValueSupport)pValue).getElements()) {
                if (!value.getMetaType().isComposite()) {
                    throw new IllegalStateException(pValue + " is not a Composite type");
                }
                ManagedSequencerConfig sequencer = (ManagedSequencerConfig)MetaValueFactory.getInstance().unwrap(value);
                list.add(sequencer);
            }
        }
        return list;
    }

    private Collection createReportResultList(List fieldNameList, Iterator objectIter) {
        ArrayList reportResultList = new ArrayList();
        while (objectIter.hasNext()) {
            Object object = objectIter.next();
            Class<?> cls = null;
            try {
                cls = object.getClass();
                Iterator methodIter = fieldNameList.iterator();
                HashMap<String, Object> reportValueMap = new HashMap<String, Object>();
                while (methodIter.hasNext()) {
                    String fieldName;
                    String methodName = fieldName = (String)methodIter.next();
                    Method meth = cls.getMethod(methodName, null);
                    Object retObj = meth.invoke(object, (Object[])null);
                    reportValueMap.put(fieldName, retObj);
                }
                reportResultList.add(reportValueMap);
            }
            catch (Throwable e) {
                System.err.println(e);
            }
        }
        return reportResultList;
    }
}

