/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.test.integration;

import java.io.File;
import javax.ejb.EJB;
import javax.jcr.Repository;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.hamcrest.core.IsSame;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.modeshape.test.integration.RepositoryProvider;
import org.modeshape.test.integration.StatelessRepositoryProvider;

@RunWith(value=Arquillian.class)
public class StatelessRepositoryProviderIntegrationTest {
    @EJB
    private StatelessRepositoryProvider provider;

    @Deployment
    public static WebArchive createDeployment() {
        WebArchive archive = (WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"stateless-test.war")).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, ArchivePaths.create((String)"beans.xml"))).addClasses(new Class[]{StatelessRepositoryProvider.class, RepositoryProvider.class});
        archive.setManifest(new File("src/main/webapp/META-INF/MANIFEST.MF"));
        return archive;
    }

    @Test
    public void testProviderFindingRepositoriesInJndi() throws Exception {
        Repository repository = this.provider.getRepositoryFromRepositoriesInJndi("jcr", "sample");
        Assert.assertThat((Object)repository, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.provider.loginAndLogout(repository);
        this.provider.loginAndLogout(repository, "default");
        Repository repository2 = this.provider.getRepositoryFromRepositoriesInJndi("java:/jcr", "sample");
        Assert.assertThat((Object)repository2, (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)repository)));
    }

    @Test
    public void testProviderFindingRepositoryInJndi() throws Exception {
        Repository repository = this.provider.getRepositoryFromJndi("jcr/sample");
        Assert.assertThat((Object)repository, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.provider.loginAndLogout(repository);
        this.provider.loginAndLogout(repository, "default");
        Repository repository2 = this.provider.getRepositoryFromJndi("java:/jcr/sample");
        Assert.assertThat((Object)repository2, (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)repository)));
    }

    @Test
    public void testProviderFindingRepositoryWithFactory() throws Exception {
        Repository repository = this.provider.getRepositoryUsingRepositoryFactory("jndi:jcr/sample");
        Assert.assertThat((Object)repository, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.provider.loginAndLogout(repository);
        this.provider.loginAndLogout(repository, "default");
        Repository repository2 = this.provider.getRepositoryUsingRepositoryFactory("jndi:jcr?repositoryName=sample");
        Assert.assertThat((Object)repository2, (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)repository)));
        Repository repository3 = this.provider.getRepositoryUsingRepositoryFactory("jndi:jcr", "sample");
        Assert.assertThat((Object)repository3, (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)repository)));
    }
}

