/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.test.integration;

import java.util.HashMap;
import java.util.ServiceLoader;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.RepositoryFactory;
import javax.jcr.Session;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.modeshape.jcr.api.Repositories;

public class RepositoryProvider {
    public Repository getRepositoryFromJndi(String jndiName) throws NamingException {
        InitialContext context = new InitialContext();
        return (Repository)context.lookup(jndiName);
    }

    public Repository getRepositoryFromRepositoriesInJndi(String jndiNameOfRepositories, String repositoryName) throws NamingException, RepositoryException {
        InitialContext context = new InitialContext();
        Repositories repositories = (Repositories)context.lookup(jndiNameOfRepositories);
        if (repositories == null) {
            throw new RepositoryException("Repository container could not be found in JNDI at '" + jndiNameOfRepositories + "'");
        }
        return repositories.getRepository(repositoryName);
    }

    public Repository getRepositoryUsingRepositoryFactory(String url) throws RepositoryException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("org.modeshape.jcr.URL", url);
        for (RepositoryFactory factory : ServiceLoader.load(RepositoryFactory.class)) {
            Repository repository = factory.getRepository(params);
            if (repository == null) continue;
            return repository;
        }
        return null;
    }

    public Repository getRepositoryUsingRepositoryFactory(String url, String repositoryName) throws RepositoryException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("org.modeshape.jcr.URL", url);
        params.put("org.modeshape.jcr.RepositoryName", repositoryName);
        for (RepositoryFactory factory : ServiceLoader.load(RepositoryFactory.class)) {
            Repository repository = factory.getRepository(params);
            if (repository == null) continue;
            return repository;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loginAndLogout(Repository repository) throws RepositoryException {
        Session session = repository.login();
        try {
            Node node = session.getRootNode();
            String path = node.getPath();
            assert (path != null) : "Path of the root node was null; what's up with that?";
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loginAndLogout(Repository repository, String workspaceName) throws RepositoryException {
        Session session = repository.login(workspaceName);
        try {
            Node node = session.getRootNode();
            String path = node.getPath();
            assert (path != null) : "Path of the root node was null; what's up with that?";
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loginAndLogout(Repository repository, Credentials credentials) throws RepositoryException {
        Session session = repository.login(credentials);
        try {
            Node node = session.getRootNode();
            String path = node.getPath();
            assert (path != null) : "Path of the root node was null; what's up with that?";
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loginAndLogout(Repository repository, Credentials credentials, String workspaceName) throws RepositoryException {
        Session session = repository.login(credentials, workspaceName);
        try {
            Node node = session.getRootNode();
            String path = node.getPath();
            assert (path != null) : "Path of the root node was null; what's up with that?";
        }
        finally {
            session.logout();
        }
    }
}

