/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.test.kit;

import java.io.File;
import java.io.IOException;
import javax.annotation.Resource;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import javax.sql.DataSource;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.resolver.api.DependencyResolvers;
import org.jboss.shrinkwrap.resolver.api.maven.MavenDependencyResolver;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.modeshape.jcr.api.Repository;

@RunWith(value=Arquillian.class)
public class JBossASKitTest {
    @Resource(mappedName="java:/datasources/ModeShapeDS")
    private DataSource modeshapeDS;
    @Resource(mappedName="java:/jcr/artifacts")
    private Repository artifactsRepo;
    @Resource(mappedName="java:/jcr/sample")
    private Repository sampleRepo;

    @Deployment
    public static WebArchive createDeployment() {
        MavenDependencyResolver mavenResolver = ((MavenDependencyResolver)((MavenDependencyResolver)DependencyResolvers.use(MavenDependencyResolver.class)).goOffline().loadMetadataFromPom("pom.xml").artifact("org.apache.httpcomponents:httpclient:jar")).scope("test");
        return (WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"as7-kit-test.war")).addAsLibraries(mavenResolver.resolveAsFiles())).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, ArchivePaths.create((String)"beans.xml"))).setManifest(new File("src/main/webapp/META-INF/MANIFEST.MF"));
    }

    @Test
    public void repositoriesShouldBeAccessible() throws Exception {
        Assert.assertNotNull((Object)this.artifactsRepo);
        Assert.assertNotNull((Object)this.artifactsRepo.login("default"));
        Assert.assertNotNull((Object)this.sampleRepo);
        Assert.assertNotNull((Object)this.sampleRepo.login("default"));
    }

    @Test
    public void artifactsRepositoryShouldBePublishArea() throws Exception {
        Session session = this.artifactsRepo.login();
        Node filesFolder = session.getNode("/files");
        junit.framework.Assert.assertNotNull((Object)filesFolder);
        junit.framework.Assert.assertEquals((String)"nt:folder", (String)filesFolder.getPrimaryNodeType().getName());
        NodeType[] mixins = filesFolder.getMixinNodeTypes();
        junit.framework.Assert.assertEquals((int)1, (int)mixins.length);
        junit.framework.Assert.assertEquals((String)"mode:publishArea", (String)mixins[0].getName());
    }

    @Test
    public void dataSourcesShouldBeAccessible() throws Exception {
        Assert.assertNotNull((Object)this.modeshapeDS);
        Assert.assertNotNull((Object)this.modeshapeDS.getConnection("admin", "admin"));
    }

    @Test
    public void webApplicationsShouldBeAccessible() throws Exception {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        httpClient.setCredentialsProvider((CredentialsProvider)new BasicCredentialsProvider(){

            public Credentials getCredentials(AuthScope authscope) {
                return new UsernamePasswordCredentials("admin", "admin");
            }
        });
        this.assertURIisAccessible("http://localhost:8080/modeshape-webdav", (HttpClient)httpClient);
        this.assertURIisAccessible("http://localhost:8080/modeshape-rest", (HttpClient)httpClient);
    }

    private void assertURIisAccessible(String uri, HttpClient httpClient) throws IOException {
        HttpGet get = new HttpGet(uri);
        HttpResponse httpResponse = httpClient.execute((HttpUriRequest)get);
        Assert.assertEquals((long)200L, (long)httpResponse.getStatusLine().getStatusCode());
        EntityUtils.consume((HttpEntity)httpResponse.getEntity());
    }
}

