/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.modeshape.jboss.subsystem.Element;
import org.modeshape.jboss.subsystem.Namespace;

public class ModeShapeSubsystemParser
implements XMLStreamConstants,
XMLElementReader<List<ModelNode>>,
XMLElementWriter<SubsystemMarshallingContext> {
    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement(Namespace.CURRENT.getUri(), false);
        ModelNode node = context.getModelNode();
        if (!node.isDefined()) {
            return;
        }
        if (this.has(node, Element.REPOSITORY_ELEMENT.getLocalName())) {
            ArrayList repositories = new ArrayList(node.get(Element.REPOSITORY_ELEMENT.getLocalName()).keys());
            Collections.sort(repositories);
            if (!repositories.isEmpty()) {
                for (String repository : repositories) {
                    writer.writeStartElement(Element.REPOSITORY_ELEMENT.getLocalName());
                    this.writeRepositoryConfiguration(writer, node.get(new String[]{Element.REPOSITORY_ELEMENT.getLocalName(), repository}), repository);
                }
            }
        }
        writer.writeEndElement();
    }

    private void writeRepositoryConfiguration(XMLExtendedStreamWriter writer, ModelNode node, String repositoryName) throws XMLStreamException {
        this.writeAttribute(writer, Element.REPOSITORY_NAME_ATTRIBUTE, node);
        this.writeAttribute(writer, Element.REPOSITORY_JNDI_NAME_ATTRIBUTE, node);
        if (this.like(node, Element.SEQUENCER_ELEMENT)) {
            writer.writeStartElement(Element.SEQUENCING_ELEMENT.getLocalName());
            List sequencerList = node.get(Element.SEQUENCER_ELEMENT.getLocalName()).asPropertyList();
            for (Property sequencer : sequencerList) {
                writer.writeStartElement(Element.SEQUENCER_ELEMENT.getLocalName());
                writer.writeAttribute(Element.SEQUENCER_NAME_ATTRIBUTE.getLocalName(), sequencer.getName());
                this.writePropertyAttribute(writer, sequencer.getValue().get(Element.SEQUENCER_DESCRIPTION_ATTRIBUTE.getModelName()).asString(), Element.SEQUENCER_DESCRIPTION_ATTRIBUTE);
                this.writePropertyAttribute(writer, sequencer.getValue().get(Element.SEQUENCER_TYPE_ATTRIBUTE.getModelName()).asString(), Element.SEQUENCER_TYPE_ATTRIBUTE);
                this.writePropertyAttribute(writer, sequencer.getValue().get(Element.SEQUENCER_EXPRESSIONS_ATTRIBUTE.getModelName()).asString(), Element.SEQUENCER_EXPRESSIONS_ATTRIBUTE);
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        ModelNode subsystem = new ModelNode();
        subsystem.add("subsystem", "modeshape");
        subsystem.protect();
        ModelNode bootServices = new ModelNode();
        bootServices.get("operation").set("add");
        bootServices.get("address").set(subsystem);
        list.add(bootServices);
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        ArrayList<ModelNode> repositories = new ArrayList<ModelNode>();
        while (reader.hasNext() && reader.nextTag() != 2) {
            if (!reader.isStartElement()) continue;
            block0 : switch (Namespace.forUri(reader.getNamespaceURI())) {
                case MODESHAPE_3_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case REPOSITORY_ELEMENT: {
                            this.parseRepository(reader, subsystem, repositories);
                            break block0;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
        }
        list.addAll(repositories);
    }

    private void parseRepository(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> repositories) throws XMLStreamException {
        ModelNode repository = new ModelNode();
        ModelNode repositoryAddress = address.clone();
        repository.get("operation").set("add");
        String repositoryName = null;
        List<Object> sequencers = new ArrayList();
        if (reader.getAttributeCount() > 0) {
            block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                Element element = Element.forName(attrName);
                switch (element) {
                    case REPOSITORY_NAME_ATTRIBUTE: {
                        repositoryName = attrValue;
                        repositoryAddress.add("repository", attrValue);
                        repositoryAddress.protect();
                        repository.get("operation").set("add");
                        repository.get("address").set(repositoryAddress);
                        repository.get(element.getModelName()).set(attrValue);
                        repositories.add(repository);
                        continue block7;
                    }
                    case REPOSITORY_JNDI_NAME_ATTRIBUTE: {
                        repository.get(element.getModelName()).set(attrValue);
                        continue block7;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
        }
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case SEQUENCING_ELEMENT: {
                    sequencers = this.parseSequencers(reader, address, repositoryName);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        repositories.addAll(sequencers);
    }

    private List<ModelNode> parseSequencers(XMLExtendedStreamReader reader, ModelNode parentAddress, String repositoryName) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        ArrayList<ModelNode> sequencers = new ArrayList<ModelNode>();
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case SEQUENCER_ELEMENT: {
                    this.parseSequencer(reader, repositoryName, sequencers);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return sequencers;
    }

    private void parseSequencer(XMLExtendedStreamReader reader, String repositoryName, List<ModelNode> sequencers) throws XMLStreamException {
        ModelNode sequencer = new ModelNode();
        sequencer.get("operation").set("add");
        String name = null;
        sequencers.add(sequencer);
        if (reader.getAttributeCount() > 0) {
            block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                Element element = Element.forName(attrName, Element.SEQUENCER_ELEMENT);
                switch (element) {
                    case SEQUENCER_NAME_ATTRIBUTE: {
                        name = attrValue;
                        sequencer.get(element.getModelName()).set(attrValue);
                        continue block6;
                    }
                    case SEQUENCER_DESCRIPTION_ATTRIBUTE: {
                        sequencer.get(element.getModelName()).set(attrValue);
                        continue block6;
                    }
                    case SEQUENCER_EXPRESSIONS_ATTRIBUTE: {
                        sequencer.get(element.getModelName()).set(attrValue);
                        continue block6;
                    }
                    case SEQUENCER_TYPE_ATTRIBUTE: {
                        sequencer.get(element.getModelName()).set(attrValue);
                        continue block6;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
        }
        while (reader.hasNext() && reader.nextTag() != 2) {
        }
        sequencer.get("address").add("subsystem", "modeshape").add(Element.REPOSITORY_ELEMENT.getLocalName(), repositoryName).add(Element.SEQUENCER_ELEMENT.getLocalName(), name);
    }

    private boolean has(ModelNode node, String name) {
        return node.has(name) && node.get(name).isDefined();
    }

    private void writeAttribute(XMLExtendedStreamWriter writer, Element element, ModelNode node) throws XMLStreamException {
        String value;
        if (this.has(node, element.getModelName()) && !element.sameAsDefault(value = node.get(element.getModelName()).asString())) {
            writer.writeAttribute(element.getLocalName(), value);
        }
    }

    private void writePropertyAttribute(XMLExtendedStreamWriter writer, String value, Element element) throws XMLStreamException {
        if (value != null & !value.equals("undefined") && !element.sameAsDefault(value)) {
            writer.writeAttribute(element.getLocalName(), value);
        }
    }

    private boolean like(ModelNode node, Element element) {
        if (node.isDefined()) {
            Set keys = node.keys();
            for (String key : keys) {
                if (!key.startsWith(element.getLocalName())) continue;
                return true;
            }
        }
        return false;
    }
}

