/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.modeshape.jboss.service.SequencerService;
import org.modeshape.jboss.subsystem.Element;
import org.modeshape.jboss.subsystem.JBossSubsystemI18n;
import org.modeshape.jboss.subsystem.ModeShapeServiceNames;
import org.modeshape.jcr.JcrEngine;
import org.modeshape.jcr.JcrRepository;

public class SequencerAdd
extends AbstractAddStepHandler
implements DescriptionProvider {
    private static Element[] attributes = new Element[]{Element.SEQUENCER_NAME_ATTRIBUTE, Element.SEQUENCER_DESCRIPTION_ATTRIBUTE, Element.SEQUENCER_EXPRESSIONS_ATTRIBUTE, Element.SEQUENCER_TYPE_ATTRIBUTE};
    public static final SequencerAdd INSTANCE = new SequencerAdd();

    private SequencerAdd() {
    }

    public ModelNode getModelDescription(Locale locale) {
        ResourceBundle bundle = JBossSubsystemI18n.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("add");
        node.get("description").set("sequencer.add");
        SequencerAdd.describeSequencer(node, "request-properties", bundle);
        return node;
    }

    static void describeSequencer(ModelNode node, String type, ResourceBundle bundle) {
        SequencerAdd.sequencerDescribe(node, type, bundle);
    }

    static void sequencerDescribe(ModelNode node, String type, ResourceBundle bundle) {
        for (int i = 0; i < attributes.length; ++i) {
            attributes[i].describe(node, type, bundle);
        }
    }

    protected void populateModel(ModelNode operation, ModelNode model) {
        SequencerAdd.populate(operation, model);
    }

    public static void populate(ModelNode operation, ModelNode model) {
        for (int i = 0; i < attributes.length; ++i) {
            attributes[i].populate(operation, model);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ServiceTarget target = context.getServiceTarget();
        Properties props = new Properties();
        ModelNode address = operation.require("address");
        PathAddress pathAddress = PathAddress.pathAddress((ModelNode)address);
        String repositoryName = pathAddress.getElement(1).getValue();
        String sequencerName = pathAddress.getLastElement().getValue();
        props.put(Element.SEQUENCER_NAME_ATTRIBUTE.getLocalName(), sequencerName);
        if (Element.SEQUENCER_TYPE_ATTRIBUTE.isDefined(operation)) {
            props.put(Element.SEQUENCER_TYPE_ATTRIBUTE.getLocalName(), Element.SEQUENCER_TYPE_ATTRIBUTE.asString(operation));
        }
        if (Element.SEQUENCER_EXPRESSIONS_ATTRIBUTE.isDefined(operation)) {
            props.put(Element.SEQUENCER_EXPRESSIONS_ATTRIBUTE.getLocalName(), Element.SEQUENCER_EXPRESSIONS_ATTRIBUTE.asString(operation));
        }
        SequencerService sequencerService = new SequencerService(repositoryName, props);
        ServiceBuilder sequencerBuilder = target.addService(ModeShapeServiceNames.sequencerServiceName(repositoryName + sequencerName), (Service)sequencerService);
        sequencerBuilder.addDependency(ModeShapeServiceNames.ENGINE, JcrEngine.class, sequencerService.getJcrEngineInjector());
        sequencerBuilder.addDependency(ModeShapeServiceNames.repositoryServiceName(repositoryName), JcrRepository.class, sequencerService.getJcrRepositoryInjector());
        sequencerBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
        ServiceController controller = sequencerBuilder.install();
        newControllers.add(controller);
    }
}

