/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.modeshape.jboss.subsystem.ModelAttributes;
import org.modeshape.jboss.subsystem.Namespace;

public class ModeShapeDescriptions {
    public static final String RESOURCE_NAME = ModeShapeDescriptions.class.getPackage().getName() + ".LocalDescriptions";

    private ModeShapeDescriptions() {
    }

    static ModelNode getSubsystemDescription(Locale locale) {
        ResourceBundle resources = ModeShapeDescriptions.getResources(locale);
        ModelNode subsystem = ModeShapeDescriptions.createDescription(resources, "modeshape");
        subsystem.get("head-comment-allowed").set(true);
        subsystem.get("tail-comment-allowed").set(true);
        subsystem.get("namespace").set(Namespace.CURRENT.getUri());
        subsystem.get(new String[]{"children", "repository", "description"}).set(resources.getString("repository.describe"));
        subsystem.get(new String[]{"children", "repository", "min-occurs"}).set(1);
        subsystem.get(new String[]{"children", "repository", "max-occurs"}).set(Integer.MAX_VALUE);
        return subsystem;
    }

    static ModelNode getSubsystemAddDescription(Locale locale) {
        ResourceBundle resources = ModeShapeDescriptions.getResources(locale);
        ModelNode op = ModeShapeDescriptions.createOperationDescription("add", resources, "modeshape.add");
        return op;
    }

    static ModelNode getSubsystemDescribeDescription(Locale locale) {
        ResourceBundle resources = ModeShapeDescriptions.getResources(locale);
        ModelNode op = ModeShapeDescriptions.createOperationDescription("describe", resources, "modeshape.describe");
        op.get("request-properties").setEmptyObject();
        op.get(new String[]{"reply-properties", "type"}).set(ModelType.LIST);
        op.get(new String[]{"reply-properties", "value-type"}).set(ModelType.OBJECT);
        return op;
    }

    static ModelNode getRepositoryDescription(Locale locale) {
        ResourceBundle resources = ModeShapeDescriptions.getResources(locale);
        String keyPrefix = "repository";
        ModelNode repository = ModeShapeDescriptions.createDescription(resources, "repository");
        for (AttributeDefinition attr : ModelAttributes.REPOSITORY_ATTRIBUTES) {
            attr.addResourceAttributeDescription(resources, "repository", repository);
        }
        String indexDesc = resources.getString("repository.index-storage");
        repository.get(new String[]{"children", "index-storage", "description"}).set(indexDesc);
        repository.get(new String[]{"children", "index-storage", "min-occurs"}).set(0);
        repository.get(new String[]{"children", "index-storage", "max-occurs"}).set(1);
        repository.get(new String[]{"children", "index-storage", "allowed"}).setEmptyList();
        repository.get(new String[]{"children", "index-storage", "allowed"}).add("INDEXES");
        repository.get(new String[]{"children", "index-storage", "model-description"});
        String binaryDesc = resources.getString("repository.binary-storage");
        repository.get(new String[]{"children", "binary-storage", "description"}).set(binaryDesc);
        repository.get(new String[]{"children", "binary-storage", "min-occurs"}).set(0);
        repository.get(new String[]{"children", "binary-storage", "max-occurs"}).set(1);
        repository.get(new String[]{"children", "binary-storage", "allowed"}).setEmptyList();
        repository.get(new String[]{"children", "binary-storage", "allowed"}).add("BINARIES");
        repository.get(new String[]{"children", "binary-storage", "model-description"});
        repository.get(new String[]{"children", "sequencer", "description"}).set(resources.getString("repository.sequencer"));
        repository.get(new String[]{"children", "sequencer", "min-occurs"}).set(0);
        repository.get(new String[]{"children", "sequencer", "max-occurs"}).set(Integer.MAX_VALUE);
        repository.get(new String[]{"children", "sequencer", "model-description"});
        return repository;
    }

    static ModelNode getRepositoryAddDescription(Locale locale) {
        ResourceBundle resources = ModeShapeDescriptions.getResources(locale);
        ModelNode op = ModeShapeDescriptions.createOperationDescription("add", resources, "repository.add");
        for (AttributeDefinition attr : ModelAttributes.REPOSITORY_ATTRIBUTES) {
            attr.addOperationParameterDescription(resources, "repository", op);
        }
        return op;
    }

    static ModelNode getRepositoryRemoveDescription(Locale locale) {
        ResourceBundle resources = ModeShapeDescriptions.getResources(locale);
        ModelNode op = ModeShapeDescriptions.createOperationDescription("remove", resources, "repository.remove");
        return op;
    }

    static ModelNode getSequencerDescription(Locale locale) {
        ResourceBundle resources = ModeShapeDescriptions.getResources(locale);
        String keyPrefix = "repository.sequencer";
        ModelNode sequencer = ModeShapeDescriptions.createDescription(resources, keyPrefix);
        for (AttributeDefinition attr : ModelAttributes.SEQUENCER_ATTRIBUTES) {
            attr.addResourceAttributeDescription(resources, keyPrefix, sequencer);
        }
        return sequencer;
    }

    static ModelNode getSequencerAddDescription(Locale locale) {
        ResourceBundle resources = ModeShapeDescriptions.getResources(locale);
        ModelNode op = ModeShapeDescriptions.createOperationDescription("add", resources, "repository.sequencer.add");
        for (AttributeDefinition attr : ModelAttributes.SEQUENCER_ATTRIBUTES) {
            attr.addOperationParameterDescription(resources, "repository.sequencer", op);
        }
        return op;
    }

    static ModelNode getSequencerRemoveDescription(Locale locale) {
        ResourceBundle resources = ModeShapeDescriptions.getResources(locale);
        ModelNode op = ModeShapeDescriptions.createOperationDescription("remove", resources, "repository.sequencer.remove");
        return op;
    }

    static ModelNode getIndexStorageDescription(Locale locale) {
        ResourceBundle resources = ModeShapeDescriptions.getResources(locale);
        String keyPrefix = "repository.index-storage";
        ModelNode indexes = ModeShapeDescriptions.createDescription(resources, keyPrefix);
        return indexes;
    }

    static ModelNode getRamIndexStorageAddDescription(Locale locale) {
        ResourceBundle resources = ModeShapeDescriptions.getResources(locale);
        ModelNode op = ModeShapeDescriptions.createOperationDescription("add-ram-index-storage", resources, "repository.ram-index-storage.add");
        for (AttributeDefinition attr : ModelAttributes.RAM_INDEX_STORAGE_ATTRIBUTES) {
            attr.addOperationParameterDescription(resources, "repository.ram-index-storage", op);
        }
        return op;
    }

    static ModelNode getCacheIndexStorageAddDescription(Locale locale) {
        ResourceBundle resources = ModeShapeDescriptions.getResources(locale);
        ModelNode op = ModeShapeDescriptions.createOperationDescription("add-cache-index-storage", resources, "repository.cache-index-storage.add");
        for (AttributeDefinition attr : ModelAttributes.CACHE_INDEX_STORAGE_ATTRIBUTES) {
            attr.addOperationParameterDescription(resources, "repository.cache-index-storage", op);
        }
        return op;
    }

    static ModelNode getCustomIndexStorageAddDescription(Locale locale) {
        ResourceBundle resources = ModeShapeDescriptions.getResources(locale);
        ModelNode op = ModeShapeDescriptions.createOperationDescription("add-custom-index-storage", resources, "repository.custom-index-storage.add");
        for (AttributeDefinition attr : ModelAttributes.CUSTOM_INDEX_STORAGE_ATTRIBUTES) {
            attr.addOperationParameterDescription(resources, "repository.custom-index-storage", op);
        }
        return op;
    }

    static ModelNode getLocalFileIndexStorageAddDescription(Locale locale) {
        ResourceBundle resources = ModeShapeDescriptions.getResources(locale);
        ModelNode op = ModeShapeDescriptions.createOperationDescription("add-local-file-index-storage", resources, "repository.local-file-index-storage.add");
        for (AttributeDefinition attr : ModelAttributes.LOCAL_FILE_INDEX_STORAGE_ATTRIBUTES) {
            attr.addOperationParameterDescription(resources, "repository.local-file-index-storage", op);
        }
        return op;
    }

    static ModelNode getMasterFileIndexStorageAddDescription(Locale locale) {
        ResourceBundle resources = ModeShapeDescriptions.getResources(locale);
        ModelNode op = ModeShapeDescriptions.createOperationDescription("add-master-file-index-storage", resources, "repository.master-file-index-storage.add");
        for (AttributeDefinition attr : ModelAttributes.MASTER_FILE_INDEX_STORAGE_ATTRIBUTES) {
            attr.addOperationParameterDescription(resources, "repository.master-file-index-storage", op);
        }
        return op;
    }

    static ModelNode getSlaveFileIndexStorageAddDescription(Locale locale) {
        ResourceBundle resources = ModeShapeDescriptions.getResources(locale);
        ModelNode op = ModeShapeDescriptions.createOperationDescription("add-slave-file-index-storage", resources, "repository.slave-file-index-storage.add");
        for (AttributeDefinition attr : ModelAttributes.SLAVE_FILE_INDEX_STORAGE_ATTRIBUTES) {
            attr.addOperationParameterDescription(resources, "repository.slave-file-index-storage", op);
        }
        return op;
    }

    static ModelNode getIndexStorageRemoveDescription(Locale locale) {
        ResourceBundle resources = ModeShapeDescriptions.getResources(locale);
        ModelNode op = ModeShapeDescriptions.createOperationDescription("remove-index-storage", resources, "repository.index-storage.remove");
        return op;
    }

    static ModelNode getBinaryStorageDescription(Locale locale) {
        ResourceBundle resources = ModeShapeDescriptions.getResources(locale);
        String keyPrefix = "repository.binary-storage";
        ModelNode binaries = ModeShapeDescriptions.createDescription(resources, keyPrefix);
        return binaries;
    }

    static ModelNode getFileBinaryStorageAddDescription(Locale locale) {
        ResourceBundle resources = ModeShapeDescriptions.getResources(locale);
        String key = "repository.file-binary-storage";
        ModelNode op = ModeShapeDescriptions.createOperationDescription("add-file-binary-storage", resources, "repository.file-binary-storage.add");
        for (AttributeDefinition attr : ModelAttributes.FILE_BINARY_STORAGE_ATTRIBUTES) {
            attr.addOperationParameterDescription(resources, "repository.file-binary-storage", op);
        }
        return op;
    }

    static ModelNode getBinaryStorageRemoveDescription(Locale locale) {
        ResourceBundle resources = ModeShapeDescriptions.getResources(locale);
        String key = "repository.binary-storage";
        ModelNode op = ModeShapeDescriptions.createOperationDescription("remove-binary-storage", resources, "repository.binary-storage.remove");
        return op;
    }

    static ModelNode getCacheBinaryStorageAddDescription(Locale locale) {
        ResourceBundle resources = ModeShapeDescriptions.getResources(locale);
        String key = "repository.cache-binary-storage";
        ModelNode op = ModeShapeDescriptions.createOperationDescription("add-cache-binary-storage", resources, "repository.cache-binary-storage.add");
        for (AttributeDefinition attr : ModelAttributes.CACHE_BINARY_STORAGE_ATTRIBUTES) {
            attr.addOperationParameterDescription(resources, "repository.cache-binary-storage", op);
        }
        return op;
    }

    static ModelNode getDatabaseBinaryStorageAddDescription(Locale locale) {
        ResourceBundle resources = ModeShapeDescriptions.getResources(locale);
        String key = "repository.db-binary-storage";
        ModelNode op = ModeShapeDescriptions.createOperationDescription("add-db-binary-storage", resources, "repository.db-binary-storage.add");
        for (AttributeDefinition attr : ModelAttributes.DATABASE_BINARY_STORAGE_ATTRIBUTES) {
            attr.addOperationParameterDescription(resources, "repository.db-binary-storage", op);
        }
        return op;
    }

    static ModelNode getCustomBinaryStorageAddDescription(Locale locale) {
        ResourceBundle resources = ModeShapeDescriptions.getResources(locale);
        String key = "repository.custom-binary-storage";
        ModelNode op = ModeShapeDescriptions.createOperationDescription("add-custom-binary-storage", resources, "repository.custom-binary-storage.add");
        for (AttributeDefinition attr : ModelAttributes.CUSTOM_BINARY_STORAGE_ATTRIBUTES) {
            attr.addOperationParameterDescription(resources, "repository.custom-binary-storage", op);
        }
        return op;
    }

    static ResourceBundle getResources(Locale locale) {
        return ResourceBundle.getBundle(RESOURCE_NAME, locale == null ? Locale.getDefault() : locale);
    }

    private static ModelNode createDescription(ResourceBundle resources, String key) {
        return ModeShapeDescriptions.createOperationDescription(null, resources, key);
    }

    private static ModelNode createOperationDescription(String operation, ResourceBundle resources, String key) {
        ModelNode description = new ModelNode();
        if (operation != null) {
            description.get("operation-name").set(operation);
        }
        description.get("description").set(resources.getString(key));
        return description;
    }
}

