/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import java.util.ArrayList;
import java.util.HashSet;
import javax.jcr.RepositoryException;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.modeshape.jboss.service.RepositoryService;
import org.modeshape.jboss.subsystem.MappedAttributeDefinition;
import org.modeshape.jboss.subsystem.ModeShapeServiceNames;

public abstract class AbstractRepositoryConfigWriteAttributeHandler
extends AbstractWriteAttributeHandler<Void> {
    private final AttributeDefinition[] attributes;

    protected AbstractRepositoryConfigWriteAttributeHandler(AttributeDefinition[] attributes) {
        super(attributes);
        this.attributes = attributes;
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> handbackHolder) throws OperationFailedException {
        try {
            boolean changedImmediately = this.changeConfiguration(context, operation, attributeName, resolvedValue, currentValue);
            return !changedImmediately;
        }
        catch (RepositoryException t) {
            String repositoryName = this.repositoryName(operation);
            throw new OperationFailedException("Unable to set attribute '" + attributeName + "' on the '" + repositoryName + "' repository from " + currentValue + " to " + resolvedValue + ": " + t.getMessage(), (Throwable)t);
        }
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Void handback) throws OperationFailedException {
        try {
            this.changeConfiguration(context, operation, attributeName, valueToRestore, valueToRevert);
        }
        catch (RepositoryException t) {
            String repositoryName = this.repositoryName(operation);
            throw new OperationFailedException("Unable to restore attribute '" + attributeName + "' on the '" + repositoryName + "' repository from " + valueToRevert + " to " + valueToRestore + ": " + t.getMessage(), (Throwable)t);
        }
    }

    protected final String repositoryName(ModelNode operation) {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        PathElement element = address.getElement(1);
        return element.getValue();
    }

    protected boolean changeConfiguration(OperationContext context, ModelNode operation, String attributeName, ModelNode newValue, ModelNode existingValue) throws RepositoryException, OperationFailedException {
        AttributeDefinition attribute = this.getAttributeDefinition(attributeName);
        if (attribute instanceof MappedAttributeDefinition) {
            MappedAttributeDefinition mappedDefn = (MappedAttributeDefinition)attribute;
            String repositoryName = this.repositoryName(operation);
            ServiceName repositoryServiceName = ModeShapeServiceNames.repositoryServiceName(repositoryName);
            ServiceController sc = context.getServiceRegistry(true).getRequiredService(repositoryServiceName);
            RepositoryService repositoryService = (RepositoryService)RepositoryService.class.cast(sc.getService());
            return this.changeField(context, operation, repositoryService, mappedDefn, newValue);
        }
        return false;
    }

    public void registerAttributes(ManagementResourceRegistration registry) {
        for (AttributeDefinition attr : this.attributes) {
            registry.registerReadWriteAttribute(attr, null, (OperationStepHandler)this);
        }
    }

    protected boolean changeField(OperationContext context, ModelNode operation, RepositoryService repositoryService, MappedAttributeDefinition defn, ModelNode newValue) throws RepositoryException, OperationFailedException {
        repositoryService.changeField(defn, newValue);
        return true;
    }

    protected static AttributeDefinition[] unique(AttributeDefinition[] ... modelAttributeArrays) {
        HashSet<String> names = new HashSet<String>();
        ArrayList<AttributeDefinition> defns = new ArrayList<AttributeDefinition>();
        AttributeDefinition[][] arr$ = modelAttributeArrays;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            AttributeDefinition[] array;
            for (AttributeDefinition defn : array = arr$[i$]) {
                if (!names.add(defn.getName())) continue;
                defns.add(defn);
            }
        }
        return defns.toArray(new AttributeDefinition[defns.size()]);
    }

    protected static AttributeDefinition[] allBut(AttributeDefinition[] definitions, String ... excluded) {
        HashSet<String> excludedNames = new HashSet<String>();
        for (String excludedName : excluded) {
            excludedNames.add(excludedName);
        }
        boolean foundExcluded = false;
        ArrayList<AttributeDefinition> defns = new ArrayList<AttributeDefinition>();
        for (AttributeDefinition defn : definitions) {
            if (excludedNames.contains(defn.getName())) {
                foundExcluded = true;
                continue;
            }
            defns.add(defn);
        }
        return foundExcluded ? defns.toArray(new AttributeDefinition[defns.size()]) : definitions;
    }
}

