/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import org.infinispan.schematic.document.EditableDocument;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.modeshape.jboss.subsystem.AbstractAddFileSystemIndexStorage;
import org.modeshape.jboss.subsystem.ModelAttributes;

public class AddMasterFileSystemIndexStorage
extends AbstractAddFileSystemIndexStorage {
    public static final AddMasterFileSystemIndexStorage INSTANCE = new AddMasterFileSystemIndexStorage();

    private AddMasterFileSystemIndexStorage() {
    }

    @Override
    protected void writeIndexingBackendConfiguration(OperationContext context, ModelNode storage, EditableDocument backend) throws OperationFailedException {
        backend.set("type", (Object)"jms-master");
        String connJndi = ModelAttributes.CONNECTION_FACTORY_JNDI_NAME.resolveModelAttribute(context, storage).asString();
        String queueJndi = ModelAttributes.QUEUE_JNDI_NAME.resolveModelAttribute(context, storage).asString();
        backend.set("connectionFactoryJndiName", (Object)connJndi);
        backend.set("queueJndiName", (Object)queueJndi);
    }

    @Override
    protected void writeIndexStorageConfiguration(OperationContext context, ModelNode storage, EditableDocument indexStorage) throws OperationFailedException {
        indexStorage.set("type", (Object)"filesystem-master");
        String relativeTo = ModelAttributes.RELATIVE_TO.resolveModelAttribute(context, storage).asString();
        String path = ModelAttributes.PATH.resolveModelAttribute(context, storage).asString();
        String accessType = ModelAttributes.ACCESS_TYPE.resolveModelAttribute(context, storage).asString();
        String locking = ModelAttributes.LOCKING_STRATEGY.resolveModelAttribute(context, storage).asString();
        String refresh = ModelAttributes.REFRESH_PERIOD.resolveModelAttribute(context, storage).asString();
        String sourceRelativeTo = ModelAttributes.SOURCE_RELATIVE_TO.resolveModelAttribute(context, storage).asString();
        String sourcePath = ModelAttributes.SOURCE_PATH.resolveModelAttribute(context, storage).asString();
        if (storage.has("relative-to") && storage.get("relative-to").asString().contains("jboss.server.data.dir")) {
            this.setIndexStoragePathInDataDirectory(path);
        }
        if (storage.has("source-relative-to") && storage.get("source-relative-to").asString().contains("jboss.server.data.dir")) {
            this.setIndexSourcePathInDataDirectory(sourcePath);
        }
        path = relativeTo + path;
        sourcePath = sourceRelativeTo + sourcePath;
        indexStorage.set("type", (Object)"filesystem-master");
        indexStorage.set("location", (Object)path);
        indexStorage.set("lockingStrategy", (Object)locking.toLowerCase());
        indexStorage.set("fileSystemAccessType", (Object)accessType.toLowerCase());
        indexStorage.set("refreshInSeconds", (Object)refresh);
        indexStorage.set("sourceLocation", (Object)sourcePath);
    }
}

