/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.naming.ManagedReferenceInjector;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.Module;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.naming.SingletonInitialContextFactory;
import org.modeshape.jboss.lifecycle.JBossLifeCycleListener;
import org.modeshape.jboss.service.EngineService;
import org.modeshape.jboss.service.ReferenceFactoryService;
import org.modeshape.jboss.subsystem.ModeShapeServiceNames;
import org.modeshape.jboss.subsystem.ModelAttributes;
import org.modeshape.jcr.JcrEngine;

class AddModeShapeSubsystem
extends AbstractAddStepHandler {
    public static final AddModeShapeSubsystem INSTANCE = new AddModeShapeSubsystem();
    EngineService engine;
    SingletonInitialContextFactory scf = new SingletonInitialContextFactory();
    final JBossLifeCycleListener shutdownListener = new JBossLifeCycleListener();

    AddModeShapeSubsystem() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        AddModeShapeSubsystem.populate(operation, model);
    }

    static void populate(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (AttributeDefinition attribute : ModelAttributes.SUBSYSTEM_ATTRIBUTES) {
            attribute.validateAndSet(operation, model);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) {
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)Module.getCallerModule().getClassLoader());
            this.initializeModeShapeEngine(context, operation, model, newControllers);
        }
        finally {
            Thread.currentThread().setContextClassLoader(classloader);
        }
    }

    private void initializeModeShapeEngine(OperationContext context, ModelNode operation, ModelNode model, List<ServiceController<?>> newControllers) {
        ServiceTarget target = context.getServiceTarget();
        JBossLifeCycleListener shutdownListener = new JBossLifeCycleListener();
        this.engine = this.buildModeShapeEngine(model);
        ServiceBuilder engineBuilder = target.addService(ModeShapeServiceNames.ENGINE, (Service)this.engine);
        engineBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
        ServiceController controller = engineBuilder.install();
        controller.getServiceContainer().addTerminateListener((ServiceContainer.TerminateListener)shutdownListener);
        newControllers.add(controller);
        ReferenceFactoryService referenceFactoryService = new ReferenceFactoryService();
        ServiceName referenceFactoryServiceName = ModeShapeServiceNames.ENGINE.append(new String[]{"reference-factory"});
        ServiceBuilder referenceBuilder = target.addService(referenceFactoryServiceName, referenceFactoryService);
        referenceBuilder.addDependency(ModeShapeServiceNames.ENGINE, JcrEngine.class, referenceFactoryService.getInjector());
        referenceBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
        ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)"jcr/");
        BinderService binderService = new BinderService(bindInfo.getBindName());
        ServiceBuilder binderBuilder = target.addService(bindInfo.getBinderServiceName(), (Service)binderService);
        binderBuilder.addDependency(ModeShapeServiceNames.ENGINE, JcrEngine.class, (Injector)new ManagedReferenceInjector(binderService.getManagedObjectInjector()));
        binderBuilder.addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, binderService.getNamingStoreInjector());
        binderBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
        Logger.getLogger(((Object)((Object)this)).getClass()).debug("Binding ModeShape to JNDI name '{0}'", new Object[]{bindInfo.getAbsoluteJndiName()});
        newControllers.add(referenceBuilder.install());
        newControllers.add(binderBuilder.install());
    }

    private EngineService buildModeShapeEngine(ModelNode model) {
        EngineService engine = new EngineService(new JcrEngine());
        return engine;
    }
}

