/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.modeshape.jboss.service.SequencerService;
import org.modeshape.jboss.subsystem.ModeShapeServiceNames;
import org.modeshape.jboss.subsystem.ModelAttributes;
import org.modeshape.jcr.JcrEngine;
import org.modeshape.jcr.JcrRepository;

public class AddSequencer
extends AbstractAddStepHandler {
    public static final AddSequencer INSTANCE = new AddSequencer();

    private AddSequencer() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        AddSequencer.populate(operation, model);
    }

    static void populate(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (AttributeDefinition attribute : ModelAttributes.SEQUENCER_ATTRIBUTES) {
            attribute.validateAndSet(operation, model);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) {
        ServiceTarget target = context.getServiceTarget();
        Properties props = new Properties();
        ModelNode address = operation.require("address");
        PathAddress pathAddress = PathAddress.pathAddress((ModelNode)address);
        String repositoryName = pathAddress.getElement(1).getValue();
        String sequencerName = pathAddress.getLastElement().getValue();
        props.put("name", sequencerName);
        for (String key : operation.keys()) {
            ModelNode node;
            if (key.equals("address") || key.equals("operation") || key.equals("operation-headers") || !(node = operation.get(key)).isDefined()) continue;
            if (key.equals("classname") && ModelAttributes.SEQUENCER_CLASSNAME.isMarshallable(operation)) {
                props.put("type", node.asString());
                continue;
            }
            if (key.equals("module") && ModelAttributes.MODULE.isMarshallable(operation)) {
                props.put("classloader", node.asString());
                continue;
            }
            if (key.equals("path-expressions")) {
                ArrayList<String> pathExpressions = new ArrayList<String>();
                for (ModelNode pathExpression : operation.get("path-expressions").asList()) {
                    pathExpressions.add(pathExpression.asString());
                }
                props.put("pathExpressions", pathExpressions);
                continue;
            }
            props.put(key, node.asString());
        }
        SequencerService sequencerService = new SequencerService(repositoryName, props);
        ServiceBuilder sequencerBuilder = target.addService(ModeShapeServiceNames.sequencerServiceName(repositoryName, sequencerName), (Service)sequencerService);
        sequencerBuilder.addDependency(ModeShapeServiceNames.ENGINE, JcrEngine.class, sequencerService.getJcrEngineInjector());
        sequencerBuilder.addDependency(ModeShapeServiceNames.repositoryServiceName(repositoryName), JcrRepository.class, sequencerService.getJcrRepositoryInjector());
        sequencerBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
        ServiceController controller = sequencerBuilder.install();
        newControllers.add(controller);
    }
}

