/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import javax.jcr.ItemVisitor;
import javax.jcr.Node;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.MockitoAnnotations;
import org.modeshape.graph.property.Path;
import org.modeshape.jcr.AbstractJcrItem;
import org.modeshape.jcr.SessionCache;

public class AbstractJcrItemTest {
    private AbstractJcrItem item;
    @MockitoAnnotations.Mock
    private SessionCache cache;

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)this);
        this.item = new AbstractJcrItem(this.cache){

            public void accept(ItemVisitor visitor) {
            }

            Path path() {
                throw new UnsupportedOperationException();
            }

            public String getName() {
                return null;
            }

            public Node getParent() {
                return null;
            }

            public String getPath() {
                return null;
            }

            public boolean isNode() {
                return false;
            }

            public boolean isNew() {
                return false;
            }

            public boolean isModified() {
                return false;
            }

            public void refresh(boolean keepChanges) {
                throw new UnsupportedOperationException();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public void save() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Test
    public void shouldNotBeNew() throws Exception {
        Assert.assertThat((Object)this.item.isNew(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldNotBeModified() throws Exception {
        Assert.assertThat((Object)this.item.isModified(), (Matcher)Is.is((Object)false));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldNotAllowRefresh() throws Exception {
        this.item.refresh(false);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldNotAllowRemove() throws Exception {
        this.item.remove();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldNotAllowSave() throws Exception {
        this.item.save();
    }
}

