/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.IOException;
import javax.jcr.RepositoryException;
import javax.jcr.Workspace;
import org.junit.Before;
import org.junit.BeforeClass;
import org.mockito.Mockito;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Graph;
import org.modeshape.graph.connector.RepositoryConnection;
import org.modeshape.graph.connector.RepositoryConnectionFactory;
import org.modeshape.graph.connector.RepositorySourceException;
import org.modeshape.graph.connector.inmemory.InMemoryRepositorySource;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.jcr.CndNodeTypeSource;
import org.modeshape.jcr.JcrNodeTypeManager;
import org.modeshape.jcr.JcrNodeTypeSource;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.NodeTemplateNodeTypeSource;
import org.modeshape.jcr.RepositoryNodeTypeManager;
import org.modeshape.jcr.SessionCache;
import org.modeshape.jcr.Vehicles;

public abstract class AbstractJcrTest {
    protected static ExecutionContext context;
    protected static JcrRepository repository;
    protected static RepositoryNodeTypeManager rntm;
    protected InMemoryRepositorySource source;
    protected Graph store;
    protected int numberOfConnections;
    protected SessionCache cache;
    protected JcrSession jcrSession;
    protected JcrNodeTypeManager nodeTypes;
    protected Workspace workspace;

    @BeforeClass
    public static void beforeAll() throws Exception {
        context = new ExecutionContext();
        context.getNamespaceRegistry().register("vehix", "http://example.com/vehicles");
        repository = (JcrRepository)Mockito.mock(JcrRepository.class);
        Mockito.stub((Object)repository.getExecutionContext()).toReturn((Object)context);
        rntm = new RepositoryNodeTypeManager(repository, true);
        try {
            rntm.registerNodeTypes((JcrNodeTypeSource)new CndNodeTypeSource(new String[]{"/org/modeshape/jcr/jsr_170_builtins.cnd", "/org/modeshape/jcr/dna_builtins.cnd"}));
            rntm.registerNodeTypes((JcrNodeTypeSource)new NodeTemplateNodeTypeSource(Vehicles.getNodeTypes(context)));
        }
        catch (RepositoryException re) {
            re.printStackTrace();
            throw new IllegalStateException("Could not load node type definition files", re);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new IllegalStateException("Could not access node type definition files", ioe);
        }
    }

    @Before
    public void beforeEach() throws Exception {
        this.source = new InMemoryRepositorySource();
        this.source.setName("store");
        RepositoryConnectionFactory connectionFactory = new RepositoryConnectionFactory(){

            public RepositoryConnection createConnection(String sourceName) throws RepositorySourceException {
                if (AbstractJcrTest.this.source.getName().equals(sourceName)) {
                    ++AbstractJcrTest.this.numberOfConnections;
                    return AbstractJcrTest.this.source.getConnection();
                }
                return null;
            }
        };
        this.store = Graph.create((String)this.source.getName(), (RepositoryConnectionFactory)connectionFactory, (ExecutionContext)context);
        String xmlResourceName = this.getResourceNameOfXmlFileToImport();
        this.store.importXmlFrom(AbstractJcrTest.class.getClassLoader().getResourceAsStream(xmlResourceName)).into("/");
        this.numberOfConnections = 0;
        this.jcrSession = (JcrSession)Mockito.mock(JcrSession.class);
        this.workspace = (Workspace)Mockito.mock(Workspace.class);
        Mockito.stub((Object)this.jcrSession.getExecutionContext()).toReturn((Object)context);
        Mockito.stub((Object)this.jcrSession.getWorkspace()).toReturn((Object)this.workspace);
        Mockito.stub((Object)this.jcrSession.getRepository()).toReturn((Object)repository);
        Mockito.stub((Object)this.workspace.getName()).toReturn((Object)"workspace1");
        this.nodeTypes = new JcrNodeTypeManager(this.jcrSession, rntm);
        Mockito.stub((Object)this.jcrSession.nodeTypeManager()).toReturn((Object)this.nodeTypes);
        this.cache = new SessionCache(this.jcrSession, this.store.getCurrentWorkspaceName(), context, this.nodeTypes, this.store);
    }

    protected String getResourceNameOfXmlFileToImport() {
        return "cars.xml";
    }

    protected Name name(String name) {
        return (Name)context.getValueFactories().getNameFactory().create(name);
    }

    protected Path relativePath(String relativePath) {
        return (Path)context.getValueFactories().getPathFactory().create(relativePath);
    }

    protected Path path(String absolutePath) {
        return (Path)context.getValueFactories().getPathFactory().create(absolutePath);
    }
}

