/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import javax.jcr.Credentials;
import javax.jcr.Node;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.MockitoAnnotations;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.MockSecurityContext;
import org.modeshape.graph.SecurityContext;
import org.modeshape.graph.connector.RepositoryConnection;
import org.modeshape.graph.connector.RepositoryConnectionFactory;
import org.modeshape.graph.connector.RepositorySourceException;
import org.modeshape.graph.connector.inmemory.InMemoryRepositorySource;
import org.modeshape.graph.observe.MockObservable;
import org.modeshape.graph.observe.Observable;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.SecurityContextCredentials;

public class ImportExportTest {
    private static final String BAD_CHARACTER_STRING = "Test & <Test>*";
    private InMemoryRepositorySource source;
    private JcrSession session;
    private JcrRepository repository;

    @Before
    public void beforeEach() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        String workspaceName = "workspace1";
        this.source = new InMemoryRepositorySource();
        this.source.setName(workspaceName);
        this.source.setDefaultWorkspaceName(workspaceName);
        ExecutionContext context = new ExecutionContext();
        context.getNamespaceRegistry().register("modetest", "http://www.modeshape.org/test/1.0");
        RepositoryConnectionFactory connectionFactory = new RepositoryConnectionFactory(){

            public RepositoryConnection createConnection(String sourceName) throws RepositorySourceException {
                return ImportExportTest.this.source.getConnection();
            }
        };
        this.repository = new JcrRepository(context, connectionFactory, "unused", (Observable)new MockObservable(), null, null, null);
        MockSecurityContext mockSecurityContext = new MockSecurityContext("testuser", Collections.singleton("readwrite"));
        this.session = (JcrSession)this.repository.login((Credentials)new SecurityContextCredentials((SecurityContext)mockSecurityContext));
    }

    @After
    public void after() throws Exception {
        if (this.session != null && this.session.isLive()) {
            this.session.logout();
        }
    }

    private void testImportExport(String sourcePath, String targetPath, ExportType useSystemView, boolean skipBinary, boolean noRecurse, boolean useWorkspace) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (useSystemView == ExportType.SYSTEM) {
            this.session.exportSystemView(sourcePath, (OutputStream)baos, skipBinary, noRecurse);
        } else {
            this.session.exportDocumentView(sourcePath, (OutputStream)baos, skipBinary, noRecurse);
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        if (useWorkspace) {
            this.session.getWorkspace().importXML(targetPath, (InputStream)bais, 0);
        } else {
            this.session.importXML(targetPath, (InputStream)bais, 0);
        }
    }

    @Test
    public void shouldImportExportEscapedXmlCharactersInSystemViewUsingSession() throws Exception {
        String testName = "importExportEscapedXmlCharacters";
        Node rootNode = this.session.getRootNode();
        Node sourceNode = rootNode.addNode(testName + "Source", "nt:unstructured");
        Node targetNode = rootNode.addNode(testName + "Target", "nt:unstructured");
        sourceNode.setProperty("badcharacters", BAD_CHARACTER_STRING);
        Assert.assertThat((Object)sourceNode.getProperty("badcharacters").getString(), (Matcher)Is.is((Object)BAD_CHARACTER_STRING));
        sourceNode.addNode(BAD_CHARACTER_STRING);
        this.testImportExport(sourceNode.getPath(), targetNode.getPath(), ExportType.SYSTEM, false, false, false);
        Node newSourceNode = targetNode.getNode(testName + "Source");
        newSourceNode.getNode(BAD_CHARACTER_STRING);
        Assert.assertThat((Object)newSourceNode.getProperty("badcharacters").getString(), (Matcher)Is.is((Object)BAD_CHARACTER_STRING));
    }

    @Test
    public void shouldImportExportEscapedXmlCharactersInSystemViewUsingWorkspace() throws Exception {
        String testName = "importExportEscapedXmlCharacters";
        Node rootNode = this.session.getRootNode();
        System.out.println(this.session);
        Node sourceNode = rootNode.addNode(testName + "Source", "nt:unstructured");
        Node targetNode = rootNode.addNode(testName + "Target", "nt:unstructured");
        sourceNode.setProperty("badcharacters", BAD_CHARACTER_STRING);
        Assert.assertThat((Object)sourceNode.getProperty("badcharacters").getString(), (Matcher)Is.is((Object)BAD_CHARACTER_STRING));
        sourceNode.addNode(BAD_CHARACTER_STRING);
        this.session.save();
        this.testImportExport(sourceNode.getPath(), targetNode.getPath(), ExportType.SYSTEM, false, false, true);
        Node newSourceNode = targetNode.getNode(testName + "Source");
        newSourceNode.getNode(BAD_CHARACTER_STRING);
        Assert.assertThat((Object)newSourceNode.getProperty("badcharacters").getString(), (Matcher)Is.is((Object)BAD_CHARACTER_STRING));
    }

    @Ignore(value="JR TCK is broken")
    @Test
    public void shouldImportExportEscapedXmlCharactersInDocumentViewUsingSession() throws Exception {
        String testName = "importExportEscapedXmlCharacters";
        Node rootNode = this.session.getRootNode();
        Node sourceNode = rootNode.addNode(testName + "Source", "nt:unstructured");
        Node targetNode = rootNode.addNode(testName + "Target", "nt:unstructured");
        sourceNode.setProperty("badcharacters", BAD_CHARACTER_STRING);
        Assert.assertThat((Object)sourceNode.getProperty("badcharacters").getString(), (Matcher)Is.is((Object)BAD_CHARACTER_STRING));
        sourceNode.addNode(BAD_CHARACTER_STRING);
        this.testImportExport(sourceNode.getPath(), targetNode.getPath(), ExportType.DOCUMENT, false, false, false);
        Node newSourceNode = targetNode.getNode(testName + "Source");
        newSourceNode.getNode(BAD_CHARACTER_STRING);
        Assert.assertThat((Object)newSourceNode.getProperty("badcharacters").getString(), (Matcher)Is.is((Object)BAD_CHARACTER_STRING));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ExportType {
        SYSTEM,
        DOCUMENT;

    }
}

