/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.jcr.Value;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.graph.Graph;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NameFactory;
import org.modeshape.graph.property.basic.BasicName;
import org.modeshape.jcr.AbstractSessionTest;
import org.modeshape.jcr.JcrNodeTypeTemplate;
import org.modeshape.jcr.JcrPropertyDefinition;
import org.modeshape.jcr.JcrPropertyDefinitionTemplate;
import org.modeshape.jcr.nodetype.NodeTypeTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemDefinitionTest
extends AbstractSessionTest {
    private static final Name NODE_TYPE_A = new BasicName("http://www.modeshape.org/test/1.0", "nodeA");
    private static final Name NODE_TYPE_B = new BasicName("http://www.modeshape.org/test/1.0", "nodeB");
    private static final Name NODE_TYPE_C = new BasicName("http://www.modeshape.org/test/1.0", "nodeC");
    private static final Name SINGLE_PROP1 = new BasicName("http://www.modeshape.org/test/1.0", "singleProp1");
    private static final Name SINGLE_PROP2 = new BasicName("http://www.modeshape.org/test/1.0", "singleProp2");
    protected NameFactory nameFactory;

    @Override
    @Before
    public void beforeEach() throws Exception {
        super.beforeEach();
        this.nameFactory = this.session.getExecutionContext().getValueFactories().getNameFactory();
    }

    @Override
    protected void initializeContent() {
        ((Graph)this.graph.create("/jcr:system").and()).create("/jcr:system/mode:namespaces");
    }

    @After
    public void after() throws Exception {
        if (this.session != null && this.session.isLive()) {
            this.session.logout();
        }
    }

    @Test
    public void shouldNotFindInvalidPropertyDefinition() throws Exception {
        Name badName = (Name)this.nameFactory.create("undefinedName");
        JcrPropertyDefinition propDef = this.repoTypeManager.findPropertyDefinition(NODE_TYPE_A, Collections.emptyList(), badName, null, true, true);
        Assert.assertThat((Object)propDef, (Matcher)Is.is((Matcher)IsNull.nullValue()));
        propDef = this.repoTypeManager.findPropertyDefinition(NODE_TYPE_B, Collections.emptyList(), badName, null, true, true);
        Assert.assertThat((Object)propDef, (Matcher)Is.is((Matcher)IsNull.nullValue()));
        propDef = this.repoTypeManager.findPropertyDefinition(NODE_TYPE_C, Collections.emptyList(), badName, null, true, true);
        Assert.assertThat((Object)propDef, (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldUseNearestPropertyDefinition() {
        JcrPropertyDefinition propDef = this.repoTypeManager.findPropertyDefinition(NODE_TYPE_A, Collections.emptyList(), SINGLE_PROP1, null, true, true);
        Assert.assertThat((Object)propDef, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertEquals((long)propDef.getRequiredType(), (long)1L);
        propDef = this.repoTypeManager.findPropertyDefinition(NODE_TYPE_B, Collections.emptyList(), SINGLE_PROP1, null, true, true);
        Assert.assertThat((Object)propDef, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertEquals((long)propDef.getRequiredType(), (long)4L);
        propDef = this.repoTypeManager.findPropertyDefinition(NODE_TYPE_C, Collections.emptyList(), SINGLE_PROP1, null, true, true);
        Assert.assertThat((Object)propDef, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertEquals((long)propDef.getRequiredType(), (long)3L);
    }

    @Test
    public void shouldFindBestMatchDefinition() {
        Value doubleValue = this.session.getValueFactory().createValue(0.7);
        Value longValue = this.session.getValueFactory().createValue(10L);
        Value stringValue = this.session.getValueFactory().createValue("Should not work");
        JcrPropertyDefinition propDef = this.repoTypeManager.findPropertyDefinition(NODE_TYPE_C, Collections.emptyList(), SINGLE_PROP2, doubleValue, true, true);
        Assert.assertThat((Object)propDef, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertEquals((long)propDef.getRequiredType(), (long)4L);
        propDef = this.repoTypeManager.findPropertyDefinition(NODE_TYPE_C, Collections.emptyList(), SINGLE_PROP2, longValue, true, true);
        Assert.assertThat((Object)propDef, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertEquals((long)propDef.getRequiredType(), (long)3L);
        propDef = this.repoTypeManager.findPropertyDefinition(NODE_TYPE_C, Collections.emptyList(), SINGLE_PROP2, stringValue, true, true);
        Assert.assertThat((Object)propDef, (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Override
    protected List<NodeTypeTemplate> getTestTypes() {
        JcrNodeTypeTemplate nodeA = new JcrNodeTypeTemplate(this.context);
        nodeA.setName("modetest:nodeA");
        JcrPropertyDefinitionTemplate nodeASingleProp1 = new JcrPropertyDefinitionTemplate(this.context);
        nodeASingleProp1.setName("modetest:singleProp1");
        nodeASingleProp1.setRequiredType(1);
        nodeA.getPropertyDefinitionTemplates().add(nodeASingleProp1);
        JcrNodeTypeTemplate nodeB = new JcrNodeTypeTemplate(this.context);
        nodeB.setName("modetest:nodeB");
        JcrPropertyDefinitionTemplate nodeBSingleProp1 = new JcrPropertyDefinitionTemplate(this.context);
        nodeBSingleProp1.setName("modetest:singleProp1");
        nodeBSingleProp1.setRequiredType(4);
        nodeB.getPropertyDefinitionTemplates().add(nodeBSingleProp1);
        JcrPropertyDefinitionTemplate nodeBSingleProp2 = new JcrPropertyDefinitionTemplate(this.context);
        nodeBSingleProp2.setName("modetest:singleProp2");
        nodeBSingleProp2.setRequiredType(0);
        nodeB.getPropertyDefinitionTemplates().add(nodeBSingleProp2);
        JcrNodeTypeTemplate nodeC = new JcrNodeTypeTemplate(this.context);
        nodeC.setName("modetest:nodeC");
        nodeC.setDeclaredSupertypeNames(new String[]{"modetest:nodeB"});
        JcrPropertyDefinitionTemplate nodeCSingleProp1 = new JcrPropertyDefinitionTemplate(this.context);
        nodeCSingleProp1.setName("modetest:singleProp1");
        nodeCSingleProp1.setRequiredType(3);
        nodeC.getPropertyDefinitionTemplates().add(nodeCSingleProp1);
        JcrPropertyDefinitionTemplate nodeCSingleProp2Double = new JcrPropertyDefinitionTemplate(this.context);
        nodeCSingleProp2Double.setName("modetest:singleProp2");
        nodeCSingleProp2Double.setRequiredType(4);
        nodeC.getPropertyDefinitionTemplates().add(nodeCSingleProp2Double);
        JcrPropertyDefinitionTemplate nodeCSingleProp2Long = new JcrPropertyDefinitionTemplate(this.context);
        nodeCSingleProp2Long.setName("modetest:singleProp2");
        nodeCSingleProp2Long.setRequiredType(3);
        nodeC.getPropertyDefinitionTemplates().add(nodeCSingleProp2Long);
        return Arrays.asList(nodeA, nodeB, nodeC);
    }
}

