/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsSame;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.JcrChildNodeIterator;

public class JcrChildNodeIteratorTest {
    private List<AbstractJcrNode> children;
    private NodeIterator iter;

    @Before
    public void beforeEach() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.children = new ArrayList<AbstractJcrNode>();
        for (int i = 0; i != 10; ++i) {
            AbstractJcrNode childJcrNode = (AbstractJcrNode)Mockito.mock(AbstractJcrNode.class);
            this.children.add(childJcrNode);
        }
        this.iter = new JcrChildNodeIterator(this.children, this.children.size());
    }

    @Test
    public void shouldProperlyDetermineHasNext() {
        Iterator<AbstractJcrNode> nodeIter = this.children.iterator();
        long position = 0L;
        Assert.assertThat((Object)this.iter.getPosition(), (Matcher)Is.is((Object)position));
        while (this.iter.hasNext()) {
            Assert.assertThat((Object)nodeIter.hasNext(), (Matcher)Is.is((Object)true));
            Node actual = (Node)this.iter.next();
            Node expected = (Node)nodeIter.next();
            Assert.assertThat((Object)this.iter.getPosition(), (Matcher)Is.is((Object)(++position)));
            Assert.assertThat((Object)this.iter.getPosition(), (Matcher)Is.is((Object)position));
            Assert.assertThat((Object)actual, (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)expected)));
        }
        Assert.assertThat((Object)this.iter.hasNext(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)nodeIter.hasNext(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldStartWithPositionOfZero() {
        Assert.assertThat((Object)this.iter.getPosition(), (Matcher)Is.is((Object)0L));
    }

    @Test
    public void shouldHaveCorrectSize() {
        Assert.assertThat((Object)this.iter.getSize(), (Matcher)Is.is((Object)this.children.size()));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldNotAllowRemove() {
        this.iter.remove();
    }

    @Test(expected=NoSuchElementException.class)
    public void shouldFailWhenNextIsCalled() {
        while (this.iter.hasNext()) {
            this.iter.next();
        }
        this.iter.next();
    }
}

