/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import javax.jcr.NamespaceException;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.MockitoAnnotations;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.jcr.JcrNamespaceRegistry;
import org.modeshape.jcr.JcrSession;

public class JcrNamespaceRegistryTest {
    private ExecutionContext executionContext;
    private JcrNamespaceRegistry registry;
    @MockitoAnnotations.Mock
    private JcrSession session;

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)this);
        this.executionContext = new ExecutionContext();
        this.registry = new JcrNamespaceRegistry(this.executionContext.getNamespaceRegistry(), this.session);
    }

    protected void assertThatNamespaceIsRegistered(String prefix, String uri) throws Exception {
        Assert.assertThat((Object)this.registry.getURI(prefix), (Matcher)Is.is((Object)uri));
        Assert.assertThat((Object)this.registry.getPrefix(uri), (Matcher)Is.is((Object)prefix));
        boolean foundPrefix = false;
        for (String existingPrefix : this.registry.getPrefixes()) {
            if (!existingPrefix.equals(prefix)) continue;
            foundPrefix = true;
        }
        Assert.assertThat((Object)foundPrefix, (Matcher)Is.is((Object)true));
        boolean foundUri = false;
        for (String existingUri : this.registry.getURIs()) {
            if (!existingUri.equals(uri)) continue;
            foundUri = true;
        }
        Assert.assertThat((Object)foundUri, (Matcher)Is.is((Object)true));
    }

    protected void assertThatNamespacePrefixIsNotRegistered(String prefix) throws Exception {
        try {
            this.registry.getURI(prefix);
            Assert.fail((String)("Should not have found namespace mapping with prefix \"" + prefix + "\""));
        }
        catch (NamespaceException e) {
            // empty catch block
        }
        for (String existingPrefix : this.registry.getPrefixes()) {
            Assert.assertThat((Object)existingPrefix, (Matcher)Is.is((Matcher)IsNot.not((Object)prefix)));
        }
    }

    protected void assertThatNamespaceUriIsNotRegistered(String uri) throws Exception {
        try {
            this.registry.getPrefix(uri);
            Assert.fail((String)("Should not have found namespace mapping with URI \"" + uri + "\""));
        }
        catch (NamespaceException e) {
            // empty catch block
        }
        for (String existingUri : this.registry.getURIs()) {
            Assert.assertThat((Object)existingUri, (Matcher)Is.is((Matcher)IsNot.not((Object)uri)));
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowRegisteringNullPrefix() throws Exception {
        this.registry.registerNamespace("foo", null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowRegisteringNullUri() throws Exception {
        this.registry.registerNamespace(null, "http://example.com");
    }

    @Test(expected=NamespaceException.class)
    public void shouldNotAllowRegisteringPrefixThatStartsWithLowercaseXml() throws Exception {
        this.registry.registerNamespace("xmlw", "http://example.com");
    }

    @Test(expected=NamespaceException.class)
    public void shouldNotAllowRegisteringPrefixThatStartsWithUppercaseXml() throws Exception {
        this.registry.registerNamespace("XMLw", "http://example.com");
    }

    @Test(expected=NamespaceException.class)
    public void shouldNotAllowRegisteringPrefixThatStartsWithMixedcaseXml() throws Exception {
        this.registry.registerNamespace("XmLw", "http://example.com");
    }

    @Test(expected=NamespaceException.class)
    public void shouldNotAllowRegisteringEmptyPrefix() throws Exception {
        this.registry.registerNamespace("", "http://www.jcp.org/jcr/1.0");
    }

    @Test(expected=NamespaceException.class)
    public void shouldNotAllowRegisteringEmptyUri() throws Exception {
        this.registry.registerNamespace("foo", "");
    }

    @Test(expected=NamespaceException.class)
    public void shouldNotAllowRegisteringUsingJcrPrefix() throws Exception {
        this.registry.registerNamespace("jcr", "http://example.com");
    }

    @Test(expected=NamespaceException.class)
    public void shouldNotAllowRegisteringUsingNtPrefix() throws Exception {
        this.registry.registerNamespace("nt", "http://example.com");
    }

    @Test(expected=NamespaceException.class)
    public void shouldNotAllowRegisteringUsingMixPrefix() throws Exception {
        this.registry.registerNamespace("mix", "http://example.com");
    }

    @Test(expected=NamespaceException.class)
    public void shouldNotAllowRegisteringUsingSvPrefix() throws Exception {
        this.registry.registerNamespace("sv", "http://example.com");
    }

    @Test(expected=NamespaceException.class)
    public void shouldNotAllowRegisteringUsingXmlPrefix() throws Exception {
        this.registry.registerNamespace("xml", "http://example.com");
    }

    @Test(expected=NamespaceException.class)
    public void shouldNotAllowRegisteringUsingDnaPrefix() throws Exception {
        this.registry.registerNamespace("mode", "http://example.com");
    }

    @Test(expected=NamespaceException.class)
    public void shouldNotAllowRegisteringUsingJcrUri() throws Exception {
        this.registry.registerNamespace("foo", "http://www.jcp.org/jcr/1.0");
    }

    @Test(expected=NamespaceException.class)
    public void shouldNotAllowRegisteringUsingNtUri() throws Exception {
        this.registry.registerNamespace("foo", "http://www.jcp.org/jcr/nt/1.0");
    }

    @Test(expected=NamespaceException.class)
    public void shouldNotAllowRegisteringUsingMixUri() throws Exception {
        this.registry.registerNamespace("foo", "http://www.jcp.org/jcr/mix/1.0");
    }

    @Test(expected=NamespaceException.class)
    public void shouldNotAllowRegisteringUsingSvUri() throws Exception {
        this.registry.registerNamespace("foo", "http://www.jcp.org/jcr/sv/1.0");
    }

    @Test(expected=NamespaceException.class)
    public void shouldNotAllowRegisteringUsingXmlUri() throws Exception {
        this.registry.registerNamespace("foo", "http://www.w3.org/XML/1998/namespace");
    }

    @Test(expected=NamespaceException.class)
    public void shouldNotAllowRegisteringUsingXmlnsUri() throws Exception {
        this.registry.registerNamespace("foo", "http://www.w3.org/2000/xmlns/");
    }

    @Test(expected=NamespaceException.class)
    public void shouldNotAllowRegisteringUsingModeUri() throws Exception {
        this.registry.registerNamespace("foo", "http://www.modeshape.org/1.0");
    }

    @Test(expected=NamespaceException.class)
    public void shouldNotAllowRegisteringPrefixThatIsNotValidXmlNCName() throws Exception {
        this.registry.registerNamespace("1foot&in<door", "http://example.com");
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowUnregisteringNullPrefix() throws Exception {
        this.registry.unregisterNamespace(null);
    }

    @Test(expected=NamespaceException.class)
    public void shouldNotAllowUnregisteringBlankPrefix() throws Exception {
        this.registry.unregisterNamespace("");
    }

    @Test(expected=NamespaceException.class)
    public void shouldNotAllowUnregisteringJcrPrefix() throws Exception {
        this.registry.unregisterNamespace("jcr");
    }

    @Test(expected=NamespaceException.class)
    public void shouldNotAllowUnregisteringNtPrefix() throws Exception {
        this.registry.unregisterNamespace("nt");
    }

    @Test(expected=NamespaceException.class)
    public void shouldNotAllowUnregisteringMixPrefix() throws Exception {
        this.registry.unregisterNamespace("mix");
    }

    @Test(expected=NamespaceException.class)
    public void shouldNotAllowUnregisteringSvPrefix() throws Exception {
        this.registry.unregisterNamespace("sv");
    }

    @Test(expected=NamespaceException.class)
    public void shouldNotAllowUnregisteringXmlPrefix() throws Exception {
        this.registry.unregisterNamespace("xml");
    }

    @Test(expected=NamespaceException.class)
    public void shouldNotAllowUnregisteringModePrefix() throws Exception {
        this.registry.unregisterNamespace("mode");
    }

    @Test(expected=NamespaceException.class)
    public void shouldNotAllowUnregisteringPrefixThatIsNotUsed() throws Exception {
        String prefix = "bar";
        this.assertThatNamespacePrefixIsNotRegistered(prefix);
        this.registry.unregisterNamespace(prefix);
    }

    @Test
    public void shouldRegisterNewPrefixWithNewUri() throws Exception {
        String prefix = "foo";
        String uri = "http://example.com";
        this.assertThatNamespacePrefixIsNotRegistered(prefix);
        this.assertThatNamespaceUriIsNotRegistered(uri);
        this.registry.registerNamespace(prefix, uri);
        this.assertThatNamespaceIsRegistered(prefix, uri);
    }

    @Test
    public void shouldRegisterRemoveExistingMappingWhenUsingNewPrefixWithPreviouslyUsedUri() throws Exception {
        String prefix1 = "foo1";
        String prefix2 = "foo2";
        String uri = "http://example.com";
        this.assertThatNamespacePrefixIsNotRegistered(prefix1);
        this.assertThatNamespacePrefixIsNotRegistered(prefix2);
        this.assertThatNamespaceUriIsNotRegistered(uri);
        this.registry.registerNamespace(prefix1, uri);
        this.assertThatNamespaceIsRegistered(prefix1, uri);
        this.registry.registerNamespace(prefix2, uri);
        this.assertThatNamespaceIsRegistered(prefix2, uri);
        this.assertThatNamespacePrefixIsNotRegistered(prefix1);
    }

    @Test
    public void shouldRegisterOverwriteExistingMappingWhenUsingPreviouslyUsedPrefixWithNewUri() throws Exception {
        String prefix = "foo1";
        String uri1 = "http://example.com";
        String uri2 = "http://acme.com";
        this.assertThatNamespacePrefixIsNotRegistered(prefix);
        this.assertThatNamespaceUriIsNotRegistered(uri1);
        this.assertThatNamespaceUriIsNotRegistered(uri2);
        this.registry.registerNamespace(prefix, uri1);
        this.assertThatNamespaceIsRegistered(prefix, uri1);
        this.registry.registerNamespace(prefix, uri2);
        this.assertThatNamespaceIsRegistered(prefix, uri2);
        this.assertThatNamespaceUriIsNotRegistered(uri1);
    }

    @Test(expected=NamespaceException.class)
    public void shouldNotAllowUnregisteredPrefix() throws Exception {
        this.registry.getURI("bogus");
    }

    @Test(expected=NamespaceException.class)
    public void shouldNotAllowUnregisteredUri() throws Exception {
        this.registry.getPrefix("bogus");
    }
}

