/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import javax.jcr.Credentials;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import junit.framework.TestSuite;
import org.jboss.security.config.IDTrustConfiguration;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.modeshape.graph.connector.inmemory.InMemoryRepositorySource;
import org.modeshape.jcr.JcrConfiguration;
import org.modeshape.jcr.JcrEngine;
import org.modeshape.jcr.JcrNodeTypeManager;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.repository.ModeShapeConfiguration;

public final class JcrNodeTypeManagerTest
extends TestSuite {
    private static final String MIXIN1 = "mix:lockable";
    private static final String MIXIN2 = "mix:referenceable";
    private static final String[] MIXINS = new String[]{"mix:lockable", "mix:referenceable"};
    private static final String HIERARCHY_NODE_TYPE = "nt:hierarchyNode";
    private static final String SUBTYPE1 = "nt:folder";
    private static final String SUBTYPE2 = "nt:file";
    private static final String[] SUBTYPES = new String[]{"nt:folder", "nt:file"};
    private static final String NO_MATCH_TYPE = "nt:query";
    private static final String[] SUBTYPES_MIXINS = new String[SUBTYPES.length + MIXINS.length];
    private JcrEngine engine;
    private Session session;
    private JcrNodeTypeManager nodeTypeMgr;

    @BeforeClass
    public static void beforeClass() {
        String configFile = "security/jaas.conf.xml";
        IDTrustConfiguration idtrustConfig = new IDTrustConfiguration();
        try {
            idtrustConfig.config(configFile);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void afterEach() {
        try {
            if (this.session != null) {
                this.session.logout();
            }
        }
        finally {
            this.session = null;
            try {
                this.engine.shutdown();
            }
            finally {
                this.engine = null;
            }
        }
    }

    @Before
    public void beforeEach() throws RepositoryException {
        String WORKSPACE = "ws1";
        String REPOSITORY = "r1";
        String SOURCE = "store";
        JcrConfiguration config = new JcrConfiguration();
        ((ModeShapeConfiguration.RepositorySourceDefinition)config.repositorySource("store").usingClass(InMemoryRepositorySource.class)).setRetryLimit(100).setProperty("defaultWorkspaceName", "ws1");
        config.repository("r1").setSource("store").setOption(JcrRepository.Option.JAAS_LOGIN_CONFIG_NAME, "modeshape-jcr");
        config.save();
        this.engine = config.build();
        this.engine.start();
        JcrRepository repository = this.engine.getRepository("r1");
        String USER_ID = "superuser";
        SimpleCredentials credentials = new SimpleCredentials("superuser", "superuser".toCharArray());
        this.session = repository.login((Credentials)credentials, "ws1");
        this.nodeTypeMgr = (JcrNodeTypeManager)this.session.getWorkspace().getNodeTypeManager();
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowNullSubTypeNames() throws RepositoryException {
        this.nodeTypeMgr.isDerivedFrom(null, "nt:base", MIXINS);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowEmptySubTypeNames() throws Exception {
        this.nodeTypeMgr.isDerivedFrom(new String[0], "nt:base", MIXINS);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowNullPrimaryType() throws Exception {
        this.nodeTypeMgr.isDerivedFrom(SUBTYPES, null, MIXINS);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowEmptyPrimaryType() throws Exception {
        this.nodeTypeMgr.isDerivedFrom(SUBTYPES, "", MIXINS);
    }

    @Test
    public void shouldBeDerivedFromIfSubtypeMatchesPrimaryType() throws Exception {
        Assert.assertTrue((boolean)this.nodeTypeMgr.isDerivedFrom(SUBTYPES, SUBTYPE2, null));
        Assert.assertTrue((boolean)this.nodeTypeMgr.isDerivedFrom(SUBTYPES, SUBTYPE2, MIXINS));
    }

    @Test
    public void shouldBeDerivedFromIfSubtypeMatchesMixin() throws Exception {
        Assert.assertTrue((boolean)this.nodeTypeMgr.isDerivedFrom(new String[]{MIXIN2}, SUBTYPE1, MIXINS));
    }

    @Test
    public void shouldBeDerivedFromIfSubtypeIsActualSubType() throws Exception {
        Assert.assertTrue((boolean)this.nodeTypeMgr.isDerivedFrom(SUBTYPES, HIERARCHY_NODE_TYPE, MIXINS));
    }

    @Test
    public void shouldNotBeDerivedFromIfNoMatch() throws Exception {
        Assert.assertFalse((boolean)this.nodeTypeMgr.isDerivedFrom(SUBTYPES, NO_MATCH_TYPE, MIXINS));
    }

    static {
        System.arraycopy(SUBTYPES, 0, SUBTYPES_MIXINS, 0, SUBTYPES.length);
        System.arraycopy(MIXINS, 0, SUBTYPES_MIXINS, SUBTYPES.length, MIXINS.length);
    }
}

