/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.Workspace;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.ObservationManager;
import junit.framework.TestSuite;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.jboss.security.config.IDTrustConfiguration;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.modeshape.graph.connector.inmemory.InMemoryRepositorySource;
import org.modeshape.jcr.JcrConfiguration;
import org.modeshape.jcr.JcrEngine;
import org.modeshape.jcr.JcrObservationManager;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.repository.ModeShapeConfiguration;

public final class JcrObservationManagerTest
extends TestSuite {
    private static final int ALL_EVENTS = 31;
    private static final String LOCK_MIXIN = "mix:lockable";
    private static final String LOCK_OWNER = "jcr:lockOwner";
    private static final String LOCK_IS_DEEP = "jcr:lockIsDeep";
    private static final String NT_BASE = "nt:base";
    private static final String REF_MIXIN = "mix:referenceable";
    private static final String UNSTRUCTURED = "nt:unstructured";
    private static final String USER_ID = "superuser";
    private JcrEngine engine;
    private Session session;
    private Node testRootNode;

    @BeforeClass
    public static void beforeClass() {
        String configFile = "security/jaas.conf.xml";
        IDTrustConfiguration idtrustConfig = new IDTrustConfiguration();
        try {
            idtrustConfig.config(configFile);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    TestListener addListener(int eventsExpected, int eventTypes, String absPath, boolean isDeep, String[] uuids, String[] nodeTypeNames, boolean noLocal) throws Exception {
        return this.addListener(eventsExpected, 1, eventTypes, absPath, isDeep, uuids, nodeTypeNames, noLocal);
    }

    TestListener addListener(int eventsExpected, int numIterators, int eventTypes, String absPath, boolean isDeep, String[] uuids, String[] nodeTypeNames, boolean noLocal) throws Exception {
        TestListener listener = new TestListener(eventsExpected, numIterators, eventTypes);
        this.session.getWorkspace().getObservationManager().addEventListener((EventListener)listener, eventTypes, absPath, isDeep, uuids, nodeTypeNames, noLocal);
        return listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void afterEach() {
        try {
            if (this.session != null) {
                this.session.logout();
            }
        }
        finally {
            this.session = null;
            try {
                this.engine.shutdown();
            }
            finally {
                this.engine = null;
            }
        }
    }

    @Before
    public void beforeEach() throws RepositoryException {
        String WORKSPACE = "ws1";
        String REPOSITORY = "r1";
        String SOURCE = "store";
        JcrConfiguration config = new JcrConfiguration();
        ((ModeShapeConfiguration.RepositorySourceDefinition)config.repositorySource("store").usingClass(InMemoryRepositorySource.class)).setRetryLimit(100).setProperty("defaultWorkspaceName", "ws1");
        config.repository("r1").setSource("store").setOption(JcrRepository.Option.JAAS_LOGIN_CONFIG_NAME, "modeshape-jcr");
        config.save();
        this.engine = config.build();
        this.engine.start();
        JcrRepository repository = this.engine.getRepository("r1");
        SimpleCredentials credentials = new SimpleCredentials(USER_ID, USER_ID.toCharArray());
        this.session = repository.login((Credentials)credentials, "ws1");
        this.testRootNode = this.session.getRootNode().addNode("testroot", UNSTRUCTURED);
        this.save();
    }

    void checkResults(TestListener listener) {
        if (listener.getActualEventCount() != listener.getExpectedEventCount()) {
            StringBuilder sb = new StringBuilder(" Actual events were: ");
            for (Event event : listener.getEvents()) {
                sb.append('\n').append(event);
            }
            Assert.assertThat((String)("Received incorrect number of events." + sb.toString()), (Object)listener.getActualEventCount(), (Matcher)Is.is((Object)listener.getExpectedEventCount()));
            Assert.assertThat((String)listener.getErrorMessage(), (Object)listener.getErrorMessage(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        }
    }

    boolean containsPath(TestListener listener, String path) throws Exception {
        for (Event event : listener.getEvents()) {
            if (!event.getPath().equals(path)) continue;
            return true;
        }
        return false;
    }

    ObservationManager getObservationManager() throws RepositoryException {
        return this.session.getWorkspace().getObservationManager();
    }

    Node getRoot() {
        return this.testRootNode;
    }

    Workspace getWorkspace() {
        return this.session.getWorkspace();
    }

    void removeListener(TestListener listener) throws Exception {
        this.session.getWorkspace().getObservationManager().removeEventListener((EventListener)listener);
    }

    void save() throws RepositoryException {
        this.session.save();
    }

    @Test
    public void shouldNotReceiveEventIfUuidDoesNotMatch() throws Exception {
        Node n1 = this.getRoot().addNode("node1", UNSTRUCTURED);
        n1.addMixin(REF_MIXIN);
        this.save();
        TestListener listener = this.addListener(0, 4, this.getRoot().getPath(), true, new String[]{UUID.randomUUID().toString()}, null, false);
        n1.setProperty("prop1", "foo");
        this.save();
        listener.waitForEvents();
        this.removeListener(listener);
        this.checkResults(listener);
    }

    @Test
    public void shouldNotReceiveEventIfNodeTypeDoesNotMatch() throws Exception {
        Node node1 = this.getRoot().addNode("node1", UNSTRUCTURED);
        this.save();
        TestListener listener = this.addListener(0, 31, null, false, null, new String[]{REF_MIXIN}, false);
        node1.setProperty("newProperty", "newValue");
        this.save();
        listener.waitForEvents();
        this.removeListener(listener);
        this.checkResults(listener);
    }

    @Test
    public void shouldReceiveNodeAddedEventWhenRegisteredToReceiveAllEvents() throws Exception {
        Node root = this.getRoot();
        this.save();
        TestListener listener = this.addListener(4, 31, null, false, null, null, false);
        Node addedNode = root.addNode("node1", UNSTRUCTURED);
        this.save();
        listener.waitForEvents();
        this.removeListener(listener);
        this.checkResults(listener);
        Assert.assertTrue((String)("Path for added node is wrong: actual=" + listener.getEvents().get(0).getPath() + ", expected=" + addedNode.getPath()), (boolean)this.containsPath(listener, addedNode.getPath()));
    }

    @Test
    public void shouldReceiveNodeRemovedEventWhenRegisteredToReceiveAllEvents() throws Exception {
        Node addedNode = this.getRoot().addNode("node1", UNSTRUCTURED);
        this.save();
        TestListener listener = this.addListener(1, 31, null, false, null, null, false);
        String path = addedNode.getPath();
        addedNode.remove();
        this.save();
        listener.waitForEvents();
        this.removeListener(listener);
        this.checkResults(listener);
        Assert.assertTrue((String)("Path for removed node is wrong: actual=" + listener.getEvents().get(0).getPath() + ", expected=" + path), (boolean)this.containsPath(listener, path));
    }

    @Test
    public void shouldReceivePropertyAddedEventWhenRegisteredToReceiveAllEvents() throws Exception {
        Node node = this.getRoot().addNode("node1", UNSTRUCTURED);
        this.save();
        TestListener listener = this.addListener(1, 31, null, false, null, null, false);
        Property prop1 = node.setProperty("prop1", "prop1 content");
        this.save();
        listener.waitForEvents();
        this.removeListener(listener);
        this.checkResults(listener);
        Assert.assertTrue((String)("Path for added property is wrong: actual=" + listener.getEvents().get(0).getPath() + ", expected=" + prop1.getPath()), (boolean)this.containsPath(listener, prop1.getPath()));
    }

    @Test
    public void shouldReceivePropertyChangedEventWhenRegisteredToReceiveAllEvents() throws Exception {
        Node node = this.getRoot().addNode("node1", UNSTRUCTURED);
        Property prop1 = node.setProperty("prop1", "prop1 content");
        this.save();
        TestListener listener = this.addListener(1, 31, null, false, null, null, false);
        prop1.setValue("prop1 modified content");
        this.save();
        listener.waitForEvents();
        this.removeListener(listener);
        this.checkResults(listener);
        Assert.assertTrue((String)("Path for changed property is wrong: actual=" + listener.getEvents().get(0).getPath() + ", expected=" + prop1.getPath()), (boolean)this.containsPath(listener, prop1.getPath()));
    }

    @Test
    public void shouldReceivePropertyRemovedEventWhenRegisteredToReceiveAllEvents() throws Exception {
        Node node = this.getRoot().addNode("node1", UNSTRUCTURED);
        Property prop = node.setProperty("prop1", "prop1 content");
        String propPath = prop.getPath();
        this.save();
        TestListener listener = this.addListener(1, 31, null, false, null, null, false);
        prop.remove();
        this.save();
        listener.waitForEvents();
        this.removeListener(listener);
        this.checkResults(listener);
        Assert.assertTrue((String)("Path for removed property is wrong: actual=" + listener.getEvents().get(0).getPath() + ", expected=" + propPath), (boolean)this.containsPath(listener, propPath));
    }

    @Test
    public void shouldTestEventIteratorTest_testGetPosition() throws Exception {
        TestListener listener = this.addListener(3, 1, null, false, null, null, false);
        this.getRoot().addNode("node1", UNSTRUCTURED);
        this.getRoot().addNode("node2", UNSTRUCTURED);
        this.getRoot().addNode("node3", UNSTRUCTURED);
        this.save();
        listener.waitForEvents();
        this.removeListener(listener);
        this.checkResults(listener);
    }

    @Test
    public void shouldTestEventIteratorTest_testGetSize() throws Exception {
        TestListener listener = this.addListener(1, 1, null, false, null, null, false);
        this.getRoot().addNode("node1", UNSTRUCTURED);
        this.save();
        listener.waitForEvents();
        this.removeListener(listener);
        this.checkResults(listener);
    }

    @Test
    public void shouldTestEventIteratorTest_testSkip() throws Exception {
        ArrayList<JcrObservationManager.JcrEvent> events = new ArrayList<JcrObservationManager.JcrEvent>();
        JcrObservationManager jcrObservationManager = (JcrObservationManager)this.getObservationManager();
        jcrObservationManager.getClass();
        events.add(new JcrObservationManager.JcrEvent(jcrObservationManager, 1, "/testroot/node1", "userId"));
        JcrObservationManager jcrObservationManager2 = (JcrObservationManager)this.getObservationManager();
        jcrObservationManager2.getClass();
        events.add(new JcrObservationManager.JcrEvent(jcrObservationManager2, 1, "/testroot/node2", "userId"));
        JcrObservationManager jcrObservationManager3 = (JcrObservationManager)this.getObservationManager();
        jcrObservationManager3.getClass();
        events.add(new JcrObservationManager.JcrEvent(jcrObservationManager3, 1, "/testroot/node3", "userId"));
        JcrObservationManager jcrObservationManager4 = (JcrObservationManager)this.getObservationManager();
        jcrObservationManager4.getClass();
        JcrObservationManager.JcrEventIterator itr = new JcrObservationManager.JcrEventIterator(jcrObservationManager4, events);
        itr.skip(0L);
        Assert.assertThat((String)"getPosition() for first element should return 0.", (Object)itr.getPosition(), (Matcher)Is.is((Object)0L));
        itr.skip(2L);
        Assert.assertThat((String)"Wrong value when skipping ", (Object)itr.getPosition(), (Matcher)Is.is((Object)2L));
        try {
            itr.skip(2L);
            Assert.fail((String)"EventIterator must throw NoSuchElementException when skipping past the end");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void shouldTestEventTest_testGetNodePath() throws Exception {
        TestListener listener = this.addListener(1, 1, null, false, null, null, false);
        Node addedNode = this.getRoot().addNode("node1", UNSTRUCTURED);
        this.save();
        listener.waitForEvents();
        this.removeListener(listener);
        this.checkResults(listener);
        Assert.assertTrue((String)("Path added node is wrong: actual=" + listener.getEvents().get(0).getPath() + ", expected=" + addedNode.getPath()), (boolean)this.containsPath(listener, addedNode.getPath()));
    }

    @Test
    public void shouldTestEventTest_testGetType() throws Exception {
        TestListener listener = this.addListener(1, 1, null, false, null, null, false);
        this.getRoot().addNode("node1", UNSTRUCTURED);
        this.save();
        listener.waitForEvents();
        this.removeListener(listener);
        this.checkResults(listener);
        Assert.assertThat((String)"Event did not return correct event type", (Object)listener.getEvents().get(0).getType(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldTestEventTest_testGetUserId() throws Exception {
        TestListener listener = this.addListener(1, 1, null, false, null, null, false);
        this.getRoot().addNode("node1", UNSTRUCTURED);
        this.save();
        listener.waitForEvents();
        this.removeListener(listener);
        this.checkResults(listener);
        Assert.assertThat((String)"UserId of event is not equal to userId of session", (Object)listener.getEvents().get(0).getUserID(), (Matcher)Is.is((Object)USER_ID));
    }

    @Test
    public void shouldTestGetRegisteredEventListenersTest_testGetSize() throws Exception {
        Assert.assertThat((String)"A new session must not have any event listeners registered.", (Object)this.getObservationManager().getRegisteredEventListeners().getSize(), (Matcher)Is.is((Object)0L));
        TestListener listener = this.addListener(0, 31, null, false, null, null, false);
        this.addListener(0, 31, null, false, null, null, false);
        Assert.assertThat((String)"Wrong number of event listeners.", (Object)this.getObservationManager().getRegisteredEventListeners().getSize(), (Matcher)Is.is((Object)2L));
        this.getObservationManager().addEventListener((EventListener)listener, 31, null, false, null, null, false);
        Assert.assertThat((String)"The same listener should not be added more than once.", (Object)this.getObservationManager().getRegisteredEventListeners().getSize(), (Matcher)Is.is((Object)2L));
    }

    @Test
    public void shouldTestGetRegisteredEventListenersTest_testRemoveEventListener() throws Exception {
        TestListener listener1 = this.addListener(0, 31, null, false, null, null, false);
        TestListener listener2 = this.addListener(0, 31, null, false, null, null, false);
        Assert.assertThat((String)"Wrong number of event listeners.", (Object)this.getObservationManager().getRegisteredEventListeners().getSize(), (Matcher)Is.is((Object)2L));
        this.removeListener(listener1);
        Assert.assertThat((String)"Wrong number of event listeners after removing a listener.", (Object)this.getObservationManager().getRegisteredEventListeners().getSize(), (Matcher)Is.is((Object)1L));
        Assert.assertThat((String)"Wrong number of event listeners after removing a listener.", (Object)this.getObservationManager().getRegisteredEventListeners().nextEventListener(), (Matcher)Is.is((Object)listener2));
    }

    @Test
    public void shouldTestLockingTest_testAddLockToNode() throws Exception {
        String node1 = "node1";
        Node lockable = this.getRoot().addNode(node1, UNSTRUCTURED);
        lockable.addMixin(LOCK_MIXIN);
        this.save();
        TestListener listener = this.addListener(2, 4, null, false, null, null, false);
        lockable.lock(false, true);
        listener.waitForEvents();
        this.removeListener(listener);
        this.checkResults(listener);
        Assert.assertTrue((String)"No event created for jcr:lockOwner", (boolean)this.containsPath(listener, lockable.getPath() + '/' + LOCK_OWNER));
        Assert.assertTrue((String)"No event created for jcr:lockIsDeep", (boolean)this.containsPath(listener, lockable.getPath() + '/' + LOCK_IS_DEEP));
    }

    @Test
    public void shouldTestLockingTest_testRemoveLockFromNode() throws Exception {
        String node1 = "node1";
        Node lockable = this.getRoot().addNode(node1, UNSTRUCTURED);
        lockable.addMixin(LOCK_MIXIN);
        this.save();
        lockable.lock(false, true);
        TestListener listener = this.addListener(2, 8, null, false, null, null, false);
        lockable.unlock();
        listener.waitForEvents();
        this.removeListener(listener);
        this.checkResults(listener);
        Assert.assertTrue((String)"No event created for jcr:lockOwner", (boolean)this.containsPath(listener, lockable.getPath() + '/' + LOCK_OWNER));
        Assert.assertTrue((String)"No event created for jcr:lockIsDeep", (boolean)this.containsPath(listener, lockable.getPath() + '/' + LOCK_IS_DEEP));
    }

    @Test
    public void shouldTestNodeAddedTest_testMultipleNodeAdded1() throws Exception {
        TestListener listener = this.addListener(2, 1, null, false, null, null, false);
        Node addedNode1 = this.getRoot().addNode("node1", UNSTRUCTURED);
        Node addedNode2 = this.getRoot().addNode("node2", UNSTRUCTURED);
        this.save();
        listener.waitForEvents();
        this.removeListener(listener);
        this.checkResults(listener);
        Assert.assertTrue((String)"Path for first added node is wrong", (boolean)this.containsPath(listener, addedNode1.getPath()));
        Assert.assertTrue((String)"Path for second added node is wrong", (boolean)this.containsPath(listener, addedNode2.getPath()));
    }

    @Test
    public void shouldTestNodeAddedTest_testMultipleNodeAdded2() throws Exception {
        TestListener listener = this.addListener(2, 1, null, false, null, null, false);
        Node addedNode = this.getRoot().addNode("node1", UNSTRUCTURED);
        Node addedChildNode = addedNode.addNode("node2", UNSTRUCTURED);
        this.save();
        listener.waitForEvents();
        this.removeListener(listener);
        this.checkResults(listener);
        Assert.assertTrue((String)"Path for added node is wrong", (boolean)this.containsPath(listener, addedNode.getPath()));
        Assert.assertTrue((String)"Path for added child node is wrong", (boolean)this.containsPath(listener, addedChildNode.getPath()));
    }

    @Test
    public void shouldTestNodeAddedTest_testSingleNodeAdded() throws Exception {
        TestListener listener = this.addListener(1, 1, null, false, null, null, false);
        Node addedNode = this.getRoot().addNode("node1", UNSTRUCTURED);
        this.save();
        listener.waitForEvents();
        this.removeListener(listener);
        this.checkResults(listener);
        Assert.assertTrue((String)("Path for added node is wrong: actual=" + listener.getEvents().get(0).getPath() + ", expected=" + addedNode.getPath()), (boolean)this.containsPath(listener, addedNode.getPath()));
    }

    @Test
    public void shouldTestNodeAddedTest_testTransientNodeAddedRemoved() throws Exception {
        TestListener listener = this.addListener(1, 1, null, false, null, null, false);
        Node addedNode = this.getRoot().addNode("node1", UNSTRUCTURED);
        Node transientNode = addedNode.addNode("node2", UNSTRUCTURED);
        transientNode.remove();
        this.save();
        listener.waitForEvents();
        this.removeListener(listener);
        this.checkResults(listener);
        Assert.assertTrue((String)("Path for added node is wrong: actual=" + listener.getEvents().get(0).getPath() + ", expected=" + addedNode.getPath()), (boolean)this.containsPath(listener, addedNode.getPath()));
    }

    @Test
    @Ignore
    public void shouldTestNodeRemovedTest_testMultiNodesRemoved() throws Exception {
        TestListener listener = this.addListener(2, 2, null, false, null, null, false);
        Node addedNode = this.getRoot().addNode("node1", UNSTRUCTURED);
        Node childNode = addedNode.addNode("node2", UNSTRUCTURED);
        this.save();
        String parentPath = addedNode.getPath();
        String childPath = childNode.getPath();
        addedNode.remove();
        this.save();
        listener.waitForEvents();
        this.removeListener(listener);
        this.checkResults(listener);
        Assert.assertTrue((String)"Path for removed node is wrong", (boolean)this.containsPath(listener, parentPath));
        Assert.assertTrue((String)"Path for removed child node is wrong", (boolean)this.containsPath(listener, childPath));
    }

    @Test
    public void shouldTestNodeRemovedTest_testSingleNodeRemoved() throws Exception {
        TestListener listener = this.addListener(1, 2, null, false, null, null, false);
        Node addedNode = this.getRoot().addNode("node1", UNSTRUCTURED);
        this.save();
        String path = addedNode.getPath();
        addedNode.remove();
        this.save();
        listener.waitForEvents();
        this.removeListener(listener);
        this.checkResults(listener);
        Assert.assertTrue((String)("Path for removed node is wrong: actual=" + listener.getEvents().get(0).getPath() + ", expected=" + path), (boolean)this.containsPath(listener, path));
    }

    @Test
    public void shouldTestNodeMovedTest_testMoveNode() throws Exception {
        String node1 = "node1";
        String node2 = "node2";
        Node n1 = this.getRoot().addNode(node1, UNSTRUCTURED);
        Node n2 = n1.addNode(node2, UNSTRUCTURED);
        String oldPath = n2.getPath();
        this.save();
        TestListener addNodeListener = this.addListener(1, 1, null, false, null, null, false);
        TestListener removeNodeListener = this.addListener(1, 2, null, false, null, null, false);
        String newPath = this.getRoot().getPath() + '/' + node2;
        this.getWorkspace().move(n2.getPath(), newPath);
        this.save();
        addNodeListener.waitForEvents();
        this.removeListener(addNodeListener);
        removeNodeListener.waitForEvents();
        this.removeListener(removeNodeListener);
        this.checkResults(addNodeListener);
        this.checkResults(removeNodeListener);
        Assert.assertTrue((String)("Path for new location of moved node is wrong: actual=" + addNodeListener.getEvents().get(0).getPath() + ", expected=" + newPath), (boolean)this.containsPath(addNodeListener, newPath));
        Assert.assertTrue((String)("Path for old location of moved node is wrong: actual=" + removeNodeListener.getEvents().get(0).getPath() + ", expected=" + oldPath), (boolean)this.containsPath(removeNodeListener, oldPath));
    }

    @Test
    public void shouldTestNodeMovedTest_testMoveTree() throws Exception {
        Node n1 = this.getRoot().addNode("node1", UNSTRUCTURED);
        String oldPath = n1.getPath();
        n1.addNode("node2", UNSTRUCTURED);
        this.save();
        TestListener addNodeListener = this.addListener(1, 1, null, false, null, null, false);
        TestListener removeNodeListener = this.addListener(1, 2, null, false, null, null, false);
        String newPath = this.getRoot().getPath() + "/node3";
        this.getWorkspace().move(n1.getPath(), newPath);
        this.save();
        addNodeListener.waitForEvents();
        this.removeListener(addNodeListener);
        removeNodeListener.waitForEvents();
        this.removeListener(removeNodeListener);
        this.checkResults(addNodeListener);
        this.checkResults(removeNodeListener);
        Assert.assertTrue((String)("Path for new location of moved node is wrong: actual=" + addNodeListener.getEvents().get(0).getPath() + ", expected=" + newPath), (boolean)this.containsPath(addNodeListener, newPath));
        Assert.assertTrue((String)("Path for old location of moved node is wrong: actual=" + removeNodeListener.getEvents().get(0).getPath() + ", expected=" + oldPath), (boolean)this.containsPath(removeNodeListener, oldPath));
    }

    @Test
    public void shouldTestNodeMovedTest_testMoveWithRemove() throws Exception {
        String node2 = "node2";
        Node n1 = this.getRoot().addNode("node1", UNSTRUCTURED);
        Node n2 = n1.addNode(node2, UNSTRUCTURED);
        Node n3 = this.getRoot().addNode("node3", UNSTRUCTURED);
        this.save();
        TestListener addNodeListener = this.addListener(1, 1, null, false, null, null, false);
        TestListener removeNodeListener = this.addListener(2, 2, 2, null, false, null, null, false);
        String oldPath = n2.getPath();
        String newPath = n3.getPath() + '/' + node2;
        this.getWorkspace().move(oldPath, newPath);
        String removedNodePath = n1.getPath();
        n1.remove();
        this.save();
        addNodeListener.waitForEvents();
        this.removeListener(addNodeListener);
        removeNodeListener.waitForEvents();
        this.removeListener(removeNodeListener);
        this.checkResults(addNodeListener);
        this.checkResults(removeNodeListener);
        Assert.assertTrue((String)("Path for new location of moved node is wrong: actual=" + addNodeListener.getEvents().get(0).getPath() + ", expected=" + newPath), (boolean)this.containsPath(addNodeListener, newPath));
        Assert.assertTrue((String)"Path for removed node is wrong", (boolean)this.containsPath(removeNodeListener, removedNodePath));
        Assert.assertTrue((String)"Path for old path of moved node is wrong", (boolean)this.containsPath(removeNodeListener, oldPath));
    }

    @Test
    public void shouldTestNodeReorderTest_testNodeReorder() throws Exception {
        this.getRoot().addNode("node1", UNSTRUCTURED);
        Node n2 = this.getRoot().addNode("node2", UNSTRUCTURED);
        Node n3 = this.getRoot().addNode("node3", UNSTRUCTURED);
        this.save();
        TestListener addNodeListener = this.addListener(1, 1, null, false, null, null, false);
        TestListener removeNodeListener = this.addListener(1, 2, null, false, null, null, false);
        this.getRoot().orderBefore(n3.getName(), n2.getName());
        this.save();
        addNodeListener.waitForEvents();
        this.removeListener(addNodeListener);
        removeNodeListener.waitForEvents();
        this.removeListener(removeNodeListener);
        this.checkResults(addNodeListener);
        this.checkResults(removeNodeListener);
        Assert.assertTrue((String)("Added reordered node has wrong path: actual=" + addNodeListener.getEvents().get(0).getPath() + ", expected=" + n3.getPath()), (boolean)this.containsPath(addNodeListener, n3.getPath()));
        Assert.assertTrue((String)("Removed reordered node has wrong path: actual=" + removeNodeListener.getEvents().get(0).getPath() + ", expected=" + n3.getPath()), (boolean)this.containsPath(addNodeListener, n3.getPath()));
    }

    @Test
    public void shouldTestNodeReorderTest_testNodeReorderSameName() throws Exception {
        String node1 = "node1";
        Node n1 = this.getRoot().addNode(node1, UNSTRUCTURED);
        this.getRoot().addNode(node1, UNSTRUCTURED);
        this.getRoot().addNode(node1, UNSTRUCTURED);
        this.save();
        TestListener addNodeListener = this.addListener(1, 1, null, false, null, null, false);
        TestListener removeNodeListener = this.addListener(1, 2, null, false, null, null, false);
        this.getRoot().orderBefore(node1 + "[3]", node1 + "[2]");
        this.save();
        addNodeListener.waitForEvents();
        this.removeListener(addNodeListener);
        removeNodeListener.waitForEvents();
        this.removeListener(removeNodeListener);
        this.checkResults(addNodeListener);
        this.checkResults(removeNodeListener);
        Assert.assertTrue((String)("Added reordered node has wrong path: actual=" + addNodeListener.getEvents().get(0).getPath() + ", expected=" + n1.getPath() + "[2]"), (boolean)this.containsPath(addNodeListener, n1.getPath() + "[2]"));
        Assert.assertTrue((String)("Removed reordered node has wrong path: actual=" + removeNodeListener.getEvents().get(0).getPath() + ", expected=" + n1.getPath() + "[3]"), (boolean)this.containsPath(removeNodeListener, n1.getPath() + "[3]"));
    }

    @Test
    public void shouldTestNodeReorderTest_testNodeReorderSameNameWithRemove() throws Exception {
        String node1 = "node1";
        Node n1 = this.getRoot().addNode(node1, UNSTRUCTURED);
        this.getRoot().addNode("node2", UNSTRUCTURED);
        this.getRoot().addNode(node1, UNSTRUCTURED);
        this.getRoot().addNode(node1, UNSTRUCTURED);
        Node n3 = this.getRoot().addNode("node3", UNSTRUCTURED);
        this.save();
        TestListener addNodeListener = this.addListener(1, 1, null, false, null, null, false);
        TestListener removeNodeListener = this.addListener(2, 2, null, false, null, null, false);
        this.getRoot().orderBefore(node1 + "[2]", null);
        String removedPath = n3.getPath();
        n3.remove();
        this.save();
        addNodeListener.waitForEvents();
        this.removeListener(addNodeListener);
        removeNodeListener.waitForEvents();
        this.removeListener(removeNodeListener);
        this.checkResults(addNodeListener);
        this.checkResults(removeNodeListener);
        Assert.assertTrue((String)("Added reordered node has wrong path: actual=" + addNodeListener.getEvents().get(0).getPath() + ", expected=" + n1.getPath() + "[3]"), (boolean)this.containsPath(addNodeListener, n1.getPath() + "[3]"));
        Assert.assertTrue((String)("Removed reordered node path not found: " + n1.getPath() + "[2]"), (boolean)this.containsPath(removeNodeListener, n1.getPath() + "[2]"));
        Assert.assertTrue((String)("Removed node path not found: " + removedPath), (boolean)this.containsPath(removeNodeListener, removedPath));
    }

    @Test
    public void shouldTestPropertyAddedTest_testMultiPropertyAdded() throws Exception {
        Node node = this.getRoot().addNode("node1", UNSTRUCTURED);
        this.save();
        TestListener listener = this.addListener(2, 4, null, false, null, null, false);
        Property prop1 = node.setProperty("prop1", "prop1 content");
        Property prop2 = node.setProperty("prop2", "prop2 content");
        this.save();
        listener.waitForEvents();
        this.removeListener(listener);
        this.checkResults(listener);
        Assert.assertTrue((String)("Path for first added property not found: " + prop1.getPath()), (boolean)this.containsPath(listener, prop1.getPath()));
        Assert.assertTrue((String)("Path for second added property not found: " + prop2.getPath()), (boolean)this.containsPath(listener, prop2.getPath()));
    }

    @Test
    public void shouldTestPropertyAddedTest_testSinglePropertyAdded() throws Exception {
        Node node = this.getRoot().addNode("node1", UNSTRUCTURED);
        this.save();
        TestListener listener = this.addListener(1, 4, null, false, null, null, false);
        Property prop1 = node.setProperty("prop1", "prop1 content");
        this.save();
        listener.waitForEvents();
        this.removeListener(listener);
        this.checkResults(listener);
        Assert.assertTrue((String)("Path for added property is wrong: actual=" + listener.getEvents().get(0).getPath() + ", expected=" + prop1.getPath()), (boolean)this.containsPath(listener, prop1.getPath()));
    }

    @Test
    public void shouldTestPropertyAddedTest_testSystemGenerated() throws Exception {
        TestListener listener = this.addListener(3, 4, null, false, null, null, false);
        Node node = this.getRoot().addNode("node1", UNSTRUCTURED);
        this.save();
        listener.waitForEvents();
        this.removeListener(listener);
        this.checkResults(listener);
        Assert.assertTrue((String)"Path for jrc:primaryType property was not found.", (boolean)this.containsPath(listener, node.getProperty("jcr:primaryType").getPath()));
    }

    @Test
    public void shouldTestPropertyChangedTests_testMultiPropertyChanged() throws Exception {
        Node node = this.getRoot().addNode("node1", UNSTRUCTURED);
        Property prop1 = node.setProperty("prop1", "prop1 content");
        Property prop2 = node.setProperty("prop2", "prop2 content");
        this.save();
        TestListener listener = this.addListener(2, 16, null, false, null, null, false);
        prop1.setValue("prop1 modified content");
        prop2.setValue("prop2 modified content");
        this.save();
        listener.waitForEvents();
        this.removeListener(listener);
        this.checkResults(listener);
        Assert.assertTrue((String)("Path for first changed property not found: " + prop1.getPath()), (boolean)this.containsPath(listener, prop1.getPath()));
        Assert.assertTrue((String)("Path for second changed property not found: " + prop2.getPath()), (boolean)this.containsPath(listener, prop2.getPath()));
    }

    @Test
    public void shouldTestPropertyChangedTests_testPropertyRemoveCreate() throws Exception {
        Node node = this.getRoot().addNode("node1", UNSTRUCTURED);
        String propName = "prop1";
        Property prop = node.setProperty(propName, propName + " content");
        String propPath = prop.getPath();
        this.save();
        TestListener listener1 = this.addListener(1, 16, null, false, null, null, false);
        TestListener listener2 = this.addListener(2, 12, null, false, null, null, false);
        prop.remove();
        node.setProperty(propName, true);
        this.save();
        listener1.waitForEvents();
        this.removeListener(listener1);
        listener2.waitForEvents();
        this.removeListener(listener2);
        if (listener1.getEvents().size() == 1) {
            this.checkResults(listener1);
            Assert.assertTrue((String)("Path for removed then added property is wrong: actual=" + listener1.getEvents().get(0).getPath() + ", expected=" + propPath), (boolean)this.containsPath(listener1, propPath));
        } else {
            this.checkResults(listener2);
            Assert.assertTrue((String)("Path for removed then added property is wrong: actual=" + listener2.getEvents().get(0).getPath() + ", expected=" + propPath), (boolean)this.containsPath(listener2, propPath));
            Assert.assertTrue((String)("Path for removed then added property is wrong: actual=" + listener2.getEvents().get(1).getPath() + ", expected=" + propPath), (boolean)this.containsPath(listener2, propPath));
        }
    }

    @Test
    public void shouldTestPropertyChangedTests_testSinglePropertyChanged() throws Exception {
        Node node = this.getRoot().addNode("node1", UNSTRUCTURED);
        Property prop1 = node.setProperty("prop1", "prop1 content");
        this.save();
        TestListener listener = this.addListener(1, 16, null, false, null, null, false);
        prop1.setValue("prop1 modified content");
        this.save();
        listener.waitForEvents();
        this.removeListener(listener);
        this.checkResults(listener);
        Assert.assertTrue((String)("Path for changed property is wrong: actual=" + listener.getEvents().get(0).getPath() + ", expected=" + prop1.getPath()), (boolean)this.containsPath(listener, prop1.getPath()));
    }

    @Test
    public void shouldTestPropertyChangedTests_testSinglePropertyChangedWithAdded() throws Exception {
        Node node = this.getRoot().addNode("node1", UNSTRUCTURED);
        Property prop1 = node.setProperty("prop1", "prop1 content");
        this.save();
        TestListener listener = this.addListener(1, 16, null, false, null, null, false);
        prop1.setValue("prop1 modified content");
        node.setProperty("prop2", "prop2 content");
        this.save();
        listener.waitForEvents();
        this.removeListener(listener);
        this.checkResults(listener);
        Assert.assertTrue((String)("Path for changed property is wrong: actual=" + listener.getEvents().get(0).getPath() + ", expected=" + prop1.getPath()), (boolean)this.containsPath(listener, prop1.getPath()));
    }

    @Test
    public void shouldTestPropertyRemovedTest_testMultiPropertyRemoved() throws Exception {
        Node node = this.getRoot().addNode("node1", UNSTRUCTURED);
        Property prop1 = node.setProperty("prop1", "prop1 content");
        Property prop2 = node.setProperty("prop2", "prop2 content");
        this.save();
        TestListener listener = this.addListener(2, 8, null, false, null, null, false);
        String prop1Path = prop1.getPath();
        prop1.remove();
        String prop2Path = prop2.getPath();
        prop2.remove();
        this.save();
        listener.waitForEvents();
        this.removeListener(listener);
        this.checkResults(listener);
        Assert.assertTrue((String)("Path for first removed property not found: " + prop1Path), (boolean)this.containsPath(listener, prop1Path));
        Assert.assertTrue((String)("Path for second removed property not found: " + prop2Path), (boolean)this.containsPath(listener, prop2Path));
    }

    @Test
    public void shouldTestPropertyRemovedTest_testSinglePropertyRemoved() throws Exception {
        Node node = this.getRoot().addNode("node1", UNSTRUCTURED);
        Property prop = node.setProperty("prop1", "prop1 content");
        String propPath = prop.getPath();
        this.save();
        TestListener listener = this.addListener(1, 8, null, false, null, null, false);
        prop.remove();
        this.save();
        listener.waitForEvents();
        this.removeListener(listener);
        this.checkResults(listener);
        Assert.assertTrue((String)("Path for removed property is wrong: actual=" + listener.getEvents().get(0).getPath() + ", expected=" + propPath), (boolean)this.containsPath(listener, propPath));
    }

    @Test
    public void shouldTestAddEventListenerTest_testIsDeepFalseNodeAdded() throws Exception {
        String node1 = "node1";
        String path = this.getRoot().getPath() + '/' + node1;
        TestListener listener = this.addListener(1, 1, path, false, null, null, false);
        Node n1 = this.getRoot().addNode(node1, UNSTRUCTURED);
        Node childNode = n1.addNode("node2", UNSTRUCTURED);
        this.save();
        listener.waitForEvents();
        this.removeListener(listener);
        this.checkResults(listener);
        Assert.assertTrue((String)("Child node path is wrong: actual=" + listener.getEvents().get(0).getPath() + ", expected=" + childNode.getPath()), (boolean)this.containsPath(listener, childNode.getPath()));
    }

    @Test
    public void shouldTestAddEventListenerTest_testIsDeepFalsePropertyAdded() throws Exception {
        Node n1 = this.getRoot().addNode("node1", UNSTRUCTURED);
        Node n2 = this.getRoot().addNode("node2", UNSTRUCTURED);
        this.save();
        TestListener listener = this.addListener(1, 4, n1.getPath(), false, null, null, false);
        String prop = "prop";
        Property n1Prop = n1.setProperty(prop, "foo");
        n2.setProperty(prop, "foo");
        this.save();
        listener.waitForEvents();
        this.removeListener(listener);
        this.checkResults(listener);
        Assert.assertTrue((String)("Path for added property is wrong: actual=" + listener.getEvents().get(0).getPath() + ", expected=" + n1Prop.getPath()), (boolean)this.containsPath(listener, n1Prop.getPath()));
    }

    @Test
    public void shouldTestAddEventListenerTest_testNodeType() throws Exception {
        Node n1 = this.getRoot().addNode("node1", UNSTRUCTURED);
        n1.addMixin(LOCK_MIXIN);
        Node n2 = this.getRoot().addNode("node2", UNSTRUCTURED);
        this.save();
        TestListener listener = this.addListener(1, 1, this.getRoot().getPath(), true, null, new String[]{LOCK_MIXIN}, false);
        String node3 = "node3";
        Node n3 = n1.addNode(node3, NT_BASE);
        n2.addNode(node3, UNSTRUCTURED);
        this.save();
        listener.waitForEvents();
        this.removeListener(listener);
        this.checkResults(listener);
        Assert.assertTrue((String)("Wrong path: actual=" + listener.getEvents().get(0).getPath() + ", expected=" + n3.getPath()), (boolean)this.containsPath(listener, n3.getPath()));
    }

    @Test
    public void shouldTestAddEventListenerTest_testNoLocalTrue() throws Exception {
        TestListener listener = this.addListener(0, 1, this.getRoot().getPath(), true, null, null, true);
        this.getRoot().addNode("node1", UNSTRUCTURED);
        this.save();
        listener.waitForEvents();
        this.removeListener(listener);
        this.checkResults(listener);
    }

    @Test
    public void shouldTestAddEventListenerTest_testPath() throws Exception {
        String node1 = "node1";
        String path = this.getRoot().getPath() + '/' + node1;
        TestListener listener = this.addListener(1, 1, path, true, null, null, false);
        Node n1 = this.getRoot().addNode(node1, UNSTRUCTURED);
        Node childNode = n1.addNode("node2", UNSTRUCTURED);
        this.save();
        listener.waitForEvents();
        this.removeListener(listener);
        this.checkResults(listener);
        Assert.assertTrue((String)("Child node path is wrong: actual=" + listener.getEvents().get(0).getPath() + ", expected=" + childNode.getPath()), (boolean)this.containsPath(listener, childNode.getPath()));
    }

    @Test
    public void shouldTestAddEventListenerTest_testUUID() throws Exception {
        Node n1 = this.getRoot().addNode("node1", UNSTRUCTURED);
        n1.addMixin(REF_MIXIN);
        Node n2 = this.getRoot().addNode("node2", UNSTRUCTURED);
        n2.addMixin(REF_MIXIN);
        this.save();
        TestListener listener = this.addListener(1, 4, this.getRoot().getPath(), true, new String[]{n1.getUUID()}, null, false);
        String prop1 = "prop1";
        Property n1Prop = n1.setProperty(prop1, "foo");
        n2.setProperty(prop1, "foo");
        this.save();
        listener.waitForEvents();
        this.removeListener(listener);
        this.checkResults(listener);
        Assert.assertTrue((String)("Wrong path: actual=" + listener.getEvents().get(0).getPath() + ", expected=" + n1Prop.getPath()), (boolean)this.containsPath(listener, n1Prop.getPath()));
    }

    @Test
    @Ignore
    public void shouldTestWorkspaceOperationTest_testCopy() throws Exception {
        Node addedNode = this.getRoot().addNode("node1", UNSTRUCTURED);
        String node2 = "node2";
        addedNode.addNode(node2, UNSTRUCTURED);
        this.save();
        TestListener listener = this.addListener(2, 1, null, false, null, null, false);
        String targetPath = this.getRoot().getPath() + "/node3";
        this.getWorkspace().copy(addedNode.getPath(), targetPath);
        listener.waitForEvents();
        this.removeListener(listener);
        this.checkResults(listener);
        Assert.assertTrue((String)("Path for copied node not found: " + targetPath), (boolean)this.containsPath(listener, targetPath));
        Assert.assertTrue((String)("Path for copied child node not found: " + targetPath + '/' + node2), (boolean)this.containsPath(listener, targetPath + '/' + node2));
    }

    @Test
    public void shouldTestWorkspaceOperationTest_testMove() throws Exception {
        String node2 = "node2";
        Node n1 = this.getRoot().addNode("node1", UNSTRUCTURED);
        n1.addNode(node2, UNSTRUCTURED);
        Node n3 = this.getRoot().addNode("node3", UNSTRUCTURED);
        this.save();
        TestListener addNodeListener = this.addListener(1, 1, null, false, null, null, false);
        TestListener removeNodeListener = this.addListener(1, 2, null, false, null, null, false);
        String oldPath = n1.getPath();
        String targetPath = n3.getPath() + "/node4";
        this.getWorkspace().move(oldPath, targetPath);
        this.save();
        addNodeListener.waitForEvents();
        this.removeListener(addNodeListener);
        removeNodeListener.waitForEvents();
        this.removeListener(removeNodeListener);
        this.checkResults(addNodeListener);
        this.checkResults(removeNodeListener);
        Assert.assertTrue((String)("Path for new location of moved node is wrong: actual=" + addNodeListener.getEvents().get(0).getPath() + ", expected=" + targetPath), (boolean)this.containsPath(addNodeListener, targetPath));
        Assert.assertTrue((String)("Path for old location of moved node is wrong: actual=" + removeNodeListener.getEvents().get(0).getPath() + ", expected=" + oldPath), (boolean)this.containsPath(removeNodeListener, oldPath));
    }

    @Test
    public void shouldTestWorkspaceOperationTest_testRename() throws Exception {
        Node n1 = this.getRoot().addNode("node1", UNSTRUCTURED);
        n1.addNode("node2", UNSTRUCTURED);
        this.save();
        TestListener addNodeListener = this.addListener(1, 1, null, false, null, null, false);
        TestListener removeNodeListener = this.addListener(1, 2, null, false, null, null, false);
        String oldPath = n1.getPath();
        String renamedPath = this.getRoot().getPath() + "/node3";
        this.getWorkspace().move(oldPath, renamedPath);
        this.save();
        addNodeListener.waitForEvents();
        this.removeListener(addNodeListener);
        removeNodeListener.waitForEvents();
        this.removeListener(removeNodeListener);
        this.checkResults(addNodeListener);
        this.checkResults(removeNodeListener);
        Assert.assertTrue((String)("Path for renamed node is wrong: actual=" + addNodeListener.getEvents().get(0).getPath() + ", expected=" + renamedPath), (boolean)this.containsPath(addNodeListener, renamedPath));
        Assert.assertTrue((String)("Path for old name of renamed node is wrong: actual=" + removeNodeListener.getEvents().get(0).getPath() + ", expected=" + oldPath), (boolean)this.containsPath(removeNodeListener, oldPath));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TestListener
    implements EventListener {
        private String errorMessage;
        private final List<Event> events;
        private int eventsProcessed = 0;
        private final int eventTypes;
        private final int expectedEvents;
        private final CountDownLatch latch;

        public TestListener(int expectedEvents, int numIterators, int eventTypes) {
            this.eventTypes = eventTypes;
            this.expectedEvents = expectedEvents;
            this.events = new ArrayList<Event>();
            this.latch = new CountDownLatch(numIterators);
        }

        public int getActualEventCount() {
            return this.eventsProcessed;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public List<Event> getEvents() {
            return this.events;
        }

        public int getExpectedEventCount() {
            return this.expectedEvents;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onEvent(EventIterator itr) {
            block9: {
                try {
                    long position = itr.getPosition();
                    if (position == 0L) {
                        while (itr.hasNext()) {
                            Event event = itr.nextEvent();
                            if (++position != itr.getPosition()) {
                                this.errorMessage = "EventIterator position was " + itr.getPosition() + " and should be " + position;
                            } else {
                                this.events.add(event);
                                ++this.eventsProcessed;
                                if (this.eventsProcessed > this.expectedEvents) {
                                } else {
                                    int eventType = event.getType();
                                    if ((this.eventTypes & eventType) != 0) continue;
                                    this.errorMessage = "Received a wrong event type of " + eventType;
                                }
                            }
                            break block9;
                        }
                        break block9;
                    }
                    this.errorMessage = "EventIterator position was not initially set to zero";
                }
                finally {
                    this.latch.countDown();
                }
            }
        }

        public void waitForEvents() throws Exception {
            this.latch.await(2000L, TimeUnit.MILLISECONDS);
        }
    }
}

