/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.jboss.security.config.IDTrustConfiguration;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.modeshape.graph.connector.inmemory.InMemoryRepositorySource;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.jcr.JcrConfiguration;
import org.modeshape.jcr.JcrEngine;
import org.modeshape.jcr.JcrNodeTypeManager;
import org.modeshape.jcr.JcrQueryManager;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.nodetype.InvalidNodeTypeDefinitionException;
import org.modeshape.repository.ModeShapeConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JcrQueryManagerTest {
    private static JcrConfiguration configuration;
    private static JcrEngine engine;
    private static JcrRepository repository;
    private Session session;
    private boolean print;

    protected static URI resourceUri(String name) throws URISyntaxException {
        return JcrQueryManagerTest.resourceUrl(name).toURI();
    }

    protected static URL resourceUrl(String name) {
        return JcrQueryManagerTest.class.getClassLoader().getResource(name);
    }

    protected static InputStream resourceStream(String name) {
        return JcrQueryManagerTest.class.getClassLoader().getResourceAsStream(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BeforeClass
    public static void beforeAll() throws Exception {
        configuration = new JcrConfiguration();
        ((ModeShapeConfiguration.RepositorySourceDefinition)configuration.repositorySource("car-source").usingClass(InMemoryRepositorySource.class)).setDescription("The automobile content");
        configuration.repository("cars").setSource("car-source").registerNamespace("car", "http://www.modeshape.org/examples/cars/1.0").addNodeTypes(JcrQueryManagerTest.resourceUrl("cars.cnd")).setOption(JcrRepository.Option.ANONYMOUS_USER_ROLES, "readonly,readwrite").setOption(JcrRepository.Option.JAAS_LOGIN_CONFIG_NAME, "modeshape-jcr");
        engine = configuration.build();
        engine.start();
        String configFile = "security/jaas.conf.xml";
        IDTrustConfiguration idtrustConfig = new IDTrustConfiguration();
        try {
            idtrustConfig.config(configFile);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
        repository = engine.getRepository("cars");
        Session session = repository.login();
        try {
            InputStream stream = JcrQueryManagerTest.resourceStream("io/cars-system-view.xml");
            try {
                session.getWorkspace().importXML("/", stream, 0);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            finally {
                stream.close();
            }
            Node other = session.getRootNode().addNode("Other", "nt:unstructured");
            other.addNode("NodeA", "nt:unstructured").setProperty("something", "value3");
            other.addNode("NodeA", "nt:unstructured").setProperty("something", "value2");
            other.addNode("NodeA", "nt:unstructured").setProperty("something", "value1");
            session.save();
            session.getWorkspace().getQueryManager().createQuery("//element(*,nt:unstructured)", "xpath");
            session.getWorkspace().getQueryManager().createQuery("SELECT * FROM [nt:base]", "SQL");
        }
        finally {
            session.logout();
        }
        repository.getRepositoryTypeManager().getRepositorySchemata();
    }

    @AfterClass
    public static void afterAll() throws Exception {
        engine.shutdown();
        engine.awaitTermination(3L, TimeUnit.SECONDS);
        engine = null;
        configuration = null;
    }

    @Before
    public void beforeEach() throws Exception {
        this.print = false;
        this.session = repository.login();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void afterEach() throws Exception {
        if (this.session != null) {
            try {
                this.session.logout();
            }
            finally {
                this.session = null;
            }
        }
    }

    protected Name name(String name) {
        return (Name)engine.getExecutionContext().getValueFactories().getNameFactory().create(name);
    }

    protected Path.Segment segment(String segment) {
        return engine.getExecutionContext().getValueFactories().getPathFactory().createSegment(segment);
    }

    protected List<Path.Segment> segments(String ... segments) {
        ArrayList<Path.Segment> result = new ArrayList<Path.Segment>();
        for (String segment : segments) {
            result.add(this.segment(segment));
        }
        return result;
    }

    protected void assertResults(Query query, QueryResult result, long numberOfResults) throws RepositoryException {
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        if (this.print) {
            System.out.println();
            System.out.println(query);
            System.out.println(" plan -> " + ((JcrQueryManager.JcrQueryResult)result).getPlan());
            System.out.println(result);
        }
        Assert.assertThat((Object)result.getNodes().getSize(), (Matcher)Is.is((Object)numberOfResults));
        Assert.assertThat((Object)result.getRows().getSize(), (Matcher)Is.is((Object)numberOfResults));
    }

    protected void assertResultsHaveColumns(QueryResult result, String ... columnNames) throws RepositoryException {
        HashSet<String> expectedNames = new HashSet<String>();
        for (String name : columnNames) {
            expectedNames.add(name);
        }
        HashSet<String> actualNames = new HashSet<String>();
        for (String name : result.getColumnNames()) {
            actualNames.add(name);
        }
        Assert.assertThat(actualNames, (Matcher)Is.is(expectedNames));
    }

    @Test
    public void shouldStartUp() {
        Assert.assertThat((Object)engine.getRepositoryService(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldHaveLoadedContent() throws RepositoryException {
        Node node = this.session.getRootNode().getNode("Cars");
        Assert.assertThat((Object)node, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)node.hasNode("Sports"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)node.hasNode("Utility"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)node.hasNode("Hybrid"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)node.hasNode("Hybrid/Toyota Prius"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)node.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"nt:unstructured"));
    }

    @Test
    public void shouldReturnQueryManagerFromWorkspace() throws RepositoryException {
        Assert.assertThat((Object)this.session.getWorkspace().getQueryManager(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldBeAbleToCreateAndExecuteSqlQuery() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("SELECT * FROM [nt:base]", "SQL");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 22L);
        this.assertResultsHaveColumns(result, "jcr:primaryType");
    }

    @Test
    public void shouldBeAbleToCreateXPathQuery() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("//element(*,car:Car)", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, query.execute(), 12L);
        query = this.session.getWorkspace().getQueryManager().createQuery("//element(*,nt:unstructured)", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, query.execute(), 21L);
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryToFindAllNodes() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("//element(*,nt:base)", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        this.assertResults(query, result, 22L);
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "jcr:score");
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryToFindAllUnstructuredNodes() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("//element(*,nt:unstructured)", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        this.assertResults(query, result, 21L);
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "jcr:score");
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryToFindAllUnstructuredNodesOrderedByPropertyValue() throws RepositoryException {
        QueryManager manager = this.session.getWorkspace().getQueryManager();
        Query query = manager.createQuery("//element(*,nt:unstructured) order by @jcr:primaryType", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        this.assertResults(query, result, 21L);
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "jcr:score");
        query = manager.createQuery("//element(*,car:Car) order by @car:year", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        result = query.execute();
        this.assertResults(query, result, 12L);
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResultsHaveColumns(result, "car:year", "jcr:path", "jcr:score");
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryToFindNodesUnderNode() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery(" /jcr:root/Cars/Hybrid/*", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        this.assertResults(query, result, 3L);
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "jcr:score");
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryToFindNodesUnderNodeAndWithProperty() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery(" /jcr:root/Cars/Hybrid/*[@car:year]", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        this.assertResults(query, result, 3L);
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "jcr:score");
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryToFindNodesUnderNodeAndWithPropertyOrderedByProperty() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery(" /jcr:root/Cars/Hybrid/*[@car:year] order by @car:year ascending", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        this.assertResults(query, result, 3L);
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResultsHaveColumns(result, "car:year", "jcr:path", "jcr:score");
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryToFindNodesUnderPath() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery(" /jcr:root/Cars//*", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        this.print = true;
        this.assertResults(query, result, 16L);
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "jcr:score");
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryToFindNodesUnderPathAndWithProperty() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery(" /jcr:root/Cars//*[@car:year]", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        this.assertResults(query, result, 16L);
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "jcr:score");
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryToFindNodesUnderPathAndWithPropertyOrderedByProperty() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery(" /jcr:root/Cars//*[@car:year] order by @car:year ascending", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        this.assertResults(query, result, 16L);
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResultsHaveColumns(result, "car:year", "jcr:path", "jcr:score");
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryToFindAllUnstructuredNodesOrderedByScore() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("//element(*,nt:unstructured) order by jcr:score()", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        this.assertResults(query, result, 21L);
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "jcr:score");
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryToFindSameNameSiblingsByIndex() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("/jcr:root/Other/NodeA", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        this.assertResults(query, result, 1L);
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)result.getNodes().nextNode().getIndex(), (Matcher)Is.is((Object)1));
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "jcr:score");
        query = this.session.getWorkspace().getQueryManager().createQuery("/jcr:root/Other/NodeA[2]", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        result = query.execute();
        this.assertResults(query, result, 1L);
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)result.getNodes().nextNode().getIndex(), (Matcher)Is.is((Object)2));
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "jcr:score");
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryToFindAllCarNodes() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("//element(*,car:Car)", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 12L);
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "jcr:score", "car:mpgCity", "car:userRating", "car:mpgHighway", "car:engine", "car:model", "car:year", "car:maker", "car:lengthInInches", "car:valueRating", "car:wheelbaseInInches", "car:msrp");
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryToFindRootNode() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("/jcr:root", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        this.assertResults(query, result, 1L);
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "jcr:score");
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryToFindChildOfRootNode() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("/jcr:root/Cars", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 1L);
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "jcr:score");
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryToFindChildOfRootNodeWithTypeCriteria() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("/jcr:root/Cars[@jcr:primaryType]", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 1L);
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "jcr:score");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=InvalidNodeTypeDefinitionException.class)
    public void shouldNotAllowUnregisteringUsedPrimaryType() throws Exception {
        Session adminSession = null;
        try {
            adminSession = repository.login((Credentials)new SimpleCredentials("superuser", "superuser".toCharArray()));
            adminSession.setNamespacePrefix("cars", "http://www.modeshape.org/examples/cars/1.0");
            JcrNodeTypeManager nodeTypeManager = (JcrNodeTypeManager)adminSession.getWorkspace().getNodeTypeManager();
            nodeTypeManager.unregisterNodeType(Collections.singletonList("cars:Car"));
        }
        finally {
            if (adminSession != null) {
                adminSession.logout();
            }
        }
    }
}

