/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.InputStream;
import java.util.Properties;
import org.apache.jackrabbit.test.RepositoryStub;
import org.jboss.security.config.IDTrustConfiguration;
import org.modeshape.common.collection.Problem;
import org.modeshape.common.collection.Problems;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Graph;
import org.modeshape.graph.connector.RepositoryConnectionFactory;
import org.modeshape.graph.property.Path;
import org.modeshape.jcr.JcrConfiguration;
import org.modeshape.jcr.JcrEngine;
import org.modeshape.jcr.JcrRepository;

public class ModeShapeRepositoryStub
extends RepositoryStub {
    public static final String MODE_SHAPE_SKIP_IMPORT = "javax.jcr.tck.modeSkipImport";
    public static final String MODE_SHAPE_NODE_TYPE_PATH = "javax.jcr.tck.modeNodeTypePath";
    private static final String REPOSITORY_SOURCE_NAME = "Test Repository Source";
    private static String currentConfigurationName = "default";
    private Properties configProps;
    private String repositoryConfigurationName;
    private JcrRepository repository;

    public ModeShapeRepositoryStub(Properties env) {
        super(env);
        this.configureRepository();
    }

    private void configureRepository() {
        this.repositoryConfigurationName = currentConfigurationName;
        JcrConfiguration configuration = new JcrConfiguration();
        try {
            this.configProps = new Properties();
            String propsFileName = "/tck/" + this.repositoryConfigurationName + "/repositoryOverlay.properties";
            InputStream propsStream = ((Object)((Object)this)).getClass().getResourceAsStream(propsFileName);
            this.configProps.load(propsStream);
            String configFileName = "/tck/" + this.repositoryConfigurationName + "/configRepository.xml";
            configuration.loadFrom(((Object)((Object)this)).getClass().getResourceAsStream(configFileName));
            configuration.repository(REPOSITORY_SOURCE_NAME).addNodeTypes(((Object)((Object)this)).getClass().getResourceAsStream("/tck/tck_test_types.cnd"));
            String nodeTypePath = this.configProps.getProperty(MODE_SHAPE_NODE_TYPE_PATH);
            if (nodeTypePath != null) {
                InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(nodeTypePath);
                configuration.repository(REPOSITORY_SOURCE_NAME).addNodeTypes(is);
            }
            JcrEngine engine = configuration.build();
            engine.start();
            Problems problems = engine.getProblems();
            for (Problem problem : problems) {
                System.err.println(problem);
            }
            if (problems.hasErrors()) {
                throw new IllegalStateException("Problems starting JCR repository");
            }
            ExecutionContext executionContext = engine.getExecutionContext();
            executionContext.getNamespaceRegistry().register("modetest", "http://www.modeshape.org/test/1.0");
            this.repository = engine.getRepository(REPOSITORY_SOURCE_NAME);
            String skipImport = (String)this.configProps.get(MODE_SHAPE_SKIP_IMPORT);
            if (!Boolean.valueOf(skipImport).booleanValue()) {
                Graph graph = Graph.create((String)this.repository.getRepositorySourceName(), (RepositoryConnectionFactory)engine.getRepositoryConnectionFactory(), (ExecutionContext)executionContext);
                Path destinationPath = executionContext.getValueFactories().getPathFactory().createRootPath();
                InputStream xmlStream = ((Object)((Object)this)).getClass().getResourceAsStream("/tck/repositoryForTckTests.xml");
                graph.importXmlFrom(xmlStream).into(destinationPath);
                graph.createWorkspace().named("otherWorkspace");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IllegalStateException("Failed to initialize the repository with text content.", ex);
        }
    }

    public static void setCurrentConfigurationName(String newConfigName) {
        currentConfigurationName = newConfigName;
    }

    public JcrRepository getRepository() {
        if (!currentConfigurationName.equals(this.repositoryConfigurationName)) {
            this.configureRepository();
        }
        return this.repository;
    }

    public String getProperty(String name) {
        String value = this.configProps.getProperty(name);
        if (value != null) {
            return value;
        }
        return super.getProperty(name);
    }

    static {
        String configFile = "security/jaas.conf.xml";
        IDTrustConfiguration idtrustConfig = new IDTrustConfiguration();
        try {
            idtrustConfig.config(configFile);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }
}

