/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.Collections;
import javax.jcr.AccessDeniedException;
import javax.jcr.Credentials;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.nodetype.ConstraintViolationException;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.modeshape.jcr.JcrNodeTypeManager;
import org.modeshape.jcr.nodetype.NodeTypeDefinition;
import org.modeshape.jcr.nodetype.NodeTypeTemplate;

public class ModeShapeTckTest
extends AbstractJCRTest {
    Session session;

    public ModeShapeTckTest(String testName) {
        this.setName(testName);
        this.isReadOnly = true;
    }

    public static Test readOnlySuite() {
        TestSuite suite = new TestSuite("ModeShape JCR API tests");
        suite.addTest((Test)new ModeShapeTckTest("testShouldAllowAdminSessionToRead"));
        suite.addTest((Test)new ModeShapeTckTest("testShouldAllowReadOnlySessionToRead"));
        suite.addTest((Test)new ModeShapeTckTest("testShouldAllowReadWriteSessionToRead"));
        suite.addTest((Test)new ModeShapeTckTest("testShouldNotSeeWorkspacesWithoutReadPermission"));
        suite.addTest((Test)new ModeShapeTckTest("testShouldMapReadRolesToWorkspacesWhenSpecified"));
        return suite;
    }

    protected void tearDown() throws Exception {
        try {
            this.superuser.getRootNode().getNode(this.nodeName1).remove();
            this.superuser.save();
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
        if (this.session != null) {
            this.session.logout();
            this.session = null;
        }
        super.tearDown();
    }

    private void testRead(Session session) throws Exception {
        Node rootNode = session.getRootNode();
        NodeIterator iter = rootNode.getNodes();
        while (iter.hasNext()) {
            iter.nextNode();
        }
    }

    private void testAddNode(Session session) throws Exception {
        session.refresh(false);
        Node root = session.getRootNode();
        root.addNode(this.nodeName1, this.testNodeType);
        session.save();
    }

    private void testRemoveNode(Session session) throws Exception {
        session.refresh(false);
        Node root = session.getRootNode();
        Node node = root.getNode(this.nodeName1);
        node.remove();
        session.save();
    }

    private void testSetProperty(Session session) throws Exception {
        session.refresh(false);
        Node root = session.getRootNode();
        root.setProperty(this.propertyName1, "test value");
        session.save();
    }

    private void testRemoveProperty(Session session) throws Exception {
        Node superNode;
        Session localAdmin = helper.getRepository().login(helper.getSuperuserCredentials(), session.getWorkspace().getName());
        ModeShapeTckTest.assertEquals((String)session.getWorkspace().getName(), (String)this.superuser.getWorkspace().getName());
        Node superRoot = localAdmin.getRootNode();
        try {
            superNode = superRoot.getNode(this.nodeName1);
        }
        catch (PathNotFoundException pnfe) {
            superNode = superRoot.addNode(this.nodeName1, this.testNodeType);
        }
        superNode.setProperty(this.propertyName1, "test value");
        localAdmin.save();
        localAdmin.logout();
        session.refresh(false);
        Node root = session.getRootNode();
        Node node = root.getNode(this.nodeName1);
        Property property = node.getProperty(this.propertyName1);
        property.remove();
        session.save();
    }

    private void testRegisterNamespace(Session session) throws Exception {
        String unusedPrefix = session.getUserID();
        session.getWorkspace().getNamespaceRegistry().registerNamespace(unusedPrefix, unusedPrefix);
        session.getWorkspace().getNamespaceRegistry().unregisterNamespace(unusedPrefix);
    }

    private void testRegisterType(Session session) throws Exception {
        JcrNodeTypeManager nodeTypes = (JcrNodeTypeManager)session.getWorkspace().getNodeTypeManager();
        NodeTypeTemplate newType = nodeTypes.createNodeTypeTemplate();
        String nodeTypeName = session.getUserID() + "Type";
        newType.setName(nodeTypeName);
        nodeTypes.registerNodeType((NodeTypeDefinition)newType, false);
        nodeTypes.unregisterNodeType(Collections.singleton(nodeTypeName));
    }

    private void testWrite(Session session) throws Exception {
        this.testAddNode(session);
        this.testSetProperty(session);
        this.testRemoveProperty(session);
        this.testRemoveNode(session);
    }

    private void testAdmin(Session session) throws Exception {
        this.testRegisterNamespace(session);
        this.testRegisterType(session);
    }

    public void testShouldAllowReadOnlySessionToRead() throws Exception {
        this.session = helper.getReadOnlySession();
        this.testRead(this.session);
    }

    public void testShouldNotAllowReadOnlySessionToWrite() throws Exception {
        this.session = helper.getReadOnlySession();
        try {
            this.testAddNode(this.session);
            ModeShapeTckTest.fail((String)"Read-only sessions should not be able to add nodes");
        }
        catch (AccessDeniedException expected) {
            // empty catch block
        }
        try {
            this.testSetProperty(this.session);
            ModeShapeTckTest.fail((String)"Read-only sessions should not be able to set properties");
        }
        catch (AccessDeniedException expected) {
            // empty catch block
        }
        try {
            this.testRemoveProperty(this.session);
            ModeShapeTckTest.fail((String)"Read-only sessions should not be able to remove properties");
        }
        catch (AccessDeniedException expected) {
            // empty catch block
        }
        try {
            this.testRemoveNode(this.session);
            ModeShapeTckTest.fail((String)"Read-only sessions should not be able to remove nodes");
        }
        catch (AccessDeniedException accessDeniedException) {
            // empty catch block
        }
    }

    public void testShouldNotAllowReadOnlySessionToAdmin() throws Exception {
        this.session = helper.getReadOnlySession();
        try {
            this.testRegisterNamespace(this.session);
            ModeShapeTckTest.fail((String)"Read-only sessions should not be able to register namespaces");
        }
        catch (AccessDeniedException expected) {
            // empty catch block
        }
        try {
            this.testRegisterType(this.session);
            ModeShapeTckTest.fail((String)"Read-only sessions should not be able to register types");
        }
        catch (AccessDeniedException accessDeniedException) {
            // empty catch block
        }
    }

    public void testShouldAllowReadWriteSessionToRead() throws Exception {
        this.session = helper.getReadWriteSession();
        this.testRead(this.session);
    }

    public void testShouldAllowReadWriteSessionToWrite() throws Exception {
        this.session = helper.getReadWriteSession();
        this.testWrite(this.session);
    }

    public void testShouldNotAllowReadWriteSessionToAdmin() throws Exception {
        this.session = helper.getReadWriteSession();
        try {
            this.testRegisterNamespace(this.session);
            ModeShapeTckTest.fail((String)"Read-write sessions should not be able to register namespaces");
        }
        catch (AccessDeniedException expected) {
            // empty catch block
        }
        try {
            this.testRegisterType(this.session);
            ModeShapeTckTest.fail((String)"Read-write sessions should not be able to register types");
        }
        catch (AccessDeniedException accessDeniedException) {
            // empty catch block
        }
    }

    public void testShouldAllowAdminSessionToRead() throws Exception {
        this.session = helper.getSuperuserSession();
        this.testRead(this.session);
    }

    public void testShouldAllowAdminSessionToWrite() throws Exception {
        this.session = helper.getSuperuserSession();
        this.testWrite(this.session);
    }

    public void testShouldAllowAdminSessionToAdmin() throws Exception {
        this.session = helper.getSuperuserSession();
        this.testAdmin(this.session);
    }

    public void testShouldMapReadRolesToWorkspacesWhenSpecified() throws Exception {
        SimpleCredentials creds = new SimpleCredentials("defaultonly", "defaultonly".toCharArray());
        this.session = helper.getRepository().login((Credentials)creds);
        this.testRead(this.session);
        this.session.logout();
        if ("default".equals(this.workspaceName)) {
            return;
        }
        this.session = helper.getRepository().login((Credentials)creds, this.workspaceName);
        this.testRead(this.session);
        try {
            this.testWrite(this.session);
            ModeShapeTckTest.fail((String)("User 'defaultuser' should not have write access to '" + this.workspaceName + "'"));
        }
        catch (AccessDeniedException accessDeniedException) {
            // empty catch block
        }
        this.session.logout();
    }

    public void testShouldMapWriteRolesToWorkspacesWhenSpecified() throws Exception {
        SimpleCredentials creds = new SimpleCredentials("defaultonly", "defaultonly".toCharArray());
        this.session = helper.getRepository().login((Credentials)creds);
        this.testRead(this.session);
        this.testWrite(this.session);
        this.session.logout();
        this.session = helper.getRepository().login((Credentials)creds, "otherWorkspace");
        this.testRead(this.session);
        try {
            this.testWrite(this.session);
            ModeShapeTckTest.fail((String)"User 'defaultuser' should not have write access to 'otherWorkspace'");
        }
        catch (AccessDeniedException accessDeniedException) {
            // empty catch block
        }
        this.session.logout();
    }

    public void testShouldNotSeeWorkspacesWithoutReadPermission() throws Exception {
        SimpleCredentials creds = new SimpleCredentials("noaccess", "noaccess".toCharArray());
        try {
            this.session = helper.getRepository().login((Credentials)creds);
            ModeShapeTckTest.fail((String)"User 'noaccess' with no access to the default workspace should not be able to log into that workspace");
        }
        catch (NoSuchWorkspaceException le) {
            // empty catch block
        }
        if ("default".equals(this.workspaceName)) {
            return;
        }
        this.session = helper.getRepository().login((Credentials)creds, this.workspaceName);
        String[] workspaceNames = this.session.getWorkspace().getAccessibleWorkspaceNames();
        Assert.assertThat((Object)workspaceNames.length, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)workspaceNames[0], (Matcher)Is.is((Object)this.workspaceName));
        this.session.logout();
    }

    public void testShouldCopyFromAnotherWorkspace() throws Exception {
        this.session = helper.getSuperuserSession("otherWorkspace");
        String nodetype1 = this.getProperty("nodetype");
        Node node1 = this.session.getRootNode().addNode(this.nodeName1, nodetype1);
        node1.addNode(this.nodeName2, nodetype1);
        this.session.save();
        this.session.logout();
        this.superuser.getRootNode().addNode(this.nodeName4, nodetype1);
        this.superuser.save();
        this.superuser.getWorkspace().copy("otherWorkspace", "/" + this.nodeName1, "/" + this.nodeName4 + "/" + this.nodeName1);
        Node node4 = this.superuser.getRootNode().getNode(this.nodeName4);
        Node node4node1 = node4.getNode(this.nodeName1);
        Node node4node1node2 = node4node1.getNode(this.nodeName2);
        ModeShapeTckTest.assertNotNull((Object)node4node1node2);
    }

    public void testShouldNotCloneIfItWouldViolateTypeSemantics() throws Exception {
        this.session = helper.getSuperuserSession("otherWorkspace");
        Assert.assertThat((Object)this.session.getWorkspace().getName(), (Matcher)Is.is((Object)"otherWorkspace"));
        String nodetype1 = this.getProperty("nodetype");
        Node node1 = this.session.getRootNode().addNode("cloneSource", nodetype1);
        node1.addNode("modetest:mandatoryChild", nodetype1);
        this.session.save();
        this.session.logout();
        this.superuser.getRootNode().addNode("cloneTarget", nodetype1);
        this.superuser.getRootNode().addNode(this.nodeName3, nodetype1);
        this.superuser.save();
        this.superuser.getWorkspace().clone("otherWorkspace", "/cloneSource", "/cloneTarget/cloneSource", false);
        this.superuser.refresh(false);
        Node node3 = (Node)this.superuser.getItem("/node3");
        Assert.assertThat((Object)node3.getNodes().getSize(), (Matcher)Is.is((Object)0L));
        Node node4node1 = (Node)this.superuser.getItem("/cloneTarget/cloneSource");
        Assert.assertThat((Object)node4node1.getNodes().getSize(), (Matcher)Is.is((Object)1L));
        this.superuser.getWorkspace().clone("otherWorkspace", "/cloneSource", "/" + this.nodeName3 + "/cloneSource", true);
        this.superuser.refresh(false);
        Node node3node1 = (Node)this.superuser.getItem("/node3/cloneSource");
        Assert.assertThat((Object)node3node1.getNodes().getSize(), (Matcher)Is.is((Object)1L));
        Node node4 = (Node)this.superuser.getItem("/cloneTarget");
        Assert.assertThat((Object)node4.getNodes().getSize(), (Matcher)Is.is((Object)0L));
        this.superuser.getRootNode().addNode("nodeWithMandatoryChild", "modetest:nodeWithMandatoryChild");
        try {
            this.superuser.save();
            ModeShapeTckTest.fail((String)"A node with type modetest:nodeWithMandatoryChild should not be savable until the child is added");
        }
        catch (ConstraintViolationException cve) {
            // empty catch block
        }
        this.superuser.move("/node3/cloneSource/modetest:mandatoryChild", "/nodeWithMandatoryChild/modetest:mandatoryChild");
        this.superuser.save();
        this.superuser.refresh(false);
        try {
            this.superuser.getWorkspace().clone("otherWorkspace", "/cloneSource", "/" + this.nodeName3 + "/cloneSource", true);
            ModeShapeTckTest.fail((String)"Should not be able to use clone to remove the mandatory child node at /nodeWithMandatoryChild/modetest:mandatoryChild");
        }
        catch (ConstraintViolationException cve) {
            // empty catch block
        }
    }

    public void testAdminUserCanBreakOthersLocks() throws Exception {
        String lockNodeName = "lockTestNode";
        this.session = helper.getReadWriteSession();
        Node root = this.session.getRootNode();
        Node lockNode = root.addNode(lockNodeName);
        lockNode.addMixin("mix:lockable");
        this.session.save();
        lockNode.lock(false, false);
        Assert.assertThat((Object)lockNode.isLocked(), (Matcher)Is.is((Object)true));
        Session superuser = helper.getSuperuserSession();
        root = superuser.getRootNode();
        lockNode = root.getNode(lockNodeName);
        Assert.assertThat((Object)lockNode.isLocked(), (Matcher)Is.is((Object)true));
        lockNode.unlock();
        Assert.assertThat((Object)lockNode.isLocked(), (Matcher)Is.is((Object)false));
        superuser.logout();
    }
}

