/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.LinkedList;
import java.util.UUID;
import javax.jcr.RepositoryException;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Graph;
import org.modeshape.graph.Location;
import org.modeshape.graph.connector.MockRepositoryConnection;
import org.modeshape.graph.connector.RepositoryConnectionFactory;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.property.PropertyFactory;
import org.modeshape.graph.request.LockBranchRequest;
import org.modeshape.graph.request.Request;
import org.modeshape.graph.request.UnlockBranchRequest;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.ModeShapeLexicon;
import org.modeshape.jcr.RepositoryNodeTypeManager;
import org.modeshape.jcr.WorkspaceLockManager;

public class WorkspaceLockManagerTest {
    protected Graph graph;
    private ExecutionContext context;
    private UUID validUuid;
    private Location validLocation;
    private String sourceName;
    private String workspaceName;
    private MockRepositoryConnection connection;
    private LinkedList<Request> executedRequests;
    private RepositoryNodeTypeManager repoTypeManager;
    protected WorkspaceLockManager workspaceLockManager;
    @MockitoAnnotations.Mock
    private RepositoryConnectionFactory connectionFactory;
    @MockitoAnnotations.Mock
    protected JcrRepository repository;

    @Before
    public void beforeEach() {
        MockitoAnnotations.initMocks((Object)this);
        this.executedRequests = new LinkedList();
        this.sourceName = "Source";
        this.workspaceName = "default";
        this.context = new ExecutionContext();
        this.connection = new MockRepositoryConnection(this.sourceName, this.executedRequests);
        Mockito.stub((Object)this.connectionFactory.createConnection(this.sourceName)).toReturn((Object)this.connection);
        this.graph = Graph.create((String)this.sourceName, (RepositoryConnectionFactory)this.connectionFactory, (ExecutionContext)this.context);
        this.validUuid = UUID.randomUUID();
        this.validLocation = Location.create((UUID)this.validUuid);
        PathFactory pathFactory = this.context.getValueFactories().getPathFactory();
        Mockito.stub((Object)this.repository.getExecutionContext()).toReturn((Object)this.context);
        Mockito.stub((Object)this.repository.getRepositorySourceName()).toReturn((Object)this.sourceName);
        Mockito.stub((Object)this.repository.getPersistentRegistry()).toReturn((Object)this.context.getNamespaceRegistry());
        Mockito.stub((Object)this.repository.createWorkspaceGraph(Matchers.anyString(), (ExecutionContext)Matchers.anyObject())).toAnswer((Answer)new Answer<Graph>(){

            public Graph answer(InvocationOnMock invocation) throws Throwable {
                return WorkspaceLockManagerTest.this.graph;
            }
        });
        Mockito.stub((Object)this.repository.createSystemGraph(this.context)).toAnswer((Answer)new Answer<Graph>(){

            public Graph answer(InvocationOnMock invocation) throws Throwable {
                return WorkspaceLockManagerTest.this.graph;
            }
        });
        Path locksPath = pathFactory.createAbsolutePath(new Name[]{JcrLexicon.SYSTEM, ModeShapeLexicon.LOCKS});
        this.workspaceLockManager = new WorkspaceLockManager(this.context, this.repository, this.workspaceName, locksPath);
        Mockito.stub((Object)this.repository.getLockManager(Matchers.anyString())).toAnswer((Answer)new Answer<WorkspaceLockManager>(){

            public WorkspaceLockManager answer(InvocationOnMock invocation) throws Throwable {
                return WorkspaceLockManagerTest.this.workspaceLockManager;
            }
        });
        this.repoTypeManager = new RepositoryNodeTypeManager(this.repository, true);
        Mockito.stub((Object)this.repository.getRepositoryTypeManager()).toReturn((Object)this.repoTypeManager);
        this.executedRequests.clear();
    }

    protected Path createPath(String path) {
        return (Path)this.context.getValueFactories().getPathFactory().create(path);
    }

    protected Path createPath(Path parent, String path) {
        return this.context.getValueFactories().getPathFactory().create(parent, path);
    }

    protected Name createName(String name) {
        return (Name)this.context.getValueFactories().getNameFactory().create(name);
    }

    protected Property createProperty(String name, Object ... values) {
        return this.context.getPropertyFactory().create(this.createName(name), values);
    }

    protected void assertNextRequestIsLock(Location at, LockBranchRequest.LockScope lockScope, long lockTimeout) {
        Request request = this.executedRequests.poll();
        Assert.assertThat((Object)request, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(LockBranchRequest.class)));
        LockBranchRequest lock = (LockBranchRequest)request;
        Assert.assertThat((Object)lock.at(), (Matcher)Is.is((Object)at));
        Assert.assertThat((Object)lock.lockScope(), (Matcher)Is.is((Object)lockScope));
        Assert.assertThat((Object)lock.lockTimeoutInMillis(), (Matcher)Is.is((Object)lockTimeout));
    }

    protected void assertNextRequestIsUnlock(Location at) {
        Request request = this.executedRequests.poll();
        Assert.assertThat((Object)request, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(UnlockBranchRequest.class)));
        UnlockBranchRequest unlock = (UnlockBranchRequest)request;
        Assert.assertThat((Object)unlock.at(), (Matcher)Is.is((Object)at));
    }

    @Test
    public void shouldCreateLockRequestWhenLockingNode() throws RepositoryException {
        WorkspaceLockManager.ModeShapeLock lock = this.workspaceLockManager.createLock("testOwner", UUID.randomUUID(), this.validUuid, false, false);
        PropertyFactory propFactory = this.context.getPropertyFactory();
        String lockOwner = "testOwner";
        boolean isDeep = false;
        Property lockOwnerProp = propFactory.create(JcrLexicon.LOCK_OWNER, new Object[]{lockOwner});
        Property lockIsDeepProp = propFactory.create(JcrLexicon.LOCK_IS_DEEP, new Object[]{isDeep});
        JcrSession session = (JcrSession)Mockito.mock(JcrSession.class);
        Mockito.stub((Object)session.getExecutionContext()).toReturn((Object)this.context);
        this.workspaceLockManager.lockNodeInRepository(session, this.validUuid, lockOwnerProp, lockIsDeepProp, lock, isDeep);
        this.assertNextRequestIsLock(this.validLocation, LockBranchRequest.LockScope.SELF_ONLY, 0L);
    }

    @Test
    public void shouldCreateLockRequestWhenUnlockingNode() {
        WorkspaceLockManager.ModeShapeLock lock = this.workspaceLockManager.createLock("testOwner", UUID.randomUUID(), this.validUuid, false, false);
        this.workspaceLockManager.unlockNodeInRepository(this.context, lock);
        this.assertNextRequestIsUnlock(this.validLocation);
    }
}

