/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import net.jcip.annotations.NotThreadSafe;
import org.modeshape.common.text.TextEncoder;
import org.modeshape.common.text.XmlNameEncoder;
import org.modeshape.common.text.XmlValueEncoder;
import org.modeshape.graph.property.Name;
import org.modeshape.jcr.JcrSession;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
abstract class AbstractJcrExporter {
    private static final TextEncoder NAME_ENCODER = new XmlNameEncoder();
    protected final JcrSession session;
    private final Collection<String> restrictedPrefixes;
    private final Map<Name, String> prefixedNames;

    AbstractJcrExporter(JcrSession session, Collection<String> restrictedPrefixes) {
        this.session = session;
        this.restrictedPrefixes = restrictedPrefixes;
        this.prefixedNames = new HashMap<Name, String>();
    }

    protected String getPrefixedName(Name baseName) {
        String prefixedName = this.prefixedNames.get(baseName);
        if (prefixedName == null) {
            prefixedName = baseName.getString(this.session.getExecutionContext().getNamespaceRegistry());
            this.prefixedNames.put(baseName, prefixedName);
        }
        return prefixedName;
    }

    public void exportView(Node exportRootNode, ContentHandler contentHandler, boolean skipBinary, boolean noRecurse) throws RepositoryException, SAXException {
        int i;
        assert (exportRootNode != null);
        assert (contentHandler != null);
        NamespaceRegistry registry = this.session.getWorkspace().getNamespaceRegistry();
        contentHandler.startDocument();
        String[] namespacePrefixes = registry.getPrefixes();
        for (i = 0; i < namespacePrefixes.length; ++i) {
            String prefix = namespacePrefixes[i];
            if (this.restrictedPrefixes.contains(prefix)) continue;
            contentHandler.startPrefixMapping(prefix, registry.getURI(prefix));
        }
        this.exportNode(exportRootNode, contentHandler, skipBinary, noRecurse);
        for (i = 0; i < namespacePrefixes.length; ++i) {
            if (this.restrictedPrefixes.contains(namespacePrefixes[i])) continue;
            contentHandler.endPrefixMapping(namespacePrefixes[i]);
        }
        contentHandler.endDocument();
    }

    public void exportView(Node node, OutputStream os, boolean skipBinary, boolean noRecurse) throws RepositoryException {
        try {
            this.exportView(node, new StreamingContentHandler(os), skipBinary, noRecurse);
            os.flush();
        }
        catch (IOException ioe) {
            throw new RepositoryException((Throwable)ioe);
        }
        catch (SAXException se) {
            throw new RepositoryException((Throwable)se);
        }
    }

    public abstract void exportNode(Node var1, ContentHandler var2, boolean var3, boolean var4) throws RepositoryException, SAXException;

    protected void startElement(ContentHandler contentHandler, Name name, Attributes atts) throws SAXException {
        contentHandler.startElement(name.getNamespaceUri(), NAME_ENCODER.encode(name.getLocalName()), NAME_ENCODER.encode(this.getPrefixedName(name)), atts);
    }

    protected void endElement(ContentHandler contentHandler, Name name) throws SAXException {
        contentHandler.endElement(name.getNamespaceUri(), NAME_ENCODER.encode(name.getLocalName()), NAME_ENCODER.encode(this.getPrefixedName(name)));
    }

    private class StreamingContentHandler
    extends DefaultHandler {
        private static final boolean LOG_TO_CONSOLE = false;
        private final TextEncoder VALUE_ENCODER = new XmlValueEncoder();
        private final List<String> UNEXPORTABLE_NAMESPACES = Arrays.asList("", "xml", "xmlns");
        private final OutputStream os;
        private final Map<String, String> mappedPrefixes;

        public StreamingContentHandler(OutputStream os) {
            this.os = os;
            this.mappedPrefixes = new HashMap<String, String>();
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            this.emit(this.VALUE_ENCODER.encode(new String(ch, start, length)));
        }

        public void startDocument() throws SAXException {
            this.emit("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        }

        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            this.emit("<");
            this.emit(name);
            for (Map.Entry<String, String> mapping : this.mappedPrefixes.entrySet()) {
                this.emit(" xmlns:");
                this.emit(mapping.getKey());
                this.emit("=\"");
                this.emit(mapping.getValue());
                this.emit("\"");
            }
            this.mappedPrefixes.clear();
            if (attributes != null) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    this.emit(" ");
                    this.emit(attributes.getQName(i));
                    this.emit("=\"");
                    this.emit(this.VALUE_ENCODER.encode(attributes.getValue(i)));
                    this.emit("\"");
                }
            }
            this.emit(">");
        }

        public void endElement(String uri, String localName, String name) throws SAXException {
            this.emit("</");
            this.emit(name);
            this.emit(">");
        }

        public void startPrefixMapping(String prefix, String uri) {
            if (!this.UNEXPORTABLE_NAMESPACES.contains(prefix)) {
                this.mappedPrefixes.put(prefix, uri);
            }
        }

        private void emit(String text) throws SAXException {
            try {
                this.os.write(text.getBytes());
            }
            catch (IOException ioe) {
                throw new SAXException(ioe);
            }
        }
    }
}

