/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.jcr.RepositoryException;
import net.jcip.annotations.ThreadSafe;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.Logger;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Graph;
import org.modeshape.graph.Location;
import org.modeshape.graph.Node;
import org.modeshape.graph.Subgraph;
import org.modeshape.graph.SubgraphNode;
import org.modeshape.graph.connector.RepositoryConnectionFactory;
import org.modeshape.graph.connector.RepositorySource;
import org.modeshape.graph.connector.RepositorySourceCapabilities;
import org.modeshape.graph.observe.Observable;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.property.PathNotFoundException;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.property.basic.GraphNamespaceRegistry;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.ModeShapeLexicon;
import org.modeshape.repository.ModeShapeConfiguration;
import org.modeshape.repository.ModeShapeEngine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class JcrEngine
extends ModeShapeEngine {
    static final int LOCK_SWEEP_INTERVAL_IN_MILLIS = 30000;
    static final int LOCK_EXTENSION_INTERVAL_IN_MILLIS = 60000;
    private final Logger log = Logger.getLogger(ModeShapeEngine.class);
    private final Map<String, JcrRepository> repositories;
    private final Lock repositoriesLock;
    private final ScheduledExecutorService scheduler = new ScheduledThreadPoolExecutor(2);

    JcrEngine(ExecutionContext context, ModeShapeConfiguration.ConfigurationDefinition configuration) {
        super(context, configuration);
        this.repositories = new HashMap<String, JcrRepository>();
        this.repositoriesLock = new ReentrantLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanUpLocks() {
        ArrayList<JcrRepository> repos;
        try {
            this.repositoriesLock.lock();
            repos = new ArrayList<JcrRepository>(this.repositories.values());
        }
        finally {
            this.repositoriesLock.unlock();
        }
        for (JcrRepository repository : repos) {
            try {
                repository.cleanUpLocks();
            }
            catch (Throwable t) {
                this.log.error(t, JcrI18n.errorCleaningUpLocks, new Object[]{repository.getRepositorySourceName()});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.scheduler.shutdown();
        super.shutdown();
        try {
            this.repositoriesLock.lock();
            for (JcrRepository repository : this.repositories.values()) {
                repository.close();
            }
            this.repositories.clear();
        }
        finally {
            this.repositoriesLock.unlock();
        }
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        if (!this.scheduler.awaitTermination(timeout, unit)) {
            return false;
        }
        return super.awaitTermination(timeout, unit);
    }

    public void start() {
        super.start();
        final JcrEngine engine = this;
        Runnable cleanUpTask = new Runnable(){

            public void run() {
                engine.cleanUpLocks();
            }
        };
        this.scheduler.scheduleAtFixedRate(cleanUpTask, 30000L, 30000L, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final JcrRepository getRepository(String repositoryName) throws RepositoryException {
        CheckArg.isNotEmpty((String)repositoryName, (String)"repositoryName");
        this.checkRunning();
        try {
            this.repositoriesLock.lock();
            JcrRepository repository = this.repositories.get(repositoryName);
            if (repository == null) {
                try {
                    repository = this.doCreateJcrRepository(repositoryName);
                }
                catch (PathNotFoundException e) {
                    String msg = JcrI18n.repositoryDoesNotExist.text(new Object[]{repositoryName});
                    throw new RepositoryException(msg);
                }
                this.repositories.put(repositoryName, repository);
            }
            JcrRepository jcrRepository = repository;
            return jcrRepository;
        }
        finally {
            this.repositoriesLock.unlock();
        }
    }

    public Set<String> getRepositoryNames() {
        this.checkRunning();
        HashSet<String> results = new HashSet<String>();
        PathFactory pathFactory = this.getExecutionContext().getValueFactories().getPathFactory();
        Path repositoriesPath = pathFactory.create(this.configuration.getPath(), new Name[]{ModeShapeLexicon.REPOSITORIES});
        Graph configuration = this.getConfigurationGraph();
        for (Location child : (List)configuration.getChildren().of(repositoriesPath)) {
            Name repositoryName = child.getPath().getLastSegment().getName();
            results.add(this.readable(repositoryName));
        }
        return Collections.unmodifiableSet(results);
    }

    protected JcrRepository doCreateJcrRepository(String repositoryName) throws RepositoryException, PathNotFoundException {
        Property property;
        RepositoryConnectionFactory connectionFactory = this.getRepositoryConnectionFactory();
        Map<String, String> descriptors = null;
        HashMap<JcrRepository.Option, String> options = new HashMap<JcrRepository.Option, String>();
        PathFactory pathFactory = this.getExecutionContext().getValueFactories().getPathFactory();
        Path repositoriesPath = pathFactory.create(this.configuration.getPath(), new Name[]{ModeShapeLexicon.REPOSITORIES});
        Path repositoryPath = pathFactory.create(repositoriesPath, repositoryName);
        Graph configuration = this.getConfigurationGraph();
        Subgraph subgraph = (Subgraph)configuration.getSubgraphOfDepth(6).at(repositoryPath);
        SubgraphNode optionsNode = subgraph.getNode(ModeShapeLexicon.OPTIONS);
        if (optionsNode != null) {
            for (Location optionLocation : optionsNode.getChildren()) {
                JcrRepository.Option option;
                Node optionNode = configuration.getNodeAt(optionLocation);
                Path.Segment segment = optionLocation.getPath().getLastSegment();
                Property valueProperty = optionNode.getProperty(ModeShapeLexicon.VALUE);
                if (valueProperty == null || (option = JcrRepository.Option.findOption(segment.getName().getLocalName())) == null) continue;
                options.put(option, valueProperty.getFirstValue().toString());
            }
        }
        ExecutionContext context = this.getExecutionContext();
        SubgraphNode namespacesNode = subgraph.getNode(ModeShapeLexicon.NAMESPACES);
        if (namespacesNode != null) {
            GraphNamespaceRegistry registry = new GraphNamespaceRegistry(configuration, namespacesNode.getLocation().getPath(), ModeShapeLexicon.NAMESPACE_URI, new Property[0]);
            context = context.with((NamespaceRegistry)registry);
        }
        if ((property = subgraph.getRoot().getProperty(ModeShapeLexicon.SOURCE_NAME)) == null || property.isEmpty()) {
            String readableName = this.readable(ModeShapeLexicon.SOURCE_NAME);
            String readablePath = this.readable(subgraph.getLocation());
            String msg = JcrI18n.propertyNotFoundOnNode.text(new Object[]{readableName, readablePath, configuration.getCurrentWorkspaceName()});
            throw new RepositoryException(msg);
        }
        String sourceName = (String)context.getValueFactories().getStringFactory().create(property.getFirstValue());
        RepositorySource source = this.getRepositorySource(sourceName);
        RepositorySourceCapabilities capabilities = source != null ? source.getCapabilities() : null;
        JcrRepository repository = new JcrRepository(context, connectionFactory, sourceName, (Observable)this.getRepositoryService().getRepositoryLibrary(), capabilities, descriptors, options);
        SubgraphNode nodeTypesNode = subgraph.getNode(JcrLexicon.NODE_TYPES);
        if (nodeTypesNode != null) {
            repository.getRepositoryTypeManager().registerNodeTypes(subgraph, nodeTypesNode.getLocation());
        }
        return repository;
    }

    protected final String readable(Name name) {
        return name.getString(this.context.getNamespaceRegistry());
    }

    protected final String readable(Path path) {
        return path.getString(this.context.getNamespaceRegistry());
    }

    protected final String readable(Location location) {
        return location.getString(this.context.getNamespaceRegistry());
    }
}

