/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import javax.jcr.ItemNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import net.jcip.annotations.NotThreadSafe;
import org.modeshape.graph.Location;
import org.modeshape.graph.session.GraphSession;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.SessionCache;

@NotThreadSafe
final class JcrNode
extends AbstractJcrNode {
    JcrNode(SessionCache cache, GraphSession.NodeId nodeId, Location location) {
        super(cache, nodeId, location);
    }

    boolean isRoot() {
        return false;
    }

    public int getIndex() throws RepositoryException {
        return this.segment().getIndex();
    }

    public String getName() throws RepositoryException {
        return this.name().getString(this.namespaces());
    }

    public AbstractJcrNode getParent() throws ItemNotFoundException, RepositoryException {
        return ((SessionCache.JcrNodePayload)this.nodeInfo().getParent().getPayload()).getJcrNode();
    }

    public String getPath() throws RepositoryException {
        return this.nodeInfo().getPath().getString(this.namespaces());
    }

    public void remove() throws RepositoryException, LockException {
        Lock parentLock;
        AbstractJcrNode parentNode = this.getParent();
        if (parentNode.isLocked() && (parentLock = parentNode.getLock()) != null && parentLock.getLockToken() == null) {
            throw new LockException();
        }
        this.editor().destroy();
    }
}

