/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.IOException;
import javax.jcr.RepositoryException;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.property.Name;
import org.modeshape.jcr.CndNodeTypeSource;
import org.modeshape.jcr.JcrNodeDefinition;
import org.modeshape.jcr.JcrNodeType;
import org.modeshape.jcr.JcrNodeTypeSource;
import org.modeshape.jcr.JcrPropertyDefinition;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.RepositoryNodeTypeManager;

public class CndNodeTypeRegistrationTest {
    private static final String CND_LOCATION = "/cndNodeTypeRegistration/";
    private ExecutionContext context;
    private RepositoryNodeTypeManager repoTypeManager;
    private JcrNodeTypeSource nodeTypes;
    @Mock
    protected JcrRepository repository;

    @Before
    public void beforeEach() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.context = new ExecutionContext();
        this.context.getNamespaceRegistry().register("modetest", "http://www.modeshape.org/test/1.0");
        Mockito.when((Object)this.repository.getExecutionContext()).thenReturn((Object)this.context);
        this.repoTypeManager = new RepositoryNodeTypeManager(this.repository, true);
        try {
            this.repoTypeManager.registerNodeTypes((JcrNodeTypeSource)new CndNodeTypeSource(new String[]{"/org/modeshape/jcr/jsr_170_builtins.cnd", "/org/modeshape/jcr/dna_builtins.cnd"}));
        }
        catch (RepositoryException re) {
            re.printStackTrace();
            throw new IllegalStateException("Could not load node type definition files", re);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new IllegalStateException("Could not access node type definition files", ioe);
        }
    }

    @Test(expected=RepositoryException.class)
    public void shouldNotAllowRedefinitionOfExistingType() throws Exception {
        this.nodeTypes = new CndNodeTypeSource("/cndNodeTypeRegistration/existingType.cnd");
        this.repoTypeManager.registerNodeTypes(this.nodeTypes);
    }

    @Test
    public void shouldRegisterValidTypes() throws Exception {
        this.nodeTypes = new CndNodeTypeSource("/cndNodeTypeRegistration/validType.cnd");
        this.repoTypeManager.registerNodeTypes(this.nodeTypes);
        Name testNodeName = this.context.getValueFactories().getNameFactory().create("http://www.modeshape.org/test/1.0", "testType");
        JcrNodeType nodeType = this.repoTypeManager.getNodeType(testNodeName);
        Assert.assertThat((Object)nodeType, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)nodeType.isMixin(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)nodeType.hasOrderableChildNodes(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)nodeType.getDeclaredSupertypes().length, (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)nodeType.getDeclaredChildNodeDefinitions().length, (Matcher)Is.is((Object)1));
        JcrNodeDefinition childNode = (JcrNodeDefinition)nodeType.getDeclaredChildNodeDefinitions()[0];
        Assert.assertThat((Object)childNode.getName(), (Matcher)Is.is((Object)"modetest:namespace"));
        Assert.assertThat((Object)childNode.getDefaultPrimaryType().getName(), (Matcher)Is.is((Object)"mode:namespace"));
        Assert.assertThat((Object)childNode.getRequiredPrimaryTypes().length, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)childNode.getRequiredPrimaryTypes()[0].getName(), (Matcher)Is.is((Object)"mode:namespace"));
        Assert.assertThat((Object)childNode.allowsSameNameSiblings(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)childNode.isMandatory(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)nodeType.getDeclaredPropertyDefinitions().length, (Matcher)Is.is((Object)1));
        JcrPropertyDefinition property = (JcrPropertyDefinition)nodeType.getDeclaredPropertyDefinitions()[0];
        Assert.assertThat((Object)property.getName(), (Matcher)Is.is((Object)"*"));
        Assert.assertThat((Object)property.getRequiredType(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)property.getValueConstraints().length, (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)property.getValueConstraints()[0], (Matcher)Is.is((Object)"foo"));
        Assert.assertThat((Object)property.getValueConstraints()[1], (Matcher)Is.is((Object)"bar"));
        Assert.assertThat((Object)property.getValueConstraints()[2], (Matcher)Is.is((Object)"baz"));
        Assert.assertThat((Object)property.getDefaultValues().length, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)property.getDefaultValues()[0].getString(), (Matcher)Is.is((Object)"foo"));
    }
}

