/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.nodetype.PropertyDefinition;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.modeshape.graph.property.DateTime;
import org.modeshape.graph.property.DateTimeFactory;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.AbstractJcrTest;
import org.modeshape.jcr.JcrNodeTypeTemplate;
import org.modeshape.jcr.JcrPropertyDefinitionTemplate;
import org.modeshape.jcr.JcrValue;

public class JcrMultiValuePropertyTest
extends AbstractJcrTest {
    private Property prop;
    private byte[][] binaryValue;
    private DateTime[] dateValue;
    private double[] doubleValue;
    private long[] longValue;
    private String[] stringValue;
    private boolean[] booleanValue;
    private String[] nameValue;
    private String[] pathValue;
    private DateTimeFactory dateFactory;
    protected AbstractJcrNode cars;
    protected AbstractJcrNode altima;

    @BeforeClass
    public static void beforeAll() throws Exception {
        AbstractJcrTest.beforeAll();
        JcrNodeTypeTemplate nodeType = new JcrNodeTypeTemplate(context);
        nodeType.setMixin(true);
        nodeType.setName("mixinWithAllPropTypes");
        List propDefns = nodeType.getPropertyDefinitionTemplates();
        JcrPropertyDefinitionTemplate binaryDefn = new JcrPropertyDefinitionTemplate(context);
        binaryDefn.setName("binaryProperty");
        binaryDefn.setRequiredType(2);
        binaryDefn.setMultiple(true);
        propDefns.add(binaryDefn);
        JcrPropertyDefinitionTemplate booleanDefn = new JcrPropertyDefinitionTemplate(context);
        booleanDefn.setName("booleanProperty");
        booleanDefn.setRequiredType(6);
        booleanDefn.setMultiple(true);
        propDefns.add(booleanDefn);
        JcrPropertyDefinitionTemplate dateDefn = new JcrPropertyDefinitionTemplate(context);
        dateDefn.setName("dateProperty");
        dateDefn.setRequiredType(5);
        dateDefn.setMultiple(true);
        propDefns.add(dateDefn);
        JcrPropertyDefinitionTemplate doubleDefn = new JcrPropertyDefinitionTemplate(context);
        doubleDefn.setName("doubleProperty");
        doubleDefn.setRequiredType(4);
        doubleDefn.setMultiple(true);
        propDefns.add(doubleDefn);
        JcrPropertyDefinitionTemplate longDefn = new JcrPropertyDefinitionTemplate(context);
        longDefn.setName("longProperty");
        longDefn.setRequiredType(3);
        longDefn.setMultiple(true);
        propDefns.add(longDefn);
        JcrPropertyDefinitionTemplate nameDefn = new JcrPropertyDefinitionTemplate(context);
        nameDefn.setName("nameProperty");
        nameDefn.setRequiredType(7);
        nameDefn.setMultiple(true);
        propDefns.add(nameDefn);
        JcrPropertyDefinitionTemplate pathDefn = new JcrPropertyDefinitionTemplate(context);
        pathDefn.setName("pathProperty");
        pathDefn.setRequiredType(8);
        pathDefn.setMultiple(true);
        propDefns.add(pathDefn);
        JcrPropertyDefinitionTemplate refDefn = new JcrPropertyDefinitionTemplate(context);
        refDefn.setName("referenceProperty");
        refDefn.setRequiredType(9);
        refDefn.setMultiple(true);
        propDefns.add(refDefn);
        JcrPropertyDefinitionTemplate stringDefn = new JcrPropertyDefinitionTemplate(context);
        stringDefn.setName("stringProperty");
        stringDefn.setRequiredType(1);
        stringDefn.setMultiple(true);
        propDefns.add(stringDefn);
        JcrPropertyDefinitionTemplate undefinedDefn = new JcrPropertyDefinitionTemplate(context);
        undefinedDefn.setName("undefinedProperty");
        undefinedDefn.setRequiredType(0);
        undefinedDefn.setMultiple(true);
        propDefns.add(undefinedDefn);
        ArrayList<JcrNodeTypeTemplate> defns = new ArrayList<JcrNodeTypeTemplate>();
        defns.add(nodeType);
        rntm.registerNodeTypes(defns, false);
    }

    @Override
    @Before
    public void beforeEach() throws Exception {
        super.beforeEach();
        context.getNamespaceRegistry().register("acme", "http://example.com");
        this.dateFactory = context.getValueFactories().getDateFactory();
        this.binaryValue = new byte[][]{"This is a binary value1".getBytes(), "This is a binary value2".getBytes()};
        this.dateValue = new DateTime[]{this.dateFactory.create(), this.dateFactory.create().plusDays(1)};
        this.doubleValue = new double[]{3.14159, 1.0};
        this.longValue = new long[]{100L, 101L};
        this.booleanValue = new boolean[]{true, false};
        this.stringValue = new String[]{"stringValue1", "string value 2"};
        this.nameValue = new String[]{"acme:SomeName1", "acme:SomeName2"};
        this.pathValue = new String[]{"/Cars/Hybrid/Toyota Highlander/acme:SomethingElse", "/Cars/acme:Wow"};
        this.cars = this.cache.findJcrNode(null, this.path("/Cars"));
        this.cars.addMixin("mixinWithAllPropTypes");
        this.altima = this.cache.findJcrNode(null, this.path("/Cars/Hybrid/Nissan Altima"));
        this.altima.addMixin("mix:referenceable");
        this.cars.setProperty("booleanProperty", this.values(this.booleanValue));
        this.cars.setProperty("dateProperty", this.values(this.dateValue));
        this.cars.setProperty("doubleProperty", this.values(this.doubleValue));
        this.cars.setProperty("binaryProperty", this.values(this.binaryValue));
        this.cars.setProperty("longProperty", this.values(this.longValue));
        this.cars.setProperty("referenceProperty", this.values(new Node[]{this.altima}));
        this.cars.setProperty("stringProperty", this.values(1, this.stringValue));
        this.cars.setProperty("pathProperty", this.values(8, this.pathValue));
        this.cars.setProperty("nameProperty", this.values(7, this.nameValue));
        this.cars.setProperty("undefinedProperty", this.values(1, new String[]{"100", "200"}));
    }

    protected Value[] values(boolean[] values) throws Exception {
        Value[] result = new Value[values.length];
        for (int i = 0; i != values.length; ++i) {
            result[i] = new JcrValue(context.getValueFactories(), this.cache, 6, (Object)values[i]);
        }
        return result;
    }

    protected Value[] values(long[] values) throws Exception {
        Value[] result = new Value[values.length];
        for (int i = 0; i != values.length; ++i) {
            result[i] = new JcrValue(context.getValueFactories(), this.cache, 3, (Object)values[i]);
        }
        return result;
    }

    protected Value[] values(double[] values) throws Exception {
        Value[] result = new Value[values.length];
        for (int i = 0; i != values.length; ++i) {
            result[i] = new JcrValue(context.getValueFactories(), this.cache, 4, (Object)values[i]);
        }
        return result;
    }

    protected Value[] values(byte[][] values) throws Exception {
        Value[] result = new Value[values.length];
        for (int i = 0; i != values.length; ++i) {
            result[i] = new JcrValue(context.getValueFactories(), this.cache, 2, (Object)values[i]);
        }
        return result;
    }

    protected Value[] values(DateTime[] values) throws Exception {
        Value[] result = new Value[values.length];
        for (int i = 0; i != values.length; ++i) {
            result[i] = new JcrValue(context.getValueFactories(), this.cache, 5, (Object)values[i].toCalendar());
        }
        return result;
    }

    protected Value[] values(Node[] values) throws Exception {
        Value[] result = new Value[values.length];
        for (int i = 0; i != values.length; ++i) {
            result[i] = new JcrValue(context.getValueFactories(), this.cache, 9, (Object)values[i]);
        }
        return result;
    }

    protected Value[] values(int type, String[] values) throws Exception {
        Value[] result = new Value[values.length];
        for (int i = 0; i != values.length; ++i) {
            result[i] = new JcrValue(context.getValueFactories(), this.cache, type, (Object)values[i]);
        }
        return result;
    }

    @Test
    public void shouldIndicateHasMultipleValues() throws Exception {
        this.prop = this.cars.getProperty("booleanProperty");
        PropertyDefinition def = this.prop.getDefinition();
        Assert.assertThat((Object)def.isMultiple(), (Matcher)Is.is((Object)true));
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotProvideBooleanForMultiValuedProperty() throws Exception {
        this.prop = this.cars.getProperty("booleanProperty");
        this.prop.getBoolean();
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotProvideDateForMultiValuedProperty() throws Exception {
        this.prop = this.cars.getProperty("dateProperty");
        this.prop.getDate();
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotProvideDoubleForMultiValuedProperty() throws Exception {
        this.prop = this.cars.getProperty("doubleProperty");
        this.prop.getDouble();
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotProvideLongForMultiValuedProperty() throws Exception {
        this.prop = this.cars.getProperty("longProperty");
        this.prop.getLong();
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotProvideStreamForMultiValuedProperty() throws Exception {
        this.prop = this.cars.getProperty("binaryProperty");
        this.prop.getStream();
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotProvideStringForMultiValuedProperty() throws Exception {
        this.prop = this.cars.getProperty("stringProperty");
        this.prop.getString();
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotProvideValue() throws Exception {
        this.prop = this.cars.getProperty("stringProperty");
        this.prop.getValue();
    }

    @Test
    public void shouldProvideValues() throws Exception {
        this.prop = this.cars.getProperty("booleanProperty");
        Value[] vals = this.prop.getValues();
        Assert.assertThat((Object)vals, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)vals.length, (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)vals[0].getBoolean(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)vals[1].getBoolean(), (Matcher)Is.is((Object)false));
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotProvideLength() throws Exception {
        this.prop = this.cars.getProperty("stringProperty");
        this.prop.getLength();
    }
}

