/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.nodetype.PropertyDefinition;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.modeshape.graph.property.DateTime;
import org.modeshape.graph.property.ValueFactory;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.AbstractJcrTest;
import org.modeshape.jcr.JcrNodeTypeTemplate;
import org.modeshape.jcr.JcrPropertyDefinitionTemplate;

public class JcrSingleValuePropertyTest
extends AbstractJcrTest {
    private Property prop;
    private byte[] binaryValue;
    private DateTime dateValue;
    private double doubleValue;
    private long longValue;
    private String stringValue;
    private boolean booleanValue;
    private String nameValue;
    private String pathValue;
    private ValueFactory<String> stringFactory;
    protected AbstractJcrNode cars;
    protected AbstractJcrNode altima;

    @BeforeClass
    public static void beforeAll() throws Exception {
        AbstractJcrTest.beforeAll();
        JcrNodeTypeTemplate nodeType = new JcrNodeTypeTemplate(context);
        nodeType.setMixin(true);
        nodeType.setName("mixinWithAllPropTypes");
        List propDefns = nodeType.getPropertyDefinitionTemplates();
        JcrPropertyDefinitionTemplate binaryDefn = new JcrPropertyDefinitionTemplate(context);
        binaryDefn.setName("binaryProperty");
        binaryDefn.setRequiredType(2);
        propDefns.add(binaryDefn);
        JcrPropertyDefinitionTemplate booleanDefn = new JcrPropertyDefinitionTemplate(context);
        booleanDefn.setName("booleanProperty");
        booleanDefn.setRequiredType(6);
        propDefns.add(booleanDefn);
        JcrPropertyDefinitionTemplate dateDefn = new JcrPropertyDefinitionTemplate(context);
        dateDefn.setName("dateProperty");
        dateDefn.setRequiredType(5);
        propDefns.add(dateDefn);
        JcrPropertyDefinitionTemplate doubleDefn = new JcrPropertyDefinitionTemplate(context);
        doubleDefn.setName("doubleProperty");
        doubleDefn.setRequiredType(4);
        propDefns.add(doubleDefn);
        JcrPropertyDefinitionTemplate longDefn = new JcrPropertyDefinitionTemplate(context);
        longDefn.setName("longProperty");
        longDefn.setRequiredType(3);
        propDefns.add(longDefn);
        JcrPropertyDefinitionTemplate nameDefn = new JcrPropertyDefinitionTemplate(context);
        nameDefn.setName("nameProperty");
        nameDefn.setRequiredType(7);
        propDefns.add(nameDefn);
        JcrPropertyDefinitionTemplate pathDefn = new JcrPropertyDefinitionTemplate(context);
        pathDefn.setName("pathProperty");
        pathDefn.setRequiredType(8);
        propDefns.add(pathDefn);
        JcrPropertyDefinitionTemplate refDefn = new JcrPropertyDefinitionTemplate(context);
        refDefn.setName("referenceProperty");
        refDefn.setRequiredType(9);
        propDefns.add(refDefn);
        JcrPropertyDefinitionTemplate stringDefn = new JcrPropertyDefinitionTemplate(context);
        stringDefn.setName("stringProperty");
        stringDefn.setRequiredType(1);
        propDefns.add(stringDefn);
        JcrPropertyDefinitionTemplate undefinedDefn = new JcrPropertyDefinitionTemplate(context);
        undefinedDefn.setName("undefinedProperty");
        undefinedDefn.setRequiredType(0);
        propDefns.add(undefinedDefn);
        ArrayList<JcrNodeTypeTemplate> defns = new ArrayList<JcrNodeTypeTemplate>();
        defns.add(nodeType);
        rntm.registerNodeTypes(defns, false);
    }

    @Override
    @Before
    public void beforeEach() throws Exception {
        super.beforeEach();
        context.getNamespaceRegistry().register("acme", "http://example.com");
        this.stringFactory = context.getValueFactories().getStringFactory();
        this.binaryValue = "This is a binary value".getBytes();
        this.dateValue = context.getValueFactories().getDateFactory().create();
        this.doubleValue = 3.14159;
        this.longValue = 100L;
        this.booleanValue = true;
        this.stringValue = "stringValue";
        this.nameValue = "acme:SomeName";
        this.pathValue = "/Cars/Hybrid/Toyota Highlander/acme:SomethingElse";
        this.cars = this.cache.findJcrNode(null, this.path("/Cars"));
        this.cars.addMixin("mixinWithAllPropTypes");
        this.altima = this.cache.findJcrNode(null, this.path("/Cars/Hybrid/Nissan Altima"));
        this.altima.addMixin("mix:referenceable");
        this.cars.setProperty("booleanProperty", this.booleanValue);
        this.cars.setProperty("dateProperty", this.dateValue.toCalendar());
        this.cars.setProperty("doubleProperty", this.doubleValue);
        this.cars.setProperty("binaryProperty", (InputStream)new ByteArrayInputStream(this.binaryValue));
        this.cars.setProperty("longProperty", this.longValue);
        this.cars.setProperty("referenceProperty", (Node)this.altima);
        this.cars.setProperty("stringProperty", this.stringValue);
        this.cars.setProperty("pathProperty", this.pathValue);
        this.cars.setProperty("nameProperty", this.nameValue);
        this.cars.setProperty("undefinedProperty", "100");
    }

    @Test
    public void shouldIndicateHasSingleValue() throws Exception {
        this.prop = this.cars.getProperty("booleanProperty");
        PropertyDefinition def = this.prop.getDefinition();
        Assert.assertThat((Object)def.isMultiple(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldProvideBoolean() throws Exception {
        this.prop = this.cars.getProperty("booleanProperty");
        Assert.assertThat((Object)this.prop.getBoolean(), (Matcher)Is.is((Object)this.booleanValue));
        Assert.assertThat((Object)this.prop.getType(), (Matcher)Is.is((Object)6));
        Assert.assertThat((Object)this.prop.getString(), (Matcher)Is.is((Object)this.stringFactory.create(this.booleanValue)));
        Assert.assertThat((Object)this.prop.getLength(), (Matcher)Is.is((Object)((String)this.stringFactory.create(this.booleanValue)).length()));
        this.checkValue(this.prop);
    }

    @Test
    public void shouldProvideDate() throws Exception {
        this.prop = this.cars.getProperty("dateProperty");
        Assert.assertThat((Object)this.prop.getLong(), (Matcher)Is.is((Object)this.dateValue.getMilliseconds()));
        Assert.assertThat((Object)this.prop.getType(), (Matcher)Is.is((Object)5));
        this.checkValue(this.prop);
    }

    @Test
    public void shouldProvideNode() throws Exception {
        this.prop = this.cars.getProperty("referenceProperty");
        Assert.assertThat((Object)this.prop.getNode(), (Matcher)Is.is((Object)this.altima));
        Assert.assertThat((Object)this.prop.getType(), (Matcher)Is.is((Object)9));
        Assert.assertThat((Object)this.prop.getString(), (Matcher)Is.is((Object)this.altima.getUUID()));
        Assert.assertThat((Object)this.prop.getLength(), (Matcher)Is.is((Object)this.altima.getUUID().length()));
        this.checkValue(this.prop);
    }

    @Test
    public void shouldProvideDouble() throws Exception {
        this.prop = this.cars.getProperty("doubleProperty");
        Assert.assertThat((Object)this.prop.getDouble(), (Matcher)Is.is((Object)this.doubleValue));
        Assert.assertThat((Object)this.prop.getString(), (Matcher)Is.is((Object)this.stringFactory.create(this.doubleValue)));
        Assert.assertThat((Object)this.prop.getType(), (Matcher)Is.is((Object)4));
        Assert.assertThat((Object)this.prop.getLength(), (Matcher)Is.is((Object)((String)this.stringFactory.create(this.doubleValue)).length()));
        this.checkValue(this.prop);
    }

    @Test
    public void shouldProvideLong() throws Exception {
        this.prop = this.cars.getProperty("longProperty");
        Assert.assertThat((Object)this.prop.getLong(), (Matcher)Is.is((Object)this.longValue));
        Assert.assertThat((Object)this.prop.getString(), (Matcher)Is.is((Object)this.stringFactory.create(this.longValue)));
        Assert.assertThat((Object)this.prop.getType(), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)this.prop.getLength(), (Matcher)Is.is((Object)((String)this.stringFactory.create(this.longValue)).length()));
        this.checkValue(this.prop);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldProvideStream() throws Exception {
        this.prop = this.cars.getProperty("binaryProperty");
        Assert.assertThat((Object)this.prop.getType(), (Matcher)Is.is((Object)2));
        InputStream stream = this.prop.getStream();
        try {
            Assert.assertThat((Object)stream, (Matcher)IsNull.notNullValue());
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
        Assert.assertThat((Object)this.prop.getString(), (Matcher)Is.is((Object)this.stringFactory.create(this.binaryValue)));
        Assert.assertThat((Object)this.prop.getLength(), (Matcher)Is.is((Object)this.binaryValue.length));
        this.checkValue(this.prop);
    }

    @Test
    public void shouldProvideString() throws Exception {
        this.prop = this.cars.getProperty("stringProperty");
        Assert.assertThat((Object)this.prop.getString(), (Matcher)Is.is((Object)this.stringValue));
        Assert.assertThat((Object)this.prop.getType(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)this.prop.getLength(), (Matcher)Is.is((Object)this.stringValue.length()));
        this.checkValue(this.prop);
    }

    @Test
    public void shouldAllowNameValue() throws Exception {
        this.prop = this.cars.getProperty("nameProperty");
        Assert.assertThat((Object)this.prop.getType(), (Matcher)Is.is((Object)7));
        Assert.assertThat((Object)this.prop.getString(), (Matcher)Is.is((Object)this.nameValue));
        Assert.assertThat((Object)this.prop.getLength(), (Matcher)Is.is((Object)this.nameValue.length()));
        context.getNamespaceRegistry().register("acme2", "http://example.com");
        Assert.assertThat((Object)this.prop.getString(), (Matcher)Is.is((Object)"acme2:SomeName"));
        this.checkValue(this.prop);
    }

    @Test
    public void shouldAllowPathValue() throws Exception {
        this.prop = this.cars.getProperty("pathProperty");
        Assert.assertThat((Object)this.prop.getType(), (Matcher)Is.is((Object)8));
        Assert.assertThat((Object)this.prop.getString(), (Matcher)Is.is((Object)this.pathValue));
        context.getNamespaceRegistry().register("acme2", "http://example.com");
        Assert.assertThat((Object)this.prop.getString(), (Matcher)Is.is((Object)"/Cars/Hybrid/Toyota Highlander/acme2:SomethingElse"));
        this.checkValue(this.prop);
    }

    public void checkValue(Property prop) throws Exception {
        Value val = prop.getValue();
        Assert.assertThat((Object)val, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)prop.getDefinition(), (Matcher)IsNull.notNullValue());
        try {
            prop.getValues();
            Assert.fail((String)"Should not be able to call 'getValues()' on a single-value property");
        }
        catch (ValueFormatException e) {
            // empty catch block
        }
        try {
            prop.getLengths();
            Assert.fail((String)"Should not be able to call 'getValues()' on a single-value property");
        }
        catch (ValueFormatException valueFormatException) {
            // empty catch block
        }
    }
}

