/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;
import javax.jcr.ValueFormatException;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.ValueFactories;
import org.modeshape.graph.property.basic.StandardValueFactories;
import org.modeshape.jcr.JcrValue;
import org.modeshape.jcr.SessionCache;

public class JcrValueTest {
    private ValueFactories factories;
    private JcrValue value;
    @Mock
    private SessionCache cache;

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)this);
        this.factories = new StandardValueFactories((NamespaceRegistry)Mockito.mock(NamespaceRegistry.class));
        this.value = new JcrValue(this.factories, this.cache, 6, (Object)true);
    }

    @Test
    public void shouldProvideType() throws Exception {
        Assert.assertThat((Object)this.value.getType(), (Matcher)Is.is((Object)6));
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotAllowConsumingInputStreamAfterConsumingNonInputStream() throws Exception {
        this.value.getBoolean();
        this.value.getStream();
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotAllowConsumingNonInputStreamAfterConsumingInputStream() throws Exception {
        this.value.getBoolean();
        this.value.getStream();
    }

    @Test
    public void shouldProvideBooleanForBoolean() throws Exception {
        Assert.assertThat((Object)this.value.getBoolean(), (Matcher)Is.is((Object)true));
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotProvideDateForBoolean() throws Exception {
        this.value.getDate();
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotProvideDoubleForBoolean() throws Exception {
        this.value.getDouble();
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotProvideLongForBoolean() throws Exception {
        this.value.getLong();
    }

    @Test
    public void shouldProvideStreamForBoolean() throws Exception {
        this.testProvidesStream(this.value);
    }

    @Test
    public void shouldProvideStringForBoolean() throws Exception {
        Assert.assertThat((Object)this.value.getString(), (Matcher)Is.is((Object)"true"));
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotProvideBooleanForDate() throws Exception {
        new JcrValue(this.factories, this.cache, 5, (Object)new Date()).getBoolean();
    }

    @Test
    public void shouldProvideDateForDate() throws Exception {
        Date date = new Date();
        Assert.assertThat((Object)new JcrValue(this.factories, this.cache, 5, (Object)date).getDate().getTime(), (Matcher)Is.is((Object)date));
    }

    @Test
    public void shouldProvideDoubleForDate() throws Exception {
        Date date = new Date();
        Assert.assertThat((Object)new JcrValue(this.factories, this.cache, 5, (Object)date).getDouble(), (Matcher)Is.is((Object)date.getTime()));
    }

    @Test
    public void shouldProvideLongForDate() throws Exception {
        Date date = new Date();
        Assert.assertThat((Object)new JcrValue(this.factories, this.cache, 5, (Object)date).getLong(), (Matcher)Is.is((Object)date.getTime()));
    }

    @Test
    public void shouldProvideStreamForDate() throws Exception {
        this.testProvidesStream(new JcrValue(this.factories, this.cache, 5, (Object)new Date()));
    }

    @Test
    public void shouldProvideStringForDate() throws Exception {
        Calendar date = Calendar.getInstance();
        date.set(2008, 7, 18, 12, 0, 0);
        date.set(14, 0);
        String expectedValue = "2008-08-18T12:00:00.000";
        Assert.assertThat((Object)new JcrValue(this.factories, this.cache, 5, (Object)date).getString().substring(0, expectedValue.length()), (Matcher)Is.is((Object)expectedValue));
        Assert.assertThat((Object)new JcrValue(this.factories, this.cache, 5, (Object)date.getTime()).getString().substring(0, expectedValue.length()), (Matcher)Is.is((Object)expectedValue));
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotProvideBooleanForDouble() throws Exception {
        new JcrValue(this.factories, this.cache, 4, (Object)0.0).getBoolean();
    }

    @Test
    public void shouldProvideDateForDouble() throws Exception {
        Calendar expectedValue = Calendar.getInstance();
        expectedValue.setTime(new Date(0L));
        Assert.assertThat((Object)new JcrValue(this.factories, this.cache, 4, (Object)0.0).getDate().getTimeInMillis(), (Matcher)Is.is((Object)expectedValue.getTimeInMillis()));
    }

    @Test
    public void shouldProvideDoubleForDouble() throws Exception {
        Assert.assertThat((Object)new JcrValue(this.factories, this.cache, 4, (Object)1.2).getDouble(), (Matcher)Is.is((Object)1.2));
    }

    @Test
    public void shouldProvideLongForDouble() throws Exception {
        Assert.assertThat((Object)new JcrValue(this.factories, this.cache, 4, (Object)1.0).getLong(), (Matcher)Is.is((Object)1L));
        Assert.assertThat((Object)new JcrValue(this.factories, this.cache, 4, (Object)Double.MAX_VALUE).getLong(), (Matcher)Is.is((Object)Long.MAX_VALUE));
    }

    @Test
    public void shouldProvideStreamForDouble() throws Exception {
        this.testProvidesStream(new JcrValue(this.factories, this.cache, 4, (Object)1.0));
    }

    @Test
    public void shouldProvideStringForDouble() throws Exception {
        Assert.assertThat((Object)new JcrValue(this.factories, this.cache, 4, (Object)1.0).getString(), (Matcher)Is.is((Object)"1.0"));
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotProvideBooleanForLong() throws Exception {
        new JcrValue(this.factories, this.cache, 3, (Object)0L).getBoolean();
    }

    @Test
    public void shouldProvideDateForLong() throws Exception {
        Calendar expectedValue = Calendar.getInstance();
        expectedValue.setTime(new Date(0L));
        Assert.assertThat((Object)new JcrValue(this.factories, this.cache, 3, (Object)0L).getDate().getTimeInMillis(), (Matcher)Is.is((Object)expectedValue.getTimeInMillis()));
    }

    @Test
    public void shouldProvideDoubleForLong() throws Exception {
        Assert.assertThat((Object)new JcrValue(this.factories, this.cache, 3, (Object)1L).getDouble(), (Matcher)Is.is((Object)1.0));
    }

    @Test
    public void shouldProvideLongForLong() throws Exception {
        Assert.assertThat((Object)new JcrValue(this.factories, this.cache, 3, (Object)1L).getLong(), (Matcher)Is.is((Object)1L));
    }

    @Test
    public void shouldProvideStreamForLong() throws Exception {
        this.testProvidesStream(new JcrValue(this.factories, this.cache, 3, (Object)1L));
    }

    @Test
    public void shouldProvideStringForLong() throws Exception {
        Assert.assertThat((Object)new JcrValue(this.factories, this.cache, 3, (Object)1L).getString(), (Matcher)Is.is((Object)"1"));
    }

    @Test
    public void shouldProvideBooleanForString() throws Exception {
        Assert.assertThat((Object)new JcrValue(this.factories, this.cache, 1, (Object)"true").getBoolean(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)new JcrValue(this.factories, this.cache, 1, (Object)"yes").getBoolean(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldProvideDateForString() throws Exception {
        Assert.assertThat((Object)new JcrValue(this.factories, this.cache, 1, (Object)"2008").getDate(), (Matcher)IsNull.notNullValue());
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotProvideDateForInvalidString() throws Exception {
        new JcrValue(this.factories, this.cache, 1, (Object)"true").getDate();
    }

    @Test
    public void shouldProvideDoubleForString() throws Exception {
        Assert.assertThat((Object)new JcrValue(this.factories, this.cache, 1, (Object)"1").getDouble(), (Matcher)Is.is((Object)1.0));
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotProvideDoubleForInvalidString() throws Exception {
        new JcrValue(this.factories, this.cache, 1, (Object)"true").getDouble();
    }

    @Test
    public void shouldProvideLongForString() throws Exception {
        Assert.assertThat((Object)new JcrValue(this.factories, this.cache, 1, (Object)"1").getLong(), (Matcher)Is.is((Object)1L));
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotProvideLongForInvalidString() throws Exception {
        new JcrValue(this.factories, this.cache, 1, (Object)"true").getLong();
    }

    @Test
    public void shouldProvideStreamForString() throws Exception {
        this.testProvidesStream(new JcrValue(this.factories, this.cache, 1, (Object)"true"));
    }

    @Test
    public void shouldProvideStringForString() throws Exception {
        Assert.assertThat((Object)new JcrValue(this.factories, this.cache, 1, (Object)"true").getString(), (Matcher)Is.is((Object)"true"));
    }

    @Test
    public void shouldProvideBooleanForUuid() throws Exception {
        Assert.assertThat((Object)new JcrValue(this.factories, this.cache, 1, (Object)UUID.randomUUID()).getBoolean(), (Matcher)Is.is((Object)false));
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotProvideDateForUuid() throws Exception {
        new JcrValue(this.factories, this.cache, 1, (Object)UUID.randomUUID()).getDate();
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotProvideDoubleForUuid() throws Exception {
        new JcrValue(this.factories, this.cache, 1, (Object)UUID.randomUUID()).getDouble();
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotProvideLongForUuid() throws Exception {
        new JcrValue(this.factories, this.cache, 1, (Object)UUID.randomUUID()).getLong();
    }

    @Test
    public void shouldProvideStreamForUuid() throws Exception {
        this.testProvidesStream(new JcrValue(this.factories, this.cache, 1, (Object)UUID.randomUUID()));
    }

    @Test
    public void shouldProvideStringForUuid() throws Exception {
        String expectedValue = "40d373f7-75ad-4d84-900e-c72ebd98abb9";
        Assert.assertThat((Object)new JcrValue(this.factories, this.cache, 1, (Object)UUID.fromString(expectedValue)).getString(), (Matcher)Is.is((Object)expectedValue));
    }

    @Test
    public void shouldProvideLength() throws Exception {
        Assert.assertThat((Object)new JcrValue(this.factories, this.cache, 1, (Object)"test").getLength(), (Matcher)Is.is((Object)4L));
        Assert.assertThat((Object)new JcrValue(this.factories, this.cache, 2, (Object)"test").getLength(), (Matcher)Is.is((Object)4L));
    }

    private void testProvidesStream(JcrValue value) throws Exception {
        InputStream stream = value.getStream();
        Assert.assertThat((Object)stream, (Matcher)IsNull.notNullValue());
        stream.close();
    }
}

