/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashSet;
import net.jcip.annotations.Immutable;
import org.modeshape.graph.property.Name;
import org.modeshape.jcr.JcrNodeDefinition;
import org.modeshape.jcr.JcrNodeType;
import org.modeshape.jcr.JcrPropertyDefinition;

@Immutable
final class DefinitionCache {
    private final Multimap<Name, JcrNodeDefinition> childNodeDefinitionsThatAllowSns = LinkedListMultimap.create();
    private final Multimap<Name, JcrNodeDefinition> childNodeDefinitionsThatAllowNoSns = LinkedListMultimap.create();
    private final Multimap<Name, JcrPropertyDefinition> multiValuedPropertyDefinitions = LinkedListMultimap.create();
    private final Multimap<Name, JcrPropertyDefinition> singleValuedPropertyDefinitions = LinkedListMultimap.create();
    private final Multimap<Name, JcrNodeDefinition> allChildNodeDefinitions = LinkedListMultimap.create();
    private final Multimap<Name, JcrPropertyDefinition> allPropertyDefinitions = LinkedListMultimap.create();

    DefinitionCache(JcrNodeType nodeType) {
        this.addDefinitionsForTypeAndAllSupertypes(nodeType);
    }

    DefinitionCache(JcrNodeType primaryType, Iterable<JcrNodeType> mixinTypes) {
        this.addDefinitionsForTypeAndAllSupertypes(primaryType);
        if (mixinTypes != null) {
            for (JcrNodeType mixinType : mixinTypes) {
                this.addDefinitionsForTypeAndAllSupertypes(mixinType);
            }
        }
    }

    private final void addDefinitionsForTypeAndAllSupertypes(JcrNodeType nodeType) {
        for (JcrNodeType superSuperType : nodeType.getTypeAndSupertypes()) {
            this.addDefinitions(superSuperType);
        }
    }

    private final void addDefinitions(JcrNodeType nodeType) {
        Name name;
        HashSet<Name> namesFromThisType = new HashSet<Name>();
        for (JcrNodeDefinition jcrNodeDefinition : nodeType.childNodeDefinitions()) {
            name = jcrNodeDefinition.getInternalName();
            if (this.allChildNodeDefinitions.containsKey((Object)name) && !namesFromThisType.contains(name)) continue;
            if (jcrNodeDefinition.allowsSameNameSiblings()) {
                this.childNodeDefinitionsThatAllowSns.put((Object)name, (Object)jcrNodeDefinition);
            } else {
                this.childNodeDefinitionsThatAllowNoSns.put((Object)name, (Object)jcrNodeDefinition);
            }
            this.allChildNodeDefinitions.put((Object)name, (Object)jcrNodeDefinition);
            namesFromThisType.add(name);
        }
        namesFromThisType.clear();
        for (JcrPropertyDefinition jcrPropertyDefinition : nodeType.propertyDefinitions()) {
            name = jcrPropertyDefinition.getInternalName();
            if (this.allPropertyDefinitions.containsKey((Object)name) && !namesFromThisType.contains(name)) continue;
            if (jcrPropertyDefinition.isMultiple()) {
                this.multiValuedPropertyDefinitions.put((Object)name, (Object)jcrPropertyDefinition);
            } else {
                this.singleValuedPropertyDefinitions.put((Object)name, (Object)jcrPropertyDefinition);
            }
            namesFromThisType.add(name);
            this.allPropertyDefinitions.put((Object)name, (Object)jcrPropertyDefinition);
        }
    }

    public Collection<JcrPropertyDefinition> allSingleValuePropertyDefinitions(Name propertyName) {
        return this.singleValuedPropertyDefinitions.get((Object)propertyName);
    }

    public Collection<JcrPropertyDefinition> allMultiValuePropertyDefinitions(Name propertyName) {
        return this.multiValuedPropertyDefinitions.get((Object)propertyName);
    }

    public Collection<JcrPropertyDefinition> allPropertyDefinitions(Name propertyName) {
        return this.allPropertyDefinitions.get((Object)propertyName);
    }

    public Collection<JcrPropertyDefinition> allPropertyDefinitions() {
        return this.allPropertyDefinitions.values();
    }

    public Collection<JcrNodeDefinition> allChildNodeDefinitionsWithNoSns(Name childName) {
        return this.childNodeDefinitionsThatAllowNoSns.get((Object)childName);
    }

    public Collection<JcrNodeDefinition> allChildNodeDefinitionsWithSns(Name childName) {
        return this.childNodeDefinitionsThatAllowSns.get((Object)childName);
    }

    public Collection<JcrNodeDefinition> allChildNodeDefinitions(Name childName) {
        return this.allChildNodeDefinitions.get((Object)childName);
    }

    public Collection<JcrNodeDefinition> allChildNodeDefinitions(Name childName, boolean requireSns) {
        if (requireSns) {
            return this.childNodeDefinitionsThatAllowSns.get((Object)childName);
        }
        return this.allChildNodeDefinitions.get((Object)childName);
    }

    public Collection<JcrNodeDefinition> allChildNodeDefinitions() {
        return this.allChildNodeDefinitions.values();
    }
}

