/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.UUID;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.PathNotFoundException;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.ValueFormatException;
import javax.jcr.nodetype.ConstraintViolationException;
import net.jcip.annotations.NotThreadSafe;
import org.modeshape.common.text.TextDecoder;
import org.modeshape.common.text.XmlNameEncoder;
import org.modeshape.common.util.Base64;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Location;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NameFactory;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Path;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.JcrDocumentViewExporter;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.JcrNode;
import org.modeshape.jcr.JcrNodeType;
import org.modeshape.jcr.JcrNodeTypeManager;
import org.modeshape.jcr.JcrNtLexicon;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.JcrSvLexicon;
import org.modeshape.jcr.JcrValue;
import org.modeshape.jcr.SessionCache;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@NotThreadSafe
class JcrContentHandler
extends DefaultHandler {
    protected static final TextDecoder SYSTEM_VIEW_NAME_DECODER = new XmlNameEncoder();
    protected static final TextDecoder DOCUMENT_VIEW_NAME_DECODER = new JcrDocumentViewExporter.JcrDocumentViewPropertyEncoder();
    private final NameFactory nameFactory;
    private final NamespaceRegistry namespaces;
    private final ValueFactory jcrValueFactory;
    private final JcrNodeTypeManager nodeTypes;
    private final javax.jcr.NamespaceRegistry jcrNamespaceRegistry;
    private final SaveMode saveMode;
    protected final int uuidBehavior;
    protected final String primaryTypeName;
    protected final String mixinTypesName;
    protected final String uuidName;
    private AbstractJcrNode currentNode;
    private ContentHandler delegate;
    private SessionCache cache;

    JcrContentHandler(JcrSession session, Path parentPath, int uuidBehavior, SaveMode saveMode) throws PathNotFoundException, RepositoryException {
        assert (session != null);
        assert (parentPath != null);
        assert (uuidBehavior == 0 || uuidBehavior == 1 || uuidBehavior == 2 || uuidBehavior == 3);
        ExecutionContext context = session.getExecutionContext();
        this.namespaces = context.getNamespaceRegistry();
        this.nameFactory = context.getValueFactories().getNameFactory();
        this.uuidBehavior = uuidBehavior;
        this.saveMode = saveMode;
        switch (this.saveMode) {
            case SESSION: {
                this.cache = session.cache();
                break;
            }
            case WORKSPACE: {
                this.cache = new SessionCache(session);
            }
        }
        assert (this.cache != null);
        try {
            this.currentNode = this.cache.findJcrNode(null, parentPath);
        }
        catch (ItemNotFoundException e) {
            throw new PathNotFoundException(e.getLocalizedMessage(), (Throwable)e);
        }
        this.jcrValueFactory = session.getValueFactory();
        this.nodeTypes = session.nodeTypeManager();
        this.jcrNamespaceRegistry = session.workspace().getNamespaceRegistry();
        this.primaryTypeName = JcrLexicon.PRIMARY_TYPE.getString(this.namespaces);
        this.mixinTypesName = JcrLexicon.MIXIN_TYPES.getString(this.namespaces);
        this.uuidName = JcrLexicon.UUID.getString(this.namespaces);
    }

    protected final NamespaceRegistry namespaces() {
        return this.namespaces;
    }

    protected final JcrNodeTypeManager nodeTypes() {
        return this.nodeTypes;
    }

    protected final JcrNodeType nodeTypeFor(String name) {
        return this.nodeTypes.getNodeType(this.nameFor(name));
    }

    protected final Name nameFor(String name) {
        return (Name)this.nameFactory.create(name);
    }

    protected final Value valueFor(String value, int type) throws ValueFormatException {
        return this.jcrValueFactory.createValue(value, type);
    }

    protected final Value valueFor(InputStream stream) {
        return this.jcrValueFactory.createValue(stream);
    }

    protected final SessionCache cache() {
        return this.cache;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        assert (this.delegate != null);
        this.delegate.characters(ch, start, length);
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.saveMode == SaveMode.WORKSPACE) {
            try {
                this.cache.save();
            }
            catch (RepositoryException e) {
                throw new EnclosingSAXException((Exception)((Object)e));
            }
        }
        super.endDocument();
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        assert (this.delegate != null);
        this.delegate.endElement(uri, localName, name);
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        this.checkDelegate(uri);
        assert (this.delegate != null);
        this.delegate.startElement(uri, localName, name, atts);
    }

    private void checkDelegate(String namespaceUri) {
        if (this.delegate != null) {
            return;
        }
        this.delegate = "http://www.jcp.org/jcr/sv/1.0".equals(namespaceUri) ? new SystemViewContentHandler(this.currentNode) : new DocumentViewContentHandler(this.currentNode);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        try {
            String existingUri = this.namespaces.getNamespaceForPrefix(prefix);
            if (existingUri != null) {
                if (existingUri.equals(uri)) {
                    return;
                }
                throw new RepositoryException("Prefix " + prefix + " is already permanently mapped");
            }
            this.jcrNamespaceRegistry.registerNamespace(prefix, uri);
        }
        catch (RepositoryException re) {
            throw new EnclosingSAXException((Exception)((Object)re));
        }
    }

    private class DocumentViewContentHandler
    extends DefaultHandler {
        private final Stack<AbstractJcrNode> parentStack = new Stack();

        DocumentViewContentHandler(AbstractJcrNode currentNode) {
            this.parentStack.push(currentNode);
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
            try {
                String primaryTypeName = atts.getValue(JcrContentHandler.this.primaryTypeName);
                String rawUuid = atts.getValue(JcrContentHandler.this.uuidName);
                UUID uuid = rawUuid != null ? UUID.fromString(rawUuid) : null;
                AbstractJcrNode parentNode = this.parentStack.peek();
                if (uuid != null) {
                    try {
                        AbstractJcrNode existingNodeWithUuid = JcrContentHandler.this.cache().findJcrNode(Location.create((UUID)uuid));
                        switch (JcrContentHandler.this.uuidBehavior) {
                            case 2: {
                                parentNode = existingNodeWithUuid.getParent();
                                existingNodeWithUuid.remove();
                                break;
                            }
                            case 0: {
                                uuid = UUID.randomUUID();
                                break;
                            }
                            case 1: {
                                if (existingNodeWithUuid.path().isAtOrAbove(((AbstractJcrNode)this.parentStack.firstElement()).path())) {
                                    throw new ConstraintViolationException();
                                }
                                existingNodeWithUuid.remove();
                                break;
                            }
                            case 3: {
                                throw new ItemExistsException();
                            }
                        }
                    }
                    catch (ItemNotFoundException e) {
                        // empty catch block
                    }
                }
                name = DOCUMENT_VIEW_NAME_DECODER.decode(name);
                JcrNode currentNode = parentNode.editor().createChild(JcrContentHandler.this.nameFor(name), uuid, JcrContentHandler.this.nameFor(primaryTypeName));
                SessionCache.NodeEditor currentNodeEditor = currentNode.editor();
                for (int i = 0; i < atts.getLength(); ++i) {
                    if (JcrContentHandler.this.primaryTypeName.equals(atts.getQName(i))) continue;
                    if (JcrContentHandler.this.mixinTypesName.equals(atts.getQName(i))) {
                        JcrNodeType mixinType = JcrContentHandler.this.nodeTypeFor(atts.getValue(i));
                        currentNodeEditor.addMixin(mixinType);
                        continue;
                    }
                    if (JcrContentHandler.this.uuidName.equals(atts.getQName(i))) continue;
                    String value = atts.getValue(i);
                    String propertyName = DOCUMENT_VIEW_NAME_DECODER.decode(atts.getQName(i));
                    currentNodeEditor.setProperty(JcrContentHandler.this.nameFor(propertyName), (JcrValue)JcrContentHandler.this.valueFor(value, 1));
                }
                this.parentStack.push(currentNode);
            }
            catch (RepositoryException re) {
                throw new EnclosingSAXException((Exception)((Object)re));
            }
        }

        @Override
        public void endElement(String uri, String localName, String name) {
            this.parentStack.pop();
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            try {
                AbstractJcrNode parentNode = this.parentStack.peek();
                JcrNode currentNode = parentNode.editor().createChild(JcrLexicon.XMLTEXT, null, JcrNtLexicon.UNSTRUCTURED);
                String s = new String(ch, start, length);
                currentNode.editor().setProperty(JcrLexicon.XMLCHARACTERS, (JcrValue)JcrContentHandler.this.valueFor(s, 1));
            }
            catch (RepositoryException re) {
                throw new EnclosingSAXException((Exception)((Object)re));
            }
        }
    }

    private class SystemViewContentHandler
    extends DefaultHandler {
        private final Stack<AbstractJcrNode> parentStack = new Stack();
        private final String svNameName;
        private final String svTypeName;
        private String currentNodeName;
        private String currentPropName;
        private int currentPropType;
        private StringBuilder valueBuffer;
        private final Map<String, List<Value>> currentProps;

        SystemViewContentHandler(AbstractJcrNode currentNode) {
            this.parentStack.push(currentNode);
            this.currentProps = new HashMap<String, List<Value>>();
            this.svNameName = JcrSvLexicon.NAME.getString(JcrContentHandler.this.namespaces());
            this.svTypeName = JcrSvLexicon.TYPE.getString(JcrContentHandler.this.namespaces());
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
            this.valueBuffer = new StringBuilder();
            if ("node".equals(localName)) {
                if (this.currentNodeName != null) {
                    this.addNodeIfPending();
                }
                this.currentNodeName = atts.getValue(SYSTEM_VIEW_NAME_DECODER.decode(this.svNameName));
            } else if ("property".equals(localName)) {
                this.currentPropName = atts.getValue(SYSTEM_VIEW_NAME_DECODER.decode(this.svNameName));
                this.currentPropType = PropertyType.valueFromName((String)atts.getValue(this.svTypeName));
                this.currentProps.put(this.currentPropName, new ArrayList());
            } else if (!"value".equals(localName)) {
                throw new IllegalStateException("Unexpected element '" + name + "' in system view");
            }
        }

        private void addNodeIfPending() throws SAXException {
            if (this.currentNodeName != null) {
                try {
                    AbstractJcrNode parentNode = this.parentStack.peek();
                    UUID uuid = null;
                    List<Value> rawUuid = this.currentProps.get(JcrContentHandler.this.uuidName);
                    if (rawUuid != null) {
                        assert (rawUuid.size() == 1);
                        uuid = UUID.fromString(rawUuid.get(0).getString());
                        try {
                            AbstractJcrNode existingNodeWithUuid = JcrContentHandler.this.cache().findJcrNode(Location.create((UUID)uuid));
                            switch (JcrContentHandler.this.uuidBehavior) {
                                case 2: {
                                    parentNode = existingNodeWithUuid.getParent();
                                    existingNodeWithUuid.remove();
                                    break;
                                }
                                case 0: {
                                    uuid = UUID.randomUUID();
                                    break;
                                }
                                case 1: {
                                    if (existingNodeWithUuid.path().isAtOrAbove(((AbstractJcrNode)this.parentStack.firstElement()).path())) {
                                        throw new ConstraintViolationException(JcrI18n.cannotRemoveParentNodeOfTarget.text(new Object[]{existingNodeWithUuid.getPath(), uuid, ((AbstractJcrNode)this.parentStack.firstElement()).getPath()}));
                                    }
                                    existingNodeWithUuid.remove();
                                    break;
                                }
                                case 3: {
                                    throw new ItemExistsException(JcrI18n.itemAlreadyExistsWithUuid.text(new Object[]{uuid, JcrContentHandler.this.cache().session().workspace().getName(), existingNodeWithUuid.getPath()}));
                                }
                            }
                        }
                        catch (ItemNotFoundException e) {
                            // empty catch block
                        }
                    }
                    String typeName = this.currentProps.get(JcrContentHandler.this.primaryTypeName).get(0).getString();
                    JcrNode newNode = parentNode.editor().createChild(JcrContentHandler.this.nameFor(this.currentNodeName), uuid, JcrContentHandler.this.nameFor(typeName));
                    SessionCache.NodeEditor newNodeEditor = newNode.editor();
                    for (Map.Entry<String, List<Value>> entry : this.currentProps.entrySet()) {
                        if (entry.getKey().equals(JcrContentHandler.this.primaryTypeName)) continue;
                        if (entry.getKey().equals(JcrContentHandler.this.mixinTypesName)) {
                            for (Value value : entry.getValue()) {
                                JcrNodeType mixinType = JcrContentHandler.this.nodeTypeFor(value.getString());
                                newNodeEditor.addMixin(mixinType);
                            }
                            continue;
                        }
                        if (entry.getKey().equals(JcrContentHandler.this.uuidName)) continue;
                        List<Value> values = entry.getValue();
                        if (values.size() == 1) {
                            newNodeEditor.setProperty(JcrContentHandler.this.nameFor(entry.getKey()), (JcrValue)values.get(0));
                            continue;
                        }
                        newNodeEditor.setProperty(JcrContentHandler.this.nameFor(entry.getKey()), values.toArray(new Value[values.size()]), 0);
                    }
                    this.parentStack.push(newNode);
                    this.currentProps.clear();
                }
                catch (RepositoryException re) {
                    throw new EnclosingSAXException((Exception)((Object)re));
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            if ("node".equals(localName)) {
                this.addNodeIfPending();
                this.currentNodeName = null;
                this.parentStack.pop();
            } else if ("value".equals(localName)) {
                String s = this.valueBuffer.toString();
                try {
                    if (this.currentPropType == 2) {
                        ByteArrayInputStream is = new ByteArrayInputStream(Base64.decode((String)s, (int)16));
                        this.currentProps.get(this.currentPropName).add(JcrContentHandler.this.valueFor(is));
                    } else {
                        this.currentProps.get(this.currentPropName).add(JcrContentHandler.this.valueFor(SYSTEM_VIEW_NAME_DECODER.decode(s), this.currentPropType));
                    }
                }
                catch (RepositoryException re) {
                    throw new EnclosingSAXException((Exception)((Object)re));
                }
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.valueBuffer.append(ch, start, length);
        }
    }

    class EnclosingSAXException
    extends SAXException {
        private static final long serialVersionUID = -1044992767566435542L;

        EnclosingSAXException(Exception e) {
            super(e);
        }
    }

    static enum SaveMode {
        WORKSPACE,
        SESSION;

    }
}

