/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.NotThreadSafe;
import org.modeshape.common.collection.Problem;
import org.modeshape.common.collection.Problems;
import org.modeshape.common.text.ParsingException;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.StringUtil;
import org.modeshape.graph.Location;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.ValueFactories;
import org.modeshape.graph.query.QueryResults;
import org.modeshape.graph.query.model.QueryCommand;
import org.modeshape.graph.query.model.TypeSystem;
import org.modeshape.graph.query.model.Visitable;
import org.modeshape.graph.query.model.Visitors;
import org.modeshape.graph.query.parse.InvalidQueryException;
import org.modeshape.graph.query.parse.QueryParser;
import org.modeshape.graph.query.plan.PlanHints;
import org.modeshape.graph.query.validate.Schemata;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.JcrEmptyNodeIterator;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.JcrNodeType;
import org.modeshape.jcr.JcrNtLexicon;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.JcrValue;
import org.modeshape.jcr.SessionCache;

@Immutable
class JcrQueryManager
implements QueryManager {
    public static final int MAXIMUM_RESULTS_FOR_FULL_TEXT_SEARCH_QUERIES = Integer.MAX_VALUE;
    private final JcrSession session;
    protected static final String JCR_SCORE_COLUMN_NAME = "jcr:score";
    protected static final String JCR_PATH_COLUMN_NAME = "jcr:path";

    JcrQueryManager(JcrSession session) {
        this.session = session;
    }

    public Query createQuery(String statement, String language) throws javax.jcr.query.InvalidQueryException {
        CheckArg.isNotNull((Object)statement, (String)"statement");
        CheckArg.isNotNull((Object)language, (String)"language");
        return this.createQuery(statement, language, null);
    }

    public Query createQuery(String expression, String language, Path storedAtPath) throws javax.jcr.query.InvalidQueryException {
        QueryParser parser = this.session.repository().queryParsers().getParserFor(language);
        if (parser == null) {
            Set languages = this.session.repository().queryParsers().getLanguages();
            throw new javax.jcr.query.InvalidQueryException(JcrI18n.invalidQueryLanguage.text(new Object[]{language, languages}));
        }
        if (parser.getLanguage().equals("Search")) {
            return new JcrSearch(this.session, expression, parser.getLanguage(), storedAtPath);
        }
        TypeSystem typeSystem = this.session.executionContext.getValueFactories().getTypeSystem();
        try {
            QueryCommand command = parser.parseQuery(expression, typeSystem);
            if (command == null) {
                throw new javax.jcr.query.InvalidQueryException(JcrI18n.queryCannotBeParsedUsingLanguage.text(new Object[]{language, expression}));
            }
            PlanHints hints = new PlanHints();
            hints.showPlan = true;
            if ("xpath".equals(language)) {
                hints.hasFullTextSearch = true;
                hints.validateColumnExistance = false;
            }
            return new JcrQuery(this.session, expression, parser.getLanguage(), command, hints, storedAtPath);
        }
        catch (ParsingException e) {
            String reason = e.getMessage();
            throw new javax.jcr.query.InvalidQueryException(JcrI18n.queryCannotBeParsedUsingLanguage.text(new Object[]{language, expression, reason}));
        }
        catch (InvalidQueryException e) {
            String reason = e.getMessage();
            throw new javax.jcr.query.InvalidQueryException(JcrI18n.queryInLanguageIsNotValid.text(new Object[]{language, expression, reason}));
        }
    }

    public Query createQuery(QueryCommand command) throws javax.jcr.query.InvalidQueryException {
        if (command == null) {
            throw new javax.jcr.query.InvalidQueryException(JcrI18n.queryInLanguageIsNotValid.text(new Object[]{"JCR-SQL2", command}));
        }
        String expression = Visitors.readable((Visitable)command);
        try {
            PlanHints hints = new PlanHints();
            hints.showPlan = true;
            return new JcrQuery(this.session, expression, "JCR-SQL2", command, hints, null);
        }
        catch (InvalidQueryException e) {
            String reason = e.getMessage();
            throw new javax.jcr.query.InvalidQueryException(JcrI18n.queryInLanguageIsNotValid.text(new Object[]{"JCR-SQL2", expression, reason}));
        }
    }

    public Query getQuery(Node node) throws javax.jcr.query.InvalidQueryException, RepositoryException {
        AbstractJcrNode jcrNode = (AbstractJcrNode)CheckArg.getInstanceOf((Object)node, AbstractJcrNode.class, (String)"node");
        JcrNodeType nodeType = jcrNode.getPrimaryNodeType();
        if (!nodeType.getInternalName().equals(JcrNtLexicon.QUERY)) {
            NamespaceRegistry registry = this.session.getExecutionContext().getNamespaceRegistry();
            throw new javax.jcr.query.InvalidQueryException(JcrI18n.notStoredQuery.text(new Object[]{jcrNode.path().getString(registry)}));
        }
        String statement = jcrNode.getProperty(JcrLexicon.STATEMENT).getString();
        String language = jcrNode.getProperty(JcrLexicon.LANGUAGE).getString();
        return this.createQuery(statement, language, jcrNode.path());
    }

    public String[] getSupportedQueryLanguages() {
        Set languages = this.session.repository().queryParsers().getLanguages();
        return languages.toArray(new String[languages.size()]);
    }

    protected static class XPathQueryResultRow
    extends QueryResultRow {
        protected XPathQueryResultRow(XPathQueryResultRowIterator iterator, Node node, Object[] tuple) {
            super(iterator, node, tuple);
        }

        @Override
        public Value getValue(String columnName) throws ItemNotFoundException, RepositoryException {
            if (JcrQueryManager.JCR_PATH_COLUMN_NAME.equals(columnName)) {
                Location location = (Location)this.tuple[this.iterator.locationIndex];
                return ((XPathQueryResultRowIterator)this.iterator).jcrPath(location.getPath());
            }
            if (JcrQueryManager.JCR_SCORE_COLUMN_NAME.equals(columnName)) {
                Float score = (Float)this.tuple[this.iterator.scoreIndex];
                return ((XPathQueryResultRowIterator)this.iterator).jcrScore(score);
            }
            return super.getValue(columnName);
        }
    }

    protected static class XPathQueryResultRowIterator
    extends QueryResultRowIterator {
        private final ValueFactories factories;
        private final SessionCache cache;

        protected XPathQueryResultRowIterator(JcrSession session, QueryResults.Columns columns, Iterator<Object[]> tuples, long numRows) {
            super(session, columns, tuples, numRows);
            this.factories = session.executionContext.getValueFactories();
            this.cache = session.cache();
        }

        @Override
        protected Row createRow(Node node, Object[] tuple) {
            return new XPathQueryResultRow(this, node, tuple);
        }

        protected Value jcrPath(Path path) {
            return new JcrValue(this.factories, this.cache, 8, path);
        }

        protected Value jcrScore(Float score) {
            return new JcrValue(this.factories, this.cache, 4, score);
        }
    }

    protected static class XPathQueryResult
    extends JcrQueryResult {
        private final List<String> columnNames;

        protected XPathQueryResult(JcrSession session, QueryResults graphResults) {
            super(session, graphResults);
            LinkedList<String> columnNames = new LinkedList<String>(graphResults.getColumns().getColumnNames());
            if (graphResults.getColumns().hasFullTextSearchScores() && !columnNames.contains(JcrQueryManager.JCR_SCORE_COLUMN_NAME)) {
                columnNames.add(0, JcrQueryManager.JCR_SCORE_COLUMN_NAME);
            }
            columnNames.add(0, JcrQueryManager.JCR_PATH_COLUMN_NAME);
            this.columnNames = Collections.unmodifiableList(columnNames);
        }

        @Override
        public List<String> getColumnNameList() {
            return this.columnNames;
        }

        @Override
        public RowIterator getRows() {
            int numRows = this.results.getRowCount();
            List tuples = this.results.getTuples();
            return new XPathQueryResultRowIterator(this.session, this.results.getColumns(), tuples.iterator(), numRows);
        }
    }

    protected static class QueryResultRow
    implements Row {
        protected final QueryResultRowIterator iterator;
        protected final Node node;
        protected final Object[] tuple;
        private Value[] values = null;

        protected QueryResultRow(QueryResultRowIterator iterator, Node node, Object[] tuple) {
            this.iterator = iterator;
            this.node = node;
            this.tuple = tuple;
            assert (this.iterator != null);
            assert (this.node != null);
            assert (this.tuple != null);
        }

        public Value getValue(String columnName) throws ItemNotFoundException, RepositoryException {
            return this.node.getProperty(columnName).getValue();
        }

        public Value[] getValues() throws RepositoryException {
            if (this.values == null) {
                int i = 0;
                this.values = new Value[this.iterator.columnNames.size()];
                for (String columnName : this.iterator.columnNames) {
                    this.values[i++] = this.getValue(columnName);
                }
            }
            return this.values;
        }
    }

    @NotThreadSafe
    protected static class QueryResultRowIterator
    implements RowIterator {
        protected final List<String> columnNames;
        private final Iterator<Object[]> tuples;
        protected final int locationIndex;
        protected final int scoreIndex;
        protected final JcrSession session;
        private long position = 0L;
        private long numRows;
        private Row nextRow;

        protected QueryResultRowIterator(JcrSession session, QueryResults.Columns columns, Iterator<Object[]> tuples, long numRows) {
            this.tuples = tuples;
            this.columnNames = columns.getColumnNames();
            String selectorName = (String)columns.getSelectorNames().get(0);
            this.locationIndex = columns.getLocationIndex(selectorName);
            this.scoreIndex = columns.getFullTextSearchScoreIndexFor(selectorName);
            this.session = session;
            this.numRows = numRows;
        }

        public Row nextRow() {
            if (this.nextRow == null && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            assert (this.nextRow != null);
            Row result = this.nextRow;
            this.nextRow = null;
            return result;
        }

        protected Row createRow(Node node, Object[] tuple) {
            return new QueryResultRow(this, node, tuple);
        }

        public long getPosition() {
            return this.position;
        }

        public long getSize() {
            return this.numRows;
        }

        public void skip(long skipNum) {
            for (long i = 0L; i != skipNum; ++i) {
                this.tuples.next();
            }
            this.position += skipNum;
        }

        public boolean hasNext() {
            if (this.nextRow != null) {
                return true;
            }
            while (this.tuples.hasNext()) {
                Object[] tuple = this.tuples.next();
                ++this.position;
                try {
                    Location location = (Location)tuple[this.locationIndex];
                    if (!this.session.wasRemovedInSession(location)) {
                        AbstractJcrNode node = this.session.getNode(location.getPath());
                        this.nextRow = this.createRow(node, tuple);
                        return true;
                    }
                }
                catch (RepositoryException repositoryException) {
                    // empty catch block
                }
                --this.numRows;
            }
            return false;
        }

        public Object next() {
            return this.nextRow();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    @NotThreadSafe
    protected static class QueryResultNodeIterator
    implements NodeIterator {
        private final Iterator<? extends Node> nodes;
        private final int size;
        private long position = 0L;

        protected QueryResultNodeIterator(List<? extends Node> nodes) {
            this.nodes = nodes.iterator();
            this.size = nodes.size();
        }

        public Node nextNode() {
            Node node = this.nodes.next();
            ++this.position;
            return node;
        }

        public long getPosition() {
            return this.position;
        }

        public long getSize() {
            return this.size;
        }

        public void skip(long skipNum) {
            for (long i = 0L; i != skipNum; ++i) {
                this.nextNode();
            }
        }

        public boolean hasNext() {
            return this.nodes.hasNext();
        }

        public Object next() {
            return this.nextNode();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    @NotThreadSafe
    protected static class JcrQueryResult
    implements QueryResult {
        protected final JcrSession session;
        protected final QueryResults results;

        protected JcrQueryResult(JcrSession session, QueryResults graphResults) {
            this.session = session;
            this.results = graphResults;
            assert (this.session != null);
            assert (this.results != null);
        }

        protected QueryResults results() {
            return this.results;
        }

        public List<String> getColumnNameList() {
            return this.results.getColumns().getColumnNames();
        }

        public String[] getColumnNames() {
            List<String> names = this.getColumnNameList();
            return names.toArray(new String[names.size()]);
        }

        public NodeIterator getNodes() throws RepositoryException {
            int numRows = this.results.getRowCount();
            if (numRows == 0) {
                return new JcrEmptyNodeIterator();
            }
            ArrayList<AbstractJcrNode> nodes = new ArrayList<AbstractJcrNode>(numRows);
            String selectorName = (String)this.results.getColumns().getSelectorNames().get(0);
            int locationIndex = this.results.getColumns().getLocationIndex(selectorName);
            for (Object[] tuple : this.results.getTuples()) {
                Location location = (Location)tuple[locationIndex];
                if (this.session.wasRemovedInSession(location)) continue;
                nodes.add(this.session.getNode(location.getPath()));
            }
            return new QueryResultNodeIterator(nodes);
        }

        public RowIterator getRows() {
            int numRows = this.results.getRowCount();
            List tuples = this.results.getTuples();
            return new QueryResultRowIterator(this.session, this.results.getColumns(), tuples.iterator(), numRows);
        }

        public String getPlan() {
            return this.results.getPlan();
        }

        public String toString() {
            return this.results.toString();
        }
    }

    @NotThreadSafe
    protected static class JcrSearch
    extends AbstractQuery {
        protected JcrSearch(JcrSession session, String statement, String language, Path storedAtPath) {
            super(session, statement, language, storedAtPath);
        }

        public QueryResult execute() throws RepositoryException {
            QueryResults result = this.session.repository().queryManager().search(this.session.workspace().getName(), this.statement, Integer.MAX_VALUE, 0);
            this.checkForProblems(result.getProblems());
            return new JcrQueryResult(this.session, result);
        }

        public String toString() {
            return this.language + " -> " + this.statement;
        }
    }

    @NotThreadSafe
    protected static class JcrQuery
    extends AbstractQuery {
        private final QueryCommand query;
        private final PlanHints hints;
        private final Map<String, Object> variables;

        protected JcrQuery(JcrSession session, String statement, String language, QueryCommand query, PlanHints hints, Path storedAtPath) {
            super(session, statement, language, storedAtPath);
            assert (query != null);
            this.query = query;
            this.hints = hints;
            this.variables = null;
        }

        public QueryCommand getAbstractQueryModel() {
            return this.query;
        }

        public QueryResult execute() throws RepositoryException {
            Schemata schemata = this.session.workspace().nodeTypeManager().schemata();
            QueryResults result = this.session.repository().queryManager().query(this.session.workspace().getName(), this.query, schemata, this.hints, this.variables);
            this.checkForProblems(result.getProblems());
            if ("xpath".equals(this.language)) {
                return new XPathQueryResult(this.session, result);
            }
            return new JcrQueryResult(this.session, result);
        }

        public String toString() {
            return this.language + " -> " + this.statement + "\n" + StringUtil.createString((char)' ', (int)Math.min(this.language.length() - 3, 0)) + "AQM -> " + this.query;
        }
    }

    @NotThreadSafe
    protected static abstract class AbstractQuery
    implements Query {
        protected final JcrSession session;
        protected final String language;
        protected final String statement;
        private Path storedAtPath;

        protected AbstractQuery(JcrSession session, String statement, String language, Path storedAtPath) {
            assert (session != null);
            assert (statement != null);
            assert (language != null);
            this.session = session;
            this.language = language;
            this.statement = statement;
            this.storedAtPath = storedAtPath;
        }

        protected final JcrSession session() {
            return this.session;
        }

        public String getLanguage() {
            return this.language;
        }

        public String getStatement() {
            return this.statement;
        }

        public String getStoredQueryPath() throws ItemNotFoundException {
            if (this.storedAtPath == null) {
                throw new ItemNotFoundException(JcrI18n.notStoredQuery.text(new Object[0]));
            }
            return this.storedAtPath.getString(this.session.getExecutionContext().getNamespaceRegistry());
        }

        public Node storeAsNode(String absPath) throws PathNotFoundException, ConstraintViolationException, RepositoryException {
            Path path;
            NamespaceRegistry namespaces = this.session.namespaces();
            try {
                path = (Path)this.session.getExecutionContext().getValueFactories().getPathFactory().create(absPath);
            }
            catch (IllegalArgumentException iae) {
                throw new RepositoryException(JcrI18n.invalidPathParameter.text(new Object[]{"absPath", absPath}));
            }
            Path parentPath = path.getParent();
            AbstractJcrNode parentNode = this.session.getNode(parentPath);
            Node queryNode = parentNode.addNode(path.relativeTo(parentPath).getString(namespaces), JcrNtLexicon.QUERY.getString(namespaces));
            queryNode.setProperty(JcrLexicon.LANGUAGE.getString(namespaces), this.language);
            queryNode.setProperty(JcrLexicon.STATEMENT.getString(namespaces), this.statement);
            this.storedAtPath = path;
            return queryNode;
        }

        protected void checkForProblems(Problems problems) throws RepositoryException {
            if (problems.hasErrors()) {
                StringBuilder msg = new StringBuilder();
                for (Problem problem : problems) {
                    if (problem.getStatus() != Problem.Status.ERROR) continue;
                    msg.append(problem.getMessageString()).append("\n");
                }
                throw new RepositoryException(msg.toString());
            }
        }
    }
}

