/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.IOException;
import java.io.InputStream;
import java.security.AccessControlException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidSerializedDataException;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.observation.ObservationManager;
import javax.jcr.query.QueryManager;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import net.jcip.annotations.NotThreadSafe;
import org.modeshape.common.util.CheckArg;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Graph;
import org.modeshape.graph.Location;
import org.modeshape.graph.Node;
import org.modeshape.graph.Subgraph;
import org.modeshape.graph.SubgraphNode;
import org.modeshape.graph.connector.RepositorySourceException;
import org.modeshape.graph.connector.UuidAlreadyExistsException;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.property.ValueFormatException;
import org.modeshape.graph.property.basic.LocalNamespaceRegistry;
import org.modeshape.graph.request.InvalidWorkspaceException;
import org.modeshape.graph.session.GraphSession;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.JcrContentHandler;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrNamespaceRegistry;
import org.modeshape.jcr.JcrNodeDefinition;
import org.modeshape.jcr.JcrNodeType;
import org.modeshape.jcr.JcrNodeTypeManager;
import org.modeshape.jcr.JcrObservationManager;
import org.modeshape.jcr.JcrQueryManager;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.ModeShapeLexicon;
import org.modeshape.jcr.NodeDefinitionId;
import org.modeshape.jcr.SessionCache;
import org.modeshape.jcr.WorkspaceLockManager;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

@NotThreadSafe
class JcrWorkspace
implements Workspace {
    private final String name;
    private final ExecutionContext context;
    private final JcrRepository repository;
    private final Graph graph;
    private final JcrNamespaceRegistry workspaceRegistry;
    private final JcrNodeTypeManager nodeTypeManager;
    private final JcrQueryManager queryManager;
    private final JcrObservationManager observationManager;
    private final WorkspaceLockManager lockManager;
    private final JcrSession session;

    JcrWorkspace(JcrRepository repository, String workspaceName, ExecutionContext context, Map<String, Object> sessionAttributes) {
        assert (workspaceName != null);
        assert (context != null);
        assert (context.getSecurityContext() != null);
        assert (repository != null);
        this.name = workspaceName;
        this.repository = repository;
        this.lockManager = repository.getLockManager(workspaceName);
        NamespaceRegistry globalRegistry = context.getNamespaceRegistry();
        LocalNamespaceRegistry localRegistry = new LocalNamespaceRegistry(globalRegistry);
        this.context = context.with((NamespaceRegistry)localRegistry);
        this.graph = this.repository.createWorkspaceGraph(this.name, this.context);
        this.session = new JcrSession(this.repository, this, this.context, globalRegistry, sessionAttributes);
        this.nodeTypeManager = new JcrNodeTypeManager(this.session, this.repository.getRepositoryTypeManager());
        this.queryManager = new JcrQueryManager(this.session);
        this.observationManager = new JcrObservationManager(this.session, this.repository.getRepositoryObservable());
        this.workspaceRegistry = new JcrNamespaceRegistry(this.repository.getPersistentRegistry(), this.session);
    }

    final Graph graph() {
        return this.graph;
    }

    final String getSourceName() {
        return this.repository.getRepositorySourceName();
    }

    final JcrNodeTypeManager nodeTypeManager() {
        return this.nodeTypeManager;
    }

    final ExecutionContext context() {
        return this.context;
    }

    final WorkspaceLockManager lockManager() {
        return this.lockManager;
    }

    final JcrObservationManager observationManager() {
        return this.observationManager;
    }

    final JcrQueryManager queryManager() {
        return this.queryManager;
    }

    public final String getName() {
        return this.name;
    }

    public final Session getSession() {
        return this.session;
    }

    public final javax.jcr.NamespaceRegistry getNamespaceRegistry() {
        return this.workspaceRegistry;
    }

    public String[] getAccessibleWorkspaceNames() throws RepositoryException {
        try {
            Set workspaceNamesFromGraph = this.graph.getWorkspaces();
            HashSet<String> workspaceNames = new HashSet<String>(workspaceNamesFromGraph.size());
            for (String workspaceName : workspaceNamesFromGraph) {
                try {
                    this.session.checkPermission(workspaceName, null, "read");
                    workspaceNames.add(workspaceName);
                }
                catch (AccessControlException ace) {}
            }
            return workspaceNames.toArray(new String[workspaceNames.size()]);
        }
        catch (RepositorySourceException e) {
            throw new RepositoryException(JcrI18n.errorObtainingWorkspaceNames.text(new Object[]{this.getSourceName(), e.getMessage()}), (Throwable)e);
        }
    }

    public final NodeTypeManager getNodeTypeManager() {
        return this.nodeTypeManager;
    }

    public final ObservationManager getObservationManager() {
        return this.observationManager;
    }

    public final QueryManager getQueryManager() {
        return this.queryManager;
    }

    public void clone(String srcWorkspace, String srcAbsPath, String destAbsPath, boolean removeExisting) throws ConstraintViolationException, VersionException, AccessDeniedException, PathNotFoundException, ItemExistsException, LockException, RepositoryException {
        CheckArg.isNotNull((Object)srcWorkspace, (String)"source workspace name");
        CheckArg.isNotNull((Object)srcAbsPath, (String)"source path");
        CheckArg.isNotNull((Object)destAbsPath, (String)"destination path");
        if (!this.graph.getWorkspaces().contains(srcWorkspace)) {
            throw new NoSuchWorkspaceException(JcrI18n.workspaceNameIsInvalid.text(new Object[]{this.graph.getSourceName(), this.name}));
        }
        PathFactory factory = this.context.getValueFactories().getPathFactory();
        Path srcPath = null;
        Path destPath = null;
        try {
            srcPath = (Path)factory.create(srcAbsPath);
        }
        catch (ValueFormatException e) {
            throw new PathNotFoundException(JcrI18n.invalidPathParameter.text(new Object[]{srcAbsPath, "srcAbsPath"}), (Throwable)e);
        }
        try {
            destPath = (Path)factory.create(destAbsPath);
        }
        catch (ValueFormatException e) {
            throw new PathNotFoundException(JcrI18n.invalidPathParameter.text(new Object[]{destAbsPath, "destAbsPath"}), (Throwable)e);
        }
        if (destAbsPath.endsWith("]")) {
            throw new RepositoryException(JcrI18n.pathCannotHaveSameNameSiblingIndex.text(new Object[]{destAbsPath}));
        }
        try {
            Set<UUID> uuidsInCloneBranch;
            Lock newParentLock;
            AbstractJcrNode parentNode;
            Name newNodeName = destPath.getLastSegment().getName();
            SessionCache cache = this.session.cache();
            Node sourceNode = this.repository.createWorkspaceGraph(srcWorkspace, this.context).getNodeAt(srcPath);
            Property uuidProp = sourceNode.getProperty(ModeShapeLexicon.UUID);
            if (uuidProp != null) {
                UUID sourceUuid = (UUID)this.context.getValueFactories().getUuidFactory().create(uuidProp.getFirstValue());
                WorkspaceLockManager.ModeShapeLock sourceLock = this.lockManager().lockFor(this.session, Location.create((UUID)sourceUuid));
                if (sourceLock != null && sourceLock.getLockToken() == null) {
                    throw new LockException(JcrI18n.lockTokenNotHeld.text(new Object[]{srcAbsPath}));
                }
            }
            if ((parentNode = cache.findJcrNode(Location.create((Path)destPath.getParent()))).isLocked() && (newParentLock = parentNode.getLock()) != null && newParentLock.getLockToken() == null) {
                throw new LockException(destAbsPath);
            }
            GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload> parent = cache.findNode(null, destPath.getParent());
            cache.findBestNodeDefinition(parent, newNodeName, ((SessionCache.JcrNodePayload)parent.getPayload()).getPrimaryTypeName());
            if (removeExisting && !(uuidsInCloneBranch = this.getUuidsInBranch(srcPath, srcWorkspace)).isEmpty()) {
                GraphSession<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload> graphSession = cache.graphSession();
                GraphSession.Node node = null;
                for (UUID uuid : uuidsInCloneBranch) {
                    Location location = Location.create((UUID)uuid);
                    try {
                        node = graphSession.findNodeWith(location);
                    }
                    catch (org.modeshape.graph.property.PathNotFoundException e) {
                        continue;
                    }
                    NodeDefinitionId childDefnId = ((SessionCache.JcrNodePayload)node.getPayload()).getDefinitionId();
                    JcrNodeType nodeType = this.nodeTypeManager().getNodeType(childDefnId.getNodeTypeName());
                    JcrNodeDefinition childDefn = nodeType.childNodeDefinition(childDefnId);
                    if (childDefn.isMandatory()) {
                        String path = node.getPath().getString(this.context.getNamespaceRegistry());
                        throw new ConstraintViolationException(JcrI18n.cannotRemoveNodeFromClone.text(new Object[]{path, uuid}));
                    }
                    if (!node.isChanged(true)) continue;
                    String path = node.getPath().getString(this.context.getNamespaceRegistry());
                    throw new RepositoryException(JcrI18n.cannotRemoveNodeFromCloneDueToChangesInSession.text(new Object[]{path, uuid}));
                }
            }
            cache.graphSession().immediateClone(srcPath, srcWorkspace, destPath, removeExisting, false);
        }
        catch (ItemNotFoundException e) {
            throw new PathNotFoundException(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (org.modeshape.graph.property.PathNotFoundException e) {
            throw new PathNotFoundException(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (UuidAlreadyExistsException e) {
            throw new ItemExistsException(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (InvalidWorkspaceException e) {
            throw new NoSuchWorkspaceException(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (RepositorySourceException e) {
            throw new RepositoryException(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (AccessControlException ace) {
            throw new AccessDeniedException((Throwable)ace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<UUID> getUuidsInBranch(Path sourcePath, String workspace) {
        String existingWorkspace = this.graph.getCurrentWorkspaceName();
        try {
            this.graph.useWorkspace(workspace);
            Subgraph subgraph = (Subgraph)this.graph.getSubgraphOfDepth(Integer.MAX_VALUE).at(sourcePath);
            HashSet<UUID> uuids = new HashSet<UUID>();
            for (SubgraphNode nodeInSubgraph : subgraph) {
                UUID uuid = nodeInSubgraph.getLocation().getUuid();
                if (uuid == null) continue;
                uuids.add(uuid);
            }
            HashSet<UUID> hashSet = uuids;
            return hashSet;
        }
        finally {
            this.graph.useWorkspace(existingWorkspace);
        }
    }

    public void copy(String srcAbsPath, String destAbsPath) throws ConstraintViolationException, VersionException, AccessDeniedException, PathNotFoundException, ItemExistsException, LockException, RepositoryException {
        this.copy(this.name, srcAbsPath, destAbsPath);
    }

    public void copy(String srcWorkspace, String srcAbsPath, String destAbsPath) throws ConstraintViolationException, VersionException, AccessDeniedException, PathNotFoundException, ItemExistsException, LockException, RepositoryException {
        CheckArg.isNotNull((Object)srcWorkspace, (String)"source workspace name");
        CheckArg.isNotNull((Object)srcAbsPath, (String)"source path");
        CheckArg.isNotNull((Object)destAbsPath, (String)"destination path");
        if (!this.graph.getWorkspaces().contains(srcWorkspace)) {
            throw new NoSuchWorkspaceException(JcrI18n.workspaceNameIsInvalid.text(new Object[]{this.graph.getSourceName(), this.name}));
        }
        PathFactory factory = this.context.getValueFactories().getPathFactory();
        Path srcPath = null;
        Path destPath = null;
        try {
            srcPath = (Path)factory.create(srcAbsPath);
        }
        catch (ValueFormatException e) {
            throw new PathNotFoundException(JcrI18n.invalidPathParameter.text(new Object[]{srcAbsPath, "srcAbsPath"}), (Throwable)e);
        }
        try {
            destPath = (Path)factory.create(destAbsPath);
        }
        catch (ValueFormatException e) {
            throw new PathNotFoundException(JcrI18n.invalidPathParameter.text(new Object[]{destAbsPath, "destAbsPath"}), (Throwable)e);
        }
        if (destAbsPath.endsWith("]")) {
            throw new RepositoryException(JcrI18n.pathCannotHaveSameNameSiblingIndex.text(new Object[]{destAbsPath}));
        }
        try {
            Lock newParentLock;
            AbstractJcrNode parentNode;
            Name newNodeName = destPath.getLastSegment().getName();
            SessionCache cache = this.session.cache();
            Node sourceNode = this.repository.createWorkspaceGraph(srcWorkspace, this.context).getNodeAt(srcPath);
            Property uuidProp = sourceNode.getProperty(ModeShapeLexicon.UUID);
            if (uuidProp != null) {
                UUID sourceUuid = (UUID)this.context.getValueFactories().getUuidFactory().create(uuidProp.getFirstValue());
                WorkspaceLockManager.ModeShapeLock sourceLock = this.lockManager().lockFor(this.session, Location.create((UUID)sourceUuid));
                if (sourceLock != null && sourceLock.getLockToken() == null) {
                    throw new LockException(srcAbsPath);
                }
            }
            if ((parentNode = cache.findJcrNode(Location.create((Path)destPath.getParent()))).isLocked() && (newParentLock = parentNode.getLock()) != null && newParentLock.getLockToken() == null) {
                throw new LockException(destAbsPath);
            }
            GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload> parent = cache.findNode(null, destPath.getParent());
            cache.findBestNodeDefinition(parent, newNodeName, ((SessionCache.JcrNodePayload)parent.getPayload()).getPrimaryTypeName());
            cache.graphSession().immediateCopy(srcPath, srcWorkspace, destPath);
        }
        catch (ItemNotFoundException e) {
            throw new PathNotFoundException(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (org.modeshape.graph.property.PathNotFoundException e) {
            throw new PathNotFoundException(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (UuidAlreadyExistsException e) {
            throw new ItemExistsException(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (InvalidWorkspaceException e) {
            throw new NoSuchWorkspaceException(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (RepositorySourceException e) {
            throw new RepositoryException(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (AccessControlException ace) {
            throw new AccessDeniedException((Throwable)ace);
        }
    }

    public ContentHandler getImportContentHandler(String parentAbsPath, int uuidBehavior) throws PathNotFoundException, ConstraintViolationException, VersionException, LockException, AccessDeniedException, RepositoryException {
        CheckArg.isNotNull((Object)parentAbsPath, (String)"parentAbsPath");
        Path parentPath = (Path)this.context.getValueFactories().getPathFactory().create(parentAbsPath);
        return new JcrContentHandler(this.session, parentPath, uuidBehavior, JcrContentHandler.SaveMode.WORKSPACE);
    }

    public void importXML(String parentAbsPath, InputStream in, int uuidBehavior) throws IOException, PathNotFoundException, ItemExistsException, ConstraintViolationException, InvalidSerializedDataException, LockException, AccessDeniedException, RepositoryException {
        CheckArg.isNotNull((Object)parentAbsPath, (String)"parentAbsPath");
        CheckArg.isNotNull((Object)in, (String)"in");
        try {
            XMLReader parser = XMLReaderFactory.createXMLReader();
            parser.setContentHandler(this.getImportContentHandler(parentAbsPath, uuidBehavior));
            parser.parse(new InputSource(in));
        }
        catch (JcrContentHandler.EnclosingSAXException ese) {
            Exception cause = ese.getException();
            if (cause instanceof ItemExistsException) {
                throw (ItemExistsException)cause;
            }
            if (cause instanceof ConstraintViolationException) {
                throw (ConstraintViolationException)cause;
            }
            throw new RepositoryException((Throwable)cause);
        }
        catch (SAXParseException se) {
            throw new InvalidSerializedDataException((Throwable)se);
        }
        catch (SAXException se) {
            throw new RepositoryException((Throwable)se);
        }
    }

    public void move(String srcAbsPath, String destAbsPath) throws PathNotFoundException, RepositoryException {
        CheckArg.isNotEmpty((String)srcAbsPath, (String)"srcAbsPath");
        CheckArg.isNotEmpty((String)destAbsPath, (String)"destAbsPath");
        PathFactory factory = this.context.getValueFactories().getPathFactory();
        Path srcPath = null;
        Path destPath = null;
        try {
            srcPath = (Path)factory.create(srcAbsPath);
        }
        catch (ValueFormatException e) {
            throw new PathNotFoundException(JcrI18n.invalidPathParameter.text(new Object[]{srcAbsPath, "srcAbsPath"}), (Throwable)e);
        }
        try {
            destPath = (Path)factory.create(destAbsPath);
        }
        catch (ValueFormatException e) {
            throw new PathNotFoundException(JcrI18n.invalidPathParameter.text(new Object[]{destAbsPath, "destAbsPath"}), (Throwable)e);
        }
        if (destAbsPath.endsWith("]")) {
            throw new RepositoryException(JcrI18n.pathCannotHaveSameNameSiblingIndex.text(new Object[]{destAbsPath}));
        }
        try {
            Lock newParentLock;
            Lock sourceLock;
            Name newNodeName = destPath.getLastSegment().getName();
            SessionCache cache = this.session.cache();
            GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload> newParent = cache.findNode(null, destPath.getParent());
            cache.findBestNodeDefinition(newParent, newNodeName, ((SessionCache.JcrNodePayload)newParent.getPayload()).getPrimaryTypeName());
            AbstractJcrNode sourceNode = cache.findJcrNode(Location.create((Path)srcPath));
            if (sourceNode.isLocked() && (sourceLock = sourceNode.getLock()) != null && sourceLock.getLockToken() == null) {
                throw new LockException(srcAbsPath);
            }
            AbstractJcrNode parentNode = cache.findJcrNode(Location.create((Path)destPath.getParent()));
            if (parentNode.isLocked() && (newParentLock = parentNode.getLock()) != null && newParentLock.getLockToken() == null) {
                throw new LockException(destAbsPath);
            }
            cache.graphSession().immediateMove(srcPath, destPath);
        }
        catch (AccessControlException ace) {
            throw new AccessDeniedException((Throwable)ace);
        }
        catch (ItemNotFoundException infe) {
            throw new PathNotFoundException((Throwable)infe);
        }
        catch (org.modeshape.graph.property.PathNotFoundException pnfe) {
            throw new PathNotFoundException((Throwable)pnfe);
        }
    }

    public void restore(Version[] versions, boolean removeExisting) {
        throw new UnsupportedOperationException();
    }
}

