/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.Arrays;
import java.util.List;
import javax.jcr.PropertyType;
import javax.jcr.version.OnParentVersionAction;
import net.jcip.annotations.NotThreadSafe;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Graph;
import org.modeshape.graph.JcrLexicon;
import org.modeshape.graph.JcrNtLexicon;
import org.modeshape.graph.connector.RepositorySource;
import org.modeshape.graph.connector.inmemory.InMemoryRepositorySource;
import org.modeshape.graph.io.Destination;
import org.modeshape.graph.io.GraphBatchDestination;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NameFactory;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.property.PropertyFactory;
import org.modeshape.graph.property.ValueFactory;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrNodeDefinitionTemplate;
import org.modeshape.jcr.JcrNodeType;
import org.modeshape.jcr.JcrNodeTypeSource;
import org.modeshape.jcr.JcrNodeTypeTemplate;
import org.modeshape.jcr.JcrPropertyDefinitionTemplate;
import org.modeshape.jcr.nodetype.InvalidNodeTypeDefinitionException;
import org.modeshape.jcr.nodetype.NodeDefinitionTemplate;
import org.modeshape.jcr.nodetype.NodeTypeTemplate;
import org.modeshape.jcr.nodetype.PropertyDefinitionTemplate;

@NotThreadSafe
class NodeTemplateNodeTypeSource
implements JcrNodeTypeSource {
    private final Graph graph;
    private final PathFactory pathFactory;
    private final NameFactory nameFactory;
    private final ValueFactory<Boolean> booleanFactory;
    private final ValueFactory<String> stringFactory;
    private final Destination destination;

    public NodeTemplateNodeTypeSource(NodeTypeTemplate nodeTypeTemplate) throws InvalidNodeTypeDefinitionException {
        this(Arrays.asList(nodeTypeTemplate));
    }

    public NodeTemplateNodeTypeSource(List<NodeTypeTemplate> nodeTypeTemplates) throws InvalidNodeTypeDefinitionException {
        ExecutionContext context = null;
        if (nodeTypeTemplates.isEmpty()) {
            context = new ExecutionContext();
        } else {
            for (NodeTypeTemplate ntt : nodeTypeTemplates) {
                if (!(ntt instanceof JcrNodeTypeTemplate)) {
                    throw new IllegalArgumentException(JcrI18n.cannotConvertValue.text(new Object[]{ntt.getClass(), JcrNodeTypeTemplate.class}));
                }
                JcrNodeTypeTemplate jntt = (JcrNodeTypeTemplate)ntt;
                if (context == null) {
                    context = jntt.getExecutionContext();
                    assert (context != null);
                    continue;
                }
                if (context == jntt.getExecutionContext()) continue;
                throw new IllegalArgumentException(JcrI18n.allNodeTypeTemplatesMustComeFromSameSession.text(new Object[0]));
            }
        }
        assert (context != null);
        this.pathFactory = context.getValueFactories().getPathFactory();
        this.nameFactory = context.getValueFactories().getNameFactory();
        this.booleanFactory = context.getValueFactories().getBooleanFactory();
        this.stringFactory = context.getValueFactories().getStringFactory();
        PathFactory pathFactory = context.getValueFactories().getPathFactory();
        InMemoryRepositorySource source = new InMemoryRepositorySource();
        source.setName("NodeTypeTemplate Import Source");
        this.graph = Graph.create((RepositorySource)source, (ExecutionContext)context);
        Graph.Batch batch = this.graph.batch();
        this.destination = new GraphBatchDestination(batch);
        Path rootPath = pathFactory.createRootPath();
        for (NodeTypeTemplate template : nodeTypeTemplates) {
            this.createNodeType((JcrNodeTypeTemplate)template, rootPath);
        }
        this.destination.submit();
    }

    @Override
    public final Graph getNodeTypes() {
        return this.graph;
    }

    private boolean booleanFrom(Object value, boolean defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return (Boolean)this.booleanFactory.create(value);
    }

    private Name nameFrom(Object value) {
        return (Name)this.nameFactory.create(value);
    }

    private Name[] namesFrom(Object[] values) {
        if (values == null) {
            return new Name[0];
        }
        Name[] names = new Name[values.length];
        for (int i = 0; i < values.length; ++i) {
            names[i] = (Name)this.nameFactory.create(values[i]);
        }
        return names;
    }

    private String[] stringsFrom(Object[] values) {
        if (values == null) {
            return new String[0];
        }
        String[] strings = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            strings[i] = (String)this.stringFactory.create(values[i]);
        }
        return strings;
    }

    protected Path createNodeType(JcrNodeTypeTemplate nodeType, Path parentPath) throws InvalidNodeTypeDefinitionException {
        Name name = this.nameFrom(nodeType.getName());
        Name[] supertypes = this.namesFrom(nodeType.getDeclaredSupertypes());
        boolean isAbstract = this.booleanFrom(nodeType.isAbstract(), false);
        boolean hasOrderableChildNodes = this.booleanFrom(nodeType.hasOrderableChildNodes(), false);
        boolean isMixin = this.booleanFrom(nodeType.isMixin(), false);
        boolean isQueryable = true;
        Name primaryItemName = this.nameFrom(nodeType.getPrimaryItemName());
        if (name == null) {
            throw new InvalidNodeTypeDefinitionException(JcrI18n.invalidNodeTypeName.text(new Object[0]));
        }
        Path path = this.pathFactory.create(parentPath, new Name[]{name});
        PropertyFactory factory = nodeType.getExecutionContext().getPropertyFactory();
        this.destination.create(path, factory.create(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.NODE_TYPE}), new Property[]{factory.create(JcrLexicon.SUPERTYPES, (Object[])supertypes), factory.create(JcrLexicon.IS_ABSTRACT, new Object[]{isAbstract}), factory.create(JcrLexicon.HAS_ORDERABLE_CHILD_NODES, new Object[]{hasOrderableChildNodes}), factory.create(JcrLexicon.IS_MIXIN, new Object[]{isMixin}), factory.create(JcrLexicon.IS_QUERYABLE, new Object[]{isQueryable}), factory.create(JcrLexicon.NODE_TYPE_NAME, new Object[]{name}), factory.create(JcrLexicon.PRIMARY_ITEM_NAME, new Object[]{primaryItemName})});
        for (PropertyDefinitionTemplate propDefn : nodeType.getPropertyDefinitionTemplates()) {
            this.createPropertyDefinition((JcrPropertyDefinitionTemplate)propDefn, path);
        }
        for (NodeDefinitionTemplate nodeDefn : nodeType.getNodeDefinitionTemplates()) {
            this.createChildDefinition((JcrNodeDefinitionTemplate)nodeDefn, path);
        }
        return path;
    }

    protected Path createPropertyDefinition(JcrPropertyDefinitionTemplate propDefn, Path parentPath) {
        Name name = this.nameFrom(propDefn.getName());
        String requiredType = PropertyType.nameFromValue((int)propDefn.getRequiredType()).toUpperCase();
        String[] defaultValues = propDefn.getInternalDefaultValues();
        boolean multiple = this.booleanFrom(propDefn.isMultiple(), false);
        boolean mandatory = this.booleanFrom(propDefn.isMandatory(), false);
        boolean autoCreated = this.booleanFrom(propDefn.isAutoCreated(), false);
        boolean isProtected = this.booleanFrom(propDefn.isProtected(), false);
        String onParentVersion = OnParentVersionAction.nameFromValue((int)propDefn.getOnParentVersion()).toUpperCase();
        String[] valueConstraints = this.stringsFrom(propDefn.getValueConstraints());
        if (name == null) {
            name = JcrNodeType.RESIDUAL_NAME;
        }
        Path path = this.pathFactory.create(parentPath, new Name[]{JcrLexicon.PROPERTY_DEFINITION});
        PropertyFactory factory = propDefn.getExecutionContext().getPropertyFactory();
        this.destination.create(path, factory.create(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.PROPERTY_DEFINITION}), new Property[]{factory.create(JcrLexicon.REQUIRED_TYPE, new Object[]{requiredType}), factory.create(JcrLexicon.DEFAULT_VALUES, (Object[])defaultValues), factory.create(JcrLexicon.MULTIPLE, new Object[]{multiple}), factory.create(JcrLexicon.MANDATORY, new Object[]{mandatory}), factory.create(JcrLexicon.NAME, new Object[]{name}), factory.create(JcrLexicon.AUTO_CREATED, new Object[]{autoCreated}), factory.create(JcrLexicon.PROTECTED, new Object[]{isProtected}), factory.create(JcrLexicon.ON_PARENT_VERSION, new Object[]{onParentVersion}), factory.create(JcrLexicon.VALUE_CONSTRAINTS, (Object[])valueConstraints)});
        return path;
    }

    protected Path createChildDefinition(JcrNodeDefinitionTemplate childDefn, Path parentPath) {
        Name name = this.nameFrom(childDefn.getName());
        Name[] requiredPrimaryTypes = this.namesFrom(childDefn.getRequiredPrimaryTypeNames());
        Name defaultPrimaryType = this.nameFrom(childDefn.getDefaultPrimaryTypeName());
        boolean mandatory = this.booleanFrom(childDefn.isMandatory(), false);
        boolean autoCreated = this.booleanFrom(childDefn.isAutoCreated(), false);
        boolean isProtected = this.booleanFrom(childDefn.isProtected(), false);
        String onParentVersion = OnParentVersionAction.nameFromValue((int)childDefn.getOnParentVersion()).toUpperCase();
        boolean sameNameSiblings = this.booleanFrom(childDefn.allowsSameNameSiblings(), false);
        if (name == null) {
            name = JcrNodeType.RESIDUAL_NAME;
        }
        Path path = this.pathFactory.create(parentPath, new Name[]{JcrLexicon.CHILD_NODE_DEFINITION});
        PropertyFactory factory = childDefn.getExecutionContext().getPropertyFactory();
        this.destination.create(path, factory.create(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.CHILD_NODE_DEFINITION}), new Property[]{factory.create(JcrLexicon.REQUIRED_PRIMARY_TYPES, (Object[])requiredPrimaryTypes), factory.create(JcrLexicon.DEFAULT_PRIMARY_TYPE, new Object[]{defaultPrimaryType}), factory.create(JcrLexicon.MANDATORY, new Object[]{mandatory}), factory.create(JcrLexicon.NAME, new Object[]{name}), factory.create(JcrLexicon.AUTO_CREATED, new Object[]{autoCreated}), factory.create(JcrLexicon.PROTECTED, new Object[]{isProtected}), factory.create(JcrLexicon.ON_PARENT_VERSION, new Object[]{onParentVersion}), factory.create(JcrLexicon.SAME_NAME_SIBLINGS, new Object[]{sameNameSiblings})});
        return path;
    }
}

