/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import javax.jcr.Node;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.AbstractJcrTest;

public class JcrNodeTest
extends AbstractJcrTest {
    private AbstractJcrNode hybrid;
    private AbstractJcrNode altima;

    @Override
    @Before
    public void beforeEach() throws Exception {
        super.beforeEach();
        this.hybrid = this.cache.findJcrNode(null, this.path("/Cars/Hybrid"));
        this.altima = this.cache.findJcrNode(null, this.path("/Cars/Hybrid/Nissan Altima"));
    }

    @Test
    public void shouldHavePath() throws Exception {
        Assert.assertThat((Object)this.altima.getPath(), (Matcher)Is.is((Object)"/Cars/Hybrid/Nissan Altima"));
        Node altima2 = this.hybrid.addNode("Nissan Altima");
        Assert.assertThat((Object)altima2, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)altima2.getPath(), (Matcher)Is.is((Object)"/Cars/Hybrid/Nissan Altima[2]"));
    }

    @Test
    public void shouldHaveSameNameSiblingIndex() throws Exception {
        Assert.assertThat((Object)this.altima.getIndex(), (Matcher)Is.is((Object)1));
        Node altima2 = this.hybrid.addNode("Nissan Altima");
        Assert.assertThat((Object)altima2, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)altima2.getIndex(), (Matcher)Is.is((Object)2));
    }

    @Test
    public void shouldHaveNameThatExcludesSameNameSiblingIndex() throws Exception {
        Assert.assertThat((Object)this.altima.getName(), (Matcher)Is.is((Object)"Nissan Altima"));
        Node altima2 = this.hybrid.addNode("Nissan Altima");
        Assert.assertThat((Object)altima2, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)altima2.getPath(), (Matcher)Is.is((Object)"/Cars/Hybrid/Nissan Altima[2]"));
        Assert.assertThat((Object)altima2.getName(), (Matcher)Is.is((Object)"Nissan Altima"));
    }
}

