/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.hamcrest.core.IsNull;
import org.hamcrest.core.IsSame;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.graph.Location;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.session.GraphSession;
import org.modeshape.jcr.AbstractJcrItem;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.AbstractJcrProperty;
import org.modeshape.jcr.AbstractJcrTest;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.JcrRootNode;
import org.modeshape.jcr.ModeShapeIntLexicon;
import org.modeshape.jcr.ModeShapeLexicon;

public class SessionCacheTest
extends AbstractJcrTest {
    @Override
    @Before
    public void beforeEach() throws Exception {
        super.beforeEach();
    }

    @Test
    public void shouldRepeatedlyFindRootNode() throws Exception {
        JcrRootNode root = this.cache.findJcrRootNode();
        for (int i = 0; i != 10; ++i) {
            JcrRootNode node = this.cache.findJcrRootNode();
            Assert.assertThat((Object)node, (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)root)));
            this.assertMatchesStore((AbstractJcrNode)node);
        }
    }

    @Test
    public void shouldRepeatedlyFindRootNodeByPath() throws Exception {
        AbstractJcrNode root = this.cache.findJcrNode(null, this.path("/"));
        for (int i = 0; i != 10; ++i) {
            JcrRootNode node = this.cache.findJcrRootNode();
            Assert.assertThat((Object)node, (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)root)));
            this.assertMatchesStore((AbstractJcrNode)node);
        }
    }

    @Test
    public void shouldRepeatedlyFindRootNodeByLocationWithoutPath() throws Exception {
        JcrRootNode root = this.cache.findJcrRootNode();
        AbstractJcrNode root2 = this.cache.findJcrNode(Location.create((List)root.location.getIdProperties()));
        Assert.assertThat((Object)root2, (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)root)));
    }

    @Test
    public void shouldRepeatedlyFindNodeByPath() throws Exception {
        AbstractJcrNode hybrid = this.cache.findJcrNode(null, this.path("/Cars/Hybrid"));
        for (int i = 0; i != 10; ++i) {
            AbstractJcrNode hybrid2 = this.cache.findJcrNode(null, hybrid.path());
            Assert.assertThat((Object)hybrid, (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)hybrid2)));
            this.assertMatchesStore(hybrid2);
        }
    }

    @Test
    public void shouldRepeatedlyFindNodeByNodeId() throws Exception {
        AbstractJcrNode hybrid = this.cache.findJcrNode(null, this.path("/Cars/Hybrid"));
        for (int i = 0; i != 10; ++i) {
            AbstractJcrNode hybrid2 = this.cache.findJcrNode(hybrid.nodeId, null);
            Assert.assertThat((Object)hybrid, (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)hybrid2)));
            this.assertMatchesStore(hybrid2);
        }
    }

    @Test
    public void shouldRepeatedlyFindNodeByLocationWithoutPath() throws Exception {
        AbstractJcrNode hybrid = this.cache.findJcrNode(null, this.path("/Cars/Hybrid"));
        AbstractJcrNode hybrid2 = this.cache.findJcrNode(Location.create((List)hybrid.location.getIdProperties()));
        Assert.assertThat((Object)hybrid2, (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)hybrid)));
    }

    @Test
    public void shouldFindNodeUsingStartingNodeAndRelativePath() throws Exception {
        AbstractJcrNode hybrid = this.cache.findJcrNode(null, this.path("/Cars/Hybrid"));
        AbstractJcrNode highlander = this.cache.findJcrNode(hybrid.nodeId, hybrid.path(), this.path("../Hybrid/Toyota Highlander"));
        AbstractJcrNode highlander2 = this.cache.findJcrNode(null, this.path("/Cars/Hybrid/Toyota Highlander"));
        Assert.assertThat((Object)highlander, (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)highlander2)));
        this.assertMatchesStore(highlander);
    }

    @Test
    public void shouldFindNodeItemUsingStartingNodeAndRelativePath() throws Exception {
        AbstractJcrNode hybrid = this.cache.findJcrNode(null, this.path("/Cars/Hybrid"));
        AbstractJcrItem highlander = this.cache.findJcrItem(hybrid.nodeId, hybrid.path(), this.path("../Hybrid/Toyota Highlander"));
        Assert.assertThat((Object)highlander.isNode(), (Matcher)Is.is((Object)true));
        AbstractJcrNode highlander2 = this.cache.findJcrNode(null, this.path("/Cars/Hybrid/Toyota Highlander"));
        Assert.assertThat((Object)((AbstractJcrNode)highlander), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)highlander2)));
    }

    @Test
    public void shouldFindPropertyItemUsingStartingNodeAndRelativePath() throws Exception {
        AbstractJcrNode hybrid = this.cache.findJcrNode(null, this.path("/Cars/Hybrid"));
        AbstractJcrItem altimaModel = this.cache.findJcrItem(hybrid.nodeId, hybrid.path(), this.path("../Hybrid/Nissan Altima/vehix:model"));
        Assert.assertThat((Object)altimaModel.isNode(), (Matcher)Is.is((Object)false));
        Node altimaModelParent = altimaModel.getParent();
        AbstractJcrNode altima = this.cache.findJcrNode(null, this.path("/Cars/Hybrid/Nissan Altima"));
        Assert.assertThat((Object)altima, (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)altimaModelParent)));
    }

    @Test
    public void shouldFindPropertyForNodeUsingPropertyName() throws Exception {
        AbstractJcrNode altima = this.cache.findJcrNode(null, this.path("/Cars/Hybrid/Nissan Altima"));
        AbstractJcrProperty altimaModel = this.cache.findJcrProperty(altima.nodeId, altima.path(), this.name("vehix:model"));
        Assert.assertThat((Object)altimaModel.isNode(), (Matcher)Is.is((Object)false));
        Node altimaModelParent = altimaModel.getParent();
        Assert.assertThat((Object)altima, (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)altimaModelParent)));
    }

    @Test
    public void shouldFindPropertiesForNode() throws Exception {
        AbstractJcrNode altima = this.cache.findJcrNode(null, this.path("/Cars/Hybrid/Nissan Altima"));
        Collection properties = this.cache.findJcrPropertiesFor(altima.nodeId, altima.path());
        Assert.assertThat((Object)properties.size(), (Matcher)Is.is((Object)7));
        ArrayList properties2 = new ArrayList(properties);
        Collections.sort(properties2);
        Iterator iter = properties2.iterator();
        this.assertProperty((AbstractJcrProperty)iter.next(), (Node)altima, "jcr:primaryType", 7, "vehix:car");
        this.assertProperty((AbstractJcrProperty)iter.next(), (Node)altima, "vehix:maker", 1, "Nissan");
        this.assertProperty((AbstractJcrProperty)iter.next(), (Node)altima, "vehix:model", 1, "Altima");
        this.assertProperty((AbstractJcrProperty)iter.next(), (Node)altima, "vehix:mpgCity", 3, "23");
        this.assertProperty((AbstractJcrProperty)iter.next(), (Node)altima, "vehix:mpgHighway", 3, "32");
        this.assertProperty((AbstractJcrProperty)iter.next(), (Node)altima, "vehix:msrp", 1, "$18,260");
        this.assertProperty((AbstractJcrProperty)iter.next(), (Node)altima, "vehix:year", 3, "2008");
    }

    @Test
    public void shouldRefreshWithoutKeepingChanges() throws Exception {
        AbstractJcrNode altima1 = this.cache.findJcrNode(null, this.path("/Cars/Hybrid/Nissan Altima"));
        this.assertMatchesStore(altima1);
        Assert.assertThat((Object)altima1.isNew(), (Matcher)Is.is((Object)false));
        AbstractJcrNode hybrid = this.cache.findJcrNode(null, this.path("/Cars/Hybrid"));
        Node child = hybrid.addNode("child");
        Assert.assertThat((Object)hybrid.isModified(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)child.isNew(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)hybrid.hasNode("child"), (Matcher)Is.is((Object)true));
        this.cache.refresh(false);
        AbstractJcrNode altima2 = this.cache.findJcrNode(null, this.path("/Cars/Hybrid/Nissan Altima"));
        this.assertMatchesStore(altima2);
        Assert.assertThat((Object)altima1, (Matcher)Is.is((Object)altima2));
        Assert.assertThat((Object)altima1, (Matcher)Is.is((Matcher)IsNot.not((Matcher)IsSame.sameInstance((Object)altima2))));
        Assert.assertThat((Object)altima2.isNew(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)hybrid.hasNode("child"), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldRefreshAndKeepChanges() throws Exception {
        AbstractJcrNode altima1 = this.cache.findJcrNode(null, this.path("/Cars/Hybrid/Nissan Altima"));
        this.assertMatchesStore(altima1);
        Assert.assertThat((Object)altima1.isNew(), (Matcher)Is.is((Object)false));
        AbstractJcrNode hybrid = this.cache.findJcrNode(null, this.path("/Cars/Hybrid"));
        Node child = hybrid.addNode("child");
        Assert.assertThat((Object)hybrid.isModified(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)child.isNew(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)hybrid.hasNode("child"), (Matcher)Is.is((Object)true));
        this.cache.refresh(true);
        AbstractJcrNode altima2 = this.cache.findJcrNode(null, this.path("/Cars/Hybrid/Nissan Altima"));
        this.assertMatchesStore(altima2);
        Assert.assertThat((Object)altima1, (Matcher)Is.is((Object)altima2));
        Assert.assertThat((Object)altima1, (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)altima2)));
        Assert.assertThat((Object)altima2.isNew(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)hybrid.hasNode("child"), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldSaveChanges() throws Exception {
        AbstractJcrNode altima1 = this.cache.findJcrNode(null, this.path("/Cars/Hybrid/Nissan Altima"));
        this.assertMatchesStore(altima1);
        Assert.assertThat((Object)altima1.isNew(), (Matcher)Is.is((Object)false));
        AbstractJcrNode hybrid = this.cache.findJcrNode(null, this.path("/Cars/Hybrid"));
        Node child = hybrid.addNode("child");
        Assert.assertThat((Object)hybrid.isModified(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)child.isNew(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)hybrid.hasNode("child"), (Matcher)Is.is((Object)true));
        this.cache.save();
        AbstractJcrNode altima2 = this.cache.findJcrNode(null, this.path("/Cars/Hybrid/Nissan Altima"));
        this.assertMatchesStore(altima2);
        Assert.assertThat((Object)altima1, (Matcher)Is.is((Object)altima2));
        Assert.assertThat((Object)altima1, (Matcher)Is.is((Matcher)IsNot.not((Matcher)IsSame.sameInstance((Object)altima2))));
        Assert.assertThat((Object)altima2.isNew(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)hybrid.hasNode("child"), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldNotExposeUuidPropertyOnNonReferenceableNodes() throws Exception {
        AbstractJcrNode highlander = this.cache.findJcrNode(null, this.path("/Cars/Hybrid/Toyota Highlander"));
        this.assertNotReferenceable(highlander);
    }

    @Test
    public void shouldExposeUuidPropertyOnReferenceableNodes() throws Exception {
        AbstractJcrNode hybrid = this.cache.findJcrNode(null, this.path("/Cars/Hybrid"));
        hybrid.addMixin("mix:referenceable");
        this.assertReferenceable(hybrid);
    }

    @Test
    public void shouldExposeUuidPropertyOnlyWhenNonReferenceableNodeTransitionsToReferenceable() throws Exception {
        AbstractJcrNode highlander = this.cache.findJcrNode(null, this.path("/Cars/Hybrid/Toyota Highlander"));
        this.assertNotReferenceable(highlander);
        highlander.addMixin("mix:referenceable");
        this.assertReferenceable(highlander);
    }

    protected void assertNotReferenceable(AbstractJcrNode node) throws RepositoryException {
        Assert.assertThat((Object)node.isReferenceable(), (Matcher)Is.is((Object)false));
        try {
            node.getUUID();
            Assert.fail((String)"should not return UUID if the node is not referenceable");
        }
        catch (UnsupportedRepositoryOperationException unsupportedRepositoryOperationException) {
            // empty catch block
        }
        Assert.assertThat((Object)node.hasProperty(JcrLexicon.UUID), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)node.getProperty(JcrLexicon.UUID), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    protected void assertReferenceable(AbstractJcrNode node) throws RepositoryException {
        Assert.assertThat((Object)node.isReferenceable(), (Matcher)Is.is((Object)true));
        String uuidValue = null;
        try {
            uuidValue = node.getUUID();
            Assert.assertThat((Object)uuidValue, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        }
        catch (UnsupportedOperationException e) {
            Assert.fail((String)"should return UUID if the node is referenceable");
        }
        Assert.assertThat((Object)node.hasProperty(JcrLexicon.UUID), (Matcher)Is.is((Object)true));
        AbstractJcrProperty uuidProp = node.getProperty(JcrLexicon.UUID);
        Assert.assertThat((Object)uuidProp, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)uuidProp.getString(), (Matcher)Is.is((Object)uuidValue));
    }

    protected void assertProperty(AbstractJcrProperty property, Node node, String name, int propertyType, Object ... values) throws Exception {
        Assert.assertThat((Object)property.getName(), (Matcher)Is.is((Object)name));
        Assert.assertThat((Object)property.getType(), (Matcher)Is.is((Object)propertyType));
        Assert.assertThat((Object)property.getParent(), (Matcher)Is.is((Object)node));
        if (values.length > 1) {
            int i = 0;
            for (Value actual : property.getValues()) {
                String actualString = actual.getString();
                String expectedString = (String)context.getValueFactories().getStringFactory().create(values[i]);
                Assert.assertThat((Object)actualString, (Matcher)Is.is((Object)expectedString));
                this.assertCanObtainValue(actual, propertyType);
                ++i;
            }
            try {
                property.getValue();
                Assert.fail((String)"Should not be able to call Property.getValue() on multi-valued properties");
            }
            catch (ValueFormatException e) {}
        } else {
            String actualString = property.getValue().getString();
            String expectedString = (String)context.getValueFactories().getStringFactory().create(values[0]);
            Assert.assertThat((Object)actualString, (Matcher)Is.is((Object)expectedString));
            Assert.assertThat((Object)actualString, (Matcher)Is.is((Object)property.getString()));
            this.assertCanObtainValue(property.getValue(), propertyType);
            try {
                property.getValues();
                Assert.fail((String)"Should not be able to call Property.getValues() on single-valued properties");
            }
            catch (ValueFormatException e) {
                // empty catch block
            }
            if (propertyType == 9) {
                Node referenced = property.getNode();
                Assert.assertThat((Object)referenced, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assertCanObtainValue(Value value, int expectedType) throws Exception {
        switch (expectedType) {
            case 2: {
                InputStream stream = value.getStream();
                Assert.assertThat((Object)stream, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
                try {
                    stream.read();
                    break;
                }
                finally {
                    stream.close();
                }
            }
            case 6: {
                Assert.assertThat((Object)(value.getBoolean() || !value.getBoolean() ? 1 : 0), (Matcher)Is.is((Object)true));
                break;
            }
            case 5: {
                Calendar cal = value.getDate();
                Assert.assertThat((Object)cal, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
                break;
            }
            case 4: {
                double doubleValue = value.getDouble();
                Assert.assertThat((Object)(doubleValue < 0.0 || doubleValue >= -1.0 ? 1 : 0), (Matcher)Is.is((Object)true));
                break;
            }
            case 3: {
                long longValue = value.getLong();
                Assert.assertThat((Object)(longValue < 0L || longValue >= 0L ? 1 : 0), (Matcher)Is.is((Object)true));
                break;
            }
            case 7: {
                context.getValueFactories().getNameFactory().create(value.getString());
                break;
            }
            case 8: {
                context.getValueFactories().getPathFactory().create(value.getString());
                break;
            }
            case 9: {
                UUID uuid = (UUID)context.getValueFactories().getUuidFactory().create(value.getString());
                Assert.assertThat((Object)uuid, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
                break;
            }
            case 1: {
                value.getString();
            }
        }
    }

    protected void assertMatchesStore(AbstractJcrNode jcrNode) throws RepositoryException {
        GraphSession.Node nodeInfo = this.cache.findNode(jcrNode.nodeId, jcrNode.path());
        org.modeshape.graph.Node dnaNode = this.store.getNodeAt(jcrNode.location);
        Assert.assertThat((Object)nodeInfo.getLocation(), (Matcher)Is.is((Object)dnaNode.getLocation()));
        Set propertyNames = nodeInfo.getPropertyNames();
        for (Name propertyName : propertyNames) {
            GraphSession.PropertyInfo info = nodeInfo.getProperty(propertyName);
            Assert.assertThat((Object)info.getName(), (Matcher)Is.is((Object)propertyName));
            Assert.assertThat((Object)info.getProperty().getName(), (Matcher)Is.is((Object)propertyName));
            Property actual = dnaNode.getProperty(propertyName);
            if (actual != null) {
                Assert.assertThat((Object)info.getProperty().size(), (Matcher)Is.is((Object)actual.size()));
                Assert.assertThat((Object)info.getProperty().getValuesAsArray(), (Matcher)Is.is((Object)actual.getValuesAsArray()));
                continue;
            }
            if (propertyName.equals(JcrLexicon.UUID)) {
                actual = dnaNode.getProperty(ModeShapeLexicon.UUID);
                if (actual != null) {
                    Assert.assertThat((Object)info.getProperty().size(), (Matcher)Is.is((Object)actual.size()));
                    Assert.assertThat((Object)info.getProperty().getValuesAsArray(), (Matcher)Is.is((Object)actual.getValuesAsArray()));
                    continue;
                }
                Assert.fail((String)("missing property \"" + propertyName + "\" on " + dnaNode));
                continue;
            }
            if (propertyName.equals(JcrLexicon.PRIMARY_TYPE) || propertyName.equals(ModeShapeIntLexicon.MULTI_VALUED_PROPERTIES)) continue;
            Assert.fail((String)("missing property \"" + propertyName + "\" on " + dnaNode));
        }
    }
}

