/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.graph.connector.inmemory.InMemoryRepositorySource;
import org.modeshape.jcr.JcrConfiguration;
import org.modeshape.jcr.JcrEngine;
import org.modeshape.jcr.JcrRepository;

public class AnonymousAccessTest {
    private JcrEngine engine;
    private Repository repository;
    private Session session;

    @Before
    public void beforeEach() throws Exception {
        JcrConfiguration config = new JcrConfiguration();
        config.repositorySource("source").usingClass(InMemoryRepositorySource.class);
        config.repository("repo").setSource("source").setOption(JcrRepository.Option.JAAS_LOGIN_CONFIG_NAME, "modeshape-jcr-non-existant");
        this.engine = config.build();
        this.engine.start();
        this.repository = this.engine.getRepository("repo");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void afterEach() throws Exception {
        if (this.session != null) {
            try {
                this.session.logout();
            }
            finally {
                this.session = null;
            }
        }
        this.repository = null;
        try {
            this.engine.shutdown();
        }
        finally {
            this.engine = null;
        }
    }

    @Test
    public void shouldLogInAsAnonymousUsingNoCredentials() throws RepositoryException {
        this.session = this.repository.login();
        this.session.getRootNode().getPath();
        this.session.getRootNode().addNode("someNewNode");
    }
}

