/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.jboss.security.config.IDTrustConfiguration;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.common.util.StringUtil;
import org.modeshape.graph.connector.inmemory.InMemoryRepositorySource;
import org.modeshape.graph.property.Path;
import org.modeshape.jcr.JcrConfiguration;
import org.modeshape.jcr.JcrEngine;
import org.modeshape.jcr.JcrQueryManagerTest;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.repository.ModeShapeConfiguration;

public class JcrImportExportTest {
    private JcrConfiguration configuration;
    private JcrEngine engine;
    private JcrRepository repository;
    private Session session;
    private boolean print;

    @Before
    public void beforeEach() throws Exception {
        this.configuration = new JcrConfiguration();
        ((ModeShapeConfiguration.RepositorySourceDefinition)this.configuration.repositorySource("source").usingClass(InMemoryRepositorySource.class)).setDescription("The content store");
        this.configuration.repository("repo").setSource("source").registerNamespace("car", "http://www.modeshape.org/examples/cars/1.0").addNodeTypes(JcrImportExportTest.resourceUrl("cars.cnd")).setOption(JcrRepository.Option.ANONYMOUS_USER_ROLES, "readonly,readwrite,admin").setOption(JcrRepository.Option.JAAS_LOGIN_CONFIG_NAME, "modeshape-jcr");
        this.engine = this.configuration.build();
        this.engine.start();
        this.repository = this.engine.getRepository("repo");
        this.session = this.repository.login();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void afterEach() throws Exception {
        if (this.session != null) {
            try {
                this.session.logout();
            }
            finally {
                this.session = null;
            }
        }
        if (this.engine != null) {
            try {
                this.engine.shutdown();
                this.engine.awaitTermination(3L, TimeUnit.SECONDS);
            }
            finally {
                this.engine = null;
                this.repository = null;
                this.configuration = null;
            }
        }
    }

    @Test
    public void shouldStartUp() {
        Assert.assertThat((Object)this.session, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldImportCarsSystemViewWithCreateNewBehaviorWhenImportedContentDoesNotContainJcrRoot() throws Exception {
        this.assertImport("io/cars-system-view.xml", "/a/b", ImportBehavior.CREATE_NEW);
        Assert.assertThat((Object)this.session, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertNode("/a/b/Cars");
        this.assertNode("/a/b/Cars/Hybrid");
        this.assertNode("/a/b/Cars/Hybrid/Toyota Prius");
        this.assertNode("/a/b/Cars/Sports/Infiniti G37");
        this.assertNode("/a/b/Cars/Utility/Land Rover LR3");
        this.assertNoNode("/a/b/Cars[2]");
        this.assertNoNode("/a/b/Cars/Hybrid[2]");
        this.assertNoNode("/a/b/Cars/Hybrid/Toyota Prius[2]");
        this.assertNoNode("/a/b/Cars/Sports[2]");
    }

    @Test
    public void shouldImportCarsSystemViewWithRemoveExistingBehaviorWhenImportedContentDoesNotContainJcrRoot() throws Exception {
        this.assertImport("io/cars-system-view.xml", "/a/b", ImportBehavior.REMOVE_EXISTING);
        Assert.assertThat((Object)this.session, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertNode("/a/b/Cars");
        this.assertNode("/a/b/Cars/Hybrid");
        this.assertNode("/a/b/Cars/Hybrid/Toyota Prius");
        this.assertNode("/a/b/Cars/Sports/Infiniti G37");
        this.assertNode("/a/b/Cars/Utility/Land Rover LR3");
        this.assertNoNode("/a/b/Cars[2]");
        this.assertNoNode("/a/b/Cars/Hybrid[2]");
        this.assertNoNode("/a/b/Cars/Hybrid/Toyota Prius[2]");
        this.assertNoNode("/a/b/Cars/Sports[2]");
    }

    @Test
    public void shouldImportCarsSystemViewWithReplaceExistingBehaviorWhenImportedContentDoesNotContainJcrRoot() throws Exception {
        this.assertImport("io/cars-system-view.xml", "/a/b", ImportBehavior.REPLACE_EXISTING);
        Assert.assertThat((Object)this.session, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertNode("/a/b/Cars");
        this.assertNode("/a/b/Cars/Hybrid");
        this.assertNode("/a/b/Cars/Hybrid/Toyota Prius");
        this.assertNode("/a/b/Cars/Sports/Infiniti G37");
        this.assertNode("/a/b/Cars/Utility/Land Rover LR3");
        this.assertNoNode("/a/b/Cars[2]");
        this.assertNoNode("/a/b/Cars/Hybrid[2]");
        this.assertNoNode("/a/b/Cars/Hybrid/Toyota Prius[2]");
        this.assertNoNode("/a/b/Cars/Sports[2]");
    }

    @Test
    public void shouldImportCarsSystemViewWithRemoveExistingBehaviorWhenImportedContentDoesNotContainJcrRootOrAnyUuids() throws Exception {
        this.assertImport("io/cars-system-view.xml", "/a/b", ImportBehavior.CREATE_NEW);
        this.assertNode("/a/b/Cars");
        this.assertNode("/a/b/Cars/Hybrid");
        this.assertNode("/a/b/Cars/Hybrid/Toyota Prius");
        this.assertNode("/a/b/Cars/Sports/Infiniti G37");
        this.assertNode("/a/b/Cars/Utility/Land Rover LR3");
        this.assertNoNode("/a/b/Cars[2]");
        this.assertNoNode("/a/b/Cars/Hybrid[2]");
        this.assertNoNode("/a/b/Cars/Hybrid/Toyota Prius[2]");
        this.assertNoNode("/a/b/Cars/Sports[2]");
        this.assertImport("io/cars-system-view.xml", "/a/b", ImportBehavior.REMOVE_EXISTING);
        Assert.assertThat((Object)this.session, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertNode("/a/b/Cars");
        this.assertNode("/a/b/Cars/Hybrid");
        this.assertNode("/a/b/Cars/Hybrid/Toyota Prius");
        this.assertNode("/a/b/Cars/Sports/Infiniti G37");
        this.assertNode("/a/b/Cars/Utility/Land Rover LR3");
        this.assertNode("/a/b/Cars[2]");
        this.assertNode("/a/b/Cars[2]/Hybrid");
        this.assertNode("/a/b/Cars[2]/Hybrid/Toyota Prius");
        this.assertNode("/a/b/Cars[2]/Sports/Infiniti G37");
        this.assertNode("/a/b/Cars[2]/Utility/Land Rover LR3");
    }

    @Test
    public void shouldImportCarsSystemViewWithCreateNewBehaviorWhenImportedContentDoesNotContainJcrRootButDoesContainUnusedUuids() throws Exception {
        this.assertImport("io/cars-system-view.xml", "/a/b", ImportBehavior.CREATE_NEW);
        this.assertNode("/a/b/Cars");
        this.assertNode("/a/b/Cars/Hybrid");
        this.assertNode("/a/b/Cars/Hybrid/Toyota Prius");
        this.assertNode("/a/b/Cars/Sports/Infiniti G37");
        this.assertNode("/a/b/Cars/Utility/Land Rover LR3");
        this.assertNoNode("/a/b/Cars[2]");
        this.assertNoNode("/a/b/Cars/Hybrid[2]");
        this.assertNoNode("/a/b/Cars/Hybrid/Toyota Prius[2]");
        this.assertNoNode("/a/b/Cars/Sports[2]");
        this.assertImport("io/cars-system-view-with-uuids.xml", "/a/b", ImportBehavior.REPLACE_EXISTING);
        this.print();
        Assert.assertThat((Object)this.session, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertNode("/a/b/Cars");
        this.assertNode("/a/b/Cars/Hybrid");
        this.assertNode("/a/b/Cars/Hybrid/Toyota Prius");
        this.assertNode("/a/b/Cars/Sports/Infiniti G37");
        this.assertNode("/a/b/Cars/Utility/Land Rover LR3");
        this.assertNode("/a/b/Cars[2]");
        this.assertNode("/a/b/Cars[2]/Hybrid");
        this.assertNode("/a/b/Cars[2]/Hybrid/Toyota Prius");
        this.assertNode("/a/b/Cars[2]/Sports");
    }

    @Test
    public void shouldImportCarsSystemViewWithCreateNewBehaviorWhenImportedContentDoesNotContainJcrRootButDoesContainAlreadyUsedUuids() throws Exception {
        this.assertImport("io/cars-system-view-with-uuids.xml", "/a/b", ImportBehavior.CREATE_NEW);
        this.assertNode("/a/b/Cars");
        this.assertNode("/a/b/Cars/Hybrid");
        this.assertNode("/a/b/Cars/Hybrid/Toyota Prius");
        this.assertNode("/a/b/Cars/Sports/Infiniti G37");
        this.assertNode("/a/b/Cars/Utility/Land Rover LR3");
        this.assertNoNode("/a/b/Cars[2]");
        this.assertNoNode("/a/b/Cars/Hybrid[2]");
        this.assertNoNode("/a/b/Cars/Hybrid/Toyota Prius[2]");
        this.assertNoNode("/a/b/Cars/Sports[2]");
        this.assertImport("io/cars-system-view-with-uuids.xml", "/a/b", ImportBehavior.CREATE_NEW);
        this.print();
        Assert.assertThat((Object)this.session, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertNode("/a/b/Cars");
        this.assertNode("/a/b/Cars/Hybrid");
        this.assertNode("/a/b/Cars/Hybrid/Toyota Prius");
        this.assertNode("/a/b/Cars/Sports/Infiniti G37");
        this.assertNode("/a/b/Cars/Utility/Land Rover LR3");
        this.assertNode("/a/b/Cars[2]");
        this.assertNode("/a/b/Cars[2]/Hybrid");
        this.assertNode("/a/b/Cars[2]/Hybrid/Toyota Prius");
        this.assertNode("/a/b/Cars[2]/Sports");
    }

    @Test
    public void shouldImportCarsSystemViewOverExistingContentWhenImportedContentDoesNotContainJcrRootButDoesContainAlreadyUsedUuids() throws Exception {
        this.assertImport("io/cars-system-view-with-uuids.xml", "/a/b", ImportBehavior.CREATE_NEW);
        this.assertNode("/a/b/Cars");
        this.assertNode("/a/b/Cars/Hybrid");
        this.assertNode("/a/b/Cars/Hybrid/Toyota Prius");
        this.assertNode("/a/b/Cars/Sports/Infiniti G37");
        this.assertNode("/a/b/Cars/Utility/Land Rover LR3");
        this.assertNoNode("/a/b/Cars[2]");
        this.assertNoNode("/a/b/Cars/Hybrid[2]");
        this.assertNoNode("/a/b/Cars/Hybrid/Toyota Prius[2]");
        this.assertNoNode("/a/b/Cars/Sports[2]");
        this.assertImport("io/cars-system-view-with-uuids.xml", "/a/b", ImportBehavior.REMOVE_EXISTING);
        this.print();
        Assert.assertThat((Object)this.session, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertNode("/a/b/Cars");
        this.assertNode("/a/b/Cars/Hybrid");
        this.assertNode("/a/b/Cars/Hybrid/Toyota Prius");
        this.assertNode("/a/b/Cars/Sports/Infiniti G37");
        this.assertNode("/a/b/Cars/Utility/Land Rover LR3");
        this.assertNoNode("/a/b/Cars[2]");
        this.assertNoNode("/a/b/Cars/Hybrid[2]");
        this.assertNoNode("/a/b/Cars/Hybrid/Toyota Prius[2]");
        this.assertNoNode("/a/b/Cars/Sports[2]");
        this.assertImport("io/cars-system-view-with-uuids.xml", "/a/b", ImportBehavior.REPLACE_EXISTING);
        this.print();
        Assert.assertThat((Object)this.session, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertNode("/a/b/Cars");
        this.assertNode("/a/b/Cars/Hybrid");
        this.assertNode("/a/b/Cars/Hybrid/Toyota Prius");
        this.assertNode("/a/b/Cars/Sports/Infiniti G37");
        this.assertNode("/a/b/Cars/Utility/Land Rover LR3");
        this.assertNoNode("/a/b/Cars[2]");
        this.assertNoNode("/a/b/Cars/Hybrid[2]");
        this.assertNoNode("/a/b/Cars/Hybrid/Toyota Prius[2]");
        this.assertNoNode("/a/b/Cars/Sports[2]");
    }

    @Test
    public void shouldImportCarsSystemViewWhenImportedContentDoesNotContainJcrRootButDoesContainAlreadyUsedUuids() throws Exception {
        this.assertImport("io/cars-system-view-with-uuids.xml", "/a/b", ImportBehavior.CREATE_NEW);
        this.assertNode("/a/b/Cars");
        this.assertNode("/a/b/Cars/Hybrid");
        this.assertNode("/a/b/Cars/Hybrid/Toyota Prius");
        this.assertNode("/a/b/Cars/Sports/Infiniti G37");
        this.assertNode("/a/b/Cars/Utility/Land Rover LR3");
        this.assertNoNode("/a/b/Cars[2]");
        this.assertNoNode("/a/b/Cars/Hybrid[2]");
        this.assertNoNode("/a/b/Cars/Hybrid/Toyota Prius[2]");
        this.assertNoNode("/a/b/Cars/Sports[2]");
        this.assertImport("io/cars-system-view-with-uuids.xml", "/a/c", ImportBehavior.REPLACE_EXISTING);
        this.print();
        Assert.assertThat((Object)this.session, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertNode("/a/b");
        this.assertNode("/a/c");
        this.assertNode("/a/b/Cars");
        this.assertNode("/a/b/Cars/Hybrid");
        this.assertNode("/a/b/Cars/Hybrid/Toyota Prius");
        this.assertNode("/a/b/Cars/Sports/Infiniti G37");
        this.assertNode("/a/b/Cars/Utility/Land Rover LR3");
        this.assertNoNode("/a/b/Cars[2]");
        this.assertNoNode("/a/b/Cars/Hybrid[2]");
        this.assertNoNode("/a/b/Cars/Hybrid/Toyota Prius[2]");
        this.assertNoNode("/a/b/Cars/Sports[2]");
        this.assertImport("io/cars-system-view-with-uuids.xml", "/a/d", ImportBehavior.REMOVE_EXISTING);
        this.print();
        Assert.assertThat((Object)this.session, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertNode("/a/b");
        this.assertNode("/a/c");
        this.assertNode("/a/d/Cars");
        this.assertNode("/a/d/Cars/Hybrid");
        this.assertNode("/a/d/Cars/Hybrid/Toyota Prius");
        this.assertNode("/a/d/Cars/Sports/Infiniti G37");
        this.assertNode("/a/d/Cars/Utility/Land Rover LR3");
        this.assertNoNode("/a/b/Cars[2]");
        this.assertNoNode("/a/b/Cars/Hybrid[2]");
        this.assertNoNode("/a/b/Cars/Hybrid/Toyota Prius[2]");
        this.assertNoNode("/a/b/Cars/Sports[2]");
    }

    @Test(expected=ItemExistsException.class)
    public void shouldFailToImportCarsSystemViewWithThrowBehaviorWhenImportedContentDoesNotContainJcrRootButDoesContainAlreadyUsedUuids() throws Exception {
        this.assertImport("io/cars-system-view-with-uuids.xml", "/a/b", ImportBehavior.CREATE_NEW);
        this.assertNode("/a/b/Cars");
        this.assertNode("/a/b/Cars/Hybrid");
        this.assertNode("/a/b/Cars/Hybrid/Toyota Prius");
        this.assertNode("/a/b/Cars/Sports/Infiniti G37");
        this.assertNode("/a/b/Cars/Utility/Land Rover LR3");
        this.assertNoNode("/a/b/Cars[2]");
        this.assertNoNode("/a/b/Cars/Hybrid[2]");
        this.assertNoNode("/a/b/Cars/Hybrid/Toyota Prius[2]");
        this.assertNoNode("/a/b/Cars/Sports[2]");
        this.assertImport("io/cars-system-view-with-uuids.xml", "/a/c", ImportBehavior.THROW);
    }

    @Test
    public void shouldImportSystemViewOfEntireWorkspaceWithNoAlreadyUsedUuids() throws Exception {
        this.assertImport("io/full-workspace-system-view-with-uuids.xml", "/", ImportBehavior.THROW);
        this.assertNode("/a/b/Cars");
        this.assertNode("/a/b/Cars/Hybrid");
        this.assertNode("/a/b/Cars/Hybrid/Toyota Prius");
        this.assertNode("/a/b/Cars/Sports/Infiniti G37");
        this.assertNode("/a/b/Cars/Utility/Land Rover LR3");
        this.assertNoNode("/a/b/Cars[2]");
        this.assertNoNode("/a/b/Cars/Hybrid[2]");
        this.assertNoNode("/a/b/Cars/Hybrid/Toyota Prius[2]");
        this.assertNoNode("/a/b/Cars/Sports[2]");
    }

    @Test
    public void shouldImportSystemViewOfEntireWorkspaceExportedFromJackrabbit() throws Exception {
        this.assertImport("io/full-workspace-system-view.xml", "/", ImportBehavior.THROW);
        this.assertNode("/page1");
    }

    @Test
    public void shouldImportDocumentView() throws Exception {
        this.assertImport("io/full-workspace-document-view-with-uuids.xml", "/", ImportBehavior.THROW);
        this.assertNode("/a/b/Cars");
        this.assertNode("/a/b/Cars/Hybrid");
        this.assertNode("/a/b/Cars/Hybrid/Toyota Prius");
        this.assertNode("/a/b/Cars/Sports/Infiniti G37");
        this.assertNode("/a/b/Cars/Utility/Land Rover LR3");
        this.assertNoNode("/a/b/Cars[2]");
        this.assertNoNode("/a/b/Cars/Hybrid[2]");
        this.assertNoNode("/a/b/Cars/Hybrid/Toyota Prius[2]");
        this.assertNoNode("/a/b/Cars/Sports[2]");
    }

    protected Path path(String path) {
        return (Path)this.engine.getExecutionContext().getValueFactories().getPathFactory().create(path);
    }

    protected String relativePath(String path) {
        return !path.startsWith("/") ? path : path.substring(1);
    }

    protected String asString(Object value) {
        return (String)this.engine.getExecutionContext().getValueFactories().getStringFactory().create(value);
    }

    protected void assertNode(String path) throws RepositoryException {
        String relativePath = this.relativePath(path);
        Node root = this.session.getRootNode();
        if (relativePath.trim().length() == 0) {
            Assert.assertThat((Object)root, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
            return;
        }
        if (this.print && !root.hasNode(relativePath)) {
            Node parent = root;
            int depth = 0;
            for (Path.Segment segment : this.path(path)) {
                if (!parent.hasNode(this.asString(segment))) {
                    System.out.println("Unable to find '" + path + "'; lowest node is '" + parent.getPath() + "'");
                    break;
                }
                parent = parent.getNode(this.asString(segment));
                ++depth;
            }
        }
        Assert.assertThat((Object)root.hasNode(relativePath), (Matcher)Is.is((Object)true));
    }

    protected void assertNoNode(String path) throws RepositoryException {
        Assert.assertThat((Object)this.session.getRootNode().hasNode(this.relativePath(path)), (Matcher)Is.is((Object)false));
    }

    protected Node assertImport(String resourceName, String pathToParent, ImportBehavior behavior) throws RepositoryException, IOException {
        InputStream istream = JcrImportExportTest.resourceStream(resourceName);
        return this.assertImport(istream, pathToParent, behavior);
    }

    protected Node assertImport(File resource, String pathToParent, ImportBehavior behavior) throws RepositoryException, IOException {
        FileInputStream istream = new FileInputStream(resource);
        return this.assertImport(istream, pathToParent, behavior);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Node assertImport(InputStream istream, String pathToParent, ImportBehavior behavior) throws RepositoryException, IOException {
        Path parentPath = this.path(pathToParent);
        Assert.assertThat((Object)parentPath.isAbsolute(), (Matcher)Is.is((Object)true));
        Node node = this.session.getRootNode();
        boolean found = true;
        for (Path.Segment segment : parentPath) {
            String name = this.asString(segment);
            if (found) {
                try {
                    node = node.getNode(name);
                    found = true;
                }
                catch (PathNotFoundException e) {
                    found = false;
                }
            }
            if (found) continue;
            node = node.addNode(name, "nt:unstructured");
        }
        if (!found) {
            this.session.save();
        }
        this.assertNode(pathToParent);
        Assert.assertThat((Object)istream, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        try {
            this.session.getWorkspace().importXML(pathToParent, istream, behavior.getJcrValue());
        }
        finally {
            istream.close();
        }
        this.session.save();
        return node;
    }

    protected void addMixinRecursively(String path, String ... nodeTypes) throws RepositoryException {
        Node node = this.session.getRootNode().getNode(this.relativePath(path));
        this.addMixin(node, true, nodeTypes);
    }

    protected Node addMixin(String path, String ... nodeTypes) throws RepositoryException {
        Node node = this.session.getRootNode().getNode(this.relativePath(path));
        return this.addMixin(node, false, nodeTypes);
    }

    protected Node addMixin(Node node, boolean recursive, String ... nodeTypes) throws RepositoryException {
        Assert.assertThat((Object)node, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        for (String nodeType : nodeTypes) {
            if (this.hasMixin(node, nodeType)) continue;
            node.addMixin(nodeType);
        }
        if (recursive) {
            NodeIterator children = node.getNodes();
            while (children.hasNext()) {
                this.addMixin(children.nextNode(), true, nodeTypes);
            }
        }
        return node;
    }

    protected boolean hasMixin(Node node, String mixinNodeType) throws RepositoryException {
        for (NodeType mixin : node.getMixinNodeTypes()) {
            if (!mixin.getName().equals(mixinNodeType)) continue;
            return true;
        }
        return false;
    }

    protected void print() throws RepositoryException {
        this.print(this.session.getRootNode(), true);
    }

    protected void print(String path) throws RepositoryException {
        Node node = this.session.getRootNode().getNode(this.relativePath(path));
        this.print(node, true);
    }

    protected void print(Node node, boolean includeSystem) throws RepositoryException {
        if (this.print) {
            if (!includeSystem && node.getPath().equals("/jcr:system")) {
                return;
            }
            if (node.getDepth() != 0) {
                int snsIndex = node.getIndex();
                String segment = node.getName() + (snsIndex > 1 ? "[" + snsIndex + "]" : "");
                System.out.println(StringUtil.createString((char)' ', (int)(2 * node.getDepth())) + '/' + segment);
            }
            NodeIterator children = node.getNodes();
            while (children.hasNext()) {
                this.print(children.nextNode(), includeSystem);
            }
        }
    }

    protected File export(String pathToParent) throws IOException, RepositoryException {
        this.assertNode(pathToParent);
        File tmp = File.createTempFile("JcrImportExportText-", "");
        FileOutputStream ostream = new FileOutputStream(tmp);
        boolean skipBinary = false;
        boolean noRecurse = false;
        this.session.exportSystemView(pathToParent, (OutputStream)ostream, skipBinary, noRecurse);
        return tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportDocumentView(String pathToParent, OutputStream ostream) throws RepositoryException, IOException {
        boolean skipBinary = false;
        boolean noRecurse = false;
        try {
            this.session.exportDocumentView(pathToParent, ostream, skipBinary, noRecurse);
        }
        finally {
            ostream.close();
        }
    }

    protected static URI resourceUri(String name) throws URISyntaxException {
        return JcrImportExportTest.resourceUrl(name).toURI();
    }

    protected static URL resourceUrl(String name) {
        return JcrQueryManagerTest.class.getClassLoader().getResource(name);
    }

    protected static InputStream resourceStream(String name) {
        return JcrQueryManagerTest.class.getClassLoader().getResourceAsStream(name);
    }

    static {
        String configFile = "security/jaas.conf.xml";
        IDTrustConfiguration idtrustConfig = new IDTrustConfiguration();
        try {
            idtrustConfig.config(configFile);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    protected static enum ImportBehavior {
        CREATE_NEW(0),
        REPLACE_EXISTING(2),
        REMOVE_EXISTING(1),
        THROW(3);

        private final int jcrValue;

        private ImportBehavior(int value) {
            this.jcrValue = value;
        }

        public int getJcrValue() {
            return this.jcrValue;
        }
    }
}

