/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.Arrays;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.graph.Graph;
import org.modeshape.graph.JcrNtLexicon;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.basic.BasicName;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.AbstractSessionTest;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.JcrMixLexicon;
import org.modeshape.jcr.JcrNodeDefinitionTemplate;
import org.modeshape.jcr.JcrNodeTypeTemplate;
import org.modeshape.jcr.JcrPropertyDefinitionTemplate;
import org.modeshape.jcr.nodetype.NodeTypeTemplate;

public class MixinTest
extends AbstractSessionTest {
    static final Name MIXIN_TYPE_A = new BasicName("", "mixinTypeA");
    static final Name MIXIN_TYPE_B = new BasicName("", "mixinTypeB");
    static final Name MIXIN_TYPE_C = new BasicName("", "mixinTypeC");
    static final Name MIXIN_TYPE_WITH_AUTO_PROP = new BasicName("", "mixinTypeWithAutoCreatedProperty");
    static final Name MIXIN_TYPE_WITH_AUTO_CHILD = new BasicName("", "mixinTypeWithAutoCreatedChildNode");
    static final Name PRIMARY_TYPE_A = new BasicName("", "primaryTypeA");
    static final Name PROPERTY_A = new BasicName("", "propertyA");
    static final Name PROPERTY_B = new BasicName("", "propertyB");
    static final Name CHILD_NODE_A = new BasicName("", "nodeA");
    static final Name CHILD_NODE_B = new BasicName("", "nodeB");

    @Override
    @Before
    public void beforeEach() throws Exception {
        super.beforeEach();
    }

    @After
    public void after() throws Exception {
        if (this.session != null && this.session.isLive()) {
            this.session.logout();
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowNullMixinTypeName() throws Exception {
        this.graph.create("/a").and();
        ((Graph.SetValuesTo)this.graph.set("jcr:primaryType").on("/a")).to(PRIMARY_TYPE_A);
        AbstractJcrNode rootNode = this.session.getRootNode();
        Node nodeA = rootNode.getNode("a");
        nodeA.canAddMixin(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowEmptyMixinTypeName() throws Exception {
        this.graph.create("/a").and();
        ((Graph.SetValuesTo)this.graph.set("jcr:primaryType").on("/a")).to(PRIMARY_TYPE_A);
        AbstractJcrNode rootNode = this.session.getRootNode();
        Node nodeA = rootNode.getNode("a");
        nodeA.canAddMixin("");
    }

    @Test(expected=NoSuchNodeTypeException.class)
    public void shouldNotAllowInvalidMixinTypeName() throws Exception {
        this.graph.create("/a").and();
        ((Graph.SetValuesTo)this.graph.set(JcrLexicon.PRIMARY_TYPE.getString(this.registry)).on("/a")).to(PRIMARY_TYPE_A);
        AbstractJcrNode rootNode = this.session.getRootNode();
        Node nodeA = rootNode.getNode("a");
        nodeA.canAddMixin("foo");
    }

    @Test
    public void shouldNotAllowAddingMixinToProtectedNodes() throws Exception {
        AbstractJcrNode rootNode = this.session.getRootNode();
        Node systemNode = rootNode.getNode(JcrLexicon.SYSTEM.getString(this.registry));
        Assert.assertThat((Object)systemNode.getDefinition().isProtected(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)systemNode.canAddMixin(JcrMixLexicon.VERSIONABLE.getString(this.registry)), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldAllowAddingMixinIfNoConflict() throws Exception {
        this.graph.create("/a").and();
        ((Graph.SetValuesTo)this.graph.set(JcrLexicon.PRIMARY_TYPE.getString(this.registry)).on("/a")).to(PRIMARY_TYPE_A);
        ((Graph.SetValuesTo)this.graph.set(JcrLexicon.MIXIN_TYPES.getString(this.registry)).on("/a")).to(JcrMixLexicon.REFERENCEABLE.getString(this.registry));
        AbstractJcrNode rootNode = this.session.getRootNode();
        Node nodeA = rootNode.getNode("a");
        Assert.assertThat((Object)nodeA.canAddMixin(MIXIN_TYPE_B.getString(this.registry)), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldNotAllowAddingMixinIfPrimaryTypeConflicts() throws Exception {
        this.graph.create("/a").and();
        ((Graph.SetValuesTo)this.graph.set(JcrLexicon.PRIMARY_TYPE.getString(this.registry)).on("/a")).to(PRIMARY_TYPE_A);
        ((Graph.SetValuesTo)this.graph.set(JcrLexicon.MIXIN_TYPES.getString(this.registry)).on("/a")).to(JcrMixLexicon.REFERENCEABLE.getString(this.registry));
        AbstractJcrNode rootNode = this.session.getRootNode();
        Node nodeA = rootNode.getNode("a");
        Assert.assertThat((Object)nodeA.canAddMixin(MIXIN_TYPE_C.getString(this.registry)), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldNotAllowAddingMixinIfMixinTypeConflicts() throws Exception {
        this.graph.create("/a").and();
        ((Graph.SetValuesTo)this.graph.set(JcrLexicon.PRIMARY_TYPE.getString(this.registry)).on("/a")).to(JcrNtLexicon.BASE.getString(this.registry));
        ((Graph.SetValuesTo)this.graph.set(JcrLexicon.MIXIN_TYPES.getString(this.registry)).on("/a")).to(MIXIN_TYPE_B);
        AbstractJcrNode rootNode = this.session.getRootNode();
        Node nodeA = rootNode.getNode("a");
        Assert.assertThat((Object)nodeA.canAddMixin(MIXIN_TYPE_C.getString(this.registry)), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldAutoCreateAutoCreatedPropertiesOnAddition() throws Exception {
        this.graph.create("/a").and();
        ((Graph.SetValuesTo)this.graph.set(JcrLexicon.PRIMARY_TYPE.getString(this.registry)).on("/a")).to(JcrNtLexicon.BASE.getString(this.registry));
        AbstractJcrNode rootNode = this.session.getRootNode();
        Node nodeA = rootNode.getNode("a");
        Assert.assertThat((Object)nodeA.canAddMixin(MIXIN_TYPE_WITH_AUTO_PROP.getString(this.registry)), (Matcher)Is.is((Object)true));
        nodeA.addMixin(MIXIN_TYPE_WITH_AUTO_PROP.getString(this.registry));
        Property prop = nodeA.getProperty(PROPERTY_B.getString(this.registry));
        Assert.assertThat((Object)prop, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)prop.getLong(), (Matcher)Is.is((Object)10L));
    }

    @Test
    public void shouldAutoCreateAutoCreatedChildNodesOnAddition() throws Exception {
        this.graph.create("/a").and();
        ((Graph.SetValuesTo)this.graph.set(JcrLexicon.PRIMARY_TYPE.getString(this.registry)).on("/a")).to(JcrNtLexicon.BASE.getString(this.registry));
        AbstractJcrNode rootNode = this.session.getRootNode();
        Node nodeA = rootNode.getNode("a");
        Assert.assertThat((Object)nodeA.canAddMixin(MIXIN_TYPE_WITH_AUTO_CHILD.getString(this.registry)), (Matcher)Is.is((Object)true));
        nodeA.addMixin(MIXIN_TYPE_WITH_AUTO_CHILD.getString(this.registry));
        Node childNode = nodeA.getNode(CHILD_NODE_B.getString(this.registry));
        Assert.assertThat((Object)childNode, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)childNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)JcrNtLexicon.UNSTRUCTURED.getString(this.registry)));
    }

    @Test(expected=ConstraintViolationException.class)
    public void shouldNotAllowAdditionIfResidualPropertyConflicts() throws Exception {
        this.graph.create("/a").and();
        ((Graph.SetValuesTo)this.graph.set(JcrLexicon.PRIMARY_TYPE.getString(this.registry)).on("/a")).to(JcrNtLexicon.UNSTRUCTURED.getString(this.registry));
        AbstractJcrNode rootNode = this.session.getRootNode();
        Node nodeA = rootNode.getNode("a");
        nodeA.setProperty(PROPERTY_B.getString(this.registry), "Not a boolean");
        Assert.assertThat((Object)nodeA.canAddMixin(MIXIN_TYPE_WITH_AUTO_PROP.getString(this.registry)), (Matcher)Is.is((Object)false));
        nodeA.addMixin(MIXIN_TYPE_WITH_AUTO_PROP.getString(this.registry));
    }

    @Test
    public void shouldAllowAdditionIfResidualPropertyDoesNotConflict() throws Exception {
        this.graph.create("/a").and();
        ((Graph.SetValuesTo)this.graph.set(JcrLexicon.PRIMARY_TYPE.getString(this.registry)).on("/a")).to(JcrNtLexicon.UNSTRUCTURED.getString(this.registry));
        AbstractJcrNode rootNode = this.session.getRootNode();
        Node nodeA = rootNode.getNode("a");
        nodeA.setProperty(PROPERTY_B.getString(this.registry), 10L);
        Assert.assertThat((Object)nodeA.canAddMixin(MIXIN_TYPE_WITH_AUTO_PROP.getString(this.registry)), (Matcher)Is.is((Object)true));
        nodeA.addMixin(MIXIN_TYPE_WITH_AUTO_PROP.getString(this.registry));
    }

    @Test(expected=ConstraintViolationException.class)
    public void shouldNotAllowAdditionIfResidualChildNodeConflicts() throws Exception {
        ((Graph)this.graph.create("/a").and()).create("/a/" + CHILD_NODE_B).and();
        ((Graph.SetValuesTo)this.graph.set(JcrLexicon.PRIMARY_TYPE.getString(this.registry)).on("/a")).to(JcrNtLexicon.UNSTRUCTURED.getString(this.registry));
        ((Graph.SetValuesTo)this.graph.set(JcrLexicon.PRIMARY_TYPE.getString(this.registry)).on("/a/" + CHILD_NODE_B)).to(JcrNtLexicon.BASE.getString(this.registry));
        AbstractJcrNode rootNode = this.session.getRootNode();
        Node nodeA = rootNode.getNode("a");
        Assert.assertThat((Object)nodeA.canAddMixin(MIXIN_TYPE_WITH_AUTO_CHILD.getString(this.registry)), (Matcher)Is.is((Object)false));
        nodeA.addMixin(MIXIN_TYPE_WITH_AUTO_CHILD.getString(this.registry));
    }

    @Test
    public void shouldAllowAdditionIfResidualChildNodeDoesNotConflict() throws Exception {
        ((Graph)this.graph.create("/a").and()).create("/a/" + CHILD_NODE_B).and();
        ((Graph.SetValuesTo)this.graph.set(JcrLexicon.PRIMARY_TYPE.getString(this.registry)).on("/a")).to(JcrNtLexicon.UNSTRUCTURED.getString(this.registry));
        ((Graph.SetValuesTo)this.graph.set(JcrLexicon.PRIMARY_TYPE.getString(this.registry)).on("/a/" + CHILD_NODE_B)).to(JcrNtLexicon.UNSTRUCTURED.getString(this.registry));
        AbstractJcrNode rootNode = this.session.getRootNode();
        Node nodeA = rootNode.getNode("a");
        Assert.assertThat((Object)nodeA.canAddMixin(MIXIN_TYPE_WITH_AUTO_CHILD.getString(this.registry)), (Matcher)Is.is((Object)true));
        nodeA.addMixin(MIXIN_TYPE_WITH_AUTO_CHILD.getString(this.registry));
        nodeA.save();
        AbstractJcrNode newRootNode = this.session.getRootNode();
        Node newNodeA = newRootNode.getNode("a");
        Node newNodeB = newNodeA.getNode(CHILD_NODE_B.getString(this.registry));
        Assert.assertThat((Object)newNodeA.isNodeType(MIXIN_TYPE_WITH_AUTO_CHILD.getLocalName()), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)newNodeB.isNodeType("nt:unstructured"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)newNodeB, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldAllowSettingNewPropertyAfterAddingMixin() throws Exception {
        this.graph.create("/a").and();
        ((Graph.SetValuesTo)this.graph.set(JcrLexicon.PRIMARY_TYPE.getString(this.registry)).on("/a")).to(PRIMARY_TYPE_A);
        ((Graph.SetValuesTo)this.graph.set(JcrLexicon.MIXIN_TYPES.getString(this.registry)).on("/a")).to(JcrMixLexicon.REFERENCEABLE.getString(this.registry));
        AbstractJcrNode rootNode = this.session.getRootNode();
        Node nodeA = rootNode.getNode("a");
        Assert.assertThat((Object)nodeA.canAddMixin(MIXIN_TYPE_B.getString(this.registry)), (Matcher)Is.is((Object)true));
        nodeA.addMixin(MIXIN_TYPE_B.getString(this.registry));
        nodeA.setProperty(PROPERTY_B.getString(this.registry), "some string");
        nodeA.save();
        rootNode = this.session.getRootNode();
        nodeA = rootNode.getNode("a");
        Property propB = nodeA.getProperty(PROPERTY_B.getString(this.registry));
        Assert.assertThat((Object)propB, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)propB.getValue().getString(), (Matcher)Is.is((Object)"some string"));
    }

    @Test
    public void shouldAllowAddingNewChildNodeAfterAddingMixin() throws Exception {
        this.graph.create("/a").and();
        ((Graph.SetValuesTo)this.graph.set(JcrLexicon.PRIMARY_TYPE.getString(this.registry)).on("/a")).to(PRIMARY_TYPE_A);
        ((Graph.SetValuesTo)this.graph.set(JcrLexicon.MIXIN_TYPES.getString(this.registry)).on("/a")).to(JcrMixLexicon.REFERENCEABLE.getString(this.registry));
        AbstractJcrNode rootNode = this.session.getRootNode();
        Node nodeA = rootNode.getNode("a");
        Assert.assertThat((Object)nodeA.canAddMixin(MIXIN_TYPE_B.getString(this.registry)), (Matcher)Is.is((Object)true));
        nodeA.addMixin(MIXIN_TYPE_B.getString(this.registry));
        nodeA.addNode(CHILD_NODE_B.getString(this.registry));
        nodeA.save();
        AbstractJcrNode newRootNode = this.session.getRootNode();
        Node newNodeA = newRootNode.getNode("a");
        Node newNodeB = newNodeA.getNode(CHILD_NODE_B.getString(this.registry));
        Assert.assertThat((Object)newNodeB, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)newNodeB.getDefinition().getDeclaringNodeType().getName(), (Matcher)Is.is((Object)MIXIN_TYPE_B.getString(this.registry)));
    }

    @Test
    public void shouldAllowRemovalIfNoConflict() throws Exception {
        ((Graph)this.graph.create("/a").and()).create("/a/nodeB");
        ((Graph.SetValuesTo)this.graph.set(JcrLexicon.PRIMARY_TYPE.getString(this.registry)).on("/a")).to(JcrNtLexicon.UNSTRUCTURED);
        ((Graph.SetValuesTo)this.graph.set(JcrLexicon.MIXIN_TYPES.getString(this.registry)).on("/a")).to(MIXIN_TYPE_B);
        AbstractJcrNode rootNode = this.session.getRootNode();
        Node nodeA = rootNode.getNode("a");
        nodeA.removeMixin(MIXIN_TYPE_B.getString(this.registry));
        nodeA.save();
        rootNode = this.session.getRootNode();
        nodeA = rootNode.getNode("a");
        Assert.assertThat((Object)nodeA.getMixinNodeTypes().length, (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldAllowRemovalIfExistingPropertyWouldHaveDefinition() throws Exception {
        ((Graph)this.graph.create("/a").and()).create("/a");
        ((Graph.SetValuesTo)this.graph.set(PROPERTY_B).on("/a")).to("true");
        ((Graph.SetValuesTo)this.graph.set(JcrLexicon.PRIMARY_TYPE.getString(this.registry)).on("/a")).to(JcrNtLexicon.UNSTRUCTURED);
        ((Graph.SetValuesTo)this.graph.set(JcrLexicon.MIXIN_TYPES.getString(this.registry)).on("/a")).to(MIXIN_TYPE_B);
        AbstractJcrNode rootNode = this.session.getRootNode();
        Node nodeA = rootNode.getNode("a");
        nodeA.removeMixin(MIXIN_TYPE_B.getString(this.registry));
        nodeA.save();
        rootNode = this.session.getRootNode();
        nodeA = rootNode.getNode("a");
        Assert.assertThat((Object)nodeA.getMixinNodeTypes().length, (Matcher)Is.is((Object)0));
    }

    @Test(expected=ConstraintViolationException.class)
    public void shouldNotAllowRemovalIfExistingPropertyWouldHaveNoDefinition() throws Exception {
        ((Graph)this.graph.create("/a").and()).create("/a");
        ((Graph.SetValuesTo)this.graph.set(PROPERTY_B).on("/a")).to("true");
        ((Graph.SetValuesTo)this.graph.set(JcrLexicon.PRIMARY_TYPE.getString(this.registry)).on("/a")).to(PRIMARY_TYPE_A);
        ((Graph.SetValuesTo)this.graph.set(JcrLexicon.MIXIN_TYPES.getString(this.registry)).on("/a")).to(MIXIN_TYPE_B);
        AbstractJcrNode rootNode = this.session.getRootNode();
        Node nodeA = rootNode.getNode("a");
        nodeA.removeMixin(MIXIN_TYPE_B.getString(this.registry));
        nodeA.save();
        rootNode = this.session.getRootNode();
        nodeA = rootNode.getNode("a");
        Assert.assertThat((Object)nodeA.getMixinNodeTypes().length, (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldAllowRemovalIfExistingChildNodeWouldHaveDefinition() throws Exception {
        ((Graph)this.graph.create("/a").and()).create("/a/nodeB");
        ((Graph.SetValuesTo)this.graph.set(JcrLexicon.PRIMARY_TYPE.getString(this.registry)).on("/a")).to(JcrNtLexicon.UNSTRUCTURED);
        ((Graph.SetValuesTo)this.graph.set(JcrLexicon.MIXIN_TYPES.getString(this.registry)).on("/a")).to(MIXIN_TYPE_B);
        AbstractJcrNode rootNode = this.session.getRootNode();
        Node nodeA = rootNode.getNode("a");
        nodeA.removeMixin(MIXIN_TYPE_B.getString(this.registry));
    }

    @Test(expected=ConstraintViolationException.class)
    public void shouldNotAllowRemovalIfExistingChildNodeWouldHaveNoDefinition() throws Exception {
        ((Graph)this.graph.create("/a").and()).create("/a/nodeB").and();
        ((Graph.SetValuesTo)this.graph.set(JcrLexicon.PRIMARY_TYPE.getString(this.registry)).on("/a")).to(PRIMARY_TYPE_A);
        ((Graph.SetValuesTo)this.graph.set(JcrLexicon.MIXIN_TYPES.getString(this.registry)).on("/a")).to(MIXIN_TYPE_B);
        AbstractJcrNode rootNode = this.session.getRootNode();
        Node nodeA = rootNode.getNode("a");
        nodeA.removeMixin(MIXIN_TYPE_B.getString(this.registry));
    }

    @Override
    protected List<NodeTypeTemplate> getTestTypes() {
        JcrNodeTypeTemplate mixinTypeA = new JcrNodeTypeTemplate(this.context);
        mixinTypeA.setName("mixinTypeA");
        mixinTypeA.setMixin(true);
        JcrNodeDefinitionTemplate childNodeA = new JcrNodeDefinitionTemplate(this.context);
        childNodeA.setName("nodeA");
        childNodeA.setOnParentVersion(5);
        mixinTypeA.getNodeDefinitionTemplates().add(childNodeA);
        JcrPropertyDefinitionTemplate propertyA = new JcrPropertyDefinitionTemplate(this.context);
        propertyA.setName("propertyA");
        propertyA.setOnParentVersion(5);
        propertyA.setRequiredType(1);
        mixinTypeA.getPropertyDefinitionTemplates().add(propertyA);
        JcrNodeTypeTemplate mixinTypeB = new JcrNodeTypeTemplate(this.context);
        mixinTypeB.setName("mixinTypeB");
        mixinTypeB.setMixin(true);
        JcrNodeDefinitionTemplate childNodeB = new JcrNodeDefinitionTemplate(this.context);
        childNodeB.setName("nodeB");
        childNodeB.setDefaultPrimaryType("nt:base");
        childNodeB.setOnParentVersion(5);
        mixinTypeB.getNodeDefinitionTemplates().add(childNodeB);
        JcrPropertyDefinitionTemplate propertyB = new JcrPropertyDefinitionTemplate(this.context);
        propertyB.setName("propertyB");
        propertyB.setOnParentVersion(5);
        propertyB.setRequiredType(2);
        mixinTypeB.getPropertyDefinitionTemplates().add(propertyB);
        JcrNodeTypeTemplate mixinTypeC = new JcrNodeTypeTemplate(this.context);
        mixinTypeC.setName("mixinTypeC");
        mixinTypeC.setMixin(true);
        childNodeA = new JcrNodeDefinitionTemplate(this.context);
        childNodeA.setName("nodeA");
        childNodeA.setOnParentVersion(5);
        mixinTypeC.getNodeDefinitionTemplates().add(childNodeA);
        propertyB = new JcrPropertyDefinitionTemplate(this.context);
        propertyB.setName("propertyB");
        propertyB.setOnParentVersion(5);
        propertyB.setRequiredType(1);
        mixinTypeC.getPropertyDefinitionTemplates().add(propertyB);
        JcrNodeTypeTemplate mixinTypeWithAutoChild = new JcrNodeTypeTemplate(this.context);
        mixinTypeWithAutoChild.setName("mixinTypeWithAutoCreatedChildNode");
        mixinTypeWithAutoChild.setMixin(true);
        childNodeB = new JcrNodeDefinitionTemplate(this.context);
        childNodeB.setName("nodeB");
        childNodeB.setOnParentVersion(5);
        childNodeB.setMandatory(true);
        childNodeB.setAutoCreated(true);
        childNodeB.setDefaultPrimaryType("nt:unstructured");
        childNodeB.setRequiredPrimaryTypes(new String[]{"nt:unstructured"});
        mixinTypeWithAutoChild.getNodeDefinitionTemplates().add(childNodeB);
        JcrNodeTypeTemplate mixinTypeWithAutoProperty = new JcrNodeTypeTemplate(this.context);
        mixinTypeWithAutoProperty.setName("mixinTypeWithAutoCreatedProperty");
        mixinTypeWithAutoProperty.setMixin(true);
        propertyB = new JcrPropertyDefinitionTemplate(this.context);
        propertyB.setName("propertyB");
        propertyB.setMandatory(true);
        propertyB.setAutoCreated(true);
        propertyB.setOnParentVersion(5);
        propertyB.setRequiredType(3);
        propertyB.setDefaultValues(new String[]{"10"});
        mixinTypeWithAutoProperty.getPropertyDefinitionTemplates().add(propertyB);
        JcrNodeTypeTemplate primaryTypeA = new JcrNodeTypeTemplate(this.context);
        primaryTypeA.setName("primaryTypeA");
        childNodeA = new JcrNodeDefinitionTemplate(this.context);
        childNodeA.setName("nodeA");
        childNodeA.setOnParentVersion(5);
        primaryTypeA.getNodeDefinitionTemplates().add(childNodeA);
        propertyA = new JcrPropertyDefinitionTemplate(this.context);
        propertyA.setName("propertyA");
        propertyA.setOnParentVersion(5);
        propertyA.setRequiredType(1);
        primaryTypeA.getPropertyDefinitionTemplates().add(propertyA);
        return Arrays.asList(mixinTypeA, mixinTypeB, mixinTypeC, mixinTypeWithAutoChild, mixinTypeWithAutoProperty, primaryTypeA);
    }
}

