/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyType;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.version.OnParentVersionAction;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.graph.Graph;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.AbstractSessionTest;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.JcrMixLexicon;
import org.modeshape.jcr.JcrNodeDefinition;
import org.modeshape.jcr.JcrNodeType;
import org.modeshape.jcr.JcrNtLexicon;
import org.modeshape.jcr.JcrPropertyDefinition;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.ModeShapeLexicon;

public class RepositoryNodeTypeManagerTest
extends AbstractSessionTest {
    @Override
    @Before
    public void beforeEach() throws Exception {
        super.beforeEach();
    }

    @Override
    protected void initializeContent() {
        super.initializeContent();
        ((Graph)((Graph)this.graph.create("/a").and()).create("/a/b").and()).create("/a/b/c").and();
        ((Graph.SetValuesTo)this.graph.set("jcr:mixinTypes").on("/a")).to(JcrMixLexicon.REFERENCEABLE);
    }

    @Override
    protected void initializeOptions() {
        this.options = new EnumMap(JcrRepository.Option.class);
        this.options.put(JcrRepository.Option.PROJECT_NODE_TYPES, Boolean.TRUE.toString());
    }

    @After
    public void after() throws Exception {
        if (this.session != null && this.session.isLive()) {
            this.session.logout();
        }
    }

    @Test
    public void shouldOnlyHaveOneDnaNamespacesNode() throws Exception {
        NamespaceRegistry registry = this.context.getNamespaceRegistry();
        AbstractJcrNode rootNode = this.session.getRootNode();
        Assert.assertThat((Object)rootNode, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Node systemNode = rootNode.getNode(JcrLexicon.SYSTEM.getString(registry));
        Assert.assertThat((Object)systemNode, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        NodeIterator namespacesNodes = systemNode.getNodes(ModeShapeLexicon.NAMESPACES.getString(registry));
        Assert.assertEquals((long)namespacesNodes.getSize(), (long)1L);
    }

    @Test
    public void shouldOnlyHaveOneNodeTypesNode() throws Exception {
        NamespaceRegistry registry = this.context.getNamespaceRegistry();
        AbstractJcrNode rootNode = this.session.getRootNode();
        Assert.assertThat((Object)rootNode, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Node systemNode = rootNode.getNode(JcrLexicon.SYSTEM.getString(registry));
        Assert.assertThat((Object)systemNode, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        NodeIterator nodeTypesNodes = systemNode.getNodes(JcrLexicon.NODE_TYPES.getString(registry));
        Assert.assertEquals((long)1L, (long)nodeTypesNodes.getSize());
    }

    @Test
    public void shouldAllowMultipleSiblingsDefinitionIfOneSibling() throws Exception {
        NamespaceRegistry registry = this.context.getNamespaceRegistry();
        JcrNodeDefinition def = this.repoTypeManager.findChildNodeDefinition(JcrNtLexicon.NODE_TYPE, Collections.emptyList(), JcrLexicon.PROPERTY_DEFINITION, JcrNtLexicon.PROPERTY_DEFINITION, 1, false);
        Assert.assertThat((Object)def, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertEquals((Object)def.getName(), (Object)JcrLexicon.PROPERTY_DEFINITION.getString(registry));
    }

    public void shouldProjectOntoWorkspaceGraph() throws Exception {
        NamespaceRegistry registry = this.context.getNamespaceRegistry();
        AbstractJcrNode rootNode = this.session.getRootNode();
        Assert.assertThat((Object)rootNode, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Node systemNode = rootNode.getNode(JcrLexicon.SYSTEM.getString(registry));
        Assert.assertThat((Object)systemNode, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Node typesNode = systemNode.getNode(ModeShapeLexicon.NODE_TYPES.getString(registry));
        Assert.assertThat((Object)typesNode, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Collection allNodeTypes = this.repoTypeManager.getAllNodeTypes();
        Assert.assertThat((Object)allNodeTypes.size(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        for (JcrNodeType nodeType : allNodeTypes) {
            Node typeNode = typesNode.getNode(nodeType.getName());
            this.compareNodeTypes(nodeType, typeNode, registry);
        }
    }

    private void compareNodeTypes(JcrNodeType nodeType, Node typeNode, NamespaceRegistry registry) throws Exception {
        Assert.assertThat((Object)nodeType.isMixin(), (Matcher)Is.is((Object)typeNode.getProperty(JcrLexicon.IS_MIXIN.getString(registry)).getBoolean()));
        Assert.assertThat((Object)nodeType.hasOrderableChildNodes(), (Matcher)Is.is((Object)typeNode.getProperty(JcrLexicon.HAS_ORDERABLE_CHILD_NODES.getString(registry)).getBoolean()));
        try {
            Assert.assertThat((Object)nodeType.getPrimaryItemName(), (Matcher)Is.is((Object)typeNode.getProperty(JcrLexicon.PRIMARY_ITEM_NAME.getString(registry)).getString()));
        }
        catch (PathNotFoundException pnfe) {
            Assert.assertThat((Object)nodeType.getPrimaryItemName(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        }
        Assert.assertThat((Object)nodeType.getName(), (Matcher)Is.is((Object)typeNode.getProperty(JcrLexicon.NODE_TYPE_NAME.getString(registry)).getString()));
        JcrNodeType[] supertypesFromManager = nodeType.getDeclaredSupertypes();
        Value[] supertypesFromGraph = new Value[]{};
        try {
            supertypesFromGraph = typeNode.getProperty(JcrLexicon.SUPERTYPES.getString(registry)).getValues();
        }
        catch (PathNotFoundException pnfe) {
            // empty catch block
        }
        Assert.assertThat((Object)supertypesFromGraph.length, (Matcher)Is.is((Object)supertypesFromManager.length));
        for (int i = 0; i < supertypesFromManager.length; ++i) {
            Assert.assertEquals((Object)supertypesFromManager[i].getName(), (Object)supertypesFromGraph[i].getString());
        }
        HashMap<PropertyDefinitionKey, Node> propertyDefsFromGraph = new HashMap<PropertyDefinitionKey, Node>();
        NodeIterator properties = typeNode.getNodes(JcrLexicon.PROPERTY_DEFINITION.getString(registry));
        while (properties.hasNext()) {
            Node def = properties.nextNode();
            propertyDefsFromGraph.put(new PropertyDefinitionKey(def, registry), def);
        }
        JcrPropertyDefinition[] propertyDefs = nodeType.getDeclaredPropertyDefinitions();
        for (int i = 0; i < propertyDefs.length; ++i) {
            JcrPropertyDefinition propertyDef = propertyDefs[i];
            Node propNode = (Node)propertyDefsFromGraph.get(new PropertyDefinitionKey((PropertyDefinition)propertyDef));
            this.compareProperty(propertyDef, propNode, registry);
        }
        HashMap<NodeDefinitionKey, Node> nodeDefsFromGraph = new HashMap<NodeDefinitionKey, Node>();
        NodeIterator nodes = typeNode.getNodes(JcrLexicon.CHILD_NODE_DEFINITION.getString(registry));
        while (nodes.hasNext()) {
            Node def = nodes.nextNode();
            nodeDefsFromGraph.put(new NodeDefinitionKey(def, registry), def);
        }
        JcrNodeDefinition[] nodeDefs = nodeType.getDeclaredChildNodeDefinitions();
        for (int i = 0; i < nodeDefs.length; ++i) {
            JcrNodeDefinition childNodeDef = nodeDefs[i];
            Node childNodeNode = (Node)nodeDefsFromGraph.get(new NodeDefinitionKey((NodeDefinition)childNodeDef));
            this.compareChildNode(childNodeDef, childNodeNode, registry);
        }
    }

    private void compareChildNode(JcrNodeDefinition nodeDef, Node childNodeNode, NamespaceRegistry registry) throws Exception {
        Assert.assertThat((Object)childNodeNode, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        try {
            Property nameProp = childNodeNode.getProperty(JcrLexicon.NAME.getString(registry));
            Assert.assertEquals((Object)nameProp.getString(), (Object)nodeDef.getName());
        }
        catch (PathNotFoundException pnfe) {
            Assert.assertThat((Object)nodeDef.getName(), (Matcher)Is.is((Object)"*"));
        }
        Set requiredPrimaryTypeNames = nodeDef.requiredPrimaryTypeNameSet();
        try {
            Value[] requiredPrimaryTypes = childNodeNode.getProperty(JcrLexicon.REQUIRED_PRIMARY_TYPES.getString(registry)).getValues();
            Assert.assertEquals((long)requiredPrimaryTypes.length, (long)requiredPrimaryTypeNames.size());
            for (int i = 0; i < requiredPrimaryTypes.length; ++i) {
                Name rptName = (Name)this.context.getValueFactories().getNameFactory().create(requiredPrimaryTypes[i].getString());
                Assert.assertEquals((Object)requiredPrimaryTypeNames.contains(rptName), (Object)true);
            }
        }
        catch (PathNotFoundException pnfe) {
            Assert.assertEquals((long)requiredPrimaryTypeNames.size(), (long)0L);
        }
        try {
            Property nameProp = childNodeNode.getProperty(JcrLexicon.DEFAULT_PRIMARY_TYPE.getString(registry));
            Assert.assertEquals((Object)nameProp.getString(), (Object)nodeDef.getDefaultPrimaryType().getName());
        }
        catch (PathNotFoundException pnfe) {
            Assert.assertThat((Object)nodeDef.getDefaultPrimaryType(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        }
        Assert.assertEquals((Object)nodeDef.isAutoCreated(), (Object)childNodeNode.getProperty(JcrLexicon.AUTO_CREATED.getString(registry)).getBoolean());
        Assert.assertEquals((Object)nodeDef.isMandatory(), (Object)childNodeNode.getProperty(JcrLexicon.MANDATORY.getString(registry)).getBoolean());
        Assert.assertEquals((Object)nodeDef.isProtected(), (Object)childNodeNode.getProperty(JcrLexicon.PROTECTED.getString(registry)).getBoolean());
        Assert.assertEquals((Object)nodeDef.allowsSameNameSiblings(), (Object)childNodeNode.getProperty(JcrLexicon.SAME_NAME_SIBLINGS.getString(registry)).getBoolean());
        Assert.assertEquals((long)nodeDef.getOnParentVersion(), (long)OnParentVersionAction.valueFromName((String)childNodeNode.getProperty(JcrLexicon.ON_PARENT_VERSION.getString(registry)).getString()));
    }

    private void compareProperty(JcrPropertyDefinition propertyDef, Node propNode, NamespaceRegistry registry) throws Exception {
        Assert.assertThat((Object)propNode, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        try {
            Property nameProp = propNode.getProperty(JcrLexicon.NAME.getString(registry));
            Assert.assertEquals((Object)nameProp.getString(), (Object)propertyDef.getName());
        }
        catch (PathNotFoundException pnfe) {
            Assert.assertThat((Object)propertyDef.getName(), (Matcher)Is.is((Object)"*"));
        }
        Assert.assertEquals((Object)propertyDef.isAutoCreated(), (Object)propNode.getProperty(JcrLexicon.AUTO_CREATED.getString(registry)).getBoolean());
        Assert.assertEquals((Object)propertyDef.isMandatory(), (Object)propNode.getProperty(JcrLexicon.MANDATORY.getString(registry)).getBoolean());
        Assert.assertEquals((Object)propertyDef.isMultiple(), (Object)propNode.getProperty(JcrLexicon.MULTIPLE.getString(registry)).getBoolean());
        Assert.assertEquals((Object)propertyDef.isProtected(), (Object)propNode.getProperty(JcrLexicon.PROTECTED.getString(registry)).getBoolean());
        Assert.assertEquals((long)propertyDef.getOnParentVersion(), (long)OnParentVersionAction.valueFromName((String)propNode.getProperty(JcrLexicon.ON_PARENT_VERSION.getString(registry)).getString()));
        Assert.assertEquals((long)propertyDef.getRequiredType(), (long)PropertyType.valueFromName((String)propNode.getProperty(JcrLexicon.REQUIRED_TYPE.getString(registry)).getString()));
        Value[] defaultValues = propertyDef.getDefaultValues();
        try {
            Property defaultsProp = propNode.getProperty(JcrLexicon.DEFAULT_VALUES.getString(registry));
            Value[] defaultsFromGraph = defaultsProp.getValues();
            Assert.assertEquals((long)defaultValues.length, (long)defaultsFromGraph.length);
            for (int i = 0; i < defaultValues.length; ++i) {
                Assert.assertEquals((Object)defaultValues[i].getString(), (Object)defaultsFromGraph[i].getString());
            }
        }
        catch (PathNotFoundException pnfe) {
            Assert.assertEquals((long)defaultValues.length, (long)0L);
        }
        String[] constraintValues = propertyDef.getValueConstraints();
        try {
            Property constraintsProp = propNode.getProperty(JcrLexicon.VALUE_CONSTRAINTS.getString(registry));
            Value[] constraintsFromGraph = constraintsProp.getValues();
            Assert.assertEquals((long)constraintValues.length, (long)constraintsFromGraph.length);
            for (int i = 0; i < constraintValues.length; ++i) {
                Assert.assertEquals((Object)constraintValues[i], (Object)constraintsFromGraph[i].getString());
            }
        }
        catch (PathNotFoundException pnfe) {
            Assert.assertEquals((long)constraintValues.length, (long)0L);
        }
    }

    class NodeDefinitionKey {
        String keyString;

        NodeDefinitionKey(Node node, NamespaceRegistry registry) throws Exception {
            StringBuffer buff = new StringBuffer();
            try {
                String nodeName = node.getProperty(JcrLexicon.NAME.getString(registry)).getString();
                buff.append(nodeName);
            }
            catch (PathNotFoundException pnfe) {
                buff.append("*");
            }
            try {
                Value[] requiredTypes = node.getProperty(JcrLexicon.REQUIRED_PRIMARY_TYPES.getString(registry)).getValues();
                for (int i = 0; i < requiredTypes.length; ++i) {
                    buff.append('_').append(requiredTypes[i].getString());
                }
            }
            catch (PathNotFoundException pnfe) {
                // empty catch block
            }
            buff.append('_').append(node.getProperty(JcrLexicon.SAME_NAME_SIBLINGS.getString(registry)).getBoolean());
            this.keyString = buff.toString();
        }

        NodeDefinitionKey(NodeDefinition def) {
            StringBuffer buff = new StringBuffer();
            buff.append(def.getName());
            NodeType[] requiredTypes = def.getRequiredPrimaryTypes();
            for (int i = 0; i < requiredTypes.length; ++i) {
                buff.append('_').append(requiredTypes[i].getName());
            }
            buff.append('_').append(def.allowsSameNameSiblings());
            this.keyString = buff.toString();
        }

        public boolean equals(Object ob) {
            if (!(ob instanceof NodeDefinitionKey)) {
                return false;
            }
            return this.keyString.equals(((NodeDefinitionKey)ob).keyString);
        }

        public int hashCode() {
            return this.keyString.hashCode();
        }
    }

    class PropertyDefinitionKey {
        String keyString;

        PropertyDefinitionKey(Node node, NamespaceRegistry registry) throws Exception {
            String propertyName = "*";
            try {
                propertyName = node.getProperty(JcrLexicon.NAME.getString(registry)).getString();
            }
            catch (PathNotFoundException pnfe) {
                // empty catch block
            }
            String requiredType = node.getProperty(JcrLexicon.REQUIRED_TYPE.getString(registry)).getString();
            boolean allowsMultiple = node.getProperty(JcrLexicon.MULTIPLE.getString(registry)).getBoolean();
            this.keyString = propertyName + "-" + requiredType + "-" + allowsMultiple;
        }

        PropertyDefinitionKey(PropertyDefinition def) {
            String requiredType = PropertyType.nameFromValue((int)def.getRequiredType());
            this.keyString = def.getName() + "-" + requiredType + "-" + def.isMultiple();
        }

        public boolean equals(Object ob) {
            if (!(ob instanceof PropertyDefinitionKey)) {
                return false;
            }
            return this.keyString.equals(((PropertyDefinitionKey)ob).keyString);
        }

        public int hashCode() {
            return this.keyString.hashCode();
        }
    }
}

