/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.jboss.security.config.IDTrustConfiguration;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.modeshape.common.FixFor;
import org.modeshape.graph.connector.inmemory.InMemoryRepositorySource;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.jcr.JcrConfiguration;
import org.modeshape.jcr.JcrEngine;
import org.modeshape.jcr.JcrNodeTypeManager;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.nodetype.InvalidNodeTypeDefinitionException;
import org.modeshape.jcr.query.JcrQueryResult;
import org.modeshape.repository.ModeShapeConfiguration;

public class JcrQueryManagerTest {
    private static JcrConfiguration configuration;
    private static JcrEngine engine;
    private static JcrRepository repository;
    private Session session;
    private boolean print;

    protected static URI resourceUri(String name) throws URISyntaxException {
        return JcrQueryManagerTest.resourceUrl(name).toURI();
    }

    protected static URL resourceUrl(String name) {
        return JcrQueryManagerTest.class.getClassLoader().getResource(name);
    }

    protected static InputStream resourceStream(String name) {
        return JcrQueryManagerTest.class.getClassLoader().getResourceAsStream(name);
    }

    protected static String[] carColumnNames() {
        return new String[]{"car:mpgCity", "car:lengthInInches", "car:maker", "car:userRating", "car:engine", "car:mpgHighway", "car:valueRating", "jcr:primaryType", "car:wheelbaseInInches", "car:year", "car:model", "car:msrp", "jcr:created", "jcr:createdBy"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BeforeClass
    public static void beforeAll() throws Exception {
        configuration = new JcrConfiguration();
        ((ModeShapeConfiguration.RepositorySourceDefinition)configuration.repositorySource("car-source").usingClass(InMemoryRepositorySource.class)).setDescription("The automobile content");
        configuration.repository("cars").setSource("car-source").registerNamespace("car", "http://www.modeshape.org/examples/cars/1.0").addNodeTypes(JcrQueryManagerTest.resourceUrl("cars.cnd")).setOption(JcrRepository.Option.ANONYMOUS_USER_ROLES, "readonly,readwrite,admin").setOption(JcrRepository.Option.JAAS_LOGIN_CONFIG_NAME, "modeshape-jcr");
        engine = configuration.build();
        engine.start();
        String configFile = "security/jaas.conf.xml";
        IDTrustConfiguration idtrustConfig = new IDTrustConfiguration();
        try {
            idtrustConfig.config(configFile);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
        repository = engine.getRepository("cars");
        Session session = repository.login();
        try {
            InputStream stream = JcrQueryManagerTest.resourceStream("io/cars-system-view.xml");
            try {
                session.getWorkspace().importXML("/", stream, 0);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            finally {
                stream.close();
            }
            Node other = session.getRootNode().addNode("Other", "nt:unstructured");
            other.addNode("NodeA", "nt:unstructured").setProperty("something", "value3 quick brown fox");
            other.addNode("NodeA", "nt:unstructured").setProperty("something", "value2 quick brown cat");
            other.addNode("NodeA", "nt:unstructured").setProperty("something", "value1 quick black dog");
            session.getRootNode().addNode("NodeB", "nt:unstructured").setProperty("myUrl", "http://www.acme.com/foo/bar");
            session.save();
            session.getWorkspace().getQueryManager().createQuery("//element(*,nt:unstructured)", "xpath");
            session.getWorkspace().getQueryManager().createQuery("SELECT * FROM [nt:base]", "JCR-SQL2");
        }
        finally {
            session.logout();
        }
        repository.getRepositoryTypeManager().getRepositorySchemata();
    }

    @AfterClass
    public static void afterAll() throws Exception {
        engine.shutdown();
        engine.awaitTermination(3L, TimeUnit.SECONDS);
        engine = null;
        configuration = null;
    }

    @Before
    public void beforeEach() throws Exception {
        this.print = false;
        this.session = repository.login();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void afterEach() throws Exception {
        if (this.session != null) {
            try {
                this.session.logout();
            }
            finally {
                this.session = null;
            }
        }
    }

    protected Name name(String name) {
        return (Name)engine.getExecutionContext().getValueFactories().getNameFactory().create(name);
    }

    protected Path.Segment segment(String segment) {
        return engine.getExecutionContext().getValueFactories().getPathFactory().createSegment(segment);
    }

    protected List<Path.Segment> segments(String ... segments) {
        ArrayList<Path.Segment> result = new ArrayList<Path.Segment>();
        for (String segment : segments) {
            result.add(this.segment(segment));
        }
        return result;
    }

    protected void assertResults(Query query, QueryResult result, long numberOfResults) throws RepositoryException {
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        if (this.print) {
            System.out.println();
            System.out.println(query);
            System.out.println(" plan -> " + ((JcrQueryResult)result).getPlan());
            System.out.println(result);
        }
        Assert.assertThat((Object)result.getNodes().getSize(), (Matcher)Is.is((Object)numberOfResults));
        Assert.assertThat((Object)result.getRows().getSize(), (Matcher)Is.is((Object)numberOfResults));
    }

    protected void assertResultsHaveColumns(QueryResult result, String ... columnNames) throws RepositoryException {
        HashSet<String> expectedNames = new HashSet<String>();
        for (String name : columnNames) {
            expectedNames.add(name);
        }
        HashSet<String> actualNames = new HashSet<String>();
        for (String name : result.getColumnNames()) {
            actualNames.add(name);
        }
        Assert.assertThat(actualNames, (Matcher)Is.is(expectedNames));
    }

    protected RowResult assertRow(QueryResult result, int rowNumber) throws RepositoryException {
        RowIterator rowIter = result.getRows();
        Row row = null;
        for (int i = 0; i != rowNumber; ++i) {
            row = rowIter.nextRow();
        }
        Assert.assertThat((Object)row, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        return new RowResult(row);
    }

    @Test
    public void shouldStartUp() {
        Assert.assertThat((Object)engine.getRepositoryService(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldHaveLoadedContent() throws RepositoryException {
        Node node = this.session.getRootNode().getNode("Cars");
        Assert.assertThat((Object)node, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)node.hasNode("Sports"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)node.hasNode("Utility"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)node.hasNode("Hybrid"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)node.hasNode("Hybrid/Toyota Prius"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)node.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"nt:unstructured"));
    }

    @Test
    public void shouldReturnQueryManagerFromWorkspace() throws RepositoryException {
        Assert.assertThat((Object)this.session.getWorkspace().getQueryManager(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldBeAbleToCreateAndExecuteSqlQueryToFindAllNodes() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("SELECT * FROM [nt:base]", "JCR-SQL2");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 23L);
        this.assertResultsHaveColumns(result, "jcr:primaryType");
    }

    @Test
    public void shouldBeAbleToCreateAndExecuteSqlQueryToFindAllCarNodes() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("SELECT * FROM [car:Car]", "JCR-SQL2");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 12L);
        this.assertResultsHaveColumns(result, JcrQueryManagerTest.carColumnNames());
    }

    @Test
    public void shouldBeAbleToCreateAndExecuteSqlQueryToFindAllCarNodesOrderedByYear() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("SELECT * FROM [car:Car] ORDER BY [car:year]", "JCR-SQL2");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 12L);
        this.assertResultsHaveColumns(result, JcrQueryManagerTest.carColumnNames());
    }

    @Test
    public void shouldBeAbleToCreateAndExecuteSqlQueryToFindAllCarNodesOrderedByMsrp() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("SELECT * FROM [car:Car] ORDER BY [car:msrp] DESC", "JCR-SQL2");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 12L);
        this.assertResultsHaveColumns(result, JcrQueryManagerTest.carColumnNames());
        this.assertRow(result, 1).has("car:model", "LR3").and("car:msrp", "$48,525").and("car:mpgCity", 12L);
        this.assertRow(result, 2).has("car:model", "IS350").and("car:msrp", "$36,305").and("car:mpgCity", 18L);
        this.assertRow(result, 10).has("car:model", "DB9").and("car:msrp", "$171,600").and("car:mpgCity", 12L);
    }

    @Test
    public void shouldBeAbleToCreateAndExecuteSqlQueryToFindAllCarsUnderHybrid() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("SELECT car.[car:maker], car.[car:model], car.[car:year], car.[car:msrp] FROM [car:Car] AS car WHERE PATH(car) LIKE '%/Hybrid/%'", "JCR-SQL2");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 3L);
        this.assertResultsHaveColumns(result, "car:maker", "car:model", "car:year", "car:msrp");
        this.assertRow(result, 1).has("car:model", "Altima").and("car:msrp", "$18,260").and("car:year", 2008L);
        this.assertRow(result, 2).has("car:model", "Prius").and("car:msrp", "$21,500").and("car:year", 2008L);
        this.assertRow(result, 3).has("car:model", "Highlander").and("car:msrp", "$34,200").and("car:year", 2008L);
    }

    @Ignore
    @Test
    public void shouldBeAbleToCreateAndExecuteSqlQueryUsingJoinToFindAllCarsUnderHybrid() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("SELECT car.[car:maker], car.[car:model], car.[car:year], car.[car:msrp] FROM [car:Car] AS car JOIN [nt:unstructured] AS hybrid ON ISCHILDNODE(car,hybrid) WHERE NAME(hybrid) = 'Hybrid'", "JCR-SQL2");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 12L);
        this.assertResultsHaveColumns(result, JcrQueryManagerTest.carColumnNames());
    }

    @Test
    public void shouldBeAbleToCreateAndExecuteSqlQueryToFindAllUnstructuredNodes() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("SELECT * FROM [nt:unstructured]", "JCR-SQL2");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 22L);
        this.assertResultsHaveColumns(result, "jcr:primaryType");
    }

    @Test
    public void shouldBeAbleToCreateAndExecuteSqlQueryWithChildNodeJoin() throws RepositoryException {
        String sql = "SELECT car.* from [car:Car] as car JOIN [nt:unstructured] as category ON ISCHILDNODE(car,category) WHERE NAME(category) LIKE 'Utility'";
        Query query = this.session.getWorkspace().getQueryManager().createQuery(sql, "JCR-SQL2");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 4L);
        this.assertResultsHaveColumns(result, JcrQueryManagerTest.carColumnNames());
    }

    @Test
    public void shouldBeAbleToCreateAndExecuteSqlQueryWithChildNodeJoinAndColumnsFromBothSidesOfJoin() throws RepositoryException {
        String sql = "SELECT car.*, category.[jcr:primaryType] from [car:Car] as car JOIN [nt:unstructured] as category ON ISCHILDNODE(car,category) WHERE NAME(category) LIKE 'Utility'";
        Query query = this.session.getWorkspace().getQueryManager().createQuery(sql, "JCR-SQL2");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.print = true;
        this.assertResults(query, result, 4L);
        String[] expectedColumnNames = new String[]{"car:mpgCity", "car:lengthInInches", "car:maker", "car:userRating", "car:engine", "car:mpgHighway", "car:valueRating", "jcr:primaryType", "car:wheelbaseInInches", "car:year", "car:model", "car:msrp", "jcr:created", "jcr:createdBy", "category.jcr:primaryType"};
        this.assertResultsHaveColumns(result, expectedColumnNames);
    }

    @Test
    public void shouldBeAbleToCreateAndExecuteSqlQueryWithDescendantNodeJoinWithoutCriteria() throws RepositoryException {
        String sql = "SELECT * FROM [car:Car] as car JOIN [nt:unstructured] as category ON ISDESCENDANTNODE(car,category)";
        Query query = this.session.getWorkspace().getQueryManager().createQuery(sql, "JCR-SQL2");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 12L);
        String[] expectedColumnNames = new String[]{"car:mpgCity", "car:lengthInInches", "car:maker", "car:userRating", "car:engine", "car:mpgHighway", "car:valueRating", "jcr:primaryType", "car:wheelbaseInInches", "car:year", "car:model", "car:msrp", "jcr:created", "jcr:createdBy", "category.jcr:primaryType"};
        this.assertResultsHaveColumns(result, expectedColumnNames);
    }

    @Test
    public void shouldBeAbleToCreateAndExecuteSqlQueryWithDescendantNodeJoin() throws RepositoryException {
        String sql = "SELECT car.* from [car:Car] as car JOIN [nt:unstructured] as category ON ISDESCENDANTNODE(car,category) WHERE NAME(category) LIKE 'Utility'";
        Query query = this.session.getWorkspace().getQueryManager().createQuery(sql, "JCR-SQL2");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 4L);
        this.assertResultsHaveColumns(result, JcrQueryManagerTest.carColumnNames());
    }

    @Test
    public void shouldBeAbleToCreateAndExecuteSqlQueryWithDescendantNodeJoinAndColumnsFromBothSidesOfJoin() throws RepositoryException {
        String sql = "SELECT car.*, category.[jcr:primaryType] from [car:Car] as car JOIN [nt:unstructured] as category ON ISDESCENDANTNODE(car,category) WHERE NAME(category) LIKE 'Utility'";
        Query query = this.session.getWorkspace().getQueryManager().createQuery(sql, "JCR-SQL2");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.print = true;
        this.assertResults(query, result, 4L);
        String[] expectedColumnNames = new String[]{"car:mpgCity", "car:lengthInInches", "car:maker", "car:userRating", "car:engine", "car:mpgHighway", "car:valueRating", "jcr:primaryType", "car:wheelbaseInInches", "car:year", "car:model", "car:msrp", "jcr:created", "jcr:createdBy", "category.jcr:primaryType"};
        this.assertResultsHaveColumns(result, expectedColumnNames);
    }

    @Test
    public void shouldBeAbleToCreateAndExecuteSqlQueryWithOrderByClause() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("SELECT car:model FROM car:Car WHERE car:model IS NOT NULL ORDER BY car:model ASC", "sql");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 12L);
        this.assertResultsHaveColumns(result, "jcr:path", "jcr:score", "car:model");
    }

    @Test
    public void shouldBeAbleToCreateAndExecuteSqlQueryWithPathCriteriaAndOrderByClause() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("SELECT car:model FROM car:Car WHERE jcr:path LIKE '/Cars/%' ORDER BY car:model ASC", "sql");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 12L);
        this.assertResultsHaveColumns(result, "jcr:path", "jcr:score", "car:model");
    }

    @Test
    public void shouldBeAbleToCreateAndExecuteSqlQueryWithChildAxisCriteria() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("SELECT * FROM nt:base WHERE jcr:path LIKE '/Cars/%' AND NOT jcr:path LIKE '/Cars/%/%'", "sql");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 4L);
        this.assertResultsHaveColumns(result, "jcr:path", "jcr:score", "jcr:primaryType");
    }

    @Test
    public void shouldBeAbleToCreateAndExecuteSqlQueryWithContainsCriteria() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("SELECT * FROM nt:base WHERE jcr:path LIKE '/Cars/%' AND NOT jcr:path LIKE '/Cars/%/%'", "sql");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 4L);
        this.assertResultsHaveColumns(result, "jcr:path", "jcr:score", "jcr:primaryType");
    }

    @Test
    @FixFor(value={"MODE-791"})
    public void shouldReturnNodesWithPropertyConstrainedByTimestamp() throws Exception {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("SELECT car:model, car:maker FROM car:Car WHERE jcr:path LIKE '/Cars/%' AND (car:msrp LIKE '$3%' OR car:msrp LIKE '$2') AND (car:year LIKE '2008' OR car:year LIKE '2009') AND car:valueRating > '1' AND jcr:created > TIMESTAMP '1974-07-10T00:00:00.000-05:00' AND jcr:created < TIMESTAMP '3074-07-10T00:00:00.000-05:00'", "sql");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 5L);
        NodeIterator iter = result.getNodes();
        while (iter.hasNext()) {
            Assert.assertThat((Object)iter.nextNode().hasProperty("car:model"), (Matcher)Is.is((Object)true));
        }
    }

    @Test
    public void shouldBeAbleToCreateXPathQuery() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("//element(*,car:Car)", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, query.execute(), 12L);
        query = this.session.getWorkspace().getQueryManager().createQuery("//element(*,nt:unstructured)", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, query.execute(), 22L);
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryToFindAllNodes() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("//element(*,nt:base)", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        this.assertResults(query, result, 23L);
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "jcr:score");
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryToFindAllUnstructuredNodes() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("//element(*,nt:unstructured)", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        this.assertResults(query, result, 22L);
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "jcr:score");
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryToFindAllUnstructuredNodesOrderedByPropertyValue() throws RepositoryException {
        QueryManager manager = this.session.getWorkspace().getQueryManager();
        Query query = manager.createQuery("//element(*,nt:unstructured) order by @jcr:primaryType", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        this.assertResults(query, result, 22L);
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "jcr:score");
        query = manager.createQuery("//element(*,car:Car) order by @car:year", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        result = query.execute();
        this.assertResults(query, result, 12L);
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResultsHaveColumns(result, "car:year", "jcr:path", "jcr:score");
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryToFindNodesUnderNode() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery(" /jcr:root/Cars/Hybrid/*", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        this.assertResults(query, result, 3L);
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "jcr:score");
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryToFindNodesUnderNodeAndWithProperty() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery(" /jcr:root/Cars/Hybrid/*[@car:year]", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        this.assertResults(query, result, 3L);
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "jcr:score");
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryToFindNodesUnderNodeAndWithPropertyOrderedByProperty() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery(" /jcr:root/Cars/Hybrid/*[@car:year] order by @car:year ascending", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        this.assertResults(query, result, 3L);
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResultsHaveColumns(result, "car:year", "jcr:path", "jcr:score");
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryToFindNodesUnderPath() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery(" /jcr:root/Cars//*", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        this.assertResults(query, result, 16L);
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "jcr:score");
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryToFindNodesUnderPathAndWithProperty() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery(" /jcr:root/Cars//*[@car:year]", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        this.assertResults(query, result, 12L);
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "jcr:score");
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryToFindNodesUnderPathAndWithPropertyOrderedByProperty() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery(" /jcr:root/Cars//*[@car:year] order by @car:year ascending", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        this.assertResults(query, result, 12L);
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResultsHaveColumns(result, "car:year", "jcr:path", "jcr:score");
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryToFindAllUnstructuredNodesOrderedByScore() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("//element(*,nt:unstructured) order by jcr:score()", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        this.assertResults(query, result, 22L);
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "jcr:score");
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryToFindSameNameSiblingsByIndex() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("/jcr:root/Other/NodeA", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        this.assertResults(query, result, 1L);
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)result.getNodes().nextNode().getIndex(), (Matcher)Is.is((Object)1));
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "jcr:score");
        query = this.session.getWorkspace().getQueryManager().createQuery("/jcr:root/Other/NodeA[2]", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        result = query.execute();
        this.assertResults(query, result, 1L);
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)result.getNodes().nextNode().getIndex(), (Matcher)Is.is((Object)2));
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "jcr:score");
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryToFindAllCarNodes() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("//element(*,car:Car)", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 12L);
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "jcr:score", "jcr:created", "jcr:createdBy", "car:mpgCity", "car:userRating", "car:mpgHighway", "car:engine", "car:model", "car:year", "car:maker", "car:lengthInInches", "car:valueRating", "car:wheelbaseInInches", "car:msrp");
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryToFindRootNode() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("/jcr:root", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        this.assertResults(query, result, 1L);
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "jcr:score");
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryToFindChildOfRootNode() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("/jcr:root/Cars", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 1L);
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "jcr:score");
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryToFindChildOfRootNodeWithTypeCriteria() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("/jcr:root/Cars[@jcr:primaryType]", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 1L);
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "jcr:score");
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryToFindNodeWithPathAndAttrbuteCriteria() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("/jcr:root/Cars/Sports/Infiniti_x0020_G37[@car:year='2008']", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 1L);
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "jcr:score");
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryToFindNodeWithAttrbuteCriteria() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("//Infiniti_x0020_G37[@car:year='2008']", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 1L);
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "jcr:score");
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryToFindNodeWithPathUnderRootAndAttrbuteCriteria() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("/jcr:root/NodeB[@myUrl='http://www.acme.com/foo/bar']", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 1L);
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "jcr:score");
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryToFindAnywhereNodeWithNameAndAttrbuteCriteriaMatchingUrl() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("//NodeB[@myUrl='http://www.acme.com/foo/bar']", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 1L);
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "jcr:score");
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryToFindNodeWithNameMatch() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("//NodeB", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 1L);
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "jcr:score");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=InvalidNodeTypeDefinitionException.class)
    public void shouldNotAllowUnregisteringUsedPrimaryType() throws Exception {
        Session adminSession = null;
        try {
            adminSession = repository.login((Credentials)new SimpleCredentials("superuser", "superuser".toCharArray()));
            adminSession.setNamespacePrefix("cars", "http://www.modeshape.org/examples/cars/1.0");
            JcrNodeTypeManager nodeTypeManager = (JcrNodeTypeManager)adminSession.getWorkspace().getNodeTypeManager();
            nodeTypeManager.unregisterNodeTypes(Collections.singletonList("cars:Car"));
        }
        finally {
            if (adminSession != null) {
                adminSession.logout();
            }
        }
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryWithContainsCriteria() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("/jcr:root//*[jcr:contains(., 'liter')]", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 2L);
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "jcr:score");
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryWithComplexContainsCriteria() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("/jcr:root//*[jcr:contains(., '\"liter V 12\"')]", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 1L);
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "jcr:score");
    }

    @Test
    @FixFor(value={"MODE-790"})
    public void shouldBeAbleToExecuteXPathQueryWithCompoundCriteria() throws Exception {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("/jcr:root/Cars//element(*,car:Car)[@car:year='2008' and jcr:contains(., '\"liter V 12\"')]", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 1L);
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "jcr:score", "jcr:created", "jcr:createdBy", "car:mpgCity", "car:userRating", "car:mpgHighway", "car:engine", "car:model", "car:year", "car:maker", "car:lengthInInches", "car:valueRating", "car:wheelbaseInInches", "car:msrp");
        query = this.session.getWorkspace().getQueryManager().createQuery("/jcr:root/Cars//element(*,car:Car)[@car:year='2007' and jcr:contains(., '\"liter V 12\"')]", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 0L);
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryWithElementTestForChildrenOfRoot() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("/jcr:root/element()", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 3L);
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "jcr:score");
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryWithElementTestForAllNodesBelowRoot() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("/jcr:root//element()", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 23L);
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "jcr:score");
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryWithElementTestForChildOfRootWithName() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("/jcr:root/element(Cars)", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 1L);
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "jcr:score");
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryWithElementTestForSingleNodeBelowRootWithName() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("/jcr:root//element(Utility)", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 1L);
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "jcr:score");
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryWithElementTestForChildrenOfRootWithName() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("/jcr:root/Other/element(NodeA)", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 3L);
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "jcr:score");
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryWithElementTestForMultipleNodesBelowRootWithName() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("/jcr:root//element(NodeA)", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 3L);
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "jcr:score");
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryWithRangeCriteria() throws RepositoryException {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("/jcr:root/Other/*[@something <= 'value2' and @something > 'value1']", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertResults(query, result, 1L);
        this.assertResultsHaveColumns(result, "jcr:primaryType", "jcr:path", "jcr:score");
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryWithNewlyRegisteredNamespace() throws RepositoryException {
        this.session.getWorkspace().getNamespaceRegistry().registerNamespace("newPrefix", "newUri");
        Query query = this.session.getWorkspace().getQueryManager().createQuery("//*[@newPrefix:someColumn = 'someValue']", "xpath");
        query.execute();
    }

    @Test
    public void shouldNotReturnNodesWithNoPropertyForPropertyCriterion() throws Exception {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("/jcr:root/Cars//*[@car:wheelbaseInInches]", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        NodeIterator iter = result.getNodes();
        while (iter.hasNext()) {
            Assert.assertThat((Object)iter.nextNode().hasProperty("car:wheelbaseInInches"), (Matcher)Is.is((Object)true));
        }
    }

    @Test
    public void shouldNotReturnNodesWithNoPropertyForLikeCriterion() throws Exception {
        Query query = this.session.getWorkspace().getQueryManager().createQuery("/jcr:root/Cars//*[jcr:like(@car:wheelbaseInInches, '%')]", "xpath");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        NodeIterator iter = result.getNodes();
        while (iter.hasNext()) {
            Assert.assertThat((Object)iter.nextNode().hasProperty("car:wheelbaseInInches"), (Matcher)Is.is((Object)true));
        }
    }

    public class RowResult {
        private final Row row;

        public RowResult(Row row) {
            this.row = row;
        }

        public RowResult has(String columnName, String value) throws RepositoryException {
            Assert.assertThat((Object)this.row.getValue(columnName).getString(), (Matcher)Is.is((Object)value));
            return this;
        }

        public RowResult has(String columnName, long value) throws RepositoryException {
            Assert.assertThat((Object)this.row.getValue(columnName).getLong(), (Matcher)Is.is((Object)value));
            return this;
        }

        public RowResult and(String columnName, String value) throws RepositoryException {
            return this.has(columnName, value);
        }

        public RowResult and(String columnName, long value) throws RepositoryException {
            return this.has(columnName, value);
        }
    }
}

