/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.common.collection.Problems;
import org.modeshape.common.collection.SimpleProblems;
import org.modeshape.graph.SecurityContext;
import org.modeshape.graph.connector.inmemory.InMemoryRepositorySource;
import org.modeshape.jcr.JcrConfiguration;
import org.modeshape.jcr.JcrEngine;
import org.modeshape.jcr.JcrTools;
import org.modeshape.jcr.SecurityContextCredentials;
import org.modeshape.repository.ModeShapeConfiguration;

public class JcrToolsTest {
    private JcrEngine engine;
    private Session session;
    private JcrTools tools;
    private Node personNode;
    private Node addressNode;
    private Problems problems;
    private Node NULL_NODE;
    private String NULL_STRING;
    private static final String DEF_TYPE = "nt:unstructured";

    @Before
    public void before() throws Exception {
        this.tools = new JcrTools();
        String repositoryName = "ddlRepository";
        String workspaceName = "default";
        String repositorySource = "ddlRepositorySource";
        JcrConfiguration config = new JcrConfiguration();
        ((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)config.repositorySource(repositorySource).usingClass(InMemoryRepositorySource.class)).setDescription("The repository for our content")).setProperty("defaultWorkspaceName", workspaceName);
        config.repository(repositoryName).setSource(repositorySource);
        config.save();
        this.engine = config.build();
        this.engine.start();
        this.session = this.engine.getRepository(repositoryName).login((Credentials)new SecurityContextCredentials((SecurityContext)new MyCustomSecurityContext()), workspaceName);
        Node rootNode = this.session.getRootNode();
        this.personNode = rootNode.addNode("Person");
        this.personNode.setProperty("First Name", "Ryan");
        this.personNode.setProperty("Middle Name", "Joseph");
        this.personNode.setProperty("Last Name", "Franklin");
        this.personNode.setProperty("Age", 37L);
        this.personNode.setProperty("Children", new String[]{"Sally", "Brent", "Michael"});
        this.addressNode = this.personNode.addNode("Address");
        this.addressNode.setProperty("Street", "Frost Avenue");
        this.addressNode.setProperty("House Number", 166L);
        this.addressNode.setProperty("City", "Flagstaff");
        this.addressNode.setProperty("State", "AZ");
        this.addressNode.setProperty("Country", "US");
        this.addressNode.setProperty("Zip Code", 77777L);
        this.problems = new SimpleProblems();
    }

    @After
    public void afterEach() throws Exception {
        if (this.session != null) {
            this.session.logout();
        }
        if (this.engine != null) {
            this.engine.shutdown();
        }
    }

    @Test
    public void shouldGetNode() throws RepositoryException {
        Node node = this.tools.getNode(this.session.getRootNode(), "Person", true);
        Assert.assertNotNull((Object)node);
        Assert.assertThat((Object)node.getName(), (Matcher)Is.is((Object)"Person"));
        Assert.assertThat((Object)this.problems.size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldFailGetNodeWithNoDoesntExist() {
        try {
            this.tools.getNode(this.session.getRootNode(), "Animal", true);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof PathNotFoundException));
        }
    }

    @Test
    public void shouldFailGetNodeNullParent() {
        try {
            this.tools.getNode(this.NULL_NODE, "Person", true);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IllegalArgumentException));
        }
    }

    @Test
    public void shouldFailGetNodeNullPath() {
        try {
            this.tools.getNode(this.personNode, this.NULL_STRING, true);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IllegalArgumentException));
        }
    }

    @Test
    public void testGetReadable() {
        String personStr = this.tools.getReadable(this.personNode);
        Assert.assertThat((Object)personStr, (Matcher)Is.is((Object)"/Person"));
    }

    @Test
    public void testCreateNodeSessionPath() throws RepositoryException {
        Node node = this.tools.findOrCreateNode(this.session, "Hobby");
        Assert.assertNotNull((Object)node);
        Assert.assertThat((Object)node.getName(), (Matcher)Is.is((Object)"Hobby"));
    }

    @Test
    public void testFindNodeSessionPath() throws RepositoryException {
        Node node = this.tools.findOrCreateNode(this.session, "Person");
        Assert.assertNotNull((Object)node);
        Assert.assertThat((Object)node.getName(), (Matcher)Is.is((Object)"Person"));
    }

    @Test
    public void shouldFailFindOrCreateNodeSessionPathNullSession() {
        Session sess = null;
        try {
            this.tools.findOrCreateNode(sess, "Person");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IllegalArgumentException));
        }
    }

    @Test
    public void shouldFailFindOrCreateNodeSessionPathNullPath() {
        try {
            this.tools.findOrCreateNode(this.session, this.NULL_STRING);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IllegalArgumentException));
        }
    }

    @Test
    public void testCreateNodeSessionPathType() throws RepositoryException {
        Node node = this.tools.findOrCreateNode(this.session, "Hobby", DEF_TYPE);
        Assert.assertNotNull((Object)node);
        Assert.assertThat((Object)node.getName(), (Matcher)Is.is((Object)"Hobby"));
    }

    @Test
    public void testFindNodeSessionPathType() throws RepositoryException {
        Node node = this.tools.findOrCreateNode(this.session, "Person", DEF_TYPE);
        Assert.assertNotNull((Object)node);
        Assert.assertThat((Object)node.getName(), (Matcher)Is.is((Object)"Person"));
    }

    @Test
    public void shouldFailFindOrCreateNodeSessionPathTypeNullSession() {
        Session sess = null;
        try {
            this.tools.findOrCreateNode(sess, "Person", DEF_TYPE);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IllegalArgumentException));
        }
    }

    @Test
    public void shouldFailFindOrCreateNodeSessionPathTypeNullPath() {
        try {
            this.tools.findOrCreateNode(this.session, this.NULL_STRING, DEF_TYPE);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IllegalArgumentException));
        }
    }

    @Test
    public void testCreateNodeSessionPathTypeType() throws RepositoryException {
        Node node = this.tools.findOrCreateNode(this.session, "Hobby", DEF_TYPE, DEF_TYPE);
        Assert.assertNotNull((Object)node);
        Assert.assertThat((Object)node.getName(), (Matcher)Is.is((Object)"Hobby"));
    }

    @Test
    public void testFindNodeSessionPathTypeType() throws RepositoryException {
        Node node = this.tools.findOrCreateNode(this.session, "Person", DEF_TYPE, DEF_TYPE);
        Assert.assertNotNull((Object)node);
        Assert.assertThat((Object)node.getName(), (Matcher)Is.is((Object)"Person"));
    }

    @Test
    public void shouldFailFindOrCreateNodeSessionPathTypeTypeNullSession() {
        Session sess = null;
        try {
            this.tools.findOrCreateNode(sess, "Person", DEF_TYPE, DEF_TYPE);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IllegalArgumentException));
        }
    }

    @Test
    public void shouldFailFindOrCreateNodeSessionPathTypeTypeNullPath() {
        try {
            this.tools.findOrCreateNode(this.session, this.NULL_STRING, DEF_TYPE, DEF_TYPE);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IllegalArgumentException));
        }
    }

    @Test
    public void shouldCreateNodeNodePathTypeType() throws RepositoryException {
        Node node = this.tools.findOrCreateNode(this.personNode, "Hobby", DEF_TYPE, DEF_TYPE);
        Assert.assertNotNull((Object)node);
        Assert.assertThat((Object)node.getName(), (Matcher)Is.is((Object)"Hobby"));
    }

    @Test
    public void shouldFindNodeParentPathTypeType() throws RepositoryException {
        Node node = this.tools.findOrCreateNode(this.personNode, "Address", DEF_TYPE, DEF_TYPE);
        Assert.assertNotNull((Object)node);
        Assert.assertThat((Object)node.getName(), (Matcher)Is.is((Object)"Address"));
    }

    @Test
    public void shouldFailFindOrCreateNodeNodePathTypeTypeNullNode() {
        try {
            this.tools.findOrCreateNode(this.NULL_NODE, "/topNode", DEF_TYPE, DEF_TYPE);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IllegalArgumentException));
        }
    }

    @Test
    public void shouldFailFindOrCreateNodeNodePathTypeTypeNullPath() {
        try {
            this.tools.findOrCreateNode(this.personNode, this.NULL_STRING, DEF_TYPE, DEF_TYPE);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IllegalArgumentException));
        }
    }

    @Test
    public void shouldCreateChildNodeWithParentName() throws RepositoryException {
        Node childNode = this.tools.findOrCreateChild(this.personNode, "Hobby");
        Assert.assertNotNull((Object)childNode);
        Assert.assertThat((Object)childNode.getName(), (Matcher)Is.is((Object)"Hobby"));
    }

    @Test
    public void shouldFindChildNodeWithParentName() throws RepositoryException {
        Node childNode = this.tools.findOrCreateChild(this.personNode, "Address");
        Assert.assertNotNull((Object)childNode);
        Assert.assertThat((Object)childNode.getName(), (Matcher)Is.is((Object)"Address"));
    }

    @Test
    public void shouldFailFindOrCreateChildNodeStringNullNode() {
        try {
            this.tools.findOrCreateChild(this.NULL_NODE, "childNode");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IllegalArgumentException));
        }
    }

    @Test
    public void shouldFailFindOrCreateChildNodeStringNullPath() {
        try {
            this.tools.findOrCreateChild(this.addressNode, this.NULL_STRING);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IllegalArgumentException));
        }
    }

    @Test
    public void testCreateChildNodeWithParentNameType() throws RepositoryException {
        Node childNode = this.tools.findOrCreateChild(this.personNode, "Hobby", DEF_TYPE);
        Assert.assertNotNull((Object)childNode);
        Assert.assertThat((Object)childNode.getName(), (Matcher)Is.is((Object)"Hobby"));
    }

    @Test
    public void testFindChildNodeWithParentNameType() throws RepositoryException {
        Node childNode = this.tools.findOrCreateChild(this.personNode, "Address", DEF_TYPE);
        Assert.assertNotNull((Object)childNode);
        Assert.assertThat((Object)childNode.getName(), (Matcher)Is.is((Object)"Address"));
    }

    @Test
    public void shouldFailFindOrCreateChildWithNullParentNameType() {
        try {
            this.tools.findOrCreateChild(this.NULL_NODE, "childNode", DEF_TYPE);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IllegalArgumentException));
        }
    }

    @Test
    public void shouldFailFindOrCreateChildNodeStringStringNullPath() {
        try {
            this.tools.findOrCreateChild(this.addressNode, this.NULL_STRING, DEF_TYPE);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IllegalArgumentException));
        }
    }

    protected class MyCustomSecurityContext
    implements SecurityContext {
        protected MyCustomSecurityContext() {
        }

        public String getUserName() {
            return "Fred";
        }

        public boolean hasRole(String roleName) {
            return true;
        }

        public void logout() {
        }
    }
}

