/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.Arrays;
import java.util.List;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeTypeDefinition;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NameFactory;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.jcr.AbstractSessionTest;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.JcrNodeDefinition;
import org.modeshape.jcr.JcrNodeDefinitionTemplate;
import org.modeshape.jcr.JcrNodeType;
import org.modeshape.jcr.JcrNodeTypeTemplate;
import org.modeshape.jcr.JcrNtLexicon;
import org.modeshape.jcr.JcrPropertyDefinition;
import org.modeshape.jcr.JcrPropertyDefinitionTemplate;
import org.modeshape.jcr.nodetype.InvalidNodeTypeDefinitionException;
import org.modeshape.jcr.nodetype.NodeDefinitionTemplate;
import org.modeshape.jcr.nodetype.NodeTypeExistsException;
import org.modeshape.jcr.nodetype.PropertyDefinitionTemplate;

public class TypeRegistrationTest
extends AbstractSessionTest {
    private static final String TEST_TYPE_NAME = "mode:testNode";
    private static final String TEST_TYPE_NAME2 = "mode:testNode2";
    private static final String TEST_PROPERTY_NAME = "mode:testProperty";
    private static final String TEST_CHILD_NODE_NAME = "mode:testChildNode";
    private JcrNodeTypeTemplate ntTemplate;
    private NamespaceRegistry registry;
    private NameFactory nameFactory;

    @Override
    @Before
    public void beforeEach() throws Exception {
        super.beforeEach();
        this.ntTemplate = new JcrNodeTypeTemplate(this.context);
        this.registry = this.context.getNamespaceRegistry();
        this.nameFactory = this.context.getValueFactories().getNameFactory();
    }

    @Ignore
    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowNodeTypeWithInvalidName() throws Exception {
        this.ntTemplate.setName("nt-name");
    }

    @Ignore
    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowPropertyWithInvalidName() throws Exception {
        JcrPropertyDefinitionTemplate prop = new JcrPropertyDefinitionTemplate(this.context);
        prop.setName(":foo[2]");
        System.out.println(prop.getName());
    }

    @Ignore
    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowChildNodeWithInvalidName() throws Exception {
        JcrNodeDefinitionTemplate child = new JcrNodeDefinitionTemplate(this.context);
        child.setName(":foo[2]");
    }

    @Ignore
    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowChildNodeWithInvalidRequiredPrimaryTypeName() throws Exception {
        JcrNodeDefinitionTemplate child = new JcrNodeDefinitionTemplate(this.context);
        child.setRequiredPrimaryTypeNames(new String[]{"nt-Name"});
    }

    @Ignore
    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowChildNodeWithInvalidDefaultPrimaryTypeName() throws Exception {
        JcrNodeDefinitionTemplate child = new JcrNodeDefinitionTemplate(this.context);
        child.setDefaultPrimaryTypeName("nt-Name");
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowNodeTypeWithNoName() throws Exception {
        this.ntTemplate.setName(null);
    }

    @Test
    public void shouldTranslateNameImmediately() throws Exception {
        this.ntTemplate.setName("{http://www.modeshape.org/1.0}foo");
        Assert.assertThat((Object)this.ntTemplate.getName(), (Matcher)Is.is((Object)"mode:foo"));
    }

    @Test
    public void shouldAllowNewDefinitionWithNoChildNodesOrProperties() throws Exception {
        Name testTypeName = (Name)this.nameFactory.create(TEST_TYPE_NAME);
        this.ntTemplate.setName(TEST_TYPE_NAME);
        this.ntTemplate.setDeclaredSuperTypeNames(new String[]{"nt:base"});
        JcrNodeType testNodeType = this.repoTypeManager.registerNodeType((NodeTypeDefinition)this.ntTemplate, false);
        Assert.assertThat((Object)testNodeType.getName(), (Matcher)Is.is((Object)TEST_TYPE_NAME));
        JcrNodeType nodeTypeFromRepo = this.repoTypeManager.getNodeType(testTypeName);
        Assert.assertThat((Object)nodeTypeFromRepo, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)nodeTypeFromRepo.getName(), (Matcher)Is.is((Object)TEST_TYPE_NAME));
    }

    @Test(expected=NodeTypeExistsException.class)
    public void shouldNotAllowModificationIfAllowUpdatesIsFalse() throws Exception {
        this.ntTemplate.setName("nt:base");
        this.repoTypeManager.registerNodeType((NodeTypeDefinition)this.ntTemplate, false);
    }

    @Test(expected=NodeTypeExistsException.class)
    public void shouldNotAllowRedefinitionOfNewTypeIfAllowUpdatesIsFalse() throws Exception {
        Name testTypeName = (Name)this.nameFactory.create(TEST_TYPE_NAME);
        this.ntTemplate.setName(TEST_TYPE_NAME);
        this.ntTemplate.setDeclaredSuperTypeNames(new String[]{"nt:base"});
        JcrNodeType testNodeType = this.repoTypeManager.registerNodeType((NodeTypeDefinition)this.ntTemplate, false);
        Assert.assertThat((Object)testNodeType.getName(), (Matcher)Is.is((Object)TEST_TYPE_NAME));
        JcrNodeType nodeTypeFromRepo = this.repoTypeManager.getNodeType(testTypeName);
        Assert.assertThat((Object)nodeTypeFromRepo, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)nodeTypeFromRepo.getName(), (Matcher)Is.is((Object)TEST_TYPE_NAME));
        testNodeType = this.repoTypeManager.registerNodeType((NodeTypeDefinition)this.ntTemplate, false);
    }

    @Test
    public void shouldAllowDefinitionWithExistingSupertypes() throws Exception {
        Name testTypeName = (Name)this.nameFactory.create(TEST_TYPE_NAME);
        this.ntTemplate.setName(TEST_TYPE_NAME);
        this.ntTemplate.setDeclaredSuperTypeNames(new String[]{"nt:base", "mix:referenceable"});
        JcrNodeType testNodeType = this.repoTypeManager.registerNodeType((NodeTypeDefinition)this.ntTemplate, false);
        Assert.assertThat((Object)testNodeType.getName(), (Matcher)Is.is((Object)TEST_TYPE_NAME));
        JcrNodeType nodeTypeFromRepo = this.repoTypeManager.getNodeType(testTypeName);
        Assert.assertThat((Object)nodeTypeFromRepo, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)nodeTypeFromRepo.getName(), (Matcher)Is.is((Object)TEST_TYPE_NAME));
    }

    @Test
    public void shouldAllowDefinitionWithSupertypesFromTypesRegisteredInSameCall() throws Exception {
        this.ntTemplate.setName(TEST_TYPE_NAME);
        this.ntTemplate.setDeclaredSuperTypeNames(new String[]{"nt:base", "mix:referenceable"});
        JcrNodeTypeTemplate ntTemplate2 = new JcrNodeTypeTemplate(this.context);
        ntTemplate2.setName(TEST_TYPE_NAME2);
        ntTemplate2.setDeclaredSuperTypeNames(new String[]{TEST_TYPE_NAME});
        List<NodeTypeDefinition> templates = Arrays.asList(this.ntTemplate, ntTemplate2);
        this.compareTemplatesToNodeTypes(templates, this.repoTypeManager.registerNodeTypes(templates, false));
    }

    @Test(expected=InvalidNodeTypeDefinitionException.class)
    public void shouldNotAllowDefinitionWithSupertypesFromTypesRegisteredInSameCallInWrongOrder() throws Exception {
        this.ntTemplate.setName(TEST_TYPE_NAME);
        this.ntTemplate.setDeclaredSuperTypeNames(new String[]{"nt:base", "mix:referenceable"});
        JcrNodeTypeTemplate ntTemplate2 = new JcrNodeTypeTemplate(this.context);
        ntTemplate2.setName(TEST_TYPE_NAME2);
        ntTemplate2.setDeclaredSuperTypeNames(new String[]{TEST_TYPE_NAME});
        this.repoTypeManager.registerNodeTypes(Arrays.asList(ntTemplate2, this.ntTemplate), false);
    }

    @Test
    public void shouldAllowDefinitionWithAProperty() throws Exception {
        this.ntTemplate.setName(TEST_TYPE_NAME);
        this.ntTemplate.setDeclaredSuperTypeNames(new String[]{"nt:base", "mix:referenceable"});
        JcrPropertyDefinitionTemplate prop = new JcrPropertyDefinitionTemplate(this.context);
        prop.setRequiredType(3);
        this.ntTemplate.getPropertyDefinitionTemplates().add(prop);
        List<NodeTypeDefinition> templates = Arrays.asList(this.ntTemplate);
        this.compareTemplatesToNodeTypes(templates, this.repoTypeManager.registerNodeTypes(templates, false));
    }

    @Test
    public void shouldAllowDefinitionWithProperties() throws Exception {
        this.ntTemplate.setName(TEST_TYPE_NAME);
        this.ntTemplate.setDeclaredSuperTypeNames(new String[]{"nt:base", "mix:referenceable"});
        JcrPropertyDefinitionTemplate prop = new JcrPropertyDefinitionTemplate(this.context);
        prop.setRequiredType(3);
        this.ntTemplate.getPropertyDefinitionTemplates().add(prop);
        JcrPropertyDefinitionTemplate prop2 = new JcrPropertyDefinitionTemplate(this.context);
        prop2.setRequiredType(1);
        prop2.setMultiple(true);
        this.ntTemplate.getPropertyDefinitionTemplates().add(prop2);
        JcrPropertyDefinitionTemplate prop3 = new JcrPropertyDefinitionTemplate(this.context);
        prop3.setName(TEST_PROPERTY_NAME);
        prop3.setRequiredType(1);
        this.ntTemplate.getPropertyDefinitionTemplates().add(prop3);
        List<NodeTypeDefinition> templates = Arrays.asList(this.ntTemplate);
        this.compareTemplatesToNodeTypes(templates, this.repoTypeManager.registerNodeTypes(templates, false));
    }

    @Test(expected=InvalidNodeTypeDefinitionException.class)
    public void shouldNotAllowAutocreatedPropertyWithNoDefault() throws Exception {
        this.ntTemplate.setName(TEST_TYPE_NAME);
        this.ntTemplate.setDeclaredSuperTypeNames(new String[]{"nt:base", "mix:referenceable"});
        JcrPropertyDefinitionTemplate prop = new JcrPropertyDefinitionTemplate(this.context);
        prop.setName(TEST_PROPERTY_NAME);
        prop.setRequiredType(3);
        prop.setAutoCreated(true);
        this.ntTemplate.getPropertyDefinitionTemplates().add(prop);
        List<NodeTypeDefinition> templates = Arrays.asList(this.ntTemplate);
        this.compareTemplatesToNodeTypes(templates, this.repoTypeManager.registerNodeTypes(templates, false));
    }

    @Test(expected=InvalidNodeTypeDefinitionException.class)
    public void shouldNotAllowAutocreatedResidualProperty() throws Exception {
        this.ntTemplate.setName(TEST_TYPE_NAME);
        this.ntTemplate.setDeclaredSuperTypeNames(new String[]{"nt:base", "mix:referenceable"});
        JcrPropertyDefinitionTemplate prop = new JcrPropertyDefinitionTemplate(this.context);
        prop.setName("*");
        prop.setRequiredType(0);
        prop.setAutoCreated(true);
        this.ntTemplate.getPropertyDefinitionTemplates().add(prop);
        List<NodeTypeDefinition> templates = Arrays.asList(this.ntTemplate);
        this.compareTemplatesToNodeTypes(templates, this.repoTypeManager.registerNodeTypes(templates, false));
    }

    @Test
    public void shouldAllowAutocreatedNamedPropertyWithDefault() throws Exception {
        this.ntTemplate.setName(TEST_TYPE_NAME);
        this.ntTemplate.setDeclaredSuperTypeNames(new String[]{"nt:base", "mix:referenceable"});
        JcrPropertyDefinitionTemplate prop = new JcrPropertyDefinitionTemplate(this.context);
        prop.setName(TEST_PROPERTY_NAME);
        prop.setRequiredType(1);
        prop.setAutoCreated(true);
        prop.setDefaultValues(new String[]{"<default>"});
        this.ntTemplate.getPropertyDefinitionTemplates().add(prop);
        List<NodeTypeDefinition> templates = Arrays.asList(this.ntTemplate);
        this.compareTemplatesToNodeTypes(templates, this.repoTypeManager.registerNodeTypes(templates, false));
    }

    @Test(expected=InvalidNodeTypeDefinitionException.class)
    public void shouldNotAllowSingleValuedPropertyWithMultipleDefaults() throws Exception {
        this.ntTemplate.setName(TEST_TYPE_NAME);
        this.ntTemplate.setDeclaredSuperTypeNames(new String[]{"nt:base", "mix:referenceable"});
        JcrPropertyDefinitionTemplate prop = new JcrPropertyDefinitionTemplate(this.context);
        prop.setName(TEST_PROPERTY_NAME);
        prop.setRequiredType(1);
        prop.setAutoCreated(true);
        prop.setDefaultValues(new String[]{"<default>", "too many values"});
        this.ntTemplate.getPropertyDefinitionTemplates().add(prop);
        List<NodeTypeDefinition> templates = Arrays.asList(this.ntTemplate);
        this.compareTemplatesToNodeTypes(templates, this.repoTypeManager.registerNodeTypes(templates, false));
    }

    @Test(expected=InvalidNodeTypeDefinitionException.class)
    public void shouldNotAllowMandatoryResidualProperty() throws Exception {
        this.ntTemplate.setName(TEST_TYPE_NAME);
        this.ntTemplate.setDeclaredSuperTypeNames(new String[]{"nt:base", "mix:referenceable"});
        JcrPropertyDefinitionTemplate prop = new JcrPropertyDefinitionTemplate(this.context);
        prop.setName("*");
        prop.setRequiredType(0);
        prop.setMandatory(true);
        this.ntTemplate.getPropertyDefinitionTemplates().add(prop);
        List<NodeTypeDefinition> templates = Arrays.asList(this.ntTemplate);
        this.compareTemplatesToNodeTypes(templates, this.repoTypeManager.registerNodeTypes(templates, false));
    }

    @Test
    public void shouldAllowTypeWithChildNode() throws Exception {
        this.ntTemplate.setName(TEST_TYPE_NAME);
        this.ntTemplate.setDeclaredSuperTypeNames(new String[]{"nt:base", "mix:referenceable"});
        JcrNodeDefinitionTemplate child = new JcrNodeDefinitionTemplate(this.context);
        child.setName(TEST_CHILD_NODE_NAME);
        child.setRequiredPrimaryTypeNames(new String[]{"nt:base"});
        child.setSameNameSiblings(true);
        this.ntTemplate.getNodeDefinitionTemplates().add(child);
        List<NodeTypeDefinition> templates = Arrays.asList(this.ntTemplate);
        this.compareTemplatesToNodeTypes(templates, this.repoTypeManager.registerNodeTypes(templates, false));
    }

    @Test
    public void shouldAllowTypeWithMultipleChildNodes() throws Exception {
        this.ntTemplate.setName(TEST_TYPE_NAME);
        this.ntTemplate.setDeclaredSuperTypeNames(new String[]{"nt:base", "mix:referenceable"});
        JcrNodeDefinitionTemplate child = new JcrNodeDefinitionTemplate(this.context);
        child.setName(TEST_CHILD_NODE_NAME);
        child.setRequiredPrimaryTypeNames(new String[]{"nt:base"});
        child.setSameNameSiblings(true);
        this.ntTemplate.getNodeDefinitionTemplates().add(child);
        child = new JcrNodeDefinitionTemplate(this.context);
        child.setName(TEST_CHILD_NODE_NAME);
        child.setRequiredPrimaryTypeNames(new String[]{"nt:unstructured"});
        child.setSameNameSiblings(false);
        this.ntTemplate.getNodeDefinitionTemplates().add(child);
        child = new JcrNodeDefinitionTemplate(this.context);
        child.setName("mode:testChildNode2");
        child.setRequiredPrimaryTypeNames(new String[]{"nt:base"});
        child.setSameNameSiblings(true);
        this.ntTemplate.getNodeDefinitionTemplates().add(child);
        List<NodeTypeDefinition> templates = Arrays.asList(this.ntTemplate);
        this.compareTemplatesToNodeTypes(templates, this.repoTypeManager.registerNodeTypes(templates, false));
    }

    @Test(expected=InvalidNodeTypeDefinitionException.class)
    public void shouldNotAllowAutocreatedChildNodeWithNoDefaultPrimaryType() throws Exception {
        this.ntTemplate.setName(TEST_TYPE_NAME);
        this.ntTemplate.setDeclaredSuperTypeNames(new String[]{"nt:base", "mix:referenceable"});
        JcrNodeDefinitionTemplate child = new JcrNodeDefinitionTemplate(this.context);
        child.setName(TEST_CHILD_NODE_NAME);
        child.setRequiredPrimaryTypeNames(new String[]{"nt:base"});
        child.setAutoCreated(true);
        this.ntTemplate.getNodeDefinitionTemplates().add(child);
        List<NodeTypeDefinition> templates = Arrays.asList(this.ntTemplate);
        this.compareTemplatesToNodeTypes(templates, this.repoTypeManager.registerNodeTypes(templates, false));
    }

    @Test(expected=InvalidNodeTypeDefinitionException.class)
    public void shouldNotAllowMandatoryResidualChildNode() throws Exception {
        this.ntTemplate.setName(TEST_TYPE_NAME);
        this.ntTemplate.setDeclaredSuperTypeNames(new String[]{"nt:base", "mix:referenceable"});
        JcrNodeDefinitionTemplate child = new JcrNodeDefinitionTemplate(this.context);
        child.setName("*");
        child.setRequiredPrimaryTypeNames(new String[]{"nt:base"});
        child.setMandatory(true);
        this.ntTemplate.getNodeDefinitionTemplates().add(child);
        List<NodeTypeDefinition> templates = Arrays.asList(this.ntTemplate);
        this.compareTemplatesToNodeTypes(templates, this.repoTypeManager.registerNodeTypes(templates, false));
    }

    @Test(expected=InvalidNodeTypeDefinitionException.class)
    public void shouldNotAllowOverridingProtectedProperty() throws Exception {
        this.ntTemplate.setName(TEST_TYPE_NAME);
        this.ntTemplate.setDeclaredSuperTypeNames(new String[]{"nt:base", "mix:referenceable"});
        JcrPropertyDefinitionTemplate prop = new JcrPropertyDefinitionTemplate(this.context);
        prop.setName(JcrLexicon.PRIMARY_TYPE.getString(this.registry));
        prop.setRequiredType(7);
        this.ntTemplate.getPropertyDefinitionTemplates().add(prop);
        List<NodeTypeDefinition> templates = Arrays.asList(this.ntTemplate);
        this.compareTemplatesToNodeTypes(templates, this.repoTypeManager.registerNodeTypes(templates, false));
    }

    @Test(expected=InvalidNodeTypeDefinitionException.class)
    public void shouldNotAllowOverridingProtectedChildNode() throws Exception {
        this.ntTemplate.setName(TEST_TYPE_NAME);
        this.ntTemplate.setDeclaredSuperTypeNames(new String[]{"mode:root", "mix:referenceable"});
        JcrNodeDefinitionTemplate child = new JcrNodeDefinitionTemplate(this.context);
        child.setName(JcrLexicon.SYSTEM.getString(this.registry));
        child.setRequiredPrimaryTypeNames(new String[]{"nt:base"});
        this.ntTemplate.getNodeDefinitionTemplates().add(child);
        List<NodeTypeDefinition> templates = Arrays.asList(this.ntTemplate);
        this.compareTemplatesToNodeTypes(templates, this.repoTypeManager.registerNodeTypes(templates, false));
    }

    @Test(expected=InvalidNodeTypeDefinitionException.class)
    public void shouldNotAllowOverridingMandatoryChildNodeWithOptionalChildNode() throws Exception {
        this.ntTemplate.setName(TEST_TYPE_NAME);
        this.ntTemplate.setDeclaredSuperTypeNames(new String[]{"jcr:versionHistory"});
        JcrNodeDefinitionTemplate child = new JcrNodeDefinitionTemplate(this.context);
        child.setName(JcrLexicon.SYSTEM.getString(this.registry));
        child.setRequiredPrimaryTypeNames(new String[]{"nt:base"});
        this.ntTemplate.getNodeDefinitionTemplates().add(child);
        List<NodeTypeDefinition> templates = Arrays.asList(this.ntTemplate);
        this.compareTemplatesToNodeTypes(templates, this.repoTypeManager.registerNodeTypes(templates, false));
    }

    @Test
    public void shouldAllowOverridingPropertyFromCommonAncestor() throws Exception {
        this.ntTemplate.setName(TEST_TYPE_NAME);
        this.ntTemplate.setDeclaredSuperTypeNames(new String[]{"nt:base"});
        JcrPropertyDefinitionTemplate prop = new JcrPropertyDefinitionTemplate(this.context);
        prop.setName(TEST_PROPERTY_NAME);
        prop.setRequiredType(0);
        this.ntTemplate.getPropertyDefinitionTemplates().add(prop);
        JcrNodeTypeTemplate nodeBTemplate = new JcrNodeTypeTemplate(this.context);
        nodeBTemplate.setName("mode:testNodeB");
        nodeBTemplate.setDeclaredSuperTypeNames(new String[]{TEST_TYPE_NAME});
        JcrNodeTypeTemplate nodeCTemplate = new JcrNodeTypeTemplate(this.context);
        nodeCTemplate.setName("mode:testNodeC");
        nodeCTemplate.setDeclaredSuperTypeNames(new String[]{TEST_TYPE_NAME});
        JcrNodeTypeTemplate nodeDTemplate = new JcrNodeTypeTemplate(this.context);
        nodeDTemplate.setName("mode:testNodeD");
        nodeDTemplate.setDeclaredSuperTypeNames(new String[]{"mode:testNodeB", "mode:testNodeC"});
        prop = new JcrPropertyDefinitionTemplate(this.context);
        prop.setName(TEST_PROPERTY_NAME);
        prop.setRequiredType(1);
        nodeDTemplate.getPropertyDefinitionTemplates().add(prop);
        List<NodeTypeDefinition> templates = Arrays.asList(this.ntTemplate, nodeBTemplate, nodeCTemplate, nodeDTemplate);
        this.compareTemplatesToNodeTypes(templates, this.repoTypeManager.registerNodeTypes(templates, false));
    }

    @Test(expected=InvalidNodeTypeDefinitionException.class)
    public void shouldNotAllowOverridingPropertyFromDifferentAncestors() throws Exception {
        this.ntTemplate.setName(TEST_TYPE_NAME);
        this.ntTemplate.setDeclaredSuperTypeNames(new String[]{"nt:base"});
        JcrNodeTypeTemplate nodeBTemplate = new JcrNodeTypeTemplate(this.context);
        nodeBTemplate.setName("mode:testNodeB");
        nodeBTemplate.setDeclaredSuperTypeNames(new String[]{TEST_TYPE_NAME});
        JcrPropertyDefinitionTemplate prop = new JcrPropertyDefinitionTemplate(this.context);
        prop.setName(TEST_PROPERTY_NAME);
        prop.setRequiredType(0);
        nodeBTemplate.getPropertyDefinitionTemplates().add(prop);
        JcrNodeTypeTemplate nodeCTemplate = new JcrNodeTypeTemplate(this.context);
        nodeCTemplate.setName("mode:testNodeC");
        nodeCTemplate.setDeclaredSuperTypeNames(new String[]{TEST_TYPE_NAME});
        prop = new JcrPropertyDefinitionTemplate(this.context);
        prop.setName(TEST_PROPERTY_NAME);
        prop.setRequiredType(0);
        nodeCTemplate.getPropertyDefinitionTemplates().add(prop);
        JcrNodeTypeTemplate nodeDTemplate = new JcrNodeTypeTemplate(this.context);
        nodeDTemplate.setName("mode:testNodeD");
        nodeDTemplate.setDeclaredSuperTypeNames(new String[]{nodeBTemplate.getName(), nodeCTemplate.getName()});
        List<NodeTypeDefinition> templates = Arrays.asList(this.ntTemplate, nodeBTemplate, nodeCTemplate, nodeDTemplate);
        this.compareTemplatesToNodeTypes(templates, this.repoTypeManager.registerNodeTypes(templates, false));
    }

    @Test
    public void shouldAllowOverridingChildNodeFromCommonAncestor() throws Exception {
        this.ntTemplate.setName(TEST_TYPE_NAME);
        this.ntTemplate.setDeclaredSuperTypeNames(new String[]{"nt:base"});
        JcrNodeDefinitionTemplate child = new JcrNodeDefinitionTemplate(this.context);
        child.setName(JcrLexicon.SYSTEM.getString(this.registry));
        child.setRequiredPrimaryTypeNames(new String[]{"nt:base"});
        this.ntTemplate.getNodeDefinitionTemplates().add(child);
        JcrNodeTypeTemplate nodeBTemplate = new JcrNodeTypeTemplate(this.context);
        nodeBTemplate.setName("mode:testNodeB");
        nodeBTemplate.setDeclaredSuperTypeNames(new String[]{TEST_TYPE_NAME});
        JcrNodeTypeTemplate nodeCTemplate = new JcrNodeTypeTemplate(this.context);
        nodeCTemplate.setName("mode:testNodeC");
        nodeCTemplate.setDeclaredSuperTypeNames(new String[]{TEST_TYPE_NAME});
        JcrNodeTypeTemplate nodeDTemplate = new JcrNodeTypeTemplate(this.context);
        nodeDTemplate.setName("mode:testNodeD");
        nodeDTemplate.setDeclaredSuperTypeNames(new String[]{"mode:testNodeB", "mode:testNodeC"});
        child = new JcrNodeDefinitionTemplate(this.context);
        child.setName(JcrLexicon.SYSTEM.getString(this.registry));
        child.setRequiredPrimaryTypeNames(new String[]{"nt:unstructured"});
        nodeDTemplate.getNodeDefinitionTemplates().add(child);
        List<NodeTypeDefinition> templates = Arrays.asList(this.ntTemplate, nodeBTemplate, nodeCTemplate, nodeDTemplate);
        this.compareTemplatesToNodeTypes(templates, this.repoTypeManager.registerNodeTypes(templates, false));
    }

    @Test(expected=InvalidNodeTypeDefinitionException.class)
    public void shouldNotAllowOverridingChildNodeFromDifferentAncestors() throws Exception {
        this.ntTemplate.setName(TEST_TYPE_NAME);
        this.ntTemplate.setDeclaredSuperTypeNames(new String[]{"nt:base"});
        JcrNodeTypeTemplate nodeBTemplate = new JcrNodeTypeTemplate(this.context);
        nodeBTemplate.setName("mode:testNodeB");
        nodeBTemplate.setDeclaredSuperTypeNames(new String[]{TEST_TYPE_NAME});
        JcrNodeDefinitionTemplate child = new JcrNodeDefinitionTemplate(this.context);
        child.setName(JcrLexicon.SYSTEM.getString(this.registry));
        child.setRequiredPrimaryTypeNames(new String[]{"nt:base"});
        nodeBTemplate.getNodeDefinitionTemplates().add(child);
        JcrNodeTypeTemplate nodeCTemplate = new JcrNodeTypeTemplate(this.context);
        nodeCTemplate.setName("mode:testNodeC");
        nodeCTemplate.setDeclaredSuperTypeNames(new String[]{TEST_TYPE_NAME});
        child = new JcrNodeDefinitionTemplate(this.context);
        child.setName(JcrLexicon.SYSTEM.getString(this.registry));
        child.setRequiredPrimaryTypeNames(new String[]{"nt:base"});
        nodeCTemplate.getNodeDefinitionTemplates().add(child);
        JcrNodeTypeTemplate nodeDTemplate = new JcrNodeTypeTemplate(this.context);
        nodeDTemplate.setName("mode:testNodeD");
        nodeDTemplate.setDeclaredSuperTypeNames(new String[]{nodeBTemplate.getName(), nodeCTemplate.getName()});
        List<NodeTypeDefinition> templates = Arrays.asList(this.ntTemplate, nodeBTemplate, nodeCTemplate, nodeDTemplate);
        this.compareTemplatesToNodeTypes(templates, this.repoTypeManager.registerNodeTypes(templates, false));
    }

    @Test
    public void shouldAllowExtendingPropertyIfMultipleChanges() throws Exception {
        this.ntTemplate.setName(TEST_TYPE_NAME);
        this.ntTemplate.setDeclaredSuperTypeNames(new String[]{"nt:base"});
        JcrPropertyDefinitionTemplate prop = new JcrPropertyDefinitionTemplate(this.context);
        prop.setName(TEST_PROPERTY_NAME);
        prop.setRequiredType(4);
        prop.setMultiple(false);
        this.ntTemplate.getPropertyDefinitionTemplates().add(prop);
        JcrNodeTypeTemplate nodeBTemplate = new JcrNodeTypeTemplate(this.context);
        nodeBTemplate.setName("mode:testNodeB");
        nodeBTemplate.setDeclaredSuperTypeNames(new String[]{TEST_TYPE_NAME});
        prop = new JcrPropertyDefinitionTemplate(this.context);
        prop.setName(TEST_PROPERTY_NAME);
        prop.setRequiredType(6);
        prop.setMultiple(true);
        nodeBTemplate.getPropertyDefinitionTemplates().add(prop);
        JcrNodeTypeTemplate nodeCTemplate = new JcrNodeTypeTemplate(this.context);
        nodeCTemplate.setName("mode:testNodeC");
        nodeCTemplate.setDeclaredSuperTypeNames(new String[]{TEST_TYPE_NAME, nodeBTemplate.getName()});
        List<NodeTypeDefinition> templates = Arrays.asList(this.ntTemplate, nodeBTemplate, nodeCTemplate);
        this.compareTemplatesToNodeTypes(templates, this.repoTypeManager.registerNodeTypes(templates, false));
    }

    @Test
    public void shouldAllowOverridingPropertyIfTypeNarrows() throws Exception {
        this.ntTemplate.setName(TEST_TYPE_NAME);
        this.ntTemplate.setDeclaredSuperTypeNames(new String[]{"nt:base"});
        JcrPropertyDefinitionTemplate prop = new JcrPropertyDefinitionTemplate(this.context);
        prop.setName(TEST_PROPERTY_NAME);
        prop.setRequiredType(0);
        prop.setMultiple(false);
        this.ntTemplate.getPropertyDefinitionTemplates().add(prop);
        JcrNodeTypeTemplate nodeBTemplate = new JcrNodeTypeTemplate(this.context);
        nodeBTemplate.setName("mode:testNodeB");
        nodeBTemplate.setDeclaredSuperTypeNames(new String[]{TEST_TYPE_NAME});
        prop = new JcrPropertyDefinitionTemplate(this.context);
        prop.setName(TEST_PROPERTY_NAME);
        prop.setRequiredType(1);
        prop.setMultiple(false);
        nodeBTemplate.getPropertyDefinitionTemplates().add(prop);
        List<NodeTypeDefinition> templates = Arrays.asList(this.ntTemplate, nodeBTemplate);
        this.compareTemplatesToNodeTypes(templates, this.repoTypeManager.registerNodeTypes(templates, false));
    }

    @Test(expected=InvalidNodeTypeDefinitionException.class)
    public void shouldNotAllowOverridingPropertyIfTypeDoesNotNarrow() throws Exception {
        this.ntTemplate.setName(TEST_TYPE_NAME);
        this.ntTemplate.setDeclaredSuperTypeNames(new String[]{"nt:base"});
        JcrPropertyDefinitionTemplate prop = new JcrPropertyDefinitionTemplate(this.context);
        prop.setName(TEST_PROPERTY_NAME);
        prop.setRequiredType(6);
        prop.setMultiple(false);
        this.ntTemplate.getPropertyDefinitionTemplates().add(prop);
        JcrNodeTypeTemplate nodeBTemplate = new JcrNodeTypeTemplate(this.context);
        nodeBTemplate.setName("mode:testNodeB");
        nodeBTemplate.setDeclaredSuperTypeNames(new String[]{TEST_TYPE_NAME});
        prop = new JcrPropertyDefinitionTemplate(this.context);
        prop.setName(TEST_PROPERTY_NAME);
        prop.setRequiredType(4);
        prop.setMultiple(false);
        nodeBTemplate.getPropertyDefinitionTemplates().add(prop);
        List<NodeTypeDefinition> templates = Arrays.asList(this.ntTemplate, nodeBTemplate);
        this.compareTemplatesToNodeTypes(templates, this.repoTypeManager.registerNodeTypes(templates, false));
    }

    @Test
    public void shouldAllowOverridingChildNodeIfRequiredTypesNarrow() throws Exception {
        this.ntTemplate.setName(TEST_TYPE_NAME);
        this.ntTemplate.setDeclaredSuperTypeNames(new String[]{"nt:base"});
        JcrNodeDefinitionTemplate child = new JcrNodeDefinitionTemplate(this.context);
        child.setName(TEST_CHILD_NODE_NAME);
        child.setRequiredPrimaryTypeNames(new String[]{"nt:hierarchyNode"});
        child.setSameNameSiblings(false);
        this.ntTemplate.getNodeDefinitionTemplates().add(child);
        JcrNodeTypeTemplate nodeBTemplate = new JcrNodeTypeTemplate(this.context);
        nodeBTemplate.setName("mode:testNodeB");
        nodeBTemplate.setDeclaredSuperTypeNames(new String[]{TEST_TYPE_NAME});
        child = new JcrNodeDefinitionTemplate(this.context);
        child.setName(TEST_CHILD_NODE_NAME);
        child.setRequiredPrimaryTypeNames(new String[]{"nt:file"});
        child.setSameNameSiblings(false);
        nodeBTemplate.getNodeDefinitionTemplates().add(child);
        List<NodeTypeDefinition> templates = Arrays.asList(this.ntTemplate, nodeBTemplate);
        this.compareTemplatesToNodeTypes(templates, this.repoTypeManager.registerNodeTypes(templates, false));
    }

    @Test(expected=InvalidNodeTypeDefinitionException.class)
    public void shouldNotAllowOverridingChildNodeIfRequiredTypesDoNotNarrow() throws Exception {
        this.ntTemplate.setName(TEST_TYPE_NAME);
        this.ntTemplate.setDeclaredSuperTypeNames(new String[]{"nt:base"});
        JcrNodeDefinitionTemplate child = new JcrNodeDefinitionTemplate(this.context);
        child.setName(TEST_CHILD_NODE_NAME);
        child.setRequiredPrimaryTypeNames(new String[]{"nt:hierarchyNode"});
        child.setSameNameSiblings(false);
        this.ntTemplate.getNodeDefinitionTemplates().add(child);
        JcrNodeTypeTemplate nodeBTemplate = new JcrNodeTypeTemplate(this.context);
        nodeBTemplate.setName("mode:testNodeB");
        nodeBTemplate.setDeclaredSuperTypeNames(new String[]{TEST_TYPE_NAME});
        child = new JcrNodeDefinitionTemplate(this.context);
        child.setName(TEST_CHILD_NODE_NAME);
        child.setRequiredPrimaryTypeNames(new String[]{"nt:base"});
        child.setSameNameSiblings(false);
        nodeBTemplate.getNodeDefinitionTemplates().add(child);
        List<NodeTypeDefinition> templates = Arrays.asList(this.ntTemplate, nodeBTemplate);
        this.compareTemplatesToNodeTypes(templates, this.repoTypeManager.registerNodeTypes(templates, false));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowUnregisteringNullCollection() throws Exception {
        this.repoTypeManager.unregisterNodeType(null);
    }

    @Test(expected=NoSuchNodeTypeException.class)
    public void shouldNotAllowUnregisteringInvalidTypeNames() throws Exception {
        this.repoTypeManager.unregisterNodeType(Arrays.asList(JcrNtLexicon.FILE, JcrLexicon.DATA));
    }

    @Test(expected=InvalidNodeTypeDefinitionException.class)
    public void shouldNotAllowUnregisteringSupertype() throws Exception {
        this.repoTypeManager.unregisterNodeType(Arrays.asList(JcrNtLexicon.HIERARCHY_NODE));
    }

    @Test(expected=InvalidNodeTypeDefinitionException.class)
    public void shouldNotAllowUnregisteringRequiredPrimaryType() throws Exception {
        this.repoTypeManager.unregisterNodeType(Arrays.asList(JcrNtLexicon.FROZEN_NODE));
    }

    @Test(expected=InvalidNodeTypeDefinitionException.class)
    public void shouldNotAllowUnregisteringDefaultPrimaryType() throws Exception {
        this.ntTemplate.setName(TEST_TYPE_NAME);
        JcrNodeDefinitionTemplate childNode = new JcrNodeDefinitionTemplate(this.context);
        childNode.setDefaultPrimaryType(JcrNtLexicon.FILE.getString(this.registry));
        this.ntTemplate.getNodeDefinitionTemplates().add(childNode);
        try {
            this.repoTypeManager.registerNodeType((NodeTypeDefinition)this.ntTemplate, false);
        }
        catch (Exception ex) {
            Assert.fail((String)ex.getMessage());
        }
        this.repoTypeManager.unregisterNodeType(Arrays.asList(JcrNtLexicon.FILE));
    }

    @Test
    public void shouldAllowUnregisteringUnusedType() throws Exception {
        this.ntTemplate.setName(TEST_TYPE_NAME);
        JcrNodeDefinitionTemplate childNode = new JcrNodeDefinitionTemplate(this.context);
        childNode.setDefaultPrimaryType(JcrNtLexicon.FILE.getString(this.registry));
        this.ntTemplate.getNodeDefinitionTemplates().add(childNode);
        try {
            this.repoTypeManager.registerNodeType((NodeTypeDefinition)this.ntTemplate, false);
        }
        catch (Exception ex) {
            Assert.fail((String)ex.getMessage());
        }
        Name typeNameAsName = (Name)this.nameFactory.create(TEST_TYPE_NAME);
        int nodeTypeCount = this.repoTypeManager.getAllNodeTypes().size();
        this.repoTypeManager.unregisterNodeType(Arrays.asList(typeNameAsName));
        Assert.assertThat((Object)this.repoTypeManager.getAllNodeTypes().size(), (Matcher)Is.is((Object)(nodeTypeCount - 1)));
        Assert.assertThat((Object)this.repoTypeManager.getNodeType(typeNameAsName), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldAllowUnregisteringUnusedTypesWithMutualDependencies() throws Exception {
        this.ntTemplate.setName(TEST_TYPE_NAME);
        JcrNodeDefinitionTemplate childNode = new JcrNodeDefinitionTemplate(this.context);
        childNode.setDefaultPrimaryType(TEST_TYPE_NAME2);
        this.ntTemplate.getNodeDefinitionTemplates().add(childNode);
        JcrNodeTypeTemplate ntTemplate2 = new JcrNodeTypeTemplate(this.context);
        ntTemplate2.setName(TEST_TYPE_NAME2);
        JcrNodeDefinitionTemplate childNode2 = new JcrNodeDefinitionTemplate(this.context);
        childNode2.setDefaultPrimaryType(TEST_TYPE_NAME);
        ntTemplate2.getNodeDefinitionTemplates().add(childNode2);
        try {
            this.repoTypeManager.registerNodeTypes(Arrays.asList(this.ntTemplate, ntTemplate2), false);
        }
        catch (Exception ex) {
            Assert.fail((String)ex.getMessage());
        }
        Name typeNameAsName = (Name)this.nameFactory.create(TEST_TYPE_NAME);
        Name type2NameAsName = (Name)this.nameFactory.create(TEST_TYPE_NAME2);
        int nodeTypeCount = this.repoTypeManager.getAllNodeTypes().size();
        this.repoTypeManager.unregisterNodeType(Arrays.asList(typeNameAsName, type2NameAsName));
        Assert.assertThat((Object)this.repoTypeManager.getAllNodeTypes().size(), (Matcher)Is.is((Object)(nodeTypeCount - 2)));
        Assert.assertThat((Object)this.repoTypeManager.getNodeType(typeNameAsName), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.repoTypeManager.getNodeType(type2NameAsName), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    private void compareTemplatesToNodeTypes(List<NodeTypeDefinition> templates, List<JcrNodeType> nodeTypes) {
        Assert.assertThat((Object)templates.size(), (Matcher)Is.is((Object)nodeTypes.size()));
        for (int i = 0; i < nodeTypes.size(); ++i) {
            JcrNodeTypeTemplate jntt = (JcrNodeTypeTemplate)templates.get(i);
            this.compareTemplateToNodeType(jntt, null);
            this.compareTemplateToNodeType(jntt, nodeTypes.get(i));
        }
    }

    private void compareTemplateToNodeType(JcrNodeTypeTemplate template, JcrNodeType nodeType) {
        Name nodeTypeName = (Name)this.nameFactory.create(template.getName());
        if (nodeType == null) {
            nodeType = this.repoTypeManager.getNodeType(nodeTypeName);
            Assert.assertThat((Object)nodeType.nodeTypeManager(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        }
        Assert.assertThat((Object)nodeType, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)nodeType.getName(), (Matcher)Is.is((Object)template.getName()));
        Assert.assertThat((Object)nodeType.getDeclaredSupertypes().length, (Matcher)Is.is((Object)template.getDeclaredSupertypeNames().length));
        for (int i = 0; i < template.getDeclaredSupertypeNames().length; ++i) {
            Assert.assertThat((Object)template.getDeclaredSupertypeNames()[i], (Matcher)Is.is((Object)nodeType.getDeclaredSupertypes()[i].getName()));
        }
        Assert.assertThat((Object)template.isMixin(), (Matcher)Is.is((Object)nodeType.isMixin()));
        Assert.assertThat((Object)template.hasOrderableChildNodes(), (Matcher)Is.is((Object)nodeType.hasOrderableChildNodes()));
        JcrPropertyDefinition[] propertyDefs = nodeType.getDeclaredPropertyDefinitions();
        List propertyTemplates = template.getPropertyDefinitionTemplates();
        Assert.assertThat((Object)propertyDefs.length, (Matcher)Is.is((Object)propertyTemplates.size()));
        for (PropertyDefinitionTemplate pt : propertyTemplates) {
            JcrPropertyDefinitionTemplate propertyTemplate = (JcrPropertyDefinitionTemplate)pt;
            JcrPropertyDefinition matchingDefinition = null;
            for (int i = 0; i < propertyDefs.length; ++i) {
                String ptName;
                JcrPropertyDefinition pd = propertyDefs[i];
                String string = ptName = propertyTemplate.getName() == null ? "*" : propertyTemplate.getName();
                if (!pd.getName().equals(ptName) || pd.getRequiredType() != propertyTemplate.getRequiredType() || pd.isMultiple() != propertyTemplate.isMultiple()) continue;
                matchingDefinition = pd;
                break;
            }
            this.comparePropertyTemplateToPropertyDefinition(propertyTemplate, matchingDefinition);
        }
        JcrNodeDefinition[] childNodeDefs = nodeType.getDeclaredChildNodeDefinitions();
        List childNodeTemplates = template.getNodeDefinitionTemplates();
        Assert.assertThat((Object)childNodeDefs.length, (Matcher)Is.is((Object)childNodeTemplates.size()));
        for (NodeDefinitionTemplate nt : childNodeTemplates) {
            JcrNodeDefinitionTemplate childNodeTemplate = (JcrNodeDefinitionTemplate)nt;
            JcrNodeDefinition matchingDefinition = null;
            for (int i = 0; i < childNodeDefs.length; ++i) {
                String ntName;
                JcrNodeDefinition nd = childNodeDefs[i];
                String string = ntName = childNodeTemplate.getName() == null ? "*" : childNodeTemplate.getName();
                if (!nd.getName().equals(ntName) || nd.allowsSameNameSiblings() != childNodeTemplate.allowsSameNameSiblings() || nd.getRequiredPrimaryTypes().length != childNodeTemplate.getRequiredPrimaryTypeNames().length) continue;
                boolean matchesOnRequiredTypes = true;
                for (int j = 0; j < nd.getRequiredPrimaryTypes().length; ++j) {
                    String tempName;
                    String ndName = nd.getRequiredPrimaryTypes()[j].getName();
                    if (ndName.equals(tempName = childNodeTemplate.getRequiredPrimaryTypeNames()[j])) continue;
                    matchesOnRequiredTypes = false;
                    break;
                }
                if (!matchesOnRequiredTypes) continue;
                matchingDefinition = nd;
                break;
            }
            this.compareNodeTemplateToNodeDefinition(childNodeTemplate, matchingDefinition);
        }
    }

    private void comparePropertyTemplateToPropertyDefinition(JcrPropertyDefinitionTemplate template, JcrPropertyDefinition definition) {
        Assert.assertThat((Object)definition, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)definition.getDeclaringNodeType(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)this.emptyIfNull(template.getValueConstraints()), (Matcher)Is.is((Object)definition.getValueConstraints()));
        Assert.assertThat((Object)template.getOnParentVersion(), (Matcher)Is.is((Object)definition.getOnParentVersion()));
        Assert.assertThat((Object)template.getRequiredType(), (Matcher)Is.is((Object)definition.getRequiredType()));
        Assert.assertThat((Object)template.isAutoCreated(), (Matcher)Is.is((Object)definition.isAutoCreated()));
        Assert.assertThat((Object)template.isMandatory(), (Matcher)Is.is((Object)definition.isMandatory()));
        Assert.assertThat((Object)template.isMultiple(), (Matcher)Is.is((Object)definition.isMultiple()));
        Assert.assertThat((Object)template.isProtected(), (Matcher)Is.is((Object)definition.isProtected()));
    }

    private void compareNodeTemplateToNodeDefinition(JcrNodeDefinitionTemplate template, JcrNodeDefinition definition) {
        Assert.assertThat((Object)definition, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)definition.getDeclaringNodeType(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)template.getOnParentVersion(), (Matcher)Is.is((Object)definition.getOnParentVersion()));
        Assert.assertThat((Object)template.isAutoCreated(), (Matcher)Is.is((Object)definition.isAutoCreated()));
        Assert.assertThat((Object)template.isMandatory(), (Matcher)Is.is((Object)definition.isMandatory()));
        Assert.assertThat((Object)template.isProtected(), (Matcher)Is.is((Object)definition.isProtected()));
        Assert.assertThat((Object)template.getDefaultPrimaryType(), (Matcher)Is.is((Object)definition.getDefaultPrimaryType()));
        Assert.assertThat((Object)template.allowsSameNameSiblings(), (Matcher)Is.is((Object)definition.allowsSameNameSiblings()));
    }

    private String[] emptyIfNull(String[] incoming) {
        if (incoming != null) {
            return incoming;
        }
        return new String[0];
    }
}

