/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.xpath;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.common.FixFor;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.query.model.QueryCommand;
import org.modeshape.graph.query.model.TypeSystem;
import org.modeshape.graph.query.parse.SqlQueryParser;
import org.modeshape.jcr.xpath.XPath;
import org.modeshape.jcr.xpath.XPathParser;
import org.modeshape.jcr.xpath.XPathToQueryTranslator;

public class XPathToQueryTranslatorTest {
    private ExecutionContext context;
    private TypeSystem typeSystem;
    private XPathParser parser;

    @Before
    public void beforeEach() {
        this.context = new ExecutionContext();
        this.context.getNamespaceRegistry().register("x", "http://example.com");
        this.typeSystem = this.context.getValueFactories().getTypeSystem();
        this.parser = new XPathParser(this.typeSystem);
    }

    @After
    public void afterEach() {
        this.parser = null;
    }

    @Test
    public void shouldTranslateXPathExpressionsToSql() {
        this.printSqlFor("//element(*,my:type)");
        this.printSqlFor("//element(nodeName,my:type)");
    }

    @Test
    public void shouldTranslateFromXPathOfAnyNode() {
        Assert.assertThat((Object)this.xpath("//element(*)"), this.isSql("SELECT nodeSet1.[jcr:primaryType] FROM __ALLNODES__ AS nodeSet1"));
        Assert.assertThat((Object)this.xpath("/jcr:root//element(*)"), this.isSql("SELECT nodeSet1.[jcr:primaryType] FROM __ALLNODES__ AS nodeSet1"));
        Assert.assertThat((Object)this.xpath("//*"), this.isSql("SELECT nodeSet1.[jcr:primaryType] FROM __ALLNODES__ AS nodeSet1"));
        Assert.assertThat((Object)this.xpath("/jcr:root//*"), this.isSql("SELECT nodeSet1.[jcr:primaryType] FROM __ALLNODES__ AS nodeSet1"));
        Assert.assertThat((Object)this.xpath("//."), this.isSql("SELECT nodeSet1.[jcr:primaryType] FROM __ALLNODES__ AS nodeSet1"));
        Assert.assertThat((Object)this.xpath("/jcr:root//."), this.isSql("SELECT nodeSet1.[jcr:primaryType] FROM __ALLNODES__ AS nodeSet1"));
    }

    @Test
    public void shouldTranslateFromXPathContainingExplicitRootPath() {
        Assert.assertThat((Object)this.xpath("/jcr:root"), this.isSql("SELECT nodeSet1.[jcr:primaryType] FROM __ALLNODES__ AS nodeSet1 WHERE PATH(nodeSet1) = '/'"));
    }

    @Test
    public void shouldTranslateFromXPathContainingExplicitPath() {
        Assert.assertThat((Object)this.xpath("/jcr:root/a"), this.isSql("SELECT nodeSet1.[jcr:primaryType] FROM __ALLNODES__ AS nodeSet1 WHERE PATH(nodeSet1) = '/a'"));
        Assert.assertThat((Object)this.xpath("/jcr:root/a/b"), this.isSql("SELECT nodeSet1.[jcr:primaryType] FROM __ALLNODES__ AS nodeSet1 WHERE PATH(nodeSet1) = '/a/b'"));
        Assert.assertThat((Object)this.xpath("/jcr:root/a/b/c"), this.isSql("SELECT nodeSet1.[jcr:primaryType] FROM __ALLNODES__ AS nodeSet1 WHERE PATH(nodeSet1) = '/a/b/c'"));
        Assert.assertThat((Object)this.xpath("/jcr:root/a/b/c/d"), this.isSql("SELECT nodeSet1.[jcr:primaryType] FROM __ALLNODES__ AS nodeSet1 WHERE PATH(nodeSet1) = '/a/b/c/d'"));
    }

    @Test
    public void shouldTranslateFromXPathContainingExplicitPathWithChildNumbers() {
        Assert.assertThat((Object)this.xpath("/jcr:root/a[2]/b"), this.isSql("SELECT nodeSet1.[jcr:primaryType] FROM __ALLNODES__ AS nodeSet1 WHERE PATH(nodeSet1) = '/a[2]/b'"));
        Assert.assertThat((Object)this.xpath("/jcr:root/a/b[3]"), this.isSql("SELECT nodeSet1.[jcr:primaryType] FROM __ALLNODES__ AS nodeSet1 WHERE PATH(nodeSet1) = '/a/b[3]'"));
        Assert.assertThat((Object)this.xpath("/jcr:root/a[2]/b[3]"), this.isSql("SELECT nodeSet1.[jcr:primaryType] FROM __ALLNODES__ AS nodeSet1 WHERE PATH(nodeSet1) = '/a[2]/b[3]'"));
    }

    @Test
    public void shouldTranslateFromXPathContainingExplicitPathWithWildcardChildNumbers() {
        Assert.assertThat((Object)this.xpath("/jcr:root/a[*]/b"), this.isSql("SELECT nodeSet1.[jcr:primaryType] FROM __ALLNODES__ AS nodeSet1 WHERE PATH(nodeSet1) = '/a/b'"));
        Assert.assertThat((Object)this.xpath("/jcr:root/a/b[*]"), this.isSql("SELECT nodeSet1.[jcr:primaryType] FROM __ALLNODES__ AS nodeSet1 WHERE PATH(nodeSet1) = '/a/b'"));
        Assert.assertThat((Object)this.xpath("/jcr:root/a[*]/b[*]"), this.isSql("SELECT nodeSet1.[jcr:primaryType] FROM __ALLNODES__ AS nodeSet1 WHERE PATH(nodeSet1) = '/a/b'"));
    }

    @Test
    public void shouldTranslateFromXPathUsingNameTestsAndWildcardWithNoPredicates() {
        Assert.assertThat((Object)this.xpath("/jcr:root/testroot/*"), this.isSql("SELECT nodeSet1.[jcr:primaryType] FROM __ALLNODES__ as nodeSet1 WHERE PATH(nodeSet1) LIKE '/testroot/%' AND DEPTH(nodeSet1) = CAST(2 AS LONG)"));
    }

    @Test
    public void shouldTranslateFromXPathUsingNameTestsAndWildcardWithPredicates() {
        Assert.assertThat((Object)this.xpath("/jcr:root/testroot/*[@prop1]"), this.isSql("SELECT nodeSet1.[jcr:primaryType] FROM __ALLNODES__ as nodeSet1 WHERE (PATH(nodeSet1) LIKE '/testroot/%' AND DEPTH(nodeSet1) = CAST(2 AS LONG)) AND nodeSet1.prop1 IS NOT NULL"));
    }

    @Test
    public void shouldTranslateFromXPathContainingPathWithDescendantOrSelf() {
        Assert.assertThat((Object)this.xpath("/jcr:root/a/b//c"), this.isSql("SELECT nodeSet1.[jcr:primaryType] FROM __ALLNODES__ AS nodeSet1 WHERE PATH(nodeSet1) = '/a/b/c' OR PATH(nodeSet1) LIKE '/a/b/%/c'"));
        Assert.assertThat((Object)this.xpath("/jcr:root/a/b[2]//c"), this.isSql("SELECT nodeSet1.[jcr:primaryType] FROM __ALLNODES__ AS nodeSet1 WHERE PATH(nodeSet1) = '/a/b[2]/c' OR PATH(nodeSet1) LIKE '/a/b[2]/%/c'"));
        Assert.assertThat((Object)this.xpath("/jcr:root/a/b//c[4]"), this.isSql("SELECT nodeSet1.[jcr:primaryType] FROM __ALLNODES__ AS nodeSet1 WHERE PATH(nodeSet1) = '/a/b/c[4]' OR PATH(nodeSet1) LIKE '/a/b/%/c[4]'"));
        Assert.assertThat((Object)this.xpath("/jcr:root/a/b[2]//c[4]"), this.isSql("SELECT nodeSet1.[jcr:primaryType] FROM __ALLNODES__ AS nodeSet1 WHERE PATH(nodeSet1) = '/a/b[2]/c[4]' OR PATH(nodeSet1) LIKE '/a/b[2]/%/c[4]'"));
    }

    @Test
    public void shouldTranslateFromXPathContainingPathWithMultipleDescendantOrSelf() {
        Assert.assertThat((Object)this.xpath("/jcr:root/a/b//c//d"), this.isSql("SELECT nodeSet1.[jcr:primaryType] FROM __ALLNODES__ AS nodeSet1 WHERE (((PATH(nodeSet1) = '/a/b/c/d' OR PATH(nodeSet1) LIKE '/a/b/%/c/d') OR PATH(nodeSet1) LIKE '/a/b/c/%/d') OR PATH(nodeSet1) LIKE '/a/b/%/c/%/d')"));
    }

    @Test
    public void shouldTranslateFromXPathContainingPredicatesUsingRelativePaths() {
        Assert.assertThat((Object)this.xpath("//element(*,my:type)[a/@id]"), this.isSql("SELECT * FROM [my:type] JOIN __ALLNODES__ as nodeSet1 ON ISCHILDNODE(nodeSet1,[my:type]) WHERE NAME(nodeSet1) = 'a' AND nodeSet1.id IS NOT NULL"));
        Assert.assertThat((Object)this.xpath("//element(*,my:type)[a/b/@id]"), this.isSql("SELECT * FROM [my:type] JOIN __ALLNODES__ as nodeSet1 ON ISCHILDNODE(nodeSet1,[my:type]) JOIN __ALLNODES__ as nodeSet2 ON ISCHILDNODE(nodeSet2,nodeSet1) WHERE (NAME(nodeSet1) = 'a' AND NAME(nodeSet2) = 'b') AND nodeSet2.id IS NOT NULL"));
        Assert.assertThat((Object)this.xpath("//element(*,my:type)[a/b/((@id and @name) or not(@address))]"), this.isSql("SELECT * FROM [my:type] JOIN __ALLNODES__ as nodeSet1 ON ISCHILDNODE(nodeSet1,[my:type]) JOIN __ALLNODES__ as nodeSet2 ON ISCHILDNODE(nodeSet2,nodeSet1) WHERE (NAME(nodeSet1) = 'a' AND NAME(nodeSet2) = 'b') AND ((nodeSet2.id IS NOT NULL and nodeSet2.name IS NOT NULL) OR (NOT(nodeSet2.address IS NOT NULL)))"));
        Assert.assertThat((Object)this.xpath("//element(*,my:type)[./a/b/((@id and @name) or not(@address))]"), this.isSql("SELECT * FROM [my:type] JOIN __ALLNODES__ as nodeSet1 ON ISCHILDNODE(nodeSet1,[my:type]) JOIN __ALLNODES__ as nodeSet2 ON ISCHILDNODE(nodeSet2,nodeSet1) WHERE (NAME(nodeSet1) = 'a' AND NAME(nodeSet2) = 'b') AND ((nodeSet2.id IS NOT NULL and nodeSet2.name IS NOT NULL) OR (NOT(nodeSet2.address IS NOT NULL)))"));
        Assert.assertThat((Object)this.xpath("//element(*,my:type)[a/b/((@id and @name) or not(jcr:contains(@desc,'rock star')))]"), this.isSql("SELECT * FROM [my:type] JOIN __ALLNODES__ as nodeSet1 ON ISCHILDNODE(nodeSet1,[my:type]) JOIN __ALLNODES__ as nodeSet2 ON ISCHILDNODE(nodeSet2,nodeSet1) WHERE (NAME(nodeSet1) = 'a' AND NAME(nodeSet2) = 'b') AND ((nodeSet2.id IS NOT NULL and nodeSet2.name IS NOT NULL) OR (NOT(CONTAINS(nodeSet2.desc,'rock star'))))"));
        Assert.assertThat((Object)this.xpath("//element(*,my:type)[*/@id]"), this.isSql("SELECT * FROM [my:type] JOIN __ALLNODES__ as nodeSet1 ON ISCHILDNODE(nodeSet1,[my:type]) WHERE nodeSet1.id IS NOT NULL"));
        Assert.assertThat((Object)this.xpath("//element(*,my:type)[*/*/@id]"), this.isSql("SELECT * FROM [my:type] JOIN __ALLNODES__ as nodeSet1 ON ISCHILDNODE(nodeSet1,[my:type]) JOIN __ALLNODES__ as nodeSet2 ON ISCHILDNODE(nodeSet2,nodeSet1) WHERE nodeSet2.id IS NOT NULL"));
        Assert.assertThat((Object)this.xpath("//element(*,my:type)[./*/*/@id]"), this.isSql("SELECT * FROM [my:type] JOIN __ALLNODES__ as nodeSet1 ON ISCHILDNODE(nodeSet1,[my:type]) JOIN __ALLNODES__ as nodeSet2 ON ISCHILDNODE(nodeSet2,nodeSet1) WHERE nodeSet2.id IS NOT NULL"));
        Assert.assertThat((Object)this.xpath("//element(*,my:type)[.//@id]"), this.isSql("SELECT * FROM [my:type] JOIN __ALLNODES__ as nodeSet1 ON ISDESCENDANTNODE(nodeSet1,[my:type]) WHERE nodeSet1.id IS NOT NULL"));
    }

    @Test
    public void shouldTranslateFromXPathContainingPredicatesIdentifyingPropertiesThatMustHaveValues() {
        Assert.assertThat((Object)this.xpath("/jcr:root/testroot/serializationNode[@jcr:primaryType]"), this.isSql("SELECT nodeSet1.[jcr:primaryType] FROM __ALLNODES__ AS nodeSet1 WHERE PATH(nodeSet1) = '/testroot/serializationNode' AND nodeSet1.[jcr:primaryType] IS NOT NULL"));
        Assert.assertThat((Object)this.xpath("//element(*,my:type)[@id]"), this.isSql("SELECT * FROM [my:type] WHERE id IS NOT NULL"));
        Assert.assertThat((Object)this.xpath("//element(*,my:type)[@id][@name]"), this.isSql("SELECT * FROM [my:type] WHERE id IS NOT NULL AND name IS NOT NULL"));
        Assert.assertThat((Object)this.xpath("//element(*,my:type)[@id | @name]"), this.isSql("SELECT * FROM [my:type] WHERE id IS NOT NULL OR name IS NOT NULL"));
        Assert.assertThat((Object)this.xpath("//element(*,my:type)[@id | (@name and @address)]"), this.isSql("SELECT * FROM [my:type] WHERE id IS NOT NULL OR (name IS NOT NULL AND address IS NOT NULL)"));
    }

    @Test
    public void shouldTranslateFromXPathContainingPredicatesUsingNot() {
        Assert.assertThat((Object)this.xpath("//element(*,my:type)[not(@id)]"), this.isSql("SELECT * FROM [my:type] WHERE NOT(id IS NOT NULL)"));
        Assert.assertThat((Object)this.xpath("//element(*,my:type)[not(jcr:contains(@desc,'rock star'))]"), this.isSql("SELECT * FROM [my:type] WHERE NOT(CONTAINS(desc,'rock star'))"));
        Assert.assertThat((Object)this.xpath("//element(*,my:type)[not(@id < 1 and jcr:contains(@desc,'rock star'))]"), this.isSql("SELECT * FROM [my:type] WHERE NOT(id < 1 AND CONTAINS(desc,'rock star'))"));
    }

    @Test
    public void shouldTranslateFromXPathContainingPredicatesIdentifyingPropertyCriteria() {
        Assert.assertThat((Object)this.xpath("//element(*,my:type)[@id = 1]"), this.isSql("SELECT * FROM [my:type] WHERE id = 1"));
        Assert.assertThat((Object)this.xpath("//element(*,my:type)[@id < 1 and @name = 'john']"), this.isSql("SELECT * FROM [my:type] WHERE id < 1 AND name = 'john'"));
        Assert.assertThat((Object)this.xpath("//element(*,my:type)[@id < 1 and ( @name = 'john' or @name = 'mary')]"), this.isSql("SELECT * FROM [my:type] WHERE id < 1 AND (name = 'john' OR name = 'mary')"));
        Assert.assertThat((Object)this.xpath("//element(*,my:type)[@id < 1 and ( jcr:like(@name,'%john') or @name = 'mary')]"), this.isSql("SELECT * FROM [my:type] WHERE id < 1 AND (name like '%john' OR name = 'mary')"));
        Assert.assertThat((Object)this.xpath("//element(*,my:type)[@id < 1 and jcr:contains(@desc,'rock star')]"), this.isSql("SELECT * FROM [my:type] WHERE id < 1 AND CONTAINS(desc,'rock star')"));
    }

    @Test
    public void shouldTranslateFromXPathContainingPredicatesIdentifyingPropertyCriteriaWithTypeCasts() {
        Assert.assertThat((Object)this.xpath("//element(*,my:type)[@datestart<=xs:dateTime('2009-09-24T11:53:23.293-05:00')]"), this.isSql("SELECT * FROM [my:type] WHERE datestart <= CAST('2009-09-24T11:53:23.293-05:00' AS DATE)"));
        Assert.assertThat((Object)this.xpath("//element(*,my:type)[@prop<=xs:boolean('true')]"), this.isSql("SELECT * FROM [my:type] WHERE prop <= CAST('true' AS BOOLEAN)"));
    }

    @Test
    public void shouldTranslateFromXPathContainingAttributesInPathIdentifyingPropertiesToBeSelected() {
        Assert.assertThat((Object)this.xpath("//element(*,my:type)/@id"), this.isSql("SELECT id FROM [my:type]"));
        Assert.assertThat((Object)this.xpath("//element(*,my:type)/(@id|@name)"), this.isSql("SELECT id, name FROM [my:type]"));
        Assert.assertThat((Object)this.xpath("//element(*,my:type)/(@id|@x:address)"), this.isSql("SELECT id, [x:address] FROM [my:type]"));
        Assert.assertThat((Object)this.xpath("//element(*,my:type)/(@id|@name|@x:address)"), this.isSql("SELECT id, name, [x:address] FROM [my:type]"));
        Assert.assertThat((Object)this.xpath("//element(*,my:type)/(@id union @name)"), this.isSql("SELECT id, name FROM [my:type]"));
        Assert.assertThat((Object)this.xpath("//element(*,my:type)/(@id union @name union @x:address)"), this.isSql("SELECT id, name, [x:address] FROM [my:type]"));
        Assert.assertThat((Object)this.xpath("//(@id|@name)"), this.isSql("SELECT nodeSet1.id, nodeSet1.name FROM __ALLNODES__ AS nodeSet1"));
        Assert.assertThat((Object)this.xpath("//./(@id|@name)"), this.isSql("SELECT nodeSet1.id, nodeSet1.name FROM __ALLNODES__ AS nodeSet1"));
    }

    @Test
    public void shouldTranslateFromXPathOfAnyNodeOfSpecificType() {
        Assert.assertThat((Object)this.xpath("//element(*,my:type)"), this.isSql("SELECT * FROM [my:type]"));
    }

    @Test
    public void shouldTranslateFromXPathOfAnyNodeOfSpecificTypeAndWithSpecificName() {
        Assert.assertThat((Object)this.xpath("//element(nodeName,my:type)"), this.isSql("SELECT * FROM [my:type] WHERE NAME([my:type]) = 'nodeName'"));
    }

    @Test
    public void shouldTranslateFromXPathOfAnyNodeWithName() {
        Assert.assertThat((Object)this.xpath("//element(nodeName,*)"), this.isSql("SELECT nodeSet1.[jcr:primaryType] FROM __ALLNODES__ AS nodeSet1 WHERE NAME(nodeSet1) = 'nodeName'"));
        Assert.assertThat((Object)this.xpath("//element(nodeName,*)"), this.isSql("SELECT nodeSet1.[jcr:primaryType] FROM __ALLNODES__ AS nodeSet1 WHERE NAME(nodeSet1) = 'nodeName'"));
        Assert.assertThat((Object)this.xpath("//nodeName"), this.isSql("SELECT nodeSet1.[jcr:primaryType] FROM __ALLNODES__ AS nodeSet1 WHERE NAME(nodeSet1) = 'nodeName'"));
        Assert.assertThat((Object)this.xpath("/jcr:root//element(nodeName,*)"), this.isSql("SELECT nodeSet1.[jcr:primaryType] FROM __ALLNODES__ AS nodeSet1 WHERE NAME(nodeSet1) = 'nodeName'"));
        Assert.assertThat((Object)this.xpath("/jcr:root//nodeName"), this.isSql("SELECT nodeSet1.[jcr:primaryType] FROM __ALLNODES__ AS nodeSet1 WHERE NAME(nodeSet1) = 'nodeName'"));
    }

    @Test
    public void shouldTranslateFromXPathOfNodeWithNameUnderRoot() {
        Assert.assertThat((Object)this.xpath("/jcr:root/element(nodeName,*)"), this.isSql("SELECT nodeSet1.[jcr:primaryType] FROM __ALLNODES__ AS nodeSet1 WHERE NAME(nodeSet1) = 'nodeName' AND DEPTH(nodeSet1) = CAST(1 AS LONG)"));
        Assert.assertThat((Object)this.xpath("/jcr:root/nodeName"), this.isSql("SELECT nodeSet1.[jcr:primaryType] FROM __ALLNODES__ AS nodeSet1 WHERE PATH(nodeSet1) = '/nodeName'"));
        Assert.assertThat((Object)this.xpath("nodeName"), this.isSql("SELECT nodeSet1.[jcr:primaryType] FROM __ALLNODES__ AS nodeSet1 WHERE PATH(nodeSet1) = '/nodeName'"));
    }

    @Test
    public void shouldTranslateFromXPathOfAnyNodeUsingPredicate() {
        Assert.assertThat((Object)this.xpath("//.[jcr:contains(.,'bar')]"), this.isSql("SELECT nodeSet1.[jcr:primaryType] FROM __ALLNODES__ AS nodeSet1 WHERE CONTAINS(nodeSet1.*,'bar')"));
        Assert.assertThat((Object)this.xpath("//.[jcr:contains(a,'bar')]"), this.isSql("SELECT * FROM __ALLNODES__ AS nodeSet1 JOIN __ALLNODES__ AS nodeSet2 ON ISCHILDNODE(nodeSet2,nodeSet1) WHERE CONTAINS(nodeSet2.*,'bar')"));
        Assert.assertThat((Object)this.xpath("//*[jcr:contains(.,'bar')]"), this.isSql("SELECT nodeSet1.[jcr:primaryType] FROM __ALLNODES__ AS nodeSet1 WHERE CONTAINS(nodeSet1.*,'bar')"));
        Assert.assertThat((Object)this.xpath("//*[jcr:contains(a,'bar')]"), this.isSql("SELECT * FROM __ALLNODES__ AS nodeSet1 JOIN __ALLNODES__ AS nodeSet2 ON ISCHILDNODE(nodeSet2,nodeSet1) WHERE CONTAINS(nodeSet2.*,'bar')"));
        Assert.assertThat((Object)this.xpath("//*[jcr:contains(a/@b,'bar')]"), this.isSql("SELECT * FROM __ALLNODES__ AS nodeSet1 JOIN __ALLNODES__ AS nodeSet2 ON ISCHILDNODE(nodeSet2,nodeSet1) WHERE NAME(nodeSet2) = 'a' AND CONTAINS(nodeSet2.b,'bar')"));
        Assert.assertThat((Object)this.xpath("//*[jcr:contains(a/*/@b,'bar')]"), this.isSql("SELECT * FROM __ALLNODES__ AS nodeSet1 JOIN __ALLNODES__ AS nodeSet2 ON ISCHILDNODE(nodeSet2,nodeSet1) JOIN __ALLNODES__ AS nodeSet3 ON ISCHILDNODE(nodeSet3,nodeSet2) WHERE NAME(nodeSet2) = 'a' AND CONTAINS(nodeSet3.b,'bar')"));
        Assert.assertThat((Object)this.xpath("/jcr:root//element(*)[jcr:contains(a/@b,'bar')]"), this.isSql("SELECT * FROM __ALLNODES__ AS nodeSet1 JOIN __ALLNODES__ AS nodeSet2 ON ISCHILDNODE(nodeSet2,nodeSet1) WHERE NAME(nodeSet2) = 'a' AND CONTAINS(nodeSet2.b,'bar')"));
        Assert.assertThat((Object)this.xpath("/jcr:root//element(*)[jcr:contains(a/*/@b,'bar')]"), this.isSql("SELECT * FROM __ALLNODES__ AS nodeSet1 JOIN __ALLNODES__ AS nodeSet2 ON ISCHILDNODE(nodeSet2,nodeSet1) JOIN __ALLNODES__ AS nodeSet3 ON ISCHILDNODE(nodeSet3,nodeSet2) WHERE NAME(nodeSet2) = 'a' AND CONTAINS(nodeSet3.b,'bar')"));
        Assert.assertThat((Object)this.xpath("/jcr:root//*[jcr:contains(a/@b,'bar')]"), this.isSql("SELECT * FROM __ALLNODES__ AS nodeSet1 JOIN __ALLNODES__ AS nodeSet2 ON ISCHILDNODE(nodeSet2,nodeSet1) WHERE NAME(nodeSet2) = 'a' AND CONTAINS(nodeSet2.b,'bar')"));
        Assert.assertThat((Object)this.xpath("/jcr:root//*[jcr:contains(a/*/@b,'bar')]"), this.isSql("SELECT * FROM __ALLNODES__ AS nodeSet1 JOIN __ALLNODES__ AS nodeSet2 ON ISCHILDNODE(nodeSet2,nodeSet1) JOIN __ALLNODES__ AS nodeSet3 ON ISCHILDNODE(nodeSet3,nodeSet2) WHERE NAME(nodeSet2) = 'a' AND CONTAINS(nodeSet3.b,'bar')"));
    }

    @Test
    public void shouldTranslateFromXPathUsingElementWildcardAndOrderBy() {
        Assert.assertThat((Object)this.xpath("//element(*,*) order by @title"), this.isSql("SELECT nodeSet1.title FROM __ALLNODES__ AS nodeSet1 ORDER BY nodeSet1.title"));
    }

    @Test
    public void shouldTranslateFromXPathUsingNameTestsAndWildcardOrderBy() {
        Assert.assertThat((Object)this.xpath("/jcr:root/testroot/*[@prop1] order by @prop1 ascending"), this.isSql("SELECT nodeSet1.prop1 FROM __ALLNODES__ as nodeSet1 WHERE (PATH(nodeSet1) LIKE '/testroot/%' AND DEPTH(nodeSet1) = CAST(2 AS LONG)) AND nodeSet1.prop1 IS NOT NULL ORDER BY nodeSet1.prop1"));
    }

    @Test
    public void shouldTranslateFromXPathUsingElementTestForChildrenOfRoot() {
        Assert.assertThat((Object)this.xpath("/jcr:root/element()"), this.isSql("SELECT nodeSet1.[jcr:primaryType] FROM __ALLNODES__ as nodeSet1 WHERE DEPTH(nodeSet1) = CAST(1 AS LONG)"));
    }

    @Test
    public void shouldTranslateFromXPathUsingElementTestAndParentPath() {
        Assert.assertThat((Object)this.xpath("/jcr:root/testroot/element()"), this.isSql("SELECT nodeSet1.[jcr:primaryType] FROM __ALLNODES__ as nodeSet1 WHERE PATH(nodeSet1) LIKE '/testroot/%' AND DEPTH(nodeSet1) = CAST(2 AS LONG)"));
    }

    @Test
    public void shouldTranslateFromXPathUsingElementTestAndAncestorPath() {
        Assert.assertThat((Object)this.xpath("/jcr:root/testroot//element()"), this.isSql("SELECT nodeSet1.[jcr:primaryType] FROM __ALLNODES__ as nodeSet1 WHERE PATH(nodeSet1) LIKE '/testroot/%'"));
    }

    @Test
    public void shouldTranslateFromXPathUsingElementTestWithTypeNameForChildrenOfRoot() {
        Assert.assertThat((Object)this.xpath("/jcr:root/element(nodeName)"), this.isSql("SELECT nodeSet1.[jcr:primaryType] FROM __ALLNODES__ as nodeSet1 WHERE NAME(nodeSet1) = 'nodeName' AND DEPTH(nodeSet1) = CAST(1 AS LONG)"));
    }

    @Test
    public void shouldTranslateFromXPathUsingElementTestWithTypeNameAndParentPath() {
        Assert.assertThat((Object)this.xpath("/jcr:root/testroot/element(nodeName)"), this.isSql("SELECT nodeSet1.[jcr:primaryType] FROM __ALLNODES__ as nodeSet1 WHERE NAME(nodeSet1) = 'nodeName' AND PATH(nodeSet1) LIKE '/testroot/%' AND DEPTH(nodeSet1) = CAST(2 AS LONG)"));
    }

    @Test
    public void shouldTranslateFromXPathUsingElementTestWithTypeNameAndAncestorPath() {
        Assert.assertThat((Object)this.xpath("/jcr:root/testroot//element(nodeName)"), this.isSql("SELECT nodeSet1.[jcr:primaryType] FROM __ALLNODES__ as nodeSet1 WHERE NAME(nodeSet1) = 'nodeName' AND PATH(nodeSet1) LIKE '/testroot/%'"));
    }

    @Test
    public void shouldTranslateFromXPathContainingSpacesInPath() {
        Assert.assertThat((Object)this.xpath("/jcr:root/Cars/Sports/Infiniti_x0020_G37[@foo:year='2008']"), this.isSql("SELECT nodeSet1.[jcr:primaryType] FROM __ALLNODES__ as nodeSet1 WHERE PATH(nodeSet1) = '/Cars/Sports/Infiniti G37' AND nodeSet1.[foo:year] = '2008'"));
    }

    @Test
    public void shouldTranslateFromXPathContainingPathAndAttributeMatch() {
        Assert.assertThat((Object)this.xpath("/jcr:root/Cars/Sports/InfinitiG37[@foo:year='2008']"), this.isSql("SELECT nodeSet1.[jcr:primaryType] FROM __ALLNODES__ as nodeSet1 WHERE PATH(nodeSet1) = '/Cars/Sports/InfinitiG37' AND nodeSet1.[foo:year] = '2008'"));
    }

    @Test
    public void shouldTranslateFromXPathContainingAttributeMatch() {
        Assert.assertThat((Object)this.xpath("//InfinitiG37[@foo:year='2008']"), this.isSql("SELECT nodeSet1.[jcr:primaryType] FROM __ALLNODES__ as nodeSet1 WHERE PATH(nodeSet1) LIKE '%/InfinitiG37' AND nodeSet1.[foo:year] = '2008'"));
    }

    @Test
    @FixFor(value={"MODE-790"})
    public void shouldTranslateFromXPathContainingCompoundCriteria() {
        Assert.assertThat((Object)this.xpath("/jcr:root/Cars//element(*,car:Car)[@car:year='2008' and jcr:contains(., '\"liter V 12\"')]"), this.isSql("SELECT * FROM [car:Car] WHERE (PATH([car:Car]) LIKE '/Cars/%' AND ([car:Car].[car:year] = '2008' AND CONTAINS([car:Car].*,'\"liter V 12\"')))"));
    }

    @Test
    @FixFor(value={"MODE-790"})
    public void shouldTranslateFromXPathContainingCompoundCriteria2() {
        Assert.assertThat((Object)this.xpath("/jcr:root/drools:repository/drools:package_area//element(*, drools:assetNodeType)[jcr:contains(., 'testQueryText*')]"), this.isSql("SELECT * FROM [drools:assetNodeType] WHERE (PATH([drools:assetNodeType]) LIKE '/drools:repository/drools:package_area/%' AND CONTAINS([drools:assetNodeType].*,'testQueryText*'))"));
    }

    @Test
    @FixFor(value={"MODE-790"})
    public void shouldTranslateFromXPathContainingCompoundCriteria3() {
        Assert.assertThat((Object)this.xpath("/jcr:root/drools:repository/drools:package_area//element(*, drools:assetNodeType)[jcr:contains(., 'testQueryText*') and drools:archive = 'false']"), this.isSql("SELECT * FROM [drools:assetNodeType] WHERE (PATH([drools:assetNodeType]) LIKE '/drools:repository/drools:package_area/%' AND CONTAINS([drools:assetNodeType].*,'testQueryText*') AND [drools:archive] = 'false')"));
    }

    @Test
    @FixFor(value={"MODE-790"})
    public void shouldTranslateFromXPathContainingCompoundCriteria4() {
        Assert.assertThat((Object)this.xpath("/jcr:root/drools:repository/drools:package_area//element(*, drools:assetNodeType)[jcr:contains(., 'testQueryText*') and @drools:archive = 'false']"), this.isSql("SELECT * FROM [drools:assetNodeType] WHERE (PATH([drools:assetNodeType]) LIKE '/drools:repository/drools:package_area/%' AND CONTAINS([drools:assetNodeType].*,'testQueryText*') AND [drools:archive] = 'false')"));
    }

    @Test
    public void shouldParseXPathExpressions() {
        this.xpath("/jcr:root/a/b/c");
        this.xpath("/jcr:root/a/b/c[*]");
        this.xpath("/jcr:root/some[1]/element(nodes, my:type)[1]");
        this.xpath("//element(*,my:type)");
        this.xpath("//element(*,my:type)[@jcr:title='something' and @globalProperty='something else']");
        this.xpath("//element(*,my:type)[@jcr:title | @globalProperty]");
        this.xpath("//element(*, my:type) order by @my:title");
        this.xpath("//element(*, my:type) [jcr:contains(., 'jcr')] order by jcr:score() descending");
        this.xpath("//element(*, employee)[@secretary and @assistant]");
    }

    protected void printSqlFor(String xpath) {
        System.out.println("XPath: " + xpath);
        System.out.println("SQL:   " + this.translateToSql(xpath));
        System.out.println();
    }

    private QueryCommand translateToSql(String xpath) {
        XPath.Component component = this.parser.parseXPath(xpath);
        XPathToQueryTranslator translator = new XPathToQueryTranslator(this.typeSystem, xpath);
        return translator.createQuery(component);
    }

    private QueryCommand xpath(String xpath) {
        XPath.Component component = this.parser.parseXPath(xpath);
        XPathToQueryTranslator translator = new XPathToQueryTranslator(this.typeSystem, xpath);
        return translator.createQuery(component);
    }

    protected QueryCommand sql(String sql) {
        return new SqlQueryParser().parseQuery(sql, this.typeSystem);
    }

    protected Matcher<QueryCommand> isSql(String sql) {
        return Is.is((Object)this.sql(sql));
    }
}

