/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.ItemDefinition;
import javax.jcr.nodetype.NodeType;
import net.jcip.annotations.NotThreadSafe;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.ValueFormatException;

@NotThreadSafe
abstract class JcrItemDefinitionTemplate
implements ItemDefinition {
    private final ExecutionContext context;
    private boolean autoCreated = false;
    private boolean mandatory = false;
    private boolean isProtected = false;
    private Name name;
    private int onParentVersion = 1;

    JcrItemDefinitionTemplate(ExecutionContext context) {
        assert (context != null);
        this.context = context;
    }

    ExecutionContext getExecutionContext() {
        return this.context;
    }

    public NodeType getDeclaringNodeType() {
        return null;
    }

    public String getName() {
        if (this.name == null) {
            return null;
        }
        return this.name.getString(this.context.getNamespaceRegistry());
    }

    public int getOnParentVersion() {
        return this.onParentVersion;
    }

    public boolean isAutoCreated() {
        return this.autoCreated;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public boolean isProtected() {
        return this.isProtected;
    }

    public ExecutionContext getContext() {
        return this.context;
    }

    public void setAutoCreated(boolean autoCreated) {
        this.autoCreated = autoCreated;
    }

    public void setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
    }

    public void setProtected(boolean isProtected) {
        this.isProtected = isProtected;
    }

    public void setName(String name) throws ConstraintViolationException {
        if (name == null) {
            throw new ConstraintViolationException();
        }
        try {
            this.name = (Name)this.context.getValueFactories().getNameFactory().create(name);
        }
        catch (ValueFormatException vfe) {
            throw new ConstraintViolationException((Throwable)vfe);
        }
    }

    public void setOnParentVersion(int onParentVersion) {
        assert (onParentVersion == 6 || onParentVersion == 4 || onParentVersion == 1 || onParentVersion == 5 || onParentVersion == 3 || onParentVersion == 2);
        this.onParentVersion = onParentVersion;
    }
}

